/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcie;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcik;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcio;
import com.google.android.gms.internal.zzcis;
import com.google.android.gms.internal.zzcit;
import com.google.android.gms.internal.zzcix;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import com.google.android.gms.internal.zzcni;
import com.google.android.gms.internal.zzcnl;
import com.google.android.gms.internal.zzcnn;
import com.google.android.gms.internal.zzcno;
import com.google.android.gms.internal.zzcnr;
import com.google.android.gms.internal.zzcns;
import com.google.android.gms.internal.zzcnv;
import com.google.android.gms.internal.zzcob;
import com.google.android.gms.internal.zzcoc;
import com.google.android.gms.internal.zzcoe;
import com.google.android.gms.internal.zzcof;
import com.google.android.gms.internal.zzflj;
import com.google.android.gms.internal.zzflk;
import com.google.android.gms.internal.zzflm;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class zzcil
extends zzcli {
    private static final String[] zza = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;"};
    private static final String[] zzb = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zzc = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;"};
    private static final String[] zzd = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zze = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;"};
    private static final String[] zzf = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private final zzcio zzg;
    private final zzcni zzh = new zzcni(this.zzk());

    zzcil(zzckj zzckj2) {
        super(zzckj2);
        String string = "google_app_measurement.db";
        this.zzg = new zzcio(this, this.zzl(), string);
    }

    @Override
    protected final boolean zzw() {
        return false;
    }

    @WorkerThread
    public final void zzx() {
        this.zzaq();
        this.zzaa().beginTransaction();
    }

    @WorkerThread
    public final void zzy() {
        this.zzaq();
        this.zzaa().setTransactionSuccessful();
    }

    @WorkerThread
    public final void zzz() {
        this.zzaq();
        this.zzaa().endTransaction();
    }

    @WorkerThread
    private final long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.zzaa();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzt().zzy().zza("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.zzaa();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @WorkerThread
    final SQLiteDatabase zzaa() {
        this.zzc();
        try {
            return this.zzg.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzt().zzaa().zza("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzcit zza(String string, String string2) {
        zzbq.zza((String)string);
        zzbq.zza((String)string2);
        this.zzc();
        this.zzaq();
        try (Cursor cursor = null;){
            cursor = this.zzaa().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Boolean bl = null;
            if (!cursor.isNull(6)) {
                bl = cursor.getLong(6) == 1L;
            }
            zzcit zzcit2 = new zzcit(string, string2, l, l2, l3, l4, l5, l6, bl);
            if (cursor.moveToNext()) {
                this.zzt().zzy().zza("Got multiple records for event aggregates, expected one. appId", zzcjj.zza(string));
            }
            zzcit zzcit3 = zzcit2;
            return zzcit3;
        }
    }

    @WorkerThread
    public final void zza(zzcit zzcit2) {
        zzbq.zza((Object)zzcit2);
        this.zzc();
        this.zzaq();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcit2.zza);
        contentValues.put("name", zzcit2.zzb);
        contentValues.put("lifetime_count", Long.valueOf(zzcit2.zzc));
        contentValues.put("current_bundle_count", Long.valueOf(zzcit2.zzd));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzcit2.zze));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzcit2.zzf));
        contentValues.put("last_sampled_complex_event_id", zzcit2.zzg);
        contentValues.put("last_sampling_rate", zzcit2.zzh);
        Long l = null;
        if (zzcit2.zzi != null && zzcit2.zzi.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.zzaa().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzt().zzy().zza("Failed to insert/update event aggregates (got -1). appId", zzcjj.zza(zzcit2.zza));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzt().zzy().zza("Error storing event aggregates. appId", zzcjj.zza(zzcit2.zza), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzb(String string, String string2) {
        zzbq.zza((String)string);
        zzbq.zza((String)string2);
        this.zzc();
        this.zzaq();
        try {
            int n = this.zzaa().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzt().zzae().zza("Deleted user attribute rows", n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzt().zzy().zza("Error deleting user attribute. appId", zzcjj.zza(string), this.zzo().zzc(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzcnn zzcnn2) {
        zzbq.zza((Object)zzcnn2);
        this.zzc();
        this.zzaq();
        if (this.zzc(zzcnn2.zza, zzcnn2.zzc) == null && (zzcno.zza(zzcnn2.zzc) ? this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzcnn2.zza}) >= 25L : this.zzb("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzcnn2.zza, zzcnn2.zzb}) >= 25L)) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcnn2.zza);
        contentValues.put("origin", zzcnn2.zzb);
        contentValues.put("name", zzcnn2.zzc);
        contentValues.put("set_timestamp", Long.valueOf(zzcnn2.zzd));
        zzcil.zza(contentValues, "value", zzcnn2.zze);
        try {
            if (this.zzaa().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzt().zzy().zza("Failed to insert/update user property (got -1). appId", zzcjj.zza(zzcnn2.zza));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzt().zzy().zza("Error storing user property. appId", zzcjj.zza(zzcnn2.zza), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzcnn zzc(String string, String string2) {
        zzbq.zza((String)string);
        zzbq.zza((String)string2);
        this.zzc();
        this.zzaq();
        try (Cursor cursor = null;){
            cursor = this.zzaa().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzcnn zzcnn2 = new zzcnn(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzt().zzy().zza("Got multiple records for user property, expected one. appId", zzcjj.zza(string));
            }
            zzcnn zzcnn3 = zzcnn2;
            return zzcnn3;
        }
    }

    @WorkerThread
    public final List<zzcnn> zza(String string) {
        zzbq.zza((String)string);
        this.zzc();
        this.zzaq();
        ArrayList<zzcnn> arrayList = new ArrayList<zzcnn>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.zzaa().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcnn> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzt().zzy().zza("Read invalid user property value, ignoring it. appId", zzcjj.zza(string));
                    continue;
                }
                zzcnn zzcnn2 = new zzcnn(string, string2, (String)object, l, object2);
                arrayList.add(zzcnn2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzcnn> zza(String string, String string2, String string3) {
        zzbq.zza((String)string);
        this.zzc();
        this.zzaq();
        ArrayList<zzcnn> arrayList = new ArrayList<zzcnn>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.zzaa().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, stringBuilder.toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcnn> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzt().zzy().zza("Read more than the max allowed user properties, ignoring excess", 1000);
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzt().zzy().zza("(2)Read invalid user property value, ignoring it", zzcjj.zza(string), string2, string3);
                    continue;
                }
                zzcnn zzcnn2 = new zzcnn(string, string2, (String)object, l, object2);
                arrayList.add(zzcnn2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzcii zzcii2) {
        zzbq.zza((Object)((Object)zzcii2));
        this.zzc();
        this.zzaq();
        if (this.zzc(zzcii2.zza, zzcii2.zzc.zza) == null && this.zzb("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzcii2.zza}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcii2.zza);
        contentValues.put("origin", zzcii2.zzb);
        contentValues.put("name", zzcii2.zzc.zza);
        zzcil.zza(contentValues, "value", zzcii2.zzc.zza());
        contentValues.put("active", Boolean.valueOf(zzcii2.zze));
        contentValues.put("trigger_event_name", zzcii2.zzf);
        contentValues.put("trigger_timeout", Long.valueOf(zzcii2.zzh));
        this.zzp();
        contentValues.put("timed_out_event", zzcno.zza((Parcelable)zzcii2.zzg));
        contentValues.put("creation_timestamp", Long.valueOf(zzcii2.zzd));
        this.zzp();
        contentValues.put("triggered_event", zzcno.zza((Parcelable)zzcii2.zzi));
        contentValues.put("triggered_timestamp", Long.valueOf(zzcii2.zzc.zzb));
        contentValues.put("time_to_live", Long.valueOf(zzcii2.zzj));
        this.zzp();
        contentValues.put("expired_event", zzcno.zza((Parcelable)zzcii2.zzk));
        try {
            if (this.zzaa().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzt().zzy().zza("Failed to insert/update conditional user property (got -1)", zzcjj.zza(zzcii2.zza));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzt().zzy().zza("Error storing conditional user property", zzcjj.zza(zzcii2.zza), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzcii zzd(String string, String string2) {
        zzbq.zza((String)string);
        zzbq.zza((String)string2);
        this.zzc();
        this.zzaq();
        try (Cursor cursor = null;){
            cursor = this.zzaa().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzcix zzcix2 = this.zzp().zza(cursor.getBlob(5), zzcix.CREATOR);
            long l2 = cursor.getLong(6);
            zzcix zzcix3 = this.zzp().zza(cursor.getBlob(7), zzcix.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzcix zzcix4 = this.zzp().zza(cursor.getBlob(10), zzcix.CREATOR);
            zzcnl zzcnl2 = new zzcnl(string2, l3, object, string3);
            zzcii zzcii2 = new zzcii(string, string3, zzcnl2, l2, bl, string4, zzcix2, l, zzcix3, l4, zzcix4);
            if (cursor.moveToNext()) {
                this.zzt().zzy().zza("Got multiple records for conditional property, expected one", zzcjj.zza(string), this.zzo().zzc(string2));
            }
            zzcii zzcii3 = zzcii2;
            return zzcii3;
        }
    }

    @WorkerThread
    public final int zze(String string, String string2) {
        zzbq.zza((String)string);
        zzbq.zza((String)string2);
        this.zzc();
        this.zzaq();
        try {
            return this.zzaa().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzt().zzy().zza("Error deleting conditional property", zzcjj.zza(string), this.zzo().zzc(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzcii> zzb(String string, String string2, String string3) {
        zzbq.zza((String)string);
        this.zzc();
        this.zzaq();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zza(stringBuilder.toString(), stringArray);
    }

    public final List<zzcii> zza(String string, String[] stringArray) {
        this.zzc();
        this.zzaq();
        ArrayList<zzcii> arrayList = new ArrayList<zzcii>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.zzaa().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcii> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzt().zzy().zza("Read more than the max allowed conditional properties, ignoring extra", 1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzcix zzcix2 = this.zzp().zza(cursor.getBlob(7), zzcix.CREATOR);
                long l2 = cursor.getLong(8);
                zzcix zzcix3 = this.zzp().zza(cursor.getBlob(9), zzcix.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzcix zzcix4 = this.zzp().zza(cursor.getBlob(12), zzcix.CREATOR);
                zzcnl zzcnl2 = new zzcnl(string3, l3, object2, string2);
                zzcii zzcii2 = new zzcii((String)object, string2, zzcnl2, l2, bl, string4, zzcix2, l, zzcix3, l4, zzcix4);
                arrayList.add(zzcii2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzcie zzb(String string) {
        zzbq.zza((String)string);
        this.zzc();
        this.zzaq();
        try (Cursor cursor = null;){
            cursor = this.zzaa().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzcie zzcie2 = new zzcie(this.zzp, string);
            zzcie2.zza(cursor.getString(0));
            zzcie2.zzb(cursor.getString(1));
            zzcie2.zzc(cursor.getString(2));
            zzcie2.zzf(cursor.getLong(3));
            zzcie2.zza(cursor.getLong(4));
            zzcie2.zzb(cursor.getLong(5));
            zzcie2.zze(cursor.getString(6));
            zzcie2.zzf(cursor.getString(7));
            zzcie2.zzd(cursor.getLong(8));
            zzcie2.zze(cursor.getLong(9));
            zzcie2.zza(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzcie2.zzi(cursor.getLong(11));
            zzcie2.zzj(cursor.getLong(12));
            zzcie2.zzk(cursor.getLong(13));
            zzcie2.zzl(cursor.getLong(14));
            zzcie2.zzg(cursor.getLong(15));
            zzcie2.zzh(cursor.getLong(16));
            zzcie2.zzc(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzcie2.zzd(cursor.getString(18));
            zzcie2.zzn(cursor.getLong(19));
            zzcie2.zzm(cursor.getLong(20));
            zzcie2.zzg(cursor.getString(21));
            zzcie2.zzo(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzcie2.zzb(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzcie2.zza();
            if (cursor.moveToNext()) {
                this.zzt().zzy().zza("Got multiple records for app, expected one. appId", zzcjj.zza(string));
            }
            zzcie zzcie3 = zzcie2;
            return zzcie3;
        }
    }

    @WorkerThread
    public final void zza(zzcie zzcie2) {
        zzbq.zza((Object)zzcie2);
        this.zzc();
        this.zzaq();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcie2.zzb());
        contentValues.put("app_instance_id", zzcie2.zzc());
        contentValues.put("gmp_app_id", zzcie2.zzd());
        contentValues.put("resettable_device_id_hash", zzcie2.zze());
        contentValues.put("last_bundle_index", Long.valueOf(zzcie2.zzo()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzcie2.zzg()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzcie2.zzh()));
        contentValues.put("app_version", zzcie2.zzi());
        contentValues.put("app_store", zzcie2.zzk());
        contentValues.put("gmp_version", Long.valueOf(zzcie2.zzl()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzcie2.zzm()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzcie2.zzn()));
        contentValues.put("day", Long.valueOf(zzcie2.zzs()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzcie2.zzt()));
        contentValues.put("daily_events_count", Long.valueOf(zzcie2.zzu()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzcie2.zzv()));
        contentValues.put("config_fetched_time", Long.valueOf(zzcie2.zzp()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzcie2.zzq()));
        contentValues.put("app_version_int", Long.valueOf(zzcie2.zzj()));
        contentValues.put("firebase_instance_id", zzcie2.zzf());
        contentValues.put("daily_error_events_count", Long.valueOf(zzcie2.zzx()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzcie2.zzw()));
        contentValues.put("health_monitor_sample", zzcie2.zzy());
        contentValues.put("android_id", Long.valueOf(zzcie2.zzaa()));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzcie2.zzab()));
        try {
            SQLiteDatabase sQLiteDatabase = this.zzaa();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzcie2.zzb()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzt().zzy().zza("Failed to insert/update app (got -1). appId", zzcjj.zza(zzcie2.zzb()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzt().zzy().zza("Error storing app. appId", zzcjj.zza(zzcie2.zzb()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzc(String string) {
        zzbq.zza((String)string);
        this.zzc();
        this.zzaq();
        try {
            SQLiteDatabase sQLiteDatabase = this.zzaa();
            String string2 = string;
            int n = this.zzv().zzb(string2, zzciz.zzv);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzt().zzy().zza("Error deleting over the limit events. appId", zzcjj.zza(string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzcim zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        zzbq.zza((String)string);
        this.zzc();
        this.zzaq();
        String[] stringArray = new String[]{string};
        zzcim zzcim2 = new zzcim();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.zzaa();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzt().zzaa().zza("Not updating daily counts, app is not known. appId", zzcjj.zza(string));
                zzcim zzcim3 = zzcim2;
                return zzcim3;
            }
            if (cursor.getLong(0) == l) {
                zzcim2.zzb = cursor.getLong(1);
                zzcim2.zza = cursor.getLong(2);
                zzcim2.zzc = cursor.getLong(3);
                zzcim2.zzd = cursor.getLong(4);
                zzcim2.zze = cursor.getLong(5);
            }
            if (bl) {
                ++zzcim2.zzb;
            }
            if (bl2) {
                ++zzcim2.zza;
            }
            if (bl3) {
                ++zzcim2.zzc;
            }
            if (bl4) {
                ++zzcim2.zzd;
            }
            if (bl5) {
                ++zzcim2.zze;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzcim2.zza));
            contentValues.put("daily_events_count", Long.valueOf(zzcim2.zzb));
            contentValues.put("daily_conversions_count", Long.valueOf(zzcim2.zzc));
            contentValues.put("daily_error_events_count", Long.valueOf(zzcim2.zzd));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzcim2.zze));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzcim zzcim4 = zzcim2;
            return zzcim4;
        }
    }

    @WorkerThread
    public final byte[] zzd(String string) {
        zzbq.zza((String)string);
        this.zzc();
        this.zzaq();
        try (Cursor cursor = null;){
            cursor = this.zzaa().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzt().zzy().zza("Got multiple records for app config, expected one. appId", zzcjj.zza(string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzcoe zzcoe2, boolean bl) {
        byte[] byArray;
        this.zzc();
        this.zzaq();
        zzbq.zza((Object)((Object)zzcoe2));
        zzbq.zza((String)zzcoe2.zzo);
        zzbq.zza((Object)zzcoe2.zzf);
        this.zzad();
        long l = this.zzk().zza();
        if (zzcoe2.zzf < l - zzcik.zzy() || zzcoe2.zzf > l + zzcik.zzy()) {
            this.zzt().zzaa().zza("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzcjj.zza(zzcoe2.zzo), l, zzcoe2.zzf);
        }
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = new byte[zzcoe2.zzf()];
            zzflk zzflk2 = zzflk.zza((byte[])byArray2, (int)0, (int)byArray3.length);
            zzcoe2.zza(zzflk2);
            zzflk2.zza();
            byArray = this.zzp().zza(byArray2);
        }
        catch (IOException iOException) {
            this.zzt().zzy().zza("Data loss. Failed to serialize bundle. appId", zzcjj.zza(zzcoe2.zzo), iOException);
            return false;
        }
        this.zzt().zzae().zza("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcoe2.zzo);
        contentValues.put("bundle_end_timestamp", zzcoe2.zzf);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.zzaa().insert("queue", null, contentValues) == -1L) {
                this.zzt().zzy().zza("Failed to insert bundle (got -1). appId", zzcjj.zza(zzcoe2.zzo));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzt().zzy().zza("Error storing bundle. appId", zzcjj.zza(zzcoe2.zzo), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final String zzab() {
        SQLiteDatabase sQLiteDatabase = this.zzaa();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public final boolean zzac() {
        return this.zzb("select count(1) > 0 from queue where has_realtime = 1", (String[])null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzcoe, Long>> zza(String string, int n, int n2) {
        this.zzc();
        this.zzaq();
        zzbq.zzb((n > 0 ? 1 : 0) != 0);
        zzbq.zzb((n2 > 0 ? 1 : 0) != 0);
        zzbq.zza((String)string);
        try (Cursor cursor = null;){
            cursor = this.zzaa().query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzcoe, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzcoe, Long>> arrayList = new ArrayList<Pair<zzcoe, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzp().zzb((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzt().zzy().zza("Failed to unzip queued bundle. appId", zzcjj.zza(string), iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                byte[] byArray2 = byArray;
                object = zzflj.zza((byte[])byArray, (int)0, (int)byArray2.length);
                zzcoe zzcoe2 = new zzcoe();
                try {
                    zzcoe2.zza((zzflj)object);
                }
                catch (IOException iOException) {
                    this.zzt().zzy().zza("Failed to merge queued bundle. appId", zzcjj.zza(string), iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzcoe, Long>)Pair.create((Object)((Object)zzcoe2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzcoe, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzad() {
        this.zzc();
        this.zzaq();
        if (!this.zzat()) {
            return;
        }
        long l = this.zzu().zzf.zza();
        long l2 = this.zzk().zzb();
        if (Math.abs(l2 - l) > zzciz.zzae.zzb()) {
            this.zzu().zzf.zza(l2);
            zzcil zzcil2 = this;
            zzcil2.zzc();
            zzcil2.zzaq();
            if (zzcil2.zzat()) {
                SQLiteDatabase sQLiteDatabase = zzcil2.zzaa();
                String[] stringArray = new String[]{String.valueOf(zzcil2.zzk().zza()), String.valueOf(zzcik.zzy())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzcil2.zzt().zzae().zza("Deleted stale rows. rowsDeleted", n);
                }
            }
        }
    }

    @WorkerThread
    final void zza(String string, zzcnr[] zzcnrArray) {
        this.zzaq();
        this.zzc();
        zzbq.zza((String)string);
        zzbq.zza((Object)zzcnrArray);
        SQLiteDatabase sQLiteDatabase = this.zzaa();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzcil zzcil2 = this;
            zzcil2.zzaq();
            zzcil2.zzc();
            zzbq.zza((String)string2);
            Object object = zzcil2.zzaa();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzcnrArray;
            int n2 = zzcnrArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzcns zzcns2;
                int n3;
                int n4;
                zzcnr zzcnr2 = object2[n];
                object = zzcnr2;
                string2 = string;
                zzcil2 = this;
                zzcil2.zzaq();
                zzcil2.zzc();
                zzbq.zza((String)string2);
                zzbq.zza((Object)object);
                zzbq.zza((Object)object.zzc);
                zzbq.zza((Object)object.zzb);
                if (object.zza == null) {
                    zzcil2.zzt().zzaa().zza("Audience with no ID. appId", zzcjj.zza(string2));
                    continue;
                }
                int n5 = object.zza;
                zzflm[] zzflmArray = object.zzc;
                int n6 = object.zzc.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzflmArray[n4].zza != null) continue;
                    zzcil2.zzt().zzaa().zza("Event filter with no ID. Audience definition ignored. appId, audienceId", zzcjj.zza(string2), object.zza);
                    continue block3;
                }
                zzflmArray = object.zzb;
                n6 = object.zzb.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzflmArray[n4].zza != null) continue;
                    zzcil2.zzt().zzaa().zza("Property filter with no ID. Audience definition ignored. appId, audienceId", zzcjj.zza(string2), object.zza);
                    continue block3;
                }
                boolean bl = true;
                zzflm[] zzflmArray2 = object.zzc;
                n4 = object.zzc.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzcns2 = zzflmArray2[n3];
                    if (zzcil2.zza(string2, n5, zzcns2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    zzflmArray2 = object.zzb;
                    n4 = object.zzb.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzcns2 = zzflmArray2[n3];
                        if (zzcil2.zza(string2, n5, (zzcnv)((Object)zzcns2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzcil zzcil3 = zzcil2;
                zzcil3.zzaq();
                zzcil3.zzc();
                zzbq.zza((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzcil3.zzaa();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzcnr[] zzcnrArray2 = zzcnrArray;
            n = zzcnrArray.length;
            for (int i = 0; i < n; ++i) {
                zzcnr zzcnr3 = zzcnrArray2[i];
                object2.add(zzcnr3.zza);
            }
            this.zza(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzcns zzcns2) {
        byte[] byArray;
        this.zzaq();
        this.zzc();
        zzbq.zza((String)string);
        zzbq.zza((Object)((Object)zzcns2));
        if (TextUtils.isEmpty((CharSequence)zzcns2.zzb)) {
            this.zzt().zzaa().zza("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzcjj.zza(string), n, String.valueOf(zzcns2.zza));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzcns2.zzf()];
            zzflk zzflk2 = zzflk.zza((byte[])byArray, (int)0, (int)byArray2.length);
            zzcns2.zza(zzflk2);
            zzflk2.zza();
        }
        catch (IOException iOException) {
            this.zzt().zzy().zza("Configuration loss. Failed to serialize event filter. appId", zzcjj.zza(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzcns2.zza);
        contentValues.put("event_name", zzcns2.zzb);
        contentValues.put("data", byArray);
        try {
            if (this.zzaa().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzt().zzy().zza("Failed to insert event filter (got -1). appId", zzcjj.zza(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzt().zzy().zza("Error storing event filter. appId", zzcjj.zza(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzcnv zzcnv2) {
        byte[] byArray;
        this.zzaq();
        this.zzc();
        zzbq.zza((String)string);
        zzbq.zza((Object)((Object)zzcnv2));
        if (TextUtils.isEmpty((CharSequence)zzcnv2.zzb)) {
            this.zzt().zzaa().zza("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzcjj.zza(string), n, String.valueOf(zzcnv2.zza));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzcnv2.zzf()];
            zzflk zzflk2 = zzflk.zza((byte[])byArray, (int)0, (int)byArray2.length);
            zzcnv2.zza(zzflk2);
            zzflk2.zza();
        }
        catch (IOException iOException) {
            this.zzt().zzy().zza("Configuration loss. Failed to serialize property filter. appId", zzcjj.zza(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzcnv2.zza);
        contentValues.put("property_name", zzcnv2.zzb);
        contentValues.put("data", byArray);
        try {
            if (this.zzaa().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzt().zzy().zza("Failed to insert property filter (got -1). appId", zzcjj.zza(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzt().zzy().zza("Error storing property filter. appId", zzcjj.zza(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzcns>> zzf(String string, String string2) {
        this.zzaq();
        this.zzc();
        zzbq.zza((String)string);
        zzbq.zza((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.zzaa();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzcns>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzflj zzflj2 = zzflj.zza((byte[])byArray, (int)0, (int)byArray.length);
                zzcns zzcns2 = new zzcns();
                try {
                    zzcns2.zza(zzflj2);
                }
                catch (IOException iOException) {
                    this.zzt().zzy().zza("Failed to merge filter. appId", zzcjj.zza(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzcns> arrayList = (ArrayList<zzcns>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzcns>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzcns2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzcnv>> zzg(String string, String string2) {
        this.zzaq();
        this.zzc();
        zzbq.zza((String)string);
        zzbq.zza((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.zzaa();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzcnv>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzflj zzflj2 = zzflj.zza((byte[])byArray, (int)0, (int)byArray.length);
                zzcnv zzcnv2 = new zzcnv();
                try {
                    zzcnv2.zza(zzflj2);
                }
                catch (IOException iOException) {
                    this.zzt().zzy().zza("Failed to merge filter", zzcjj.zza(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzcnv> arrayList = (ArrayList<zzcnv>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzcnv>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzcnv2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zza(String string, List<Integer> list) {
        Object object;
        long l;
        zzbq.zza((String)string);
        this.zzaq();
        this.zzc();
        SQLiteDatabase sQLiteDatabase = this.zzaa();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzt().zzy().zza("Database error querying filters. appId", zzcjj.zza(string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzv().zzb(string2, zzciz.zzal);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzcof> zze(String string) {
        this.zzaq();
        this.zzc();
        zzbq.zza((String)string);
        SQLiteDatabase sQLiteDatabase = this.zzaa();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzflj zzflj2 = zzflj.zza((byte[])byArray, (int)0, (int)byArray.length);
                zzcof zzcof2 = new zzcof();
                try {
                    zzcof2.zza(zzflj2);
                }
                catch (IOException iOException) {
                    this.zzt().zzy().zza("Failed to merge filter results. appId, audienceId, error", zzcjj.zza(string), n, iOException);
                    continue;
                }
                arrayMap.put(n, zzcof2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        zzbq.zza((String)string);
        zzbq.zza((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzt().zzy().zza("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzt().zzy().zza("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzt().zzy().zza("Loaded invalid unknown value type, ignoring it", n3);
        return null;
    }

    @WorkerThread
    public final long zzae() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    protected final long zzh(String string, String string2) {
        zzbq.zza((String)string);
        zzbq.zza((String)string2);
        this.zzc();
        this.zzaq();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.zzaa();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzt().zzy().zza("Failed to insert column (got -1). appId", zzcjj.zza(string), string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzt().zzy().zza("Failed to update column (got 0). appId", zzcjj.zza(string), string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzt().zzy().zza("Error inserting column. appId", zzcjj.zza(string), string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzaf() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzcoe zzcoe2) throws IOException {
        long l;
        Object object;
        byte[] byArray;
        this.zzc();
        this.zzaq();
        zzbq.zza((Object)((Object)zzcoe2));
        zzbq.zza((String)zzcoe2.zzo);
        try {
            byArray = new byte[zzcoe2.zzf()];
            object = byArray;
            zzflk zzflk2 = zzflk.zza((byte[])byArray, (int)0, (int)((byte[])object).length);
            zzcoe2.zza(zzflk2);
            zzflk2.zza();
        }
        catch (IOException iOException) {
            this.zzt().zzy().zza("Data loss. Failed to serialize event metadata. appId", zzcjj.zza(zzcoe2.zzo), iOException);
            throw iOException;
        }
        byte[] byArray2 = byArray;
        object = this.zzp();
        zzbq.zza((Object)byArray2);
        ((zzclh)object).zzc();
        MessageDigest messageDigest = zzcno.zzf("MD5");
        if (messageDigest == null) {
            ((zzclh)object).zzt().zzy().zza("Failed to get MD5");
            l = 0L;
        } else {
            l = zzcno.zzc(messageDigest.digest(byArray2));
        }
        long l2 = l;
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcoe2.zzo);
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("metadata", byArray);
        try {
            this.zzaa().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzt().zzy().zza("Error storing raw event metadata. appId", zzcjj.zza(zzcoe2.zzo), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l2;
    }

    public final boolean zzag() {
        return this.zzb("select count(1) > 0 from raw_events", (String[])null) != 0L;
    }

    public final boolean zzah() {
        return this.zzb("select count(1) > 0 from raw_events where realtime = 1", (String[])null) != 0L;
    }

    public final void zza(List<Long> list) {
        zzbq.zza(list);
        this.zzc();
        this.zzaq();
        StringBuilder stringBuilder = new StringBuilder("rowid in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i));
        }
        stringBuilder.append(")");
        int n = this.zzaa().delete("raw_events", stringBuilder.toString(), null);
        if (n != list.size()) {
            this.zzt().zzy().zza("Deleted fewer rows from raw events table than expected", n, list.size());
        }
    }

    public final long zzf(String string) {
        zzbq.zza((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zza(long l) {
        this.zzc();
        this.zzaq();
        try (Cursor cursor = null;){
            cursor = this.zzaa().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzt().zzae().zza("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzai() {
        try (Cursor cursor = null;){
            cursor = this.zzaa().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final Pair<zzcob, Long> zza(String string, Long l) {
        this.zzc();
        this.zzaq();
        try (Cursor cursor = null;){
            cursor = this.zzaa().rawQuery("select main_event, children_to_process from main_event_params where app_id=? and event_id=?", new String[]{string, String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzt().zzae().zza("Main event not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            Long l2 = cursor.getLong(1);
            byte[] byArray2 = byArray;
            zzflj zzflj2 = zzflj.zza((byte[])byArray, (int)0, (int)byArray2.length);
            zzcob zzcob2 = new zzcob();
            try {
                zzcob2.zza(zzflj2);
            }
            catch (IOException iOException) {
                this.zzt().zzy().zza("Failed to merge main event. appId, eventId", zzcjj.zza(string), l, iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            Pair pair = Pair.create((Object)((Object)zzcob2), (Object)l2);
            return pair;
        }
        return null;
    }

    public final boolean zza(String string, Long l, long l2, zzcob zzcob2) {
        byte[] byArray;
        this.zzc();
        this.zzaq();
        zzbq.zza((Object)((Object)zzcob2));
        zzbq.zza((String)string);
        zzbq.zza((Object)l);
        try {
            byte[] byArray2 = byArray = new byte[zzcob2.zzf()];
            zzflk zzflk2 = zzflk.zza((byte[])byArray, (int)0, (int)byArray2.length);
            zzcob2.zza(zzflk2);
            zzflk2.zza();
        }
        catch (IOException iOException) {
            this.zzt().zzy().zza("Data loss. Failed to serialize event params/data. appId, eventId", zzcjj.zza(string), l, iOException);
            return false;
        }
        this.zzt().zzae().zza("Saving complex main event, appId, data size", this.zzo().zza(string), byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("event_id", l);
        contentValues.put("children_to_process", Long.valueOf(l2));
        contentValues.put("main_event", byArray);
        try {
            if (this.zzaa().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1L) {
                this.zzt().zzy().zza("Failed to insert complex main event (got -1). appId", zzcjj.zza(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzt().zzy().zza("Error storing complex main event. appId", zzcjj.zza(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(zzcis zzcis2, long l, boolean bl) {
        Object object;
        zzcoc zzcoc2;
        String string2;
        this.zzc();
        this.zzaq();
        zzbq.zza((Object)zzcis2);
        zzbq.zza((String)zzcis2.zza);
        zzcob zzcob2 = new zzcob();
        new zzcob().zzd = zzcis2.zzd;
        zzcob2.zza = new zzcoc[zzcis2.zze.zza()];
        int n = 0;
        for (String string2 : zzcis2.zze) {
            zzcoc2 = new zzcoc();
            zzcob2.zza[n++] = zzcoc2;
            zzcoc2.zza = string2;
            Object object2 = zzcis2.zze.zza(string2);
            this.zzp().zza(zzcoc2, object2);
        }
        try {
            byte[] byArray = new byte[zzcob2.zzf()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzcoc2 = zzflk.zza((byte[])byArray, (int)0, (int)byArray2.length);
            zzcob2.zza((zzflk)zzcoc2);
            zzcoc2.zza();
        }
        catch (IOException iOException) {
            this.zzt().zzy().zza("Data loss. Failed to serialize event params/data. appId", zzcjj.zza(zzcis2.zza), iOException);
            return false;
        }
        this.zzt().zzae().zza("Saving event, name, data size", this.zzo().zza(zzcis2.zzb), ((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzcis2.zza);
        string2.put("name", zzcis2.zzb);
        string2.put("timestamp", Long.valueOf(zzcis2.zzc));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.zzaa().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzt().zzy().zza("Failed to insert raw event (got -1). appId", zzcjj.zza(zzcis2.zza));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzt().zzy().zza("Error storing raw event. appId", zzcjj.zza(zzcis2.zza), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzat() {
        return this.zzl().getDatabasePath("google_app_measurement.db").exists();
    }

    @WorkerThread
    private static boolean zza(zzcjj zzcjj2, SQLiteDatabase sQLiteDatabase, String string) {
        if (zzcjj2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
            boolean bl = cursor.moveToFirst();
            return bl;
        }
    }

    @WorkerThread
    private static Set<String> zza(SQLiteDatabase sQLiteDatabase, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
        try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
            Collections.addAll(hashSet, cursor.getColumnNames());
        }
        return hashSet;
    }

    @WorkerThread
    private static void zza(zzcjj zzcjj2, SQLiteDatabase sQLiteDatabase, String string, String string2, String[] stringArray) throws SQLiteException {
        if (zzcjj2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        Set<String> set = zzcil.zza(sQLiteDatabase, string);
        for (String string3 : string2.split(",")) {
            if (set.remove(string3)) continue;
            throw new SQLiteException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Table ").append(string).append(" is missing required column: ").append(string3).toString());
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                if (set.remove(stringArray[i])) continue;
                sQLiteDatabase.execSQL(stringArray[i + 1]);
            }
        }
        if (!set.isEmpty()) {
            zzcjj2.zzaa().zza("Table has extra columns. table, columns", string, TextUtils.join((CharSequence)", ", set));
        }
    }

    @WorkerThread
    static void zza(zzcjj zzcjj2, SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, String[] stringArray) throws SQLiteException {
        if (zzcjj2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (!zzcil.zza(zzcjj2, sQLiteDatabase, string)) {
            sQLiteDatabase.execSQL(string2);
        }
        try {
            zzcil.zza(zzcjj2, sQLiteDatabase, string, string3, stringArray);
            return;
        }
        catch (SQLiteException sQLiteException) {
            zzcjj2.zzy().zza("Failed to verify columns on table that was just created", string);
            throw sQLiteException;
        }
    }

    static void zza(zzcjj zzcjj2, SQLiteDatabase sQLiteDatabase) {
        if (zzcjj2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        File file = new File(sQLiteDatabase.getPath());
        if (!file.setReadable(false, false)) {
            zzcjj2.zzaa().zza("Failed to turn off database read permission");
        }
        if (!file.setWritable(false, false)) {
            zzcjj2.zzaa().zza("Failed to turn off database write permission");
        }
        if (!file.setReadable(true, true)) {
            zzcjj2.zzaa().zza("Failed to turn on database read permission for owner");
        }
        if (!file.setWritable(true, true)) {
            zzcjj2.zzaa().zza("Failed to turn on database write permission for owner");
        }
    }

    static /* synthetic */ zzcni zza(zzcil zzcil2) {
        return zzcil2.zzh;
    }

    static /* synthetic */ String[] zzaj() {
        return zza;
    }

    static /* synthetic */ String[] zzak() {
        return zzb;
    }

    static /* synthetic */ String[] zzal() {
        return zzc;
    }

    static /* synthetic */ String[] zzam() {
        return zze;
    }

    static /* synthetic */ String[] zzan() {
        return zzd;
    }

    static /* synthetic */ String[] zzao() {
        return zzf;
    }
}

