/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.zzbz;
import com.google.android.gms.internal.zzbif;
import com.google.android.gms.internal.zzcif;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import com.google.firebase.iid.FirebaseInstanceId;
import java.math.BigInteger;
import java.util.Locale;

public final class zzcje
extends zzcli {
    private String zza;
    private String zzb;
    private int zzc;
    private String zzd;
    private String zze;
    private long zzf;
    private long zzg;
    private int zzh;
    private String zzi;

    zzcje(zzckj zzckj2) {
        super(zzckj2);
    }

    @Override
    protected final boolean zzw() {
        return true;
    }

    @Override
    protected final void p_() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzclh)this).zzl().getPackageName();
        PackageManager packageManager = ((zzclh)this).zzl().getPackageManager();
        if (packageManager == null) {
            ((zzclh)this).zzt().zzy().zza("PackageManager is null, app identity information might be inaccurate. appId", zzcjj.zza(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzclh)this).zzt().zzy().zza("Error retrieving app installer package name. appId", zzcjj.zza(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzclh)this).zzl().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzclh)this).zzt().zzy().zza("Error retrieving package info. appId, appName", zzcjj.zza(string4), string3);
            }
        }
        this.zza = string4;
        this.zzd = string;
        this.zzb = string2;
        this.zzc = n;
        this.zze = string3;
        this.zzf = 0L;
        packageInfo = zzbz.zza((Context)((zzclh)this).zzl());
        boolean bl = packageInfo != null && packageInfo.isSuccess();
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzcje zzcje2 = this;
            if (packageInfo2 == null) {
                ((zzclh)zzcje2).zzt().zzy().zza("GoogleService failed to initialize (no status)");
            } else {
                ((zzclh)zzcje2).zzt().zzy().zza("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzclh)this).zzv().zzb("firebase_analytics_collection_enabled");
            if (((zzclh)this).zzv().zzx()) {
                ((zzclh)this).zzt().zzac().zza("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                ((zzclh)this).zzt().zzac().zza("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && zzbz.zzb()) {
                ((zzclh)this).zzt().zzac().zza("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzclh)this).zzt().zzae().zza("Collection enabled");
            }
        }
        this.zzi = "";
        this.zzg = 0L;
        try {
            object = zzbz.zza();
            Object object2 = this.zzi = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (bl2) {
                ((zzclh)this).zzt().zzae().zza("App package, google app id", this.zza, this.zzi);
            }
        }
        catch (IllegalStateException illegalStateException) {
            ((zzclh)this).zzt().zzy().zza("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzcjj.zza(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzh = zzbif.zza((Context)((zzclh)this).zzl()) ? 1 : 0;
            return;
        }
        this.zzh = 0;
    }

    @WorkerThread
    final zzcif zza(String string) {
        ((zzclh)this).zzc();
        String string2 = this.zzz();
        String string3 = this.zzaa();
        zzcje zzcje2 = this;
        zzcje2.zzaq();
        String string4 = zzcje2.zzb;
        long l = this.zzab();
        zzcje2 = this;
        zzcje2.zzaq();
        String string5 = zzcje2.zzd;
        zzcje2 = this;
        zzcje2.zzaq();
        ((zzclh)zzcje2).zzc();
        if (zzcje2.zzf == 0L) {
            zzcje2.zzf = zzcje2.zzp.zzo().zzb(((zzclh)zzcje2).zzl(), ((zzclh)zzcje2).zzl().getPackageName());
        }
        long l2 = zzcje2.zzf;
        boolean bl = this.zzp.zzab();
        boolean bl2 = !((zzclh)this).zzu().zzo;
        String string6 = this.zzad();
        this.zzaq();
        Boolean bl3 = ((zzclh)this).zzv().zzb("google_analytics_adid_collection_enabled");
        return new zzcif(string2, string3, string4, l, string5, 12210L, l2, string, bl, bl2, string6, 0L, this.zzp.zzac(), this.zzac(), bl3 == null || bl3 != false);
    }

    @WorkerThread
    final String zzy() {
        byte[] byArray = new byte[16];
        ((zzclh)this).zzp().zzz().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    private final String zzad() {
        ((zzclh)this).zzc();
        try {
            return FirebaseInstanceId.getInstance().getId();
        }
        catch (IllegalStateException illegalStateException) {
            ((zzclh)this).zzt().zzaa().zza("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String zzz() {
        this.zzaq();
        return this.zza;
    }

    final String zzaa() {
        this.zzaq();
        return this.zzi;
    }

    final int zzab() {
        this.zzaq();
        return this.zzc;
    }

    final int zzac() {
        this.zzaq();
        return this.zzh;
    }
}

