/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.WorkerThread;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgn;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcix;
import com.google.android.gms.internal.zzcjg;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import com.google.android.gms.internal.zzcnl;
import com.google.android.gms.internal.zzcno;
import java.util.ArrayList;
import java.util.List;

public final class zzcjf
extends zzcli {
    private final zzcjg zza = new zzcjg(this, ((zzclh)this).zzl(), "google_app_measurement_local.db");
    private boolean zzb;

    zzcjf(zzckj zzckj2) {
        super(zzckj2);
    }

    @Override
    protected final boolean zzw() {
        return false;
    }

    @WorkerThread
    public final void zzy() {
        ((zzclh)this).zzc();
        try {
            SQLiteDatabase sQLiteDatabase = this.zzz();
            int n = 0 + sQLiteDatabase.delete("messages", null, null);
            if (n > 0) {
                ((zzclh)this).zzt().zzae().zza("Reset local analytics data. records", n);
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            ((zzclh)this).zzt().zzy().zza("Error resetting local analytics data. error", (Object)sQLiteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final boolean zza(int n, byte[] byArray) {
        ((zzclh)this).zzc();
        if (this.zzb) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("type", Integer.valueOf(n));
        contentValues.put("entry", byArray);
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block20: {
                if (n3 >= 5) {
                    ((zzclh)this).zzt().zzaa().zza("Failed to write entry to local database");
                    return false;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.zzz();
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.beginTransaction();
                        long l = 0L;
                        cursor = sQLiteDatabase.rawQuery("select count(1) from messages", null);
                        if (cursor != null && cursor.moveToFirst()) {
                            l = cursor.getLong(0);
                        }
                        if (l >= 100000L) {
                            ((zzclh)this).zzt().zzy().zza("Data loss, local db full");
                            long l2 = 100000L - l + 1L;
                            long l3 = sQLiteDatabase.delete("messages", "rowid in (select rowid from messages order by rowid asc limit ?)", new String[]{Long.toString(l2)});
                            if (l3 != l2) {
                                ((zzclh)this).zzt().zzy().zza("Different delete count than expected in local db. expected, received, difference", l2, l3, l2 - l3);
                            }
                        }
                        sQLiteDatabase.insertOrThrow("messages", null, contentValues);
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        return true;
                    }
                    this.zzb = true;
                    if (sQLiteDatabase == null) return false;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzclh)this).zzt().zzy().zza("Error writing entry to local database", (Object)sQLiteFullException);
                    this.zzb = true;
                    break block20;
                }
                catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                    SystemClock.sleep((long)n2);
                    n2 += 20;
                    break block20;
                }
                catch (SQLiteException sQLiteException) {
                    if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                        sQLiteDatabase.endTransaction();
                    }
                    ((zzclh)this).zzt().zzy().zza("Error writing entry to local database", (Object)sQLiteException);
                    this.zzb = true;
                    break block20;
                }
                sQLiteDatabase.close();
                return false;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    public final boolean zza(zzcix zzcix2) {
        Parcel parcel = Parcel.obtain();
        zzcix2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzclh)this).zzt().zzaa().zza("Event is too long for local database. Sending event directly to service");
            return false;
        }
        return this.zza(0, byArray);
    }

    public final boolean zza(zzcnl zzcnl2) {
        Parcel parcel = Parcel.obtain();
        zzcnl2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzclh)this).zzt().zzaa().zza("User property too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(1, byArray);
    }

    public final boolean zza(zzcii zzcii2) {
        ((zzclh)this).zzp();
        byte[] byArray = zzcno.zza((Parcelable)zzcii2);
        if (byArray.length > 131072) {
            ((zzclh)this).zzt().zzaa().zza("Conditional user property too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(2, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final List<zzbgl> zza(int n) {
        ((zzclh)this).zzc();
        if (this.zzb) {
            return null;
        }
        ArrayList<zzbgl> arrayList = new ArrayList<zzbgl>();
        if (!((zzclh)this).zzl().getDatabasePath("google_app_measurement_local.db").exists()) {
            return arrayList;
        }
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block41: {
                if (n3 >= 5) {
                    ((zzclh)this).zzt().zzaa().zza("Failed to read events from database in reasonable time");
                    return null;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.zzz();
                    if (sQLiteDatabase != null) {
                        Object object;
                        sQLiteDatabase.beginTransaction();
                        cursor = sQLiteDatabase.query("messages", new String[]{"rowid", "type", "entry"}, null, null, null, null, "rowid asc", Integer.toString(100));
                        long l = -1L;
                        while (cursor.moveToNext()) {
                            zzbgl zzbgl2;
                            Parcel parcel;
                            l = cursor.getLong(0);
                            int n4 = cursor.getInt(1);
                            object = cursor.getBlob(2);
                            if (n4 == 0) {
                                parcel = Parcel.obtain();
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zzbgl2 = (zzcix)((Object)zzcix.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzbgn zzbgn2) {
                                    ((zzclh)this).zzt().zzy().zza("Failed to load event from local database");
                                    continue;
                                }
                                finally {
                                    parcel.recycle();
                                    continue;
                                }
                                if (zzbgl2 == null) continue;
                                arrayList.add(zzbgl2);
                                continue;
                            }
                            if (n4 == 1) {
                                parcel = Parcel.obtain();
                                zzbgl2 = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zzbgl2 = (zzcnl)((Object)zzcnl.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzbgn zzbgn3) {
                                    ((zzclh)this).zzt().zzy().zza("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (zzbgl2 == null) continue;
                                arrayList.add(zzbgl2);
                                continue;
                            }
                            if (n4 == 2) {
                                parcel = Parcel.obtain();
                                zzbgl2 = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zzbgl2 = (zzcii)((Object)zzcii.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzbgn zzbgn4) {
                                    ((zzclh)this).zzt().zzy().zza("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (zzbgl2 == null) continue;
                                arrayList.add(zzbgl2);
                                continue;
                            }
                            ((zzclh)this).zzt().zzy().zza("Unknown record type in local database");
                        }
                        if (sQLiteDatabase.delete("messages", "rowid <= ?", new String[]{Long.toString(l)}) < arrayList.size()) {
                            ((zzclh)this).zzt().zzy().zza("Fewer entries removed from local database than expected");
                        }
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        object = arrayList;
                        return object;
                    }
                    this.zzb = true;
                    if (sQLiteDatabase == null) return null;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzclh)this).zzt().zzy().zza("Error reading entries from local database", (Object)sQLiteFullException);
                    this.zzb = true;
                    break block41;
                }
                catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                    SystemClock.sleep((long)n2);
                    n2 += 20;
                    break block41;
                }
                catch (SQLiteException sQLiteException) {
                    if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                        sQLiteDatabase.endTransaction();
                    }
                    ((zzclh)this).zzt().zzy().zza("Error reading entries from local database", (Object)sQLiteException);
                    this.zzb = true;
                    break block41;
                }
                sQLiteDatabase.close();
                return null;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    @WorkerThread
    private final SQLiteDatabase zzz() throws SQLiteException {
        if (this.zzb) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.zza.getWritableDatabase();
        if (sQLiteDatabase == null) {
            this.zzb = true;
            return null;
        }
        return sQLiteDatabase;
    }
}

