/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcjw;
import com.google.android.gms.internal.zzcjx;
import com.google.android.gms.internal.zzcjy;
import com.google.android.gms.internal.zzcjz;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzcli;
import com.google.android.gms.internal.zzcno;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzcju
extends zzcli {
    static final Pair<String, Long> zza = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzq;
    public zzcjy zzb;
    public final zzcjx zzc = new zzcjx(this, "last_upload", 0L);
    public final zzcjx zzd = new zzcjx(this, "last_upload_attempt", 0L);
    public final zzcjx zze = new zzcjx(this, "backoff", 0L);
    public final zzcjx zzf = new zzcjx(this, "last_delete_stale", 0L);
    public final zzcjx zzg;
    public final zzcjx zzh;
    public final zzcjz zzi;
    private String zzr;
    private boolean zzs;
    private long zzt;
    private String zzu;
    private long zzv;
    private final Object zzw;
    public final zzcjx zzj = new zzcjx(this, "time_before_start", 10000L);
    public final zzcjx zzk = new zzcjx(this, "session_timeout", 1800000L);
    public final zzcjw zzl = new zzcjw(this, "start_new_session", true);
    public final zzcjx zzm = new zzcjx(this, "last_pause_time", 0L);
    public final zzcjx zzn = new zzcjx(this, "time_active", 0L);
    public boolean zzo;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zza(String string) {
        this.zzc();
        long l = this.zzk().zzb();
        if (this.zzr != null && l < this.zzt) {
            return new Pair((Object)this.zzr, (Object)this.zzs);
        }
        String string2 = string;
        this.zzt = l + this.zzv().zza(string2, zzciz.zzh);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.zzl());
            if (info != null) {
                this.zzr = info.getId();
                this.zzs = info.isLimitAdTrackingEnabled();
            }
            if (this.zzr == null) {
                this.zzr = "";
            }
        }
        catch (Throwable throwable) {
            this.zzt().zzad().zza("Unable to get advertising id", throwable);
            this.zzr = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzr, (Object)this.zzs);
    }

    @WorkerThread
    final String zzb(String string) {
        this.zzc();
        String string2 = (String)this.zza((String)string).first;
        MessageDigest messageDigest = zzcno.zzf("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzcju(zzckj zzckj2) {
        super(zzckj2);
        this.zzg = new zzcjx(this, "midnight_offset", 0L);
        this.zzh = new zzcjx(this, "first_open_time", 0L);
        this.zzi = new zzcjz(this, "app_instance_id", null);
        this.zzw = new Object();
    }

    @Override
    protected final boolean zzw() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void p_() {
        this.zzq = this.zzl().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzo = this.zzq.getBoolean("has_been_opened", false);
        if (!this.zzo) {
            SharedPreferences.Editor editor = this.zzq.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzb = new zzcjy(this, "health_monitor", Math.max(0L, zzciz.zzi.zzb()), null);
    }

    @WorkerThread
    private final SharedPreferences zzad() {
        this.zzc();
        this.zzaq();
        return this.zzq;
    }

    @WorkerThread
    final void zzc(String string) {
        this.zzc();
        SharedPreferences.Editor editor = this.zzad().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzy() {
        this.zzc();
        return this.zzad().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzd(String string) {
        Object object = this.zzw;
        synchronized (object) {
            this.zzu = string;
            this.zzv = this.zzk().zzb();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzz() {
        Object object = this.zzw;
        synchronized (object) {
            if (Math.abs(this.zzk().zzb() - this.zzv) < 1000L) {
                return this.zzu;
            }
            return null;
        }
    }

    @WorkerThread
    final Boolean zzaa() {
        this.zzc();
        if (!this.zzad().contains("use_service")) {
            return null;
        }
        return this.zzad().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzc();
        this.zzt().zzae().zza("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzad().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzab() {
        this.zzc();
        this.zzt().zzae().zza("Clearing collection preferences.");
        boolean bl = this.zzad().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzc(true);
        }
        SharedPreferences.Editor editor = this.zzad().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.zzb(bl2);
        }
    }

    @WorkerThread
    final void zzb(boolean bl) {
        this.zzc();
        this.zzt().zzae().zza("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzad().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzc(boolean bl) {
        this.zzc();
        return this.zzad().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected final String zzac() {
        this.zzc();
        String string = this.zzad().getString("previous_os_version", null);
        this.zzh().zzaq();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzad().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    static /* synthetic */ SharedPreferences zza(zzcju zzcju2) {
        return zzcju2.zzad();
    }
}

