/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzckg;
import com.google.android.gms.internal.zzckh;
import com.google.android.gms.internal.zzcki;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class zzcke
extends zzcli {
    private ExecutorService zza;
    private zzcki zzb;
    private zzcki zzc;
    private final PriorityBlockingQueue<zzckh<?>> zzd;
    private final BlockingQueue<zzckh<?>> zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Thread.UncaughtExceptionHandler zzg;
    private final Object zzh = new Object();
    private final Semaphore zzi = new Semaphore(2);
    private volatile boolean zzj;
    private static final AtomicLong zzk = new AtomicLong(Long.MIN_VALUE);

    zzcke(zzckj zzckj2) {
        super(zzckj2);
        this.zzd = new PriorityBlockingQueue();
        this.zze = new LinkedBlockingQueue();
        this.zzf = new zzckg(this, "Thread death: Uncaught exception on worker thread");
        this.zzg = new zzckg(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzw() {
        return false;
    }

    @Override
    public final void zzc() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzb() {
        if (Thread.currentThread() != this.zzc) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public static boolean zzy() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public final boolean zzz() {
        return Thread.currentThread() == this.zzb;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzaq();
        zzbq.zza(callable);
        zzckh zzckh2 = new zzckh(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzb) {
            if (!this.zzd.isEmpty()) {
                ((zzclh)this).zzt().zzaa().zza("Callable skipped the worker queue.");
            }
            zzckh2.run();
        } else {
            this.zza(zzckh2);
        }
        return zzckh2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzaq();
        zzbq.zza(callable);
        zzckh zzckh2 = new zzckh(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzb) {
            zzckh2.run();
        } else {
            this.zza(zzckh2);
        }
        return zzckh2;
    }

    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzaq();
        zzbq.zza((Object)runnable);
        this.zza(new zzckh(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzckh<?> zzckh2) {
        Object object = this.zzh;
        synchronized (object) {
            this.zzd.add(zzckh2);
            if (this.zzb == null) {
                this.zzb = new zzcki(this, "Measurement Worker", this.zzd);
                this.zzb.setUncaughtExceptionHandler(this.zzf);
                this.zzb.start();
            } else {
                this.zzb.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzaq();
        zzbq.zza((Object)runnable);
        zzckh zzckh2 = new zzckh(this, runnable, false, "Task exception on network thread");
        zzcke zzcke2 = this;
        Object object = zzcke2.zzh;
        synchronized (object) {
            zzcke2.zze.add(zzckh2);
            if (zzcke2.zzc == null) {
                zzcke2.zzc = new zzcki(zzcke2, "Measurement Network", zzcke2.zze);
                zzcke2.zzc.setUncaughtExceptionHandler(zzcke2.zzg);
                zzcke2.zzc.start();
            } else {
                zzcke2.zzc.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecutorService zzaa() {
        Object object = this.zzh;
        synchronized (object) {
            if (this.zza == null) {
                this.zza = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zza;
        }
    }

    static /* synthetic */ Semaphore zza(zzcke zzcke2) {
        return zzcke2.zzi;
    }

    static /* synthetic */ boolean zzb(zzcke zzcke2) {
        return zzcke2.zzj;
    }

    static /* synthetic */ Object zzc(zzcke zzcke2) {
        return zzcke2.zzh;
    }

    static /* synthetic */ zzcki zzd(zzcke zzcke2) {
        return zzcke2.zzb;
    }

    static /* synthetic */ zzcki zza(zzcke zzcke2, zzcki zzcki2) {
        zzcke2.zzb = null;
        return null;
    }

    static /* synthetic */ zzcki zze(zzcke zzcke2) {
        return zzcke2.zzc;
    }

    static /* synthetic */ zzcki zzb(zzcke zzcke2, zzcki zzcki2) {
        zzcke2.zzc = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzab() {
        return zzk;
    }
}

