/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.api.internal.zzbz;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzb;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbih;
import com.google.android.gms.internal.zzcia;
import com.google.android.gms.internal.zzcie;
import com.google.android.gms.internal.zzcif;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcik;
import com.google.android.gms.internal.zzcil;
import com.google.android.gms.internal.zzcin;
import com.google.android.gms.internal.zzcir;
import com.google.android.gms.internal.zzcis;
import com.google.android.gms.internal.zzcit;
import com.google.android.gms.internal.zzciu;
import com.google.android.gms.internal.zzcix;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcje;
import com.google.android.gms.internal.zzcjf;
import com.google.android.gms.internal.zzcjh;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzcjn;
import com.google.android.gms.internal.zzcjr;
import com.google.android.gms.internal.zzcjs;
import com.google.android.gms.internal.zzcju;
import com.google.android.gms.internal.zzcka;
import com.google.android.gms.internal.zzckd;
import com.google.android.gms.internal.zzcke;
import com.google.android.gms.internal.zzckk;
import com.google.android.gms.internal.zzckl;
import com.google.android.gms.internal.zzckm;
import com.google.android.gms.internal.zzckn;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import com.google.android.gms.internal.zzclj;
import com.google.android.gms.internal.zzclk;
import com.google.android.gms.internal.zzcly;
import com.google.android.gms.internal.zzcma;
import com.google.android.gms.internal.zzcme;
import com.google.android.gms.internal.zzcmy;
import com.google.android.gms.internal.zzcnd;
import com.google.android.gms.internal.zzcnj;
import com.google.android.gms.internal.zzcnl;
import com.google.android.gms.internal.zzcnn;
import com.google.android.gms.internal.zzcno;
import com.google.android.gms.internal.zzcny;
import com.google.android.gms.internal.zzcoa;
import com.google.android.gms.internal.zzcob;
import com.google.android.gms.internal.zzcoc;
import com.google.android.gms.internal.zzcod;
import com.google.android.gms.internal.zzcoe;
import com.google.android.gms.internal.zzcog;
import com.google.android.gms.internal.zzflj;
import com.google.android.gms.internal.zzflk;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class zzckj {
    private static volatile zzckj zza;
    private final Context zzb;
    private final zzcik zzc;
    private final zzcju zzd;
    private final zzcjj zze;
    private final zzcke zzf;
    private final zzcnd zzg;
    private final zzckd zzh;
    private final AppMeasurement zzi;
    private final FirebaseAnalytics zzj;
    private final zzcno zzk;
    private final zzcjh zzl;
    private final zzcjn zzm;
    private final zze zzn;
    private final zzcma zzo;
    private final zzclk zzp;
    private final zzcia zzq;
    private zzcil zzr;
    private zzcjf zzs;
    private zzcme zzt;
    private zzcir zzu;
    private zzcje zzv;
    private zzcjs zzw;
    private zzcnj zzx;
    private zzcih zzy;
    private boolean zzz = false;
    private boolean zzaa;
    private Boolean zzab;
    private long zzac;
    private FileLock zzad;
    private FileChannel zzae;
    private List<Long> zzaf;
    private List<Runnable> zzag;
    private int zzah;
    private int zzai;
    private long zzaj;
    private long zzak;
    private boolean zzal;
    private boolean zzam;
    private boolean zzan;
    private final long zzao;

    private zzckj(zzclj zzclj2) {
        zzcia zzcia2;
        zzbq.zza((Object)zzclj2);
        this.zzb = zzclj2.zza;
        this.zzaj = -1L;
        this.zzn = com.google.android.gms.common.util.zzi.zzd();
        this.zzao = this.zzn.zza();
        zzckj zzckj2 = this;
        this.zzc = new zzcik(zzckj2);
        zzckj2 = this;
        zzcju zzcju2 = new zzcju(zzckj2);
        zzcju2.zzar();
        this.zzd = zzcju2;
        zzckj2 = this;
        zzcjj zzcjj2 = new zzcjj(zzckj2);
        zzcjj2.zzar();
        this.zze = zzcjj2;
        zzckj2 = this;
        zzcno zzcno2 = new zzcno(zzckj2);
        zzcno2.zzar();
        this.zzk = zzcno2;
        zzckj2 = this;
        zzcjh zzcjh2 = new zzcjh(zzckj2);
        zzcjh2.zzar();
        this.zzl = zzcjh2;
        zzckj2 = this;
        this.zzq = zzcia2 = new zzcia(zzckj2);
        zzckj2 = this;
        zzcjn zzcjn2 = new zzcjn(zzckj2);
        zzcjn2.zzar();
        this.zzm = zzcjn2;
        zzckj2 = this;
        zzcma zzcma2 = new zzcma(zzckj2);
        zzcma2.zzar();
        this.zzo = zzcma2;
        zzckj2 = this;
        zzclk zzclk2 = new zzclk(zzckj2);
        zzclk2.zzar();
        this.zzp = zzclk2;
        zzckj2 = this;
        this.zzi = new AppMeasurement(zzckj2);
        zzckj2 = this;
        this.zzj = new FirebaseAnalytics(zzckj2);
        zzckj2 = this;
        zzcnd zzcnd2 = new zzcnd(zzckj2);
        zzcnd2.zzar();
        this.zzg = zzcnd2;
        zzckj2 = this;
        zzckd zzckd2 = new zzckd(zzckj2);
        zzckd2.zzar();
        this.zzh = zzckd2;
        zzckj2 = this;
        zzcke zzcke2 = new zzcke(zzckj2);
        zzcke2.zzar();
        this.zzf = zzcke2;
        zzckj2 = this;
        if (zzckj2.zzb.getApplicationContext() instanceof Application) {
            zzclk zzclk3 = zzckj2.zzl();
            if (((zzclh)zzclk3).zzl().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzclh)zzclk3).zzl().getApplicationContext();
                if (zzclk3.zza == null) {
                    zzclk3.zza = new zzcly(zzclk3, null);
                }
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzclk3.zza);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzclk3.zza);
                ((zzclh)zzclk3).zzt().zzae().zza("Registered activity lifecycle callback");
            }
        } else {
            zzckj2.zzf().zzaa().zza("Application context is not an Application");
        }
        this.zzf.zza(new zzckk(this, zzclj2));
    }

    final void zza() {
        if (!this.zzz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected final boolean zzb() {
        this.zza();
        ((zzclh)this.zzh()).zzc();
        if (this.zzab == null || this.zzac == 0L || this.zzab != null && !this.zzab.booleanValue() && Math.abs(this.zzn.zzb() - this.zzac) > 1000L) {
            this.zzac = this.zzn.zzb();
            this.zzab = this.zzo().zzg("android.permission.INTERNET") && this.zzo().zzg("android.permission.ACCESS_NETWORK_STATE") && (zzbih.zza((Context)this.zzb).zza() || zzcka.zza(this.zzb) && zzcmy.zza(this.zzb, false));
            if (this.zzab.booleanValue()) {
                this.zzab = this.zzo().zze(this.zzy().zzaa());
            }
        }
        return this.zzab;
    }

    @WorkerThread
    private final void zza(zzclj zzclj2) {
        String string;
        zzcjl zzcjl2;
        ((zzclh)this.zzh()).zzc();
        zzckj zzckj2 = this;
        zzcir zzcir2 = new zzcir(zzckj2);
        zzcir2.zzar();
        this.zzu = zzcir2;
        zzckj2 = this;
        zzcje zzcje2 = new zzcje(zzckj2);
        zzcje2.zzar();
        this.zzv = zzcje2;
        zzckj2 = this;
        zzcil zzcil2 = new zzcil(zzckj2);
        zzcil2.zzar();
        this.zzr = zzcil2;
        zzckj2 = this;
        zzcjf zzcjf2 = new zzcjf(zzckj2);
        zzcjf2.zzar();
        this.zzs = zzcjf2;
        zzckj2 = this;
        zzcih zzcih2 = new zzcih(zzckj2);
        zzcih2.zzar();
        this.zzy = zzcih2;
        zzckj2 = this;
        zzcme zzcme2 = new zzcme(zzckj2);
        zzcme2.zzar();
        this.zzt = zzcme2;
        zzckj2 = this;
        zzcnj zzcnj2 = new zzcnj(zzckj2);
        zzcnj2.zzar();
        this.zzx = zzcnj2;
        zzckj2 = this;
        this.zzw = new zzcjs(zzckj2);
        this.zzk.zzas();
        this.zzd.zzas();
        this.zzv.zzas();
        this.zzf().zzac().zza("App measurement is starting up, version", 12210L);
        this.zzf().zzac().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string2 = zzcje2.zzz();
        if (this.zzo().zzi(string2)) {
            zzcjl2 = this.zzf().zzac();
            string = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
        } else {
            zzcjl2 = this.zzf().zzac();
            String string3 = String.valueOf(string2);
            string = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
        }
        zzcjl2.zza(string);
        this.zzf().zzad().zza("Debug-level message logging enabled");
        if (this.zzah != this.zzai) {
            this.zzf().zzy().zza("Not all components initialized", this.zzah, this.zzai);
        }
        this.zzz = true;
    }

    @WorkerThread
    protected final void zzc() {
        ((zzclh)this.zzh()).zzc();
        this.zzq().zzad();
        if (this.zze().zzc.zza() == 0L) {
            this.zze().zzc.zza(this.zzn.zza());
        }
        if (Long.valueOf(this.zze().zzh.zza()) == 0L) {
            this.zzf().zzae().zza("Persisting first open", this.zzao);
            this.zze().zzh.zza(this.zzao);
        }
        if (!this.zzb()) {
            if (this.zzab()) {
                if (!this.zzo().zzg("android.permission.INTERNET")) {
                    this.zzf().zzy().zza("App is missing INTERNET permission");
                }
                if (!this.zzo().zzg("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzf().zzy().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!zzbih.zza((Context)this.zzb).zza()) {
                    if (!zzcka.zza(this.zzb)) {
                        this.zzf().zzy().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzcmy.zza(this.zzb, false)) {
                        this.zzf().zzy().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzf().zzy().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzaa())) {
                String string = this.zze().zzy();
                if (string == null) {
                    this.zze().zzc(this.zzy().zzaa());
                } else if (!string.equals(this.zzy().zzaa())) {
                    this.zzf().zzac().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zze().zzab();
                    this.zzt.zzae();
                    this.zzt.zzac();
                    this.zze().zzc(this.zzy().zzaa());
                    this.zze().zzh.zza(this.zzao);
                    this.zze().zzi.zza(null);
                }
            }
            this.zzl().zza(this.zze().zzi.zza());
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzaa())) {
                zzclk zzclk2 = this.zzl();
                ((zzclh)zzclk2).zzc();
                zzclk2.zzaq();
                if (zzclk2.zzp.zzb()) {
                    ((zzclh)zzclk2).zzi().zzab();
                    String string = ((zzclh)zzclk2).zzu().zzac();
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        ((zzclh)zzclk2).zzh().zzaq();
                        if (!string.equals(Build.VERSION.RELEASE)) {
                            Bundle bundle = new Bundle();
                            bundle.putString("_po", string);
                            zzclk2.zza("auto", "_ou", bundle);
                        }
                    }
                }
                this.zzw().zza(new AtomicReference<String>());
            }
        }
        this.zzam();
    }

    public final zzcik zzd() {
        return this.zzc;
    }

    public final zzcju zze() {
        zzckj.zza(this.zzd);
        return this.zzd;
    }

    public final zzcjj zzf() {
        zzckj.zzb(this.zze);
        return this.zze;
    }

    public final zzcjj zzg() {
        if (this.zze != null && this.zze.zzap()) {
            return this.zze;
        }
        return null;
    }

    public final zzcke zzh() {
        zzckj.zzb(this.zzf);
        return this.zzf;
    }

    public final zzcnd zzi() {
        zzckj.zzb(this.zzg);
        return this.zzg;
    }

    public final zzckd zzj() {
        zzckj.zzb(this.zzh);
        return this.zzh;
    }

    final zzcke zzk() {
        return this.zzf;
    }

    public final zzclk zzl() {
        zzckj.zzb(this.zzp);
        return this.zzp;
    }

    public final AppMeasurement zzm() {
        return this.zzi;
    }

    public final FirebaseAnalytics zzn() {
        return this.zzj;
    }

    public final zzcno zzo() {
        zzckj.zza(this.zzk);
        return this.zzk;
    }

    public final zzcjh zzp() {
        zzckj.zza(this.zzl);
        return this.zzl;
    }

    public final zzcil zzq() {
        zzckj.zzb(this.zzr);
        return this.zzr;
    }

    public final zzcjf zzr() {
        zzckj.zzb(this.zzs);
        return this.zzs;
    }

    public final zzcjn zzs() {
        zzckj.zzb(this.zzm);
        return this.zzm;
    }

    public final Context zzt() {
        return this.zzb;
    }

    public final zze zzu() {
        return this.zzn;
    }

    public final zzcma zzv() {
        zzckj.zzb(this.zzo);
        return this.zzo;
    }

    public final zzcme zzw() {
        zzckj.zzb(this.zzt);
        return this.zzt;
    }

    public final zzcir zzx() {
        zzckj.zzb(this.zzu);
        return this.zzu;
    }

    public final zzcje zzy() {
        zzckj.zzb(this.zzv);
        return this.zzv;
    }

    private final zzcjs zzah() {
        if (this.zzw == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzw;
    }

    private final zzcnj zzai() {
        zzckj.zzb(this.zzx);
        return this.zzx;
    }

    public final zzcih zzz() {
        zzckj.zzb(this.zzy);
        return this.zzy;
    }

    public final zzcia zzaa() {
        zzckj.zza(this.zzq);
        return this.zzq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzckj zza(Context context) {
        zzbq.zza((Object)context);
        zzbq.zza((Object)context.getApplicationContext());
        if (zza != null) return zza;
        Class<zzckj> clazz = zzckj.class;
        synchronized (zzckj.class) {
            if (zza != null) return zza;
            zzclj zzclj2 = new zzclj(context);
            zza = new zzckj(zzclj2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    final void zza(zzcif zzcif2) {
        this.zzq().zzb(zzcif2.zza);
        String string = zzcif2.zza;
        zzcil zzcil2 = this.zzq();
        zzbq.zza((String)string);
        zzcil2.zzc();
        zzcil2.zzaq();
        try {
            SQLiteDatabase sQLiteDatabase = zzcil2.zzaa();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzcil2.zzt().zzae().zza("Reset analytics data. app, records", string, n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzcil2.zzt().zzy().zza("Error resetting analytics data. appId, error", zzcjj.zza(string), (Object)sQLiteException);
        }
        zzcif zzcif3 = this.zza(this.zzb, zzcif2.zza, zzcif2.zzb, zzcif2.zzh, zzcif2.zzo);
        this.zzc(zzcif3);
    }

    private final zzcif zza(Context context, String string, String string2, boolean bl, boolean bl2) {
        String string3 = "Unknown";
        String string4 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string5 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzf().zzy().zza("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string3 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzf().zzy().zza("Error retrieving installer package name. appId", zzcjj.zza(string));
        }
        if (string3 == null) {
            string3 = "manual_install";
        } else if ("com.android.vending".equals(string3)) {
            string3 = "";
        }
        try {
            PackageInfo packageInfo = zzbih.zza((Context)context).zzb(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = zzbih.zza((Context)context).zzb(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string5 = charSequence.toString();
                }
                string4 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzf().zzy().zza("Error retrieving newly installed package info. appId, appName", zzcjj.zza(string), string5);
            return null;
        }
        return new zzcif(string, string2, string4, n, string3, 12210L, this.zzo().zzb(context, string), null, bl, false, "", 0L, 0L, 0, bl2);
    }

    private static void zzb(zzcli zzcli2) {
        if (zzcli2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzcli2.zzap()) {
            String string = String.valueOf(zzcli2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzclh zzclh2) {
        if (zzclh2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    private final boolean zzaj() {
        ((zzclh)this.zzh()).zzc();
        String string = "google_app_measurement.db";
        File file = this.zzb.getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzae = new RandomAccessFile(file2, "rw").getChannel();
            this.zzad = this.zzae.tryLock();
            if (this.zzad != null) {
                this.zzf().zzae().zza("Storage concurrent access okay");
                return true;
            }
            this.zzf().zzy().zza("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzf().zzy().zza("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzf().zzy().zza("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        ((zzclh)this.zzh()).zzc();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzf().zzy().zza("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzf().zzaa().zza("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzf().zzy().zza("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        ((zzclh)this.zzh()).zzc();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzf().zzy().zza("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzf().zzy().zza("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzf().zzy().zza("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public final boolean zzab() {
        ((zzclh)this.zzh()).zzc();
        this.zza();
        if (this.zzc.zzx()) {
            return false;
        }
        Boolean bl = this.zzc.zzb("firebase_analytics_collection_enabled");
        boolean bl2 = bl != null ? bl : !zzbz.zzb();
        return this.zze().zzc(bl2);
    }

    final void zzb(zzcif zzcif2) {
        ((zzclh)this.zzh()).zzc();
        this.zza();
        zzbq.zza((String)zzcif2.zza);
        this.zzd(zzcif2);
    }

    final long zzac() {
        Long l = this.zze().zzh.zza();
        if (l == 0L) {
            return this.zzao;
        }
        return Math.min(this.zzao, l);
    }

    private final long zzak() {
        long l = this.zzn.zza();
        zzcju zzcju2 = this.zze();
        zzcju2.zzaq();
        zzcju2.zzc();
        long l2 = zzcju2.zzg.zza();
        if (l2 == 0L) {
            l2 = 1 + zzcju2.zzp().zzz().nextInt(86400000);
            zzcju2.zzg.zza(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    private final zzcif zzb(String string) {
        zzcie zzcie2 = this.zzq().zzb(string);
        if (zzcie2 == null || TextUtils.isEmpty((CharSequence)zzcie2.zzi())) {
            this.zzf().zzad().zza("No app data available; dropping", string);
            return null;
        }
        Boolean bl = this.zzb(zzcie2);
        if (bl != null && !bl.booleanValue()) {
            this.zzf().zzy().zza("App version does not match; dropping. appId", zzcjj.zza(string));
            return null;
        }
        return new zzcif(string, zzcie2.zzd(), zzcie2.zzi(), zzcie2.zzj(), zzcie2.zzk(), zzcie2.zzl(), zzcie2.zzm(), null, zzcie2.zzn(), false, zzcie2.zzf(), zzcie2.zzaa(), 0L, 0, zzcie2.zzab());
    }

    @WorkerThread
    final void zza(zzcix zzcix2, String string) {
        zzcie zzcie2 = this.zzq().zzb(string);
        if (zzcie2 == null || TextUtils.isEmpty((CharSequence)zzcie2.zzi())) {
            this.zzf().zzad().zza("No app data available; dropping event", string);
            return;
        }
        Boolean bl = this.zzb(zzcie2);
        if (bl == null) {
            if (!"_ui".equals(zzcix2.zza)) {
                this.zzf().zzaa().zza("Could not find package. appId", zzcjj.zza(string));
            }
        } else if (!bl.booleanValue()) {
            this.zzf().zzy().zza("App version does not match; dropping event. appId", zzcjj.zza(string));
            return;
        }
        zzcif zzcif2 = new zzcif(string, zzcie2.zzd(), zzcie2.zzi(), zzcie2.zzj(), zzcie2.zzk(), zzcie2.zzl(), zzcie2.zzm(), null, zzcie2.zzn(), false, zzcie2.zzf(), zzcie2.zzaa(), 0L, 0, zzcie2.zzab());
        this.zza(zzcix2, zzcif2);
    }

    @WorkerThread
    final void zza(zzcix zzcix2, zzcif zzcif2) {
        zzbq.zza((Object)((Object)zzcif2));
        zzbq.zza((String)zzcif2.zza);
        ((zzclh)this.zzh()).zzc();
        this.zza();
        String string = zzcif2.zza;
        long l = zzcix2.zzd;
        this.zzo();
        if (!zzcno.zza(zzcix2, zzcif2)) {
            return;
        }
        if (!zzcif2.zzh) {
            this.zzd(zzcif2);
            return;
        }
        this.zzq().zzx();
        try {
            zzbgl zzbgl2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzcil zzcil2 = this.zzq();
            zzbq.zza((String)string3);
            zzcil2.zzc();
            zzcil2.zzaq();
            if (l2 < 0L) {
                zzcil2.zzt().zzaa().zza("Invalid time querying timed out conditional properties", zzcjj.zza(string3), l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzcil2.zza(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzf().zzad().zza("User property timed out", object22.zza, this.zzp().zzc(object22.zzc.zza), object22.zzc.zza());
                if (object22.zzg != null) {
                    this.zzb(new zzcix(object22.zzg, l), zzcif2);
                }
                this.zzq().zze(string, object22.zzc.zza);
            }
            l2 = l;
            string3 = string;
            zzcil2 = this.zzq();
            zzbq.zza((String)string3);
            zzcil2.zzc();
            zzcil2.zzaq();
            if (l2 < 0L) {
                zzcil2.zzt().zzaa().zza("Invalid time querying expired conditional properties", zzcjj.zza(string3), l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzcil2.zza(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzcii)((Object)object4.next());
                if (object == null) continue;
                this.zzf().zzad().zza("User property expired", object.zza, this.zzp().zzc(object.zzc.zza), object.zzc.zza());
                this.zzq().zzb(string, object.zzc.zza);
                if (object.zzk != null) {
                    object22.add(object.zzk);
                }
                this.zzq().zze(string, object.zzc.zza);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzcix)((Object)e);
                this.zzb(new zzcix((zzcix)((Object)object), l), zzcif2);
            }
            long l3 = l;
            String string4 = zzcix2.zza;
            string3 = string;
            zzcil2 = this.zzq();
            zzbq.zza((String)string3);
            zzbq.zza((String)string4);
            zzcil2.zzc();
            zzcil2.zzaq();
            if (l3 < 0L) {
                zzcil2.zzt().zzaa().zza("Invalid time querying triggered conditional properties", zzcjj.zza(string3), zzcil2.zzo().zza(string4), l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzcil2.zza((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzbgl2 = (zzcii)((Object)iterator.next());
                if (zzbgl2 == null) continue;
                zzcnl zzcnl2 = zzbgl2.zzc;
                zzcnn zzcnn2 = new zzcnn(zzbgl2.zza, zzbgl2.zzb, zzcnl2.zza, l, zzcnl2.zza());
                if (this.zzq().zza(zzcnn2)) {
                    this.zzf().zzad().zza("User property triggered", zzbgl2.zza, this.zzp().zzc(zzcnn2.zzc), zzcnn2.zze);
                } else {
                    this.zzf().zzy().zza("Too many active user properties, ignoring", zzcjj.zza(zzbgl2.zza), this.zzp().zzc(zzcnn2.zzc), zzcnn2.zze);
                }
                if (zzbgl2.zzi != null) {
                    object.add(zzbgl2.zzi);
                }
                zzbgl2.zzc = new zzcnl(zzcnn2);
                zzbgl2.zze = true;
                this.zzq().zza((zzcii)zzbgl2);
            }
            this.zzb(zzcix2, zzcif2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzbgl2 = (zzcix)((Object)e);
                this.zzb(new zzcix((zzcix)zzbgl2, l), zzcif2);
            }
            this.zzq().zzy();
            return;
        }
        finally {
            this.zzq().zzz();
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final void zzb(zzcix var1_1, zzcif var2_2) {
        zzbq.zza((Object)var2_2);
        zzbq.zza((String)var2_2.zza);
        var3_3 = System.nanoTime();
        this.zzh().zzc();
        this.zza();
        var5_4 = var2_2.zza;
        this.zzo();
        if (!zzcno.zza(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzh) {
            this.zzd(var2_2);
            return;
        }
        if (this.zzj().zzb(var5_4, var1_1.zza)) {
            this.zzf().zzaa().zza("Dropping blacklisted event. appId", zzcjj.zza(var5_4), this.zzp().zza(var1_1.zza));
            var6_5 = this.zzo().zzk(var5_4) != false || this.zzo().zzl(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.zza)) {
                this.zzo().zza(var5_4, 11, "_ev", var1_1.zza, 0);
            }
            if (var6_5 && (var7_7 = this.zzq().zzb(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzq(), var7_7.zzp());
                if (Math.abs(this.zzn.zza() - var8_9) > zzciz.zzaf.zzb()) {
                    this.zzf().zzad().zza("Fetching config for blacklisted app");
                    this.zza(var7_7);
                }
            }
            return;
        }
        if (this.zzf().zza(2)) {
            this.zzf().zzae().zza("Logging event", this.zzp().zza(var1_1));
        }
        this.zzq().zzx();
        try {
            block45: {
                block46: {
                    this.zzd(var2_2);
                    if (("_iap".equals(var1_1.zza) || "ecommerce_purchase".equals(var1_1.zza)) && !this.zza(var5_4, var1_1)) {
                        this.zzq().zzy();
                        return;
                    }
                    var6_6 = zzcno.zza(var1_1.zza);
                    var7_8 = "_err".equals(var1_1.zza);
                    var8_10 = this.zzq().zza(this.zzak(), var5_4, true, var6_6, false, var7_8, false);
                    var9_11 = var8_10.zzb - (long)zzciz.zzq.zzb().intValue();
                    if (var9_11 > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzf().zzy().zza("Data loss. Too many events logged. appId, count", zzcjj.zza(var5_4), var8_10.zzb);
                        }
                        this.zzq().zzy();
                        return;
                    }
                    if (var6_6 && (var9_11 = var8_10.zza - (long)zzciz.zzs.zzb().intValue()) > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzf().zzy().zza("Data loss. Too many public events logged. appId, count", zzcjj.zza(var5_4), var8_10.zza);
                        }
                        this.zzo().zza(var5_4, 16, "_ev", var1_1.zza, 0);
                        this.zzq().zzy();
                        return;
                    }
                    if (var7_8) {
                        var19_12 = var2_2.zza;
                        var20_13 = this.zzc.zzb((String)var19_12, zzciz.zzr);
                        var9_11 = var8_10.zzd - (long)Math.max(0, var20_13 = Math.min(1000000, var20_13));
                        if (var9_11 > 0L) {
                            if (var9_11 == 1L) {
                                this.zzf().zzy().zza("Too many error events logged. appId, count", zzcjj.zza(var5_4), var8_10.zzd);
                            }
                            this.zzq().zzy();
                            return;
                        }
                    }
                    var11_15 = var1_1.zzb.zzb();
                    this.zzo().zza(var11_15, "_o", (Object)var1_1.zzc);
                    if (this.zzo().zzi(var5_4)) {
                        this.zzo().zza(var11_15, "_dbg", 1L);
                        this.zzo().zza(var11_15, "_r", 1L);
                    }
                    if ((var12_16 = this.zzq().zzc(var5_4)) > 0L) {
                        this.zzf().zzaa().zza("Data lost. Too many events stored on disk, deleted. appId", zzcjj.zza(var5_4), var12_16);
                    }
                    var14_17 = new zzcis(this, var1_1.zzc, var5_4, var1_1.zza, var1_1.zzd, 0L, var11_15);
                    var15_18 = this.zzq().zza(var5_4, var14_17.zzb);
                    if (var15_18 == null) {
                        if (this.zzq().zzf(var5_4) >= 500L && var6_6) {
                            this.zzf().zzy().zza("Too many event names used, ignoring event. appId, name, supported count", zzcjj.zza(var5_4), this.zzp().zza(var14_17.zzb), 500);
                            this.zzo().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var16_19 = new zzcit(var5_4, var14_17.zzb, 0L, 0L, var14_17.zzc, 0L, null, null, null);
                    } else {
                        var14_17 = var14_17.zza(this, var15_18.zze);
                        var16_19 = var15_18.zza(var14_17.zzc);
                    }
                    this.zzq().zza(var16_19);
                    var20_14 = var2_2;
                    var19_12 = var14_17;
                    var18_20 = this;
                    var18_20.zzh().zzc();
                    var18_20.zza();
                    zzbq.zza((Object)var19_12);
                    zzbq.zza((Object)var20_14);
                    zzbq.zza((String)var19_12.zza);
                    zzbq.zzb((boolean)var19_12.zza.equals(var20_14.zza));
                    var21_21 = new zzcoe();
                    new zzcoe().zza = 1;
                    var21_21.zzi = "android";
                    var21_21.zzo = var20_14.zza;
                    var21_21.zzn = var20_14.zzd;
                    var21_21.zzp = var20_14.zzc;
                    var21_21.zzac = var20_14.zzj == -2147483648L ? null : Integer.valueOf((int)var20_14.zzj);
                    var21_21.zzq = var20_14.zze;
                    var21_21.zzy = var20_14.zzb;
                    var21_21.zzv = var20_14.zzf == 0L ? null : Long.valueOf(var20_14.zzf);
                    var22_22 = var18_20.zze().zza(var20_14.zza);
                    if (var22_22 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var22_22.first))) {
                        if (var20_14.zzo) {
                            var21_21.zzs = (String)var22_22.first;
                            var21_21.zzt = (Boolean)var22_22.second;
                        }
                    } else if (!var18_20.zzx().zza(var18_20.zzb)) {
                        var23_23 = Settings.Secure.getString((ContentResolver)var18_20.zzb.getContentResolver(), (String)"android_id");
                        if (var23_23 == null) {
                            var18_20.zzf().zzaa().zza("null secure ID. appId", zzcjj.zza(var21_21.zzo));
                            var23_23 = "null";
                        } else if (var23_23.isEmpty()) {
                            var18_20.zzf().zzaa().zza("empty secure ID. appId", zzcjj.zza(var21_21.zzo));
                        }
                        var21_21.zzad = var23_23;
                    }
                    var18_20.zzx().zzaq();
                    var21_21.zzk = Build.MODEL;
                    var18_20.zzx().zzaq();
                    var21_21.zzj = Build.VERSION.RELEASE;
                    var21_21.zzm = (int)var18_20.zzx().zzx();
                    var21_21.zzl = var18_20.zzx().zzy();
                    var21_21.zzr = null;
                    var21_21.zzd = null;
                    var21_21.zze = null;
                    var21_21.zzf = null;
                    var21_21.zzaf = var20_14.zzl;
                    if (var18_20.zzab() && zzcik.zzab()) {
                        var21_21.zzag = null;
                    }
                    if ((var23_23 = var18_20.zzq().zzb(var20_14.zza)) == null) {
                        var23_23 = new zzcie(var18_20, var20_14.zza);
                        var23_23.zza(var18_20.zzy().zzy());
                        var23_23.zzd(var20_14.zzk);
                        var23_23.zzb(var20_14.zzb);
                        var23_23.zzc(var18_20.zze().zzb(var20_14.zza));
                        var23_23.zzf(0L);
                        var23_23.zza(0L);
                        var23_23.zzb(0L);
                        var23_23.zze(var20_14.zzc);
                        var23_23.zzc(var20_14.zzj);
                        var23_23.zzf(var20_14.zzd);
                        var23_23.zzd(var20_14.zze);
                        var23_23.zze(var20_14.zzf);
                        var23_23.zza(var20_14.zzh);
                        var23_23.zzo(var20_14.zzl);
                        var18_20.zzq().zza((zzcie)var23_23);
                    }
                    var21_21.zzu = var23_23.zzc();
                    var21_21.zzab = var23_23.zzf();
                    var24_24 = var18_20.zzq().zza(var20_14.zza);
                    var21_21.zzc = new zzcog[var24_24.size()];
                    for (var25_25 = 0; var25_25 < var24_24.size(); ++var25_25) {
                        var21_21.zzc[var25_25] = var26_27 = new zzcog();
                        var26_27.zzb = var24_24.get((int)var25_25).zzc;
                        var26_27.zza = var24_24.get((int)var25_25).zzd;
                        var18_20.zzo().zza(var26_27, var24_24.get((int)var25_25).zze);
                    }
                    try {
                        var25_26 = var18_20.zzq().zza(var21_21);
                    }
                    catch (IOException var27_28) {
                        var18_20.zzf().zzy().zza("Data loss. Failed to insert raw event metadata. appId", zzcjj.zza(var21_21.zzo), var27_28);
                        break block45;
                    }
                    v0 = var18_20.zzq();
                    var29_29 = var19_12;
                    var28_30 = var18_20;
                    if (var29_29.zze == null) ** GOTO lbl-1000
                    for (Object var31_33 : var29_29.zze) {
                        if (!"_r".equals(var31_33)) continue;
                        v1 = true;
                        break block46;
                    }
                    var30_32 = var28_30.zzj().zzc(var29_29.zza, var29_29.zzb);
                    var31_33 = var28_30.zzq().zza(var28_30.zzak(), var29_29.zza, false, false, false, false, false);
                    if (var30_32 && var31_33.zze < (long)var28_30.zzc.zza(var29_29.zza)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                }
                if (v0.zza((zzcis)var19_12, var25_26, v1)) {
                    var18_20.zzak = 0L;
                }
            }
            this.zzq().zzy();
            if (this.zzf().zza(2)) {
                this.zzf().zzae().zza("Event recorded", this.zzp().zza(var14_17));
            }
        }
        finally {
            this.zzq().zzz();
        }
        this.zzam();
        this.zzf().zzae().zza("Background event processing time, ms", (System.nanoTime() - var3_3 + 500000L) / 1000000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean zza(String string, zzcix zzcix2) {
        long l;
        String string2;
        block10: {
            string2 = zzcix2.zzb.zzd("currency");
            if ("ecommerce_purchase".equals(zzcix2.zza)) {
                double d = zzcix2.zzb.zzc("value") * 1000000.0;
                if (d == 0.0) {
                    d = (double)zzcix2.zzb.zzb("value").longValue() * 1000000.0;
                }
                if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                    l = Math.round(d);
                    break block10;
                } else {
                    this.zzf().zzaa().zza("Data lost. Currency value is too big. appId", zzcjj.zza(string), d);
                    return false;
                }
            }
            l = zzcix2.zzb.zzb("value");
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
            String string3 = String.valueOf("_ltv_");
            String string4 = String.valueOf(string2);
            String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            zzcnn zzcnn2 = this.zzq().zzc(string, string5);
            if (zzcnn2 == null || !(zzcnn2.zze instanceof Long)) {
                String string6 = string;
                int n = this.zzc.zzb(string6, zzciz.zzak) - 1;
                string6 = string;
                zzcil zzcil2 = this.zzq();
                zzbq.zza((String)string6);
                zzcil2.zzc();
                zzcil2.zzaq();
                try {
                    zzcil2.zzaa().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string6, string6, String.valueOf(n)});
                }
                catch (SQLiteException sQLiteException) {
                    zzcil2.zzt().zzy().zza("Error pruning currencies. appId", zzcjj.zza(string6), (Object)sQLiteException);
                }
                zzcnn2 = new zzcnn(string, zzcix2.zzc, string5, this.zzn.zza(), l);
            } else {
                long l2 = (Long)zzcnn2.zze;
                zzcnn2 = new zzcnn(string, zzcix2.zzc, string5, this.zzn.zza(), l2 + l);
            }
            if (!this.zzq().zza(zzcnn2)) {
                this.zzf().zzy().zza("Too many unique user properties are set. Ignoring user property. appId", zzcjj.zza(string), this.zzp().zzc(zzcnn2.zzc), zzcnn2.zze);
                this.zzo().zza(string, 9, null, null, 0);
            }
        }
        return true;
    }

    @WorkerThread
    final void zza(zzcii zzcii2) {
        zzcif zzcif2 = this.zzb(zzcii2.zza);
        if (zzcif2 != null) {
            this.zza(zzcii2, zzcif2);
        }
    }

    @WorkerThread
    final void zza(zzcii zzcii2, zzcif zzcif2) {
        zzbq.zza((Object)((Object)zzcii2));
        zzbq.zza((String)zzcii2.zza);
        zzbq.zza((Object)zzcii2.zzb);
        zzbq.zza((Object)((Object)zzcii2.zzc));
        zzbq.zza((String)zzcii2.zzc.zza);
        ((zzclh)this.zzh()).zzc();
        this.zza();
        if (TextUtils.isEmpty((CharSequence)zzcif2.zzb)) {
            return;
        }
        if (!zzcif2.zzh) {
            this.zzd(zzcif2);
            return;
        }
        zzcii zzcii3 = new zzcii(zzcii2);
        new zzcii(zzcii2).zze = false;
        this.zzq().zzx();
        try {
            boolean bl = false;
            zzcii zzcii4 = this.zzq().zzd(zzcii3.zza, zzcii3.zzc.zza);
            if (zzcii4 != null && !zzcii4.zzb.equals(zzcii3.zzb)) {
                this.zzf().zzaa().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", this.zzp().zzc(zzcii3.zzc.zza), zzcii3.zzb, zzcii4.zzb);
            }
            if (zzcii4 != null && zzcii4.zze) {
                zzcii3.zzb = zzcii4.zzb;
                zzcii3.zzd = zzcii4.zzd;
                zzcii3.zzh = zzcii4.zzh;
                zzcii3.zzf = zzcii4.zzf;
                zzcii3.zzi = zzcii4.zzi;
                zzcii3.zze = zzcii4.zze;
                zzcii3.zzc = new zzcnl(zzcii3.zzc.zza, zzcii4.zzc.zzb, zzcii3.zzc.zza(), zzcii4.zzc.zzc);
            } else if (TextUtils.isEmpty((CharSequence)zzcii3.zzf)) {
                zzcii3.zzc = new zzcnl(zzcii3.zzc.zza, zzcii3.zzd, zzcii3.zzc.zza(), zzcii3.zzc.zzc);
                zzcii3.zze = true;
                bl = true;
            }
            if (zzcii3.zze) {
                zzcnl zzcnl2 = zzcii3.zzc;
                zzcnn zzcnn2 = new zzcnn(zzcii3.zza, zzcii3.zzb, zzcnl2.zza, zzcnl2.zzb, zzcnl2.zza());
                if (this.zzq().zza(zzcnn2)) {
                    this.zzf().zzad().zza("User property updated immediately", zzcii3.zza, this.zzp().zzc(zzcnn2.zzc), zzcnn2.zze);
                } else {
                    this.zzf().zzy().zza("(2)Too many active user properties, ignoring", zzcjj.zza(zzcii3.zza), this.zzp().zzc(zzcnn2.zzc), zzcnn2.zze);
                }
                if (bl && zzcii3.zzi != null) {
                    zzcix zzcix2 = new zzcix(zzcii3.zzi, zzcii3.zzd);
                    this.zzb(zzcix2, zzcif2);
                }
            }
            if (this.zzq().zza(zzcii3)) {
                this.zzf().zzad().zza("Conditional property added", zzcii3.zza, this.zzp().zzc(zzcii3.zzc.zza), zzcii3.zzc.zza());
            } else {
                this.zzf().zzy().zza("Too many conditional properties, ignoring", zzcjj.zza(zzcii3.zza), this.zzp().zzc(zzcii3.zzc.zza), zzcii3.zzc.zza());
            }
            this.zzq().zzy();
            return;
        }
        finally {
            this.zzq().zzz();
        }
    }

    @WorkerThread
    final void zzb(zzcii zzcii2) {
        zzcif zzcif2 = this.zzb(zzcii2.zza);
        if (zzcif2 != null) {
            this.zzb(zzcii2, zzcif2);
        }
    }

    @WorkerThread
    final void zzb(zzcii zzcii2, zzcif zzcif2) {
        zzbq.zza((Object)((Object)zzcii2));
        zzbq.zza((String)zzcii2.zza);
        zzbq.zza((Object)((Object)zzcii2.zzc));
        zzbq.zza((String)zzcii2.zzc.zza);
        ((zzclh)this.zzh()).zzc();
        this.zza();
        if (TextUtils.isEmpty((CharSequence)zzcif2.zzb)) {
            return;
        }
        if (!zzcif2.zzh) {
            this.zzd(zzcif2);
            return;
        }
        this.zzq().zzx();
        try {
            this.zzd(zzcif2);
            zzcii zzcii3 = this.zzq().zzd(zzcii2.zza, zzcii2.zzc.zza);
            if (zzcii3 != null) {
                this.zzf().zzad().zza("Removing conditional user property", zzcii2.zza, this.zzp().zzc(zzcii2.zzc.zza));
                this.zzq().zze(zzcii2.zza, zzcii2.zzc.zza);
                if (zzcii3.zze) {
                    this.zzq().zzb(zzcii2.zza, zzcii2.zzc.zza);
                }
                if (zzcii2.zzk != null) {
                    Bundle bundle = null;
                    if (zzcii2.zzk.zzb != null) {
                        bundle = zzcii2.zzk.zzb.zzb();
                    }
                    zzcix zzcix2 = this.zzo().zza(zzcii2.zzk.zza, bundle, zzcii3.zzb, zzcii2.zzk.zzd, true, false);
                    this.zzb(zzcix2, zzcif2);
                }
            } else {
                this.zzf().zzaa().zza("Conditional user property doesn't exist", zzcjj.zza(zzcii2.zza), this.zzp().zzc(zzcii2.zzc.zza));
            }
            this.zzq().zzy();
            return;
        }
        finally {
            this.zzq().zzz();
        }
    }

    @WorkerThread
    public final byte[] zzb(@NonNull zzcix zzcix2, @Size(min=1L) String string) {
        Long l;
        this.zza();
        ((zzclh)this.zzh()).zzc();
        zzckj.zzad();
        zzbq.zza((Object)((Object)zzcix2));
        zzbq.zza((String)string);
        zzcod zzcod2 = new zzcod();
        this.zzq().zzx();
        try {
            zzcit zzcit2;
            long l2;
            Object object;
            zzcie zzcie2 = this.zzq().zzb(string);
            if (zzcie2 == null) {
                this.zzf().zzad().zza("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzcie2.zzn()) {
                this.zzf().zzad().zza("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (("_iap".equals(zzcix2.zza) || "ecommerce_purchase".equals(zzcix2.zza)) && !this.zza(string, zzcix2)) {
                this.zzf().zzaa().zza("Failed to handle purchase event at single event bundle creation. appId", zzcjj.zza(string));
            }
            boolean bl = this.zzc.zzd(string);
            l = 0L;
            if (bl && "_e".equals(zzcix2.zza)) {
                if (zzcix2.zzb == null || zzcix2.zzb.zza() == 0) {
                    this.zzf().zzaa().zza("The engagement event does not contain any parameters. appId", zzcjj.zza(string));
                } else if (zzcix2.zzb.zzb("_et") == null) {
                    this.zzf().zzaa().zza("The engagement event does not include duration. appId", zzcjj.zza(string));
                } else {
                    l = zzcix2.zzb.zzb("_et");
                }
            }
            zzcoe zzcoe2 = new zzcoe();
            zzcod2.zza = new zzcoe[]{zzcoe2};
            zzcoe2.zza = 1;
            zzcoe2.zzi = "android";
            zzcoe2.zzo = zzcie2.zzb();
            zzcoe2.zzn = zzcie2.zzk();
            zzcoe2.zzp = zzcie2.zzi();
            long l3 = zzcie2.zzj();
            zzcoe2.zzac = l3 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l3);
            zzcoe2.zzq = zzcie2.zzl();
            zzcoe2.zzy = zzcie2.zzd();
            zzcoe2.zzv = zzcie2.zzm();
            if (this.zzab() && zzcik.zzab() && this.zzc.zzc(zzcoe2.zzo)) {
                zzcoe2.zzag = null;
            }
            Pair<String, Boolean> pair = this.zze().zza(zzcie2.zzb());
            if (zzcie2.zzab() && pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                zzcoe2.zzs = (String)pair.first;
                zzcoe2.zzt = (Boolean)pair.second;
            }
            this.zzx().zzaq();
            zzcoe2.zzk = Build.MODEL;
            this.zzx().zzaq();
            zzcoe2.zzj = Build.VERSION.RELEASE;
            zzcoe2.zzm = (int)this.zzx().zzx();
            zzcoe2.zzl = this.zzx().zzy();
            zzcoe2.zzu = zzcie2.zzc();
            zzcoe2.zzab = zzcie2.zzf();
            List<zzcnn> list = this.zzq().zza(zzcie2.zzb());
            zzcoe2.zzc = new zzcog[list.size()];
            zzcnn zzcnn2 = null;
            if (bl) {
                zzcnn2 = this.zzq().zzc(zzcoe2.zzo, "_lte");
                if (zzcnn2 == null || zzcnn2.zze == null) {
                    zzcnn2 = new zzcnn(zzcoe2.zzo, "auto", "_lte", this.zzn.zza(), l);
                } else if (l > 0L) {
                    zzcnn2 = new zzcnn(zzcoe2.zzo, "auto", "_lte", this.zzn.zza(), (Long)zzcnn2.zze + l);
                }
            }
            zzcog zzcog2 = null;
            for (int i = 0; i < list.size(); ++i) {
                object = new zzcog();
                zzcoe2.zzc[i] = object;
                ((zzcog)((Object)object)).zzb = list.get((int)i).zzc;
                ((zzcog)((Object)object)).zza = list.get((int)i).zzd;
                this.zzo().zza((zzcog)((Object)object), list.get((int)i).zze);
                if (!bl || !"_lte".equals(((zzcog)((Object)object)).zzb)) continue;
                zzcog2 = object;
                ((zzcog)((Object)object)).zzd = (Long)zzcnn2.zze;
                zzcog2.zza = this.zzn.zza();
            }
            if (bl && zzcog2 == null) {
                zzcog2 = new zzcog();
                new zzcog().zzb = "_lte";
                zzcog2.zza = this.zzn.zza();
                zzcog2.zzd = (Long)zzcnn2.zze;
                zzcoe2.zzc = Arrays.copyOf(zzcoe2.zzc, zzcoe2.zzc.length + 1);
                zzcoe2.zzc[zzcoe2.zzc.length - 1] = zzcog2;
            }
            if (l > 0L) {
                this.zzq().zza(zzcnn2);
            }
            Bundle bundle = zzcix2.zzb.zzb();
            if ("_iap".equals(zzcix2.zza)) {
                bundle.putLong("_c", 1L);
                this.zzf().zzad().zza("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzcix2.zzc);
            if (this.zzo().zzi(zzcoe2.zzo)) {
                this.zzo().zza(bundle, "_dbg", 1L);
                this.zzo().zza(bundle, "_r", 1L);
            }
            if ((object = this.zzq().zza(string, zzcix2.zza)) == null) {
                l2 = 0L;
                zzcit2 = new zzcit(string, zzcix2.zza, 1L, 0L, zzcix2.zzd, 0L, null, null, null);
                this.zzq().zza(zzcit2);
            } else {
                l2 = ((zzcit)object).zze;
                zzcit2 = ((zzcit)object).zza(zzcix2.zzd).zza();
                this.zzq().zza(zzcit2);
            }
            zzcis zzcis2 = new zzcis(this, zzcix2.zzc, string, zzcix2.zza, zzcix2.zzd, l2, bundle);
            zzcob zzcob2 = new zzcob();
            zzcoe2.zzb = new zzcob[]{zzcob2};
            zzcob2.zzc = zzcis2.zzc;
            zzcob2.zzb = zzcis2.zzb;
            zzcob2.zzd = zzcis2.zzd;
            zzcob2.zza = new zzcoc[zzcis2.zze.zza()];
            int n = 0;
            for (String string2 : zzcis2.zze) {
                zzcoc zzcoc2 = new zzcoc();
                zzcob2.zza[n++] = zzcoc2;
                zzcoc2.zza = string2;
                Object object2 = zzcis2.zze.zza(string2);
                this.zzo().zza(zzcoc2, object2);
            }
            zzcoe2.zzaa = this.zza(zzcie2.zzb(), zzcoe2.zzc, zzcoe2.zzb);
            zzcoe2.zze = zzcob2.zzc;
            zzcoe2.zzf = zzcob2.zzc;
            long l4 = zzcie2.zzh();
            zzcoe2.zzh = l4 != 0L ? Long.valueOf(l4) : null;
            long l5 = zzcie2.zzg();
            if (l5 == 0L) {
                l5 = l4;
            }
            zzcoe2.zzg = l5 != 0L ? Long.valueOf(l5) : null;
            zzcie2.zzr();
            zzcoe2.zzw = (int)zzcie2.zzo();
            zzcoe2.zzr = 12210L;
            zzcoe2.zzd = this.zzn.zza();
            zzcoe2.zzz = Boolean.TRUE;
            zzcie2.zza(zzcoe2.zze);
            zzcie2.zzb(zzcoe2.zzf);
            this.zzq().zza(zzcie2);
            this.zzq().zzy();
        }
        finally {
            this.zzq().zzz();
        }
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = new byte[zzcod2.zzf()];
            l = zzflk.zza((byte[])byArray, (int)0, (int)byArray2.length);
            zzcod2.zza((zzflk)l);
            l.zza();
            return this.zzo().zza(byArray);
        }
        catch (IOException iOException) {
            this.zzf().zzy().zza("Data loss. Failed to bundle and serialize. appId", zzcjj.zza(string), iOException);
            return null;
        }
    }

    public final String zza(String string) {
        Future<String> future = this.zzh().zza(new zzckl(this, string));
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzf().zzy().zza("Failed to get app instance id. appId", zzcjj.zza(string), exception);
            return null;
        }
    }

    private static boolean zza(zzcob zzcob2, String string, Object object) {
        if (TextUtils.isEmpty((CharSequence)string) || object == null) {
            return false;
        }
        zzcoc[] zzcocArray = zzcob2.zza;
        int n = zzcob2.zza.length;
        for (int i = 0; i < n; ++i) {
            zzcoc zzcoc2 = zzcocArray[i];
            if (!string.equals(zzcoc2.zza)) continue;
            return object instanceof Long && object.equals(zzcoc2.zzc) || object instanceof String && object.equals(zzcoc2.zzb) || object instanceof Double && object.equals(zzcoc2.zzd);
        }
        return false;
    }

    static void zzad() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    @WorkerThread
    final void zza(zzcnl zzcnl2, zzcif zzcif2) {
        ((zzclh)this.zzh()).zzc();
        this.zza();
        if (TextUtils.isEmpty((CharSequence)zzcif2.zzb)) {
            return;
        }
        if (!zzcif2.zzh) {
            this.zzd(zzcif2);
            return;
        }
        int n = this.zzo().zzd(zzcnl2.zza);
        if (n != 0) {
            this.zzo();
            String string = zzcno.zza(zzcnl2.zza, 24, true);
            int n2 = zzcnl2.zza != null ? zzcnl2.zza.length() : 0;
            this.zzo().zza(zzcif2.zza, n, "_ev", string, n2);
            return;
        }
        n = this.zzo().zzb(zzcnl2.zza, zzcnl2.zza());
        if (n != 0) {
            this.zzo();
            String string = zzcno.zza(zzcnl2.zza, 24, true);
            Object object = zzcnl2.zza();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzo().zza(zzcif2.zza, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzo().zzc(zzcnl2.zza, zzcnl2.zza());
        if (object == null) {
            return;
        }
        zzcnn zzcnn2 = new zzcnn(zzcif2.zza, zzcnl2.zzc, zzcnl2.zza, zzcnl2.zzb, object);
        this.zzf().zzad().zza("Setting user property", this.zzp().zzc(zzcnn2.zzc), object);
        this.zzq().zzx();
        try {
            this.zzd(zzcif2);
            boolean bl = this.zzq().zza(zzcnn2);
            this.zzq().zzy();
            if (bl) {
                this.zzf().zzad().zza("User property set", this.zzp().zzc(zzcnn2.zzc), zzcnn2.zze);
            } else {
                this.zzf().zzy().zza("Too many unique user properties are set. Ignoring user property", this.zzp().zzc(zzcnn2.zzc), zzcnn2.zze);
                this.zzo().zza(zzcif2.zza, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzq().zzz();
        }
    }

    @WorkerThread
    final void zzb(zzcnl zzcnl2, zzcif zzcif2) {
        ((zzclh)this.zzh()).zzc();
        this.zza();
        if (TextUtils.isEmpty((CharSequence)zzcif2.zzb)) {
            return;
        }
        if (!zzcif2.zzh) {
            this.zzd(zzcif2);
            return;
        }
        this.zzf().zzad().zza("Removing user property", this.zzp().zzc(zzcnl2.zza));
        this.zzq().zzx();
        try {
            this.zzd(zzcif2);
            this.zzq().zzb(zzcif2.zza, zzcnl2.zza);
            this.zzq().zzy();
            this.zzf().zzad().zza("User property removed", this.zzp().zzc(zzcnl2.zza));
            return;
        }
        finally {
            this.zzq().zzz();
        }
    }

    @WorkerThread
    public final void zzae() {
        ((zzclh)this.zzh()).zzc();
        this.zza();
        this.zzan = true;
        try {
            String string;
            Boolean bl = this.zzw().zzad();
            if (bl == null) {
                this.zzf().zzaa().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzf().zzy().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzak > 0L) {
                this.zzam();
                return;
            }
            Object object = this;
            ((zzclh)((zzckj)object).zzh()).zzc();
            if (((zzckj)object).zzaf != null) {
                this.zzf().zzae().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzs().zzy()) {
                this.zzf().zzae().zza("Network not connected, ignoring upload request");
                this.zzam();
                return;
            }
            long l = this.zzn.zza();
            long l2 = l - zzcik.zzz();
            this.zza(null, l2);
            long l3 = this.zze().zzc.zza();
            if (l3 != 0L) {
                this.zzf().zzad().zza("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzq().zzab()))) {
                if (this.zzaj == -1L) {
                    this.zzaj = this.zzq().zzai();
                }
                Object object2 = string;
                int n = this.zzc.zzb((String)object2, zzciz.zzm);
                object2 = string;
                object = this.zzc;
                int n2 = Math.max(0, ((zzcik)object).zzb((String)object2, zzciz.zzn));
                List<Pair<zzcoe, Long>> list = this.zzq().zza(string, n, n2);
                if (!list.isEmpty()) {
                    Object object3;
                    String string2 = null;
                    Object object4 = list.iterator();
                    while (object4.hasNext()) {
                        zzcoe zzcoe2 = (zzcoe)((Object)object4.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzcoe2.zzs)) continue;
                        string2 = zzcoe2.zzs;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object3 = (zzcoe)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzcoe)((Object)object3)).zzs) || ((zzcoe)((Object)object3)).zzs.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object4 = new zzcod();
                    new zzcod().zza = new zzcoe[list.size()];
                    object3 = new ArrayList(list.size());
                    boolean bl2 = zzcik.zzab() && this.zzc.zzc(string);
                    for (int i = 0; i < ((zzcod)((Object)object4)).zza.length; ++i) {
                        ((zzcod)((Object)object4)).zza[i] = (zzcoe)((Object)list.get((int)i).first);
                        object3.add((Long)list.get((int)i).second);
                        ((zzcod)((Object)object4)).zza[i].zzr = 12210L;
                        ((zzcod)((Object)object4)).zza[i].zzd = l;
                        ((zzcod)((Object)object4)).zza[i].zzz = false;
                        if (bl2) continue;
                        ((zzcod)((Object)object4)).zza[i].zzag = null;
                    }
                    String string3 = null;
                    if (this.zzf().zza(2)) {
                        string3 = this.zzp().zza((zzcod)((Object)object4));
                    }
                    byte[] byArray = this.zzo().zza((zzcod)((Object)object4));
                    String string4 = zzciz.zzw.zzb();
                    try {
                        URL uRL = new URL(string4);
                        object2 = object3;
                        object = this;
                        zzbq.zzb((!object2.isEmpty() ? 1 : 0) != 0);
                        if (((zzckj)object).zzaf != null) {
                            ((zzckj)object).zzf().zzy().zza("Set uploading progress before finishing the previous upload");
                        } else {
                            ((zzckj)object).zzaf = new ArrayList<Long>((Collection<Long>)object2);
                        }
                        this.zze().zzd.zza(l);
                        String string5 = "?";
                        if (((zzcod)((Object)object4)).zza.length > 0) {
                            string5 = ((zzcod)((Object)object4)).zza[0].zzo;
                        }
                        this.zzf().zzae().zza("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                        this.zzam = true;
                        zzckm zzckm2 = new zzckm(this);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object2 = string;
                        object = this.zzs();
                        ((zzclh)object).zzc();
                        ((zzcli)object).zzaq();
                        zzbq.zza((Object)uRL2);
                        zzbq.zza((Object)byArray2);
                        zzbq.zza((Object)zzckm2);
                        ((zzclh)object).zzs().zzb(new zzcjr((zzcjn)object, (String)object2, uRL2, byArray2, null, zzckm2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzf().zzy().zza("Failed to parse upload URL. Not uploading. appId", zzcjj.zza(string), string4);
                    }
                }
            } else {
                zzcie zzcie2;
                this.zzaj = -1L;
                String string6 = this.zzq().zza(l - zzcik.zzz());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzcie2 = this.zzq().zzb(string6)) != null) {
                    this.zza(zzcie2);
                }
            }
            return;
        }
        finally {
            this.zzan = false;
            this.zzao();
        }
    }

    @WorkerThread
    private final void zza(zzcie zzcie2) {
        ((zzclh)this.zzh()).zzc();
        if (TextUtils.isEmpty((CharSequence)zzcie2.zzd())) {
            this.zza(zzcie2.zzb(), 204, null, null, null);
            return;
        }
        Object object = zzcie2.zzc();
        String string = zzcie2.zzd();
        Uri.Builder builder = new Uri.Builder();
        String string2 = String.valueOf(string);
        builder.scheme(zzciz.zzk.zzb()).encodedAuthority(zzciz.zzl.zzb()).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", (String)object).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "12210");
        String string3 = builder.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzf().zzae().zza("Fetching remote configuration", zzcie2.zzb());
            zzcny zzcny2 = this.zzj().zza(zzcie2.zzb());
            ArrayMap arrayMap = null;
            String string4 = this.zzj().zzb(zzcie2.zzb());
            if (zzcny2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzal = true;
            zzckn zzckn2 = new zzckn(this);
            builder = arrayMap;
            object = uRL;
            string = zzcie2.zzb();
            zzcjn zzcjn2 = this.zzs();
            ((zzclh)zzcjn2).zzc();
            zzcjn2.zzaq();
            zzbq.zza((Object)object);
            zzbq.zza((Object)zzckn2);
            ((zzclh)zzcjn2).zzs().zzb(new zzcjr(zzcjn2, string, (URL)object, null, (Map)builder, zzckn2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzf().zzy().zza("Failed to parse config URL. Not fetching. appId", zzcjj.zza(zzcie2.zzb()), string3);
            return;
        }
    }

    @WorkerThread
    private final boolean zza(String string, long l) {
        this.zzq().zzx();
        try {
            block94: {
                zzcoc[] zzcocArray;
                Object object;
                int n2;
                int n3;
                Object object2;
                String string2;
                zza zza2;
                block93: {
                    zza zza3 = zza2 = new zza(this, null);
                    long l2 = this.zzaj;
                    long l3 = l;
                    string2 = null;
                    object2 = this.zzq();
                    zzbq.zza((Object)zza3);
                    ((zzclh)object2).zzc();
                    ((zzcli)object2).zzaq();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string3;
                        String string4;
                        String string5;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = ((zzcil)object2).zzaa();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string5 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string5).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string5).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block93;
                            string2 = cursor.getString(0);
                            string4 = cursor.getString(1);
                            cursor.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string5 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string5).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string5).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block93;
                            string4 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string2, string4}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            ((zzclh)object2).zzt().zzy().zza("Raw event metadata record is missing. appId", zzcjj.zza(string2));
                            break block93;
                        }
                        byte[] byArray = cursor.getBlob(0);
                        string5 = zzflj.zza((byte[])byArray, (int)0, (int)byArray.length);
                        zzcoe zzcoe2 = new zzcoe();
                        try {
                            zzcoe2.zza((zzflj)string5);
                        }
                        catch (IOException iOException) {
                            ((zzclh)object2).zzt().zzy().zza("Data loss. Failed to merge raw event metadata. appId", zzcjj.zza(string2), iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block93;
                        }
                        if (cursor.moveToNext()) {
                            ((zzclh)object2).zzt().zzaa().zza("Get multiple raw event metadata records, expected one. appId", zzcjj.zza(string2));
                        }
                        cursor.close();
                        zza3.zza(zzcoe2);
                        if (l2 != -1L) {
                            string3 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{string2, string4, String.valueOf(l2)};
                        } else {
                            string3 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{string2, string4};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string3, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            ((zzclh)object2).zzt().zzaa().zza("Raw event data disappeared while in transaction. appId", zzcjj.zza(string2));
                            break block93;
                        }
                        do {
                            long l4 = cursor.getLong(0);
                            byArray = cursor.getBlob(3);
                            string5 = zzflj.zza((byte[])byArray, (int)0, (int)byArray.length);
                            zzcob zzcob2 = new zzcob();
                            try {
                                zzcob2.zza((zzflj)string5);
                            }
                            catch (IOException iOException) {
                                ((zzclh)object2).zzt().zzy().zza("Data loss. Failed to merge raw event. appId", zzcjj.zza(string2), iOException);
                                continue;
                            }
                            zzcob2.zzb = cursor.getString(1);
                            zzcob2.zzc = cursor.getLong(2);
                            if (!zza3.zza(l4, zzcob2)) break;
                        } while (cursor.moveToNext());
                    }
                }
                object2 = zza2;
                if (((zza)object2).zzc == null || ((zza)object2).zzc.isEmpty()) break block94;
                boolean bl = false;
                zzcoe zzcoe3 = zza2.zza;
                zza2.zza.zzb = new zzcob[zza2.zzc.size()];
                int n4 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzc.zzd(zzcoe3.zzo);
                for (n3 = 0; n3 < zza2.zzc.size(); ++n3) {
                    zzcob zzcob3;
                    block96: {
                        int zzcocArray3;
                        boolean bl3;
                        block95: {
                            bl3 = bl;
                            zzcob3 = zza2.zzc.get(n3);
                            if (this.zzj().zzb(zza2.zza.zzo, zzcob3.zzb)) {
                                this.zzf().zzaa().zza("Dropping blacklisted raw event. appId", zzcjj.zza(zza2.zza.zzo), this.zzp().zza(zzcob3.zzb));
                                if (this.zzo().zzk(zza2.zza.zzo) || this.zzo().zzl(zza2.zza.zzo) || "_err".equals(zzcob3.zzb)) continue;
                                this.zzo().zza(zza2.zza.zzo, 11, "_ev", zzcob3.zzb, 0);
                                continue;
                            }
                            n2 = this.zzj().zzc(zza2.zza.zzo, zzcob3.zzb);
                            if (n2 != 0) break block95;
                            this.zzo();
                            if (!zzcno.zzm(zzcob3.zzb)) break block96;
                        }
                        boolean bl4 = false;
                        boolean n = false;
                        if (zzcob3.zza == null) {
                            zzcob3.zza = new zzcoc[0];
                        }
                        zzcoc[] i = zzcob3.zza;
                        int zzcoc2 = zzcob3.zza.length;
                        for (zzcocArray3 = 0; zzcocArray3 < zzcoc2; ++zzcocArray3) {
                            object = i[zzcocArray3];
                            if ("_c".equals(((zzcoc)((Object)object)).zza)) {
                                ((zzcoc)((Object)object)).zzc = 1L;
                                bl4 = true;
                                continue;
                            }
                            if (!"_r".equals(((zzcoc)((Object)object)).zza)) continue;
                            ((zzcoc)((Object)object)).zzc = 1L;
                            n = true;
                        }
                        if (!bl4 && n2 != 0) {
                            this.zzf().zzae().zza("Marking event as conversion", this.zzp().zza(zzcob3.zzb));
                            i = Arrays.copyOf(zzcob3.zza, zzcob3.zza.length + 1);
                            zzcoc zzcoc3 = new zzcoc();
                            new zzcoc().zza = "_c";
                            zzcoc3.zzc = 1L;
                            i[i.length - 1] = zzcoc3;
                            zzcob3.zza = i;
                        }
                        if (!n) {
                            this.zzf().zzae().zza("Marking event as real-time", this.zzp().zza(zzcob3.zzb));
                            i = Arrays.copyOf(zzcob3.zza, zzcob3.zza.length + 1);
                            zzcoc zzcob4 = new zzcoc();
                            new zzcoc().zza = "_r";
                            zzcob4.zzc = 1L;
                            i[i.length - 1] = zzcob4;
                            zzcob3.zza = i;
                        }
                        bl = true;
                        if (this.zzq().zza((long)this.zzak(), (String)zza2.zza.zzo, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zze > (long)this.zzc.zza(zza2.zza.zzo)) {
                            for (zzcoc2 = 0; zzcoc2 < zzcob3.zza.length; ++zzcoc2) {
                                if (!"_r".equals(zzcob3.zza[zzcoc2].zza)) continue;
                                zzcoc[] string6 = new zzcoc[zzcob3.zza.length - 1];
                                if (zzcoc2 > 0) {
                                    System.arraycopy(zzcob3.zza, 0, string6, 0, zzcoc2);
                                }
                                if (zzcoc2 < string6.length) {
                                    System.arraycopy(zzcob3.zza, zzcoc2 + 1, string6, zzcoc2, string6.length - zzcoc2);
                                }
                                zzcob3.zza = string6;
                                break;
                            }
                            bl = bl3;
                        }
                        if (zzcno.zza(zzcob3.zzb) && n2 != 0 && this.zzq().zza((long)this.zzak(), (String)zza2.zza.zzo, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzc > (long)this.zzc.zzb(string2 = zza2.zza.zzo, zzciz.zzt)) {
                            this.zzf().zzaa().zza("Too many conversions. Not logging as conversion. appId", zzcjj.zza(zza2.zza.zzo));
                            zzcocArray3 = 0;
                            object = null;
                            zzcocArray = zzcob3.zza;
                            int bl6 = zzcob3.zza.length;
                            for (int j = 0; j < bl6; ++j) {
                                zzcoc zzcoc3 = zzcocArray[j];
                                if ("_c".equals(zzcoc3.zza)) {
                                    object = zzcoc3;
                                    continue;
                                }
                                if (!"_err".equals(zzcoc3.zza)) continue;
                                zzcocArray3 = 1;
                            }
                            if (zzcocArray3 != 0 && object != null) {
                                zzcob3.zza = (zzcoc[])com.google.android.gms.common.util.zzb.zza((Object[])zzcob3.zza, (Object[])new zzcoc[]{object});
                            } else if (object != null) {
                                ((zzcoc)((Object)object)).zza = "_err";
                                ((zzcoc)((Object)object)).zzc = 10L;
                            } else {
                                this.zzf().zzy().zza("Did not find conversion parameter. appId", zzcjj.zza(zza2.zza.zzo));
                            }
                        }
                    }
                    if (bl2 && "_e".equals(zzcob3.zzb)) {
                        if (zzcob3.zza == null || zzcob3.zza.length == 0) {
                            this.zzf().zzaa().zza("Engagement event does not contain any parameters. appId", zzcjj.zza(zza2.zza.zzo));
                        } else {
                            this.zzo();
                            Long l6 = (Long)zzcno.zzb(zzcob3, "_et");
                            if (l6 == null) {
                                this.zzf().zzaa().zza("Engagement event does not include duration. appId", zzcjj.zza(zza2.zza.zzo));
                            } else {
                                l5 += l6.longValue();
                            }
                        }
                    }
                    zzcoe3.zzb[n4++] = zzcob3;
                }
                if (n4 < zza2.zzc.size()) {
                    zzcoe3.zzb = Arrays.copyOf(zzcoe3.zzb, n4);
                }
                if (bl2) {
                    zzcnn zzcnn2 = this.zzq().zzc(zzcoe3.zzo, "_lte");
                    zzcnn2 = zzcnn2 == null || zzcnn2.zze == null ? new zzcnn(zzcoe3.zzo, "auto", "_lte", this.zzn.zza(), l5) : new zzcnn(zzcoe3.zzo, "auto", "_lte", this.zzn.zza(), (Long)zzcnn2.zze + l5);
                    zzcog zzcog2 = new zzcog();
                    new zzcog().zzb = "_lte";
                    zzcog2.zza = this.zzn.zza();
                    zzcog2.zzd = (Long)zzcnn2.zze;
                    boolean bl5 = false;
                    for (n2 = 0; n2 < zzcoe3.zzc.length; ++n2) {
                        if (!"_lte".equals(zzcoe3.zzc[n2].zzb)) continue;
                        zzcoe3.zzc[n2] = zzcog2;
                        bl5 = true;
                        break;
                    }
                    if (!bl5) {
                        zzcoe3.zzc = Arrays.copyOf(zzcoe3.zzc, zzcoe3.zzc.length + 1);
                        zzcoe3.zzc[zza2.zza.zzc.length - 1] = zzcog2;
                    }
                    if (l5 > 0L) {
                        this.zzq().zza(zzcnn2);
                        this.zzf().zzad().zza("Updated lifetime engagement user property with value. Value", zzcnn2.zze);
                    }
                }
                zzcoe3.zzaa = this.zza(zzcoe3.zzo, zzcoe3.zzc, zzcoe3.zzb);
                if (zzciz.zzf.zzb().booleanValue()) {
                    string2 = zza2.zza.zzo;
                    object2 = this.zzc;
                    if ("1".equals(((zzclh)object2).zzq().zza(string2, "measurement.event_sampling_enabled"))) {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        zzcob[] zzcobArray = new zzcob[zzcoe3.zzb.length];
                        int n8 = 0;
                        SecureRandom secureRandom = this.zzo().zzz();
                        zzcob[] zzcobArray2 = zzcoe3.zzb;
                        int n = zzcoe3.zzb.length;
                        for (int i = 0; i < n; ++i) {
                            zzcob zzcob2 = zzcobArray2[i];
                            if (zzcob2.zzb.equals("_ep")) {
                                this.zzo();
                                String n9 = (String)zzcno.zzb(zzcob2, "_en");
                                object = (zzcit)hashMap.get(n9);
                                if (object == null) {
                                    object = this.zzq().zza(zza2.zza.zzo, n9);
                                    hashMap.put(n9, object);
                                }
                                if (((zzcit)object).zzg != null) continue;
                                if (((zzcit)object).zzh > 1L) {
                                    this.zzo();
                                    zzcob2.zza = zzcno.zza(zzcob2.zza, "_sr", ((zzcit)object).zzh);
                                }
                                if (((zzcit)object).zzi != null && ((zzcit)object).zzi.booleanValue()) {
                                    this.zzo();
                                    zzcob2.zza = zzcno.zza(zzcob2.zza, "_efs", 1L);
                                }
                                zzcobArray[n8++] = zzcob2;
                                continue;
                            }
                            int n5 = 1;
                            if (!zzckj.zza(zzcob2, "_dbg", 1L)) {
                                n5 = this.zzj().zzd(zza2.zza.zzo, zzcob2.zzb);
                            }
                            if (n5 <= 0) {
                                this.zzf().zzaa().zza("Sample rate must be positive. event, rate", zzcob2.zzb, n5);
                                zzcobArray[n8++] = zzcob2;
                                continue;
                            }
                            object = (zzcit)hashMap.get(zzcob2.zzb);
                            if (object == null && (object = this.zzq().zza(zza2.zza.zzo, zzcob2.zzb)) == null) {
                                this.zzf().zzaa().zza("Event being bundled has no eventAggregate. appId, eventName", zza2.zza.zzo, zzcob2.zzb);
                                object = new zzcit(zza2.zza.zzo, zzcob2.zzb, 1L, 1L, zzcob2.zzc, 0L, null, null, null);
                            }
                            this.zzo();
                            zzcocArray = (zzcoc[])zzcno.zzb(zzcob2, "_eid");
                            Boolean bl3 = zzcocArray != null;
                            if (n5 == 1) {
                                zzcobArray[n8++] = zzcob2;
                                if (!bl3.booleanValue() || ((zzcit)object).zzg == null && ((zzcit)object).zzh == null && ((zzcit)object).zzi == null) continue;
                                object = ((zzcit)object).zza(null, null, null);
                                hashMap.put(zzcob2.zzb, object);
                                continue;
                            }
                            if (secureRandom.nextInt(n5) == 0) {
                                this.zzo();
                                zzcob2.zza = zzcno.zza(zzcob2.zza, "_sr", n5);
                                zzcobArray[n8++] = zzcob2;
                                if (bl3.booleanValue()) {
                                    object = ((zzcit)object).zza(null, Long.valueOf(n5), null);
                                }
                                hashMap.put(zzcob2.zzb, ((zzcit)object).zzb(zzcob2.zzc));
                                continue;
                            }
                            long l2 = ((zzcit)object).zzf;
                            if (Math.abs(zzcob2.zzc - l2) >= 86400000L) {
                                this.zzo();
                                zzcob2.zza = zzcno.zza(zzcob2.zza, "_efs", 1L);
                                this.zzo();
                                zzcob2.zza = zzcno.zza(zzcob2.zza, "_sr", n5);
                                zzcobArray[n8++] = zzcob2;
                                if (bl3.booleanValue()) {
                                    object = ((zzcit)object).zza(null, Long.valueOf(n5), true);
                                }
                                hashMap.put(zzcob2.zzb, ((zzcit)object).zzb(zzcob2.zzc));
                                continue;
                            }
                            if (!bl3.booleanValue()) continue;
                            hashMap.put(zzcob2.zzb, ((zzcit)object).zza((Long)zzcocArray, null, null));
                        }
                        if (n8 < zzcoe3.zzb.length) {
                            zzcoe3.zzb = Arrays.copyOf(zzcobArray, n8);
                        }
                        for (Map.Entry entry : hashMap.entrySet()) {
                            this.zzq().zza((zzcit)entry.getValue());
                        }
                    }
                }
                zzcoe3.zze = Long.MAX_VALUE;
                zzcoe3.zzf = Long.MIN_VALUE;
                for (n3 = 0; n3 < zzcoe3.zzb.length; ++n3) {
                    zzcob zzcob5 = zzcoe3.zzb[n3];
                    if (zzcob5.zzc < zzcoe3.zze) {
                        zzcoe3.zze = zzcob5.zzc;
                    }
                    if (zzcob5.zzc <= zzcoe3.zzf) continue;
                    zzcoe3.zzf = zzcob5.zzc;
                }
                String string7 = zza2.zza.zzo;
                zzcie zzcie2 = this.zzq().zzb(string7);
                if (zzcie2 == null) {
                    this.zzf().zzy().zza("Bundling raw events w/o app info. appId", zzcjj.zza(zza2.zza.zzo));
                } else if (zzcoe3.zzb.length > 0) {
                    long l8 = zzcie2.zzh();
                    zzcoe3.zzh = l8 != 0L ? Long.valueOf(l8) : null;
                    long l9 = zzcie2.zzg();
                    if (l9 == 0L) {
                        l9 = l8;
                    }
                    zzcoe3.zzg = l9 != 0L ? Long.valueOf(l9) : null;
                    zzcie2.zzr();
                    zzcoe3.zzw = (int)zzcie2.zzo();
                    zzcie2.zza(zzcoe3.zze);
                    zzcie2.zzb(zzcoe3.zzf);
                    zzcoe3.zzx = zzcie2.zzz();
                    this.zzq().zza(zzcie2);
                }
                if (zzcoe3.zzb.length > 0) {
                    zzcny zzcny2 = this.zzj().zza(zza2.zza.zzo);
                    if (zzcny2 == null || zzcny2.zza == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zza.zzy)) {
                            zzcoe3.zzae = -1L;
                        } else {
                            this.zzf().zzaa().zza("Did not find measurement config or missing version info. appId", zzcjj.zza(zza2.zza.zzo));
                        }
                    } else {
                        zzcoe3.zzae = zzcny2.zza;
                    }
                    this.zzq().zza(zzcoe3, bl);
                }
                this.zzq().zza(zza2.zzb);
                string2 = string7;
                object2 = this.zzq();
                SQLiteDatabase sQLiteDatabase = ((zzcil)object2).zzaa();
                try {
                    sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string2, string2});
                }
                catch (SQLiteException sQLiteException) {
                    ((zzclh)object2).zzt().zzy().zza("Failed to remove unused event metadata. appId", zzcjj.zza(string2), (Object)sQLiteException);
                }
                this.zzq().zzy();
                return true;
            }
            this.zzq().zzy();
            return false;
        }
        finally {
            this.zzq().zzz();
        }
    }

    private final zzcoa[] zza(String string, zzcog[] zzcogArray, zzcob[] zzcobArray) {
        zzbq.zza((String)string);
        return this.zzz().zza(string, zzcobArray, zzcogArray);
    }

    @WorkerThread
    final void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        ((zzclh)this.zzh()).zzc();
        this.zza();
        zzbq.zza((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzf().zzae().zza("onConfigFetched. Response size", byArray.length);
            this.zzq().zzx();
            try {
                boolean bl;
                zzcie zzcie2 = this.zzq().zzb(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzcie2 == null) {
                    this.zzf().zzaa().zza("App does not exist in onConfigFetched. appId", zzcjj.zza(string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzj().zza(string) == null && !this.zzj().zza(string, null, null) : !this.zzj().zza(string, byArray, string2)) {
                        return;
                    }
                    zzcie2.zzg(this.zzn.zza());
                    this.zzq().zza(zzcie2);
                    if (n == 404) {
                        this.zzf().zzab().zza("Config not found. Using empty config. appId", string);
                    } else {
                        this.zzf().zzae().zza("Successfully fetched config. Got network response. code, size", n, byArray.length);
                    }
                    if (this.zzs().zzy() && this.zzal()) {
                        this.zzae();
                    } else {
                        this.zzam();
                    }
                } else {
                    zzcie2.zzh(this.zzn.zza());
                    this.zzq().zza(zzcie2);
                    this.zzf().zzae().zza("Fetching config failed. code, error", n, throwable);
                    this.zzj().zzc(string);
                    this.zze().zzd.zza(this.zzn.zza());
                    if (n == 503 || n == 429) {
                        this.zze().zze.zza(this.zzn.zza());
                    }
                    this.zzam();
                }
                this.zzq().zzy();
            }
            finally {
                this.zzq().zzz();
            }
            return;
        }
        finally {
            this.zzal = false;
            this.zzao();
        }
    }

    @WorkerThread
    protected final void zza(int n, Throwable throwable, byte[] byArray) {
        ((zzclh)this.zzh()).zzc();
        this.zza();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzaf;
            this.zzaf = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zze().zzc.zza(this.zzn.zza());
                    this.zze().zzd.zza(0L);
                    this.zzam();
                    this.zzf().zzae().zza("Successful upload. Got network response. code, size", n, byArray.length);
                    this.zzq().zzx();
                    try {
                        for (Long l : list) {
                            long l2 = l;
                            zzcil zzcil2 = this.zzq();
                            zzcil2.zzc();
                            zzcil2.zzaq();
                            SQLiteDatabase sQLiteDatabase = zzcil2.zzaa();
                            String[] stringArray = new String[]{String.valueOf(l2)};
                            try {
                                if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                throw new SQLiteException("Deleted fewer rows from queue than expected");
                            }
                            catch (SQLiteException sQLiteException) {
                                zzcil2.zzt().zzy().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                throw sQLiteException;
                            }
                        }
                        this.zzq().zzy();
                    }
                    finally {
                        this.zzq().zzz();
                    }
                    if (this.zzs().zzy() && this.zzal()) {
                        this.zzae();
                    } else {
                        this.zzaj = -1L;
                        this.zzam();
                    }
                    this.zzak = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzf().zzy().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzak = this.zzn.zzb();
                    this.zzf().zzae().zza("Disable upload, time", this.zzak);
                }
            } else {
                this.zzf().zzae().zza("Network upload failed. Will retry later. code, error", n, throwable);
                this.zze().zzd.zza(this.zzn.zza());
                if (n == 503 || n == 429) {
                    this.zze().zze.zza(this.zzn.zza());
                }
                this.zzam();
            }
            return;
        }
        finally {
            this.zzam = false;
            this.zzao();
        }
    }

    private final boolean zzal() {
        ((zzclh)this.zzh()).zzc();
        this.zza();
        return this.zzq().zzag() || !TextUtils.isEmpty((CharSequence)this.zzq().zzab());
    }

    @WorkerThread
    private final void zzam() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            ((zzclh)this.zzh()).zzc();
            this.zza();
            if (!this.zzan()) {
                return;
            }
            if (this.zzak > 0L) {
                l3 = this.zzn.zzb();
                l2 = 3600000L - Math.abs(l3 - this.zzak);
                if (l2 > 0L) {
                    this.zzf().zzae().zza("Upload has been suspended. Will update scheduling later in approximately ms", l2);
                    this.zzah().zzb();
                    this.zzai().zzy();
                    return;
                }
                this.zzak = 0L;
            }
            if (!this.zzb() || !this.zzal()) {
                this.zzf().zzae().zza("Nothing to upload or uploading impossible");
                this.zzah().zzb();
                this.zzai().zzy();
                return;
            }
            zzckj zzckj2 = this;
            long l4 = zzckj2.zzn.zza();
            long l5 = Math.max(0L, zzciz.zzag.zzb());
            boolean bl = zzckj2.zzq().zzah() || zzckj2.zzq().zzac();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzckj2.zzc.zzaa())) && !".none.".equals(string) ? Math.max(0L, zzciz.zzab.zzb()) : Math.max(0L, zzciz.zzaa.zzb())) : Math.max(0L, zzciz.zzz.zzb());
            long l7 = zzckj2.zze().zzc.zza();
            long l8 = zzckj2.zze().zzd.zza();
            long l9 = zzckj2.zzq().zzae();
            long l10 = zzckj2.zzq().zzaf();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzckj2.zzo().zza(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, zzciz.zzai.zzb())); ++i) {
                        long l15 = 1 << i;
                        if ((l14 += Math.max(0L, zzciz.zzah.zzb()) * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzf().zzae().zza("Next upload time is 0");
            this.zzah().zzb();
            this.zzai().zzy();
            return;
        }
        if (!this.zzs().zzy()) {
            this.zzf().zzae().zza("No network");
            this.zzah().zza();
            this.zzai().zzy();
            return;
        }
        l2 = this.zze().zze.zza();
        long l16 = Math.max(0L, zzciz.zzx.zzb());
        if (!this.zzo().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzah().zzb();
        long l17 = l3 - this.zzn.zza();
        if (l17 <= 0L) {
            l17 = Math.max(0L, zzciz.zzac.zzb());
            this.zze().zzc.zza(this.zzn.zza());
        }
        this.zzf().zzae().zza("Upload scheduled in approximately ms", l17);
        this.zzai().zza(l17);
    }

    public final void zza(boolean bl) {
        this.zzam();
    }

    final void zza(zzcli zzcli2) {
        ++this.zzah;
    }

    final void zzaf() {
        ++this.zzai;
    }

    @WorkerThread
    public final void zzc(zzcif zzcif2) {
        int n;
        ((zzclh)this.zzh()).zzc();
        this.zza();
        zzbq.zza((Object)((Object)zzcif2));
        zzbq.zza((String)zzcif2.zza);
        if (TextUtils.isEmpty((CharSequence)zzcif2.zzb)) {
            return;
        }
        zzcie zzcie2 = this.zzq().zzb(zzcif2.zza);
        if (zzcie2 != null && TextUtils.isEmpty((CharSequence)zzcie2.zzd()) && !TextUtils.isEmpty((CharSequence)zzcif2.zzb)) {
            zzcie2.zzg(0L);
            this.zzq().zza(zzcie2);
            this.zzj().zzd(zzcif2.zza);
        }
        if (!zzcif2.zzh) {
            this.zzd(zzcif2);
            return;
        }
        long l = zzcif2.zzm;
        if (l == 0L) {
            l = this.zzn.zza();
        }
        if ((n = zzcif2.zzn) != 0 && n != 1) {
            this.zzf().zzaa().zza("Incorrect app type, assuming installed app. appId, appType", zzcjj.zza(zzcif2.zza), n);
            n = 0;
        }
        this.zzq().zzx();
        try {
            zzcix zzcix2;
            Object object;
            long l2 = l;
            zzcif zzcif3 = zzcif2;
            zzckj zzckj2 = this;
            zzcie zzcie3 = zzckj2.zzq().zzb(zzcif3.zza);
            if (zzcie3 != null && zzcie3.zzd() != null && !zzcie3.zzd().equals(zzcif3.zzb)) {
                zzckj2.zzf().zzaa().zza("New GMP App Id passed in. Removing cached database data. appId", zzcjj.zza(zzcie3.zzb()));
                String string = zzcie3.zzb();
                zzcil zzcil2 = zzckj2.zzq();
                zzcil2.zzaq();
                zzcil2.zzc();
                zzbq.zza((String)string);
                try {
                    SQLiteDatabase sQLiteDatabase = zzcil2.zzaa();
                    String[] stringArray = new String[]{string};
                    int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                    if (n2 > 0) {
                        zzcil2.zzt().zzae().zza("Deleted application data. app, records", string, n2);
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzcil2.zzt().zzy().zza("Error deleting application data. appId, error", zzcjj.zza(string), (Object)sQLiteException);
                }
                zzcie3 = null;
            }
            if (zzcie3 != null) {
                if (zzcie3.zzj() != Integer.MIN_VALUE) {
                    if (zzcie3.zzj() != zzcif3.zzj) {
                        object = new Bundle();
                        object.putString("_pv", zzcie3.zzi());
                        zzcix2 = new zzcix("_au", new zzciu((Bundle)object), "auto", l2);
                        zzckj2.zza(zzcix2, zzcif3);
                    }
                } else if (zzcie3.zzi() != null && !zzcie3.zzi().equals(zzcif3.zzc)) {
                    object = new Bundle();
                    object.putString("_pv", zzcie3.zzi());
                    zzcix2 = new zzcix("_au", new zzciu((Bundle)object), "auto", l2);
                    zzckj2.zza(zzcix2, zzcif3);
                }
            }
            this.zzd(zzcif2);
            zzcit zzcit2 = null;
            if (n == 0) {
                zzcit2 = this.zzq().zza(zzcif2.zza, "_f");
            } else if (n == 1) {
                zzcit2 = this.zzq().zza(zzcif2.zza, "_v");
            }
            if (zzcit2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzbgl zzbgl2;
                    zzcnl zzcnl2 = new zzcnl("_fot", l, l3, "auto");
                    this.zza(zzcnl2, zzcif2);
                    l2 = l;
                    zzcif3 = zzcif2;
                    zzckj2 = this;
                    ((zzclh)zzckj2.zzh()).zzc();
                    zzckj2.zza();
                    zzcie3 = new Bundle();
                    zzcie3.putLong("_c", 1L);
                    zzcie3.putLong("_r", 1L);
                    zzcie3.putLong("_uwa", 0L);
                    zzcie3.putLong("_pfo", 0L);
                    zzcie3.putLong("_sys", 0L);
                    zzcie3.putLong("_sysu", 0L);
                    if (zzckj2.zzb.getPackageManager() == null) {
                        zzckj2.zzf().zzy().zza("PackageManager is null, first open report might be inaccurate. appId", zzcjj.zza(zzcif3.zza));
                    } else {
                        zzcix2 = null;
                        try {
                            zzcix2 = zzbih.zza((Context)zzckj2.zzb).zzb(zzcif3.zza, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzckj2.zzf().zzy().zza("Package info is null, first open report might be inaccurate. appId", zzcjj.zza(zzcif3.zza), (Object)nameNotFoundException);
                        }
                        if (zzcix2 != null && ((PackageInfo)zzcix2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzcix2).firstInstallTime != ((PackageInfo)zzcix2).lastUpdateTime) {
                                zzcie3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zzbgl2 = new zzcnl("_fi", l2, bl ? 1L : 0L, "auto");
                            zzckj2.zza((zzcnl)zzbgl2, zzcif3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = zzbih.zza((Context)zzckj2.zzb).zza(zzcif3.zza, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzckj2.zzf().zzy().zza("Application info is null, first open report might be inaccurate. appId", zzcjj.zza(zzcif3.zza), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzcie3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzcie3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzcif3.zza;
                    zzcil zzcil3 = zzckj2.zzq();
                    zzbq.zza((String)string);
                    zzcil3.zzc();
                    zzcil3.zzaq();
                    long l4 = zzcil3.zzh(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzcie3.putLong("_pfo", l4);
                    }
                    zzbgl2 = new zzcix("_f", new zzciu((Bundle)zzcie3), "auto", l2);
                    zzckj2.zza((zzcix)zzbgl2, zzcif3);
                } else if (n == 1) {
                    zzcnl zzcnl3 = new zzcnl("_fvt", l, l3, "auto");
                    this.zza(zzcnl3, zzcif2);
                    l2 = l;
                    zzcif3 = zzcif2;
                    zzckj2 = this;
                    ((zzclh)zzckj2.zzh()).zzc();
                    zzckj2.zza();
                    zzcie3 = new Bundle();
                    zzcie3.putLong("_c", 1L);
                    zzcie3.putLong("_r", 1L);
                    object = new zzcix("_v", new zzciu((Bundle)zzcie3), "auto", l2);
                    zzckj2.zza((zzcix)((Object)object), zzcif3);
                }
                l2 = l;
                zzcif3 = zzcif2;
                zzckj2 = this;
                zzcie3 = new Bundle();
                zzcie3.putLong("_et", 1L);
                object = new zzcix("_e", new zzciu((Bundle)zzcie3), "auto", l2);
                zzckj2.zza((zzcix)((Object)object), zzcif3);
            } else if (zzcif2.zzi) {
                l2 = l;
                zzcif3 = zzcif2;
                zzckj2 = this;
                zzcie3 = new Bundle();
                object = new zzcix("_cd", new zzciu((Bundle)zzcie3), "auto", l2);
                zzckj2.zza((zzcix)((Object)object), zzcif3);
            }
            this.zzq().zzy();
            return;
        }
        finally {
            this.zzq().zzz();
        }
    }

    @WorkerThread
    private final void zzd(zzcif zzcif2) {
        ((zzclh)this.zzh()).zzc();
        this.zza();
        zzbq.zza((Object)((Object)zzcif2));
        zzbq.zza((String)zzcif2.zza);
        zzcie zzcie2 = this.zzq().zzb(zzcif2.zza);
        String string = this.zze().zzb(zzcif2.zza);
        boolean bl = false;
        if (zzcie2 == null) {
            zzcie2 = new zzcie(this, zzcif2.zza);
            zzcie2.zza(this.zzy().zzy());
            zzcie2.zzc(string);
            bl = true;
        } else if (!string.equals(zzcie2.zze())) {
            zzcie2.zzc(string);
            zzcie2.zza(this.zzy().zzy());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcif2.zzb) && !zzcif2.zzb.equals(zzcie2.zzd())) {
            zzcie2.zzb(zzcif2.zzb);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcif2.zzk) && !zzcif2.zzk.equals(zzcie2.zzf())) {
            zzcie2.zzd(zzcif2.zzk);
            bl = true;
        }
        if (zzcif2.zze != 0L && zzcif2.zze != zzcie2.zzl()) {
            zzcie2.zzd(zzcif2.zze);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcif2.zzc) && !zzcif2.zzc.equals(zzcie2.zzi())) {
            zzcie2.zze(zzcif2.zzc);
            bl = true;
        }
        if (zzcif2.zzj != zzcie2.zzj()) {
            zzcie2.zzc(zzcif2.zzj);
            bl = true;
        }
        if (zzcif2.zzd != null && !zzcif2.zzd.equals(zzcie2.zzk())) {
            zzcie2.zzf(zzcif2.zzd);
            bl = true;
        }
        if (zzcif2.zzf != zzcie2.zzm()) {
            zzcie2.zze(zzcif2.zzf);
            bl = true;
        }
        if (zzcif2.zzh != zzcie2.zzn()) {
            zzcie2.zza(zzcif2.zzh);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcif2.zzg) && !zzcif2.zzg.equals(zzcie2.zzy())) {
            zzcie2.zzg(zzcif2.zzg);
            bl = true;
        }
        if (zzcif2.zzl != zzcie2.zzaa()) {
            zzcie2.zzo(zzcif2.zzl);
            bl = true;
        }
        if (zzcif2.zzo != zzcie2.zzab()) {
            zzcie2.zzb(zzcif2.zzo);
            bl = true;
        }
        if (bl) {
            this.zzq().zza(zzcie2);
        }
    }

    @WorkerThread
    final void zzag() {
        ((zzclh)this.zzh()).zzc();
        this.zza();
        if (!this.zzaa) {
            this.zzf().zzac().zza("This instance being marked as an uploader");
            zzckj zzckj2 = this;
            ((zzclh)zzckj2.zzh()).zzc();
            zzckj2.zza();
            if (zzckj2.zzan() && zzckj2.zzaj()) {
                int n;
                int n2 = zzckj2.zza(zzckj2.zzae);
                int n3 = n = zzckj2.zzy().zzab();
                int n4 = n2;
                zzckj zzckj3 = zzckj2;
                ((zzclh)zzckj3.zzh()).zzc();
                if (n4 > n3) {
                    zzckj3.zzf().zzy().zza("Panic: can't downgrade version. Previous, current version", n4, n3);
                } else if (n4 < n3) {
                    if (zzckj3.zza(n3, zzckj3.zzae)) {
                        zzckj3.zzf().zzae().zza("Storage version upgraded. Previous, current version", n4, n3);
                    } else {
                        zzckj3.zzf().zzy().zza("Storage version upgrade failed. Previous, current version", n4, n3);
                    }
                }
            }
            this.zzaa = true;
            this.zzam();
        }
    }

    @WorkerThread
    private final boolean zzan() {
        ((zzclh)this.zzh()).zzc();
        this.zza();
        return this.zzaa;
    }

    @WorkerThread
    final void zza(Runnable runnable) {
        ((zzclh)this.zzh()).zzc();
        if (this.zzag == null) {
            this.zzag = new ArrayList<Runnable>();
        }
        this.zzag.add(runnable);
    }

    @WorkerThread
    private final void zzao() {
        ((zzclh)this.zzh()).zzc();
        if (this.zzal || this.zzam || this.zzan) {
            this.zzf().zzae().zza("Not stopping services. fetch, network, upload", this.zzal, this.zzam, this.zzan);
            return;
        }
        this.zzf().zzae().zza("Stopping uploading service(s)");
        if (this.zzag == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzag.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzag.clear();
    }

    @WorkerThread
    private final Boolean zzb(zzcie zzcie2) {
        try {
            if (zzcie2.zzj() != Integer.MIN_VALUE) {
                int n = zzbih.zza((Context)this.zzb).zzb((String)zzcie2.zzb(), (int)0).versionCode;
                if (zzcie2.zzj() == (long)n) {
                    return true;
                }
            } else {
                String string = zzbih.zza((Context)this.zzb).zzb((String)zzcie2.zzb(), (int)0).versionName;
                if (zzcie2.zzi() != null && zzcie2.zzi().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    static /* synthetic */ void zza(zzckj zzckj2, zzclj zzclj2) {
        zzckj2.zza(zzclj2);
    }

    final class zza
    implements zzcin {
        zzcoe zza;
        List<Long> zzb;
        List<zzcob> zzc;
        private long zzd;
        private /* synthetic */ zzckj zze;

        private zza(zzckj zzckj2) {
            this.zze = zzckj2;
        }

        @Override
        public final void zza(zzcoe zzcoe2) {
            zzbq.zza((Object)((Object)zzcoe2));
            this.zza = zzcoe2;
        }

        @Override
        public final boolean zza(long l, zzcob zzcob2) {
            zzbq.zza((Object)((Object)zzcob2));
            if (this.zzc == null) {
                this.zzc = new ArrayList<zzcob>();
            }
            if (this.zzb == null) {
                this.zzb = new ArrayList<Long>();
            }
            if (this.zzc.size() > 0 && com.google.android.gms.internal.zzckj$zza.zza(this.zzc.get(0)) != com.google.android.gms.internal.zzckj$zza.zza(zzcob2)) {
                return false;
            }
            long l2 = this.zzd + (long)zzcob2.zzf();
            if (l2 >= (long)Math.max(0, zzciz.zzo.zzb())) {
                return false;
            }
            this.zzd = l2;
            this.zzc.add(zzcob2);
            this.zzb.add(l);
            return this.zzc.size() < Math.max(1, zzciz.zzp.zzb());
        }

        private static long zza(zzcob zzcob2) {
            return zzcob2.zzc / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzckj zzckj2, zzckk zzckk2) {
            this(zzckj2);
        }
    }
}

