/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcia;
import com.google.android.gms.internal.zzcid;
import com.google.android.gms.internal.zzcke;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import com.google.android.gms.internal.zzclz;
import com.google.android.gms.internal.zzcmb;
import com.google.android.gms.internal.zzcmc;
import com.google.android.gms.internal.zzcmd;
import com.google.android.gms.internal.zzcno;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class zzcma
extends zzcli {
    protected zzcmd zza;
    private volatile zzclz zzb;
    private zzclz zzc;
    private long zzd;
    private final Map<Activity, zzcmd> zze = new ArrayMap();
    private final CopyOnWriteArrayList<AppMeasurement.zza> zzf = new CopyOnWriteArrayList();
    private boolean zzg;
    private zzclz zzh;
    private String zzi;

    public zzcma(zzckj zzckj2) {
        super(zzckj2);
    }

    @Override
    protected final boolean zzw() {
        return false;
    }

    @WorkerThread
    public final zzcmd zzy() {
        this.zzaq();
        ((zzclh)this).zzc();
        return this.zza;
    }

    @MainThread
    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        ((zzclh)this).zzs();
        if (!zzcke.zzy()) {
            ((zzclh)this).zzt().zzaa().zza("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzg) {
            ((zzclh)this).zzt().zzaa().zza("Cannot call setCurrentScreen from onScreenChangeCallback");
            return;
        }
        if (this.zzb == null) {
            ((zzclh)this).zzt().zzaa().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zze.get(activity) == null) {
            ((zzclh)this).zzt().zzaa().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzcma.zza(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzb.zzb.equals(string2);
        boolean bl2 = zzcno.zzb(this.zzb.zza, string);
        if (bl && bl2) {
            ((zzclh)this).zzt().zzab().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzclh)this).zzt().zzaa().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzclh)this).zzt().zzaa().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzclh)this).zzt().zzae().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzcmd zzcmd2 = new zzcmd(string, string2, ((zzclh)this).zzp().zzy());
        this.zze.put(activity, zzcmd2);
        this.zza(activity, zzcmd2, true);
    }

    public final zzclz zzz() {
        zzclz zzclz2 = this.zzb;
        if (zzclz2 == null) {
            return null;
        }
        return new zzclz(zzclz2);
    }

    @MainThread
    public final void zza(@NonNull AppMeasurement.zza zza2) {
        if (zza2 == null) {
            ((zzclh)this).zzt().zzaa().zza("Attempting to register null OnScreenChangeCallback");
            return;
        }
        this.zzf.remove(zza2);
        this.zzf.add(zza2);
    }

    @MainThread
    public final void zzb(@NonNull AppMeasurement.zza zza2) {
        this.zzf.remove(zza2);
    }

    @MainThread
    private final void zza(Activity activity, zzcmd zzcmd2, boolean bl) {
        Object object;
        Object object2;
        zzclz zzclz2 = null;
        if (this.zzb != null) {
            zzclz2 = this.zzb;
        } else if (this.zzc != null && Math.abs(((zzclh)this).zzk().zzb() - this.zzd) < 1000L) {
            zzclz2 = this.zzc;
        }
        zzclz zzclz3 = null;
        if (zzclz2 != null) {
            zzclz3 = new zzclz(zzclz2);
        }
        boolean bl2 = true;
        this.zzg = true;
        try {
            object2 = this.zzf.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                try {
                    bl2 &= object.zza(zzclz3, zzcmd2);
                }
                catch (Exception exception) {
                    ((zzclh)this).zzt().zzy().zza("onScreenChangeCallback threw exception", exception);
                }
            }
        }
        catch (Exception exception) {
            ((zzclh)this).zzt().zzy().zza("onScreenChangeCallback loop threw exception", exception);
        }
        finally {
            this.zzg = false;
        }
        Object object3 = object2 = this.zzb == null ? this.zzc : this.zzb;
        if (bl2) {
            if (zzcmd2.zzb == null) {
                zzcmd2.zzb = zzcma.zza(activity.getClass().getCanonicalName());
            }
            object = new zzcmd(zzcmd2);
            this.zzc = this.zzb;
            this.zzd = ((zzclh)this).zzk().zzb();
            this.zzb = object;
            ((zzclh)this).zzs().zza(new zzcmb(this, bl, (zzclz)object2, (zzcmd)object));
        }
    }

    @WorkerThread
    private final void zza(@NonNull zzcmd zzcmd2) {
        ((zzclh)this).zzd().zza(((zzclh)this).zzk().zzb());
        if (((zzclh)this).zzr().zza(zzcmd2.zzd)) {
            zzcmd2.zzd = false;
        }
    }

    public static void zza(zzclz zzclz2, Bundle bundle, boolean bl) {
        if (bundle != null && zzclz2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzclz2.zza != null) {
                bundle.putString("_sn", zzclz2.zza);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzclz2.zzb);
            bundle.putLong("_si", zzclz2.zzc);
            return;
        }
        if (bundle != null && zzclz2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzclz zzclz2) {
        ((zzclh)this).zzc();
        zzcma zzcma2 = this;
        synchronized (zzcma2) {
            if (this.zzi == null || this.zzi.equals(string) || zzclz2 != null) {
                this.zzi = string;
                this.zzh = zzclz2;
            }
            return;
        }
    }

    private static String zza(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    final zzcmd zza(@NonNull Activity activity) {
        zzbq.zza((Object)activity);
        zzcmd zzcmd2 = this.zze.get(activity);
        if (zzcmd2 == null) {
            String string = zzcma.zza(activity.getClass().getCanonicalName());
            zzcmd2 = new zzcmd(null, string, ((zzclh)this).zzp().zzy());
            this.zze.put(activity, zzcmd2);
        }
        return zzcmd2;
    }

    @MainThread
    public final void zzb(Activity activity) {
        zzcmd zzcmd2 = this.zza(activity);
        this.zza(activity, zzcmd2, false);
        zzcia zzcia2 = ((zzclh)this).zzd();
        long l = ((zzclh)zzcia2).zzk().zzb();
        ((zzclh)zzcia2).zzs().zza(new zzcid(zzcia2, l));
    }

    @MainThread
    public final void zzc(Activity activity) {
        zzcmd zzcmd2 = this.zza(activity);
        this.zzc = this.zzb;
        this.zzd = ((zzclh)this).zzk().zzb();
        this.zzb = null;
        ((zzclh)this).zzs().zza(new zzcmc(this, zzcmd2));
    }

    @MainThread
    public final void zza(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzcmd zzcmd2 = this.zze.get(activity);
        if (zzcmd2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzcmd2.zzc);
        bundle2.putString("name", zzcmd2.zza);
        bundle2.putString("referrer_name", zzcmd2.zzb);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public final void zzd(Activity activity) {
        this.zze.remove(activity);
    }

    static /* synthetic */ void zza(zzcma zzcma2, zzcmd zzcmd2) {
        zzcma2.zza(zzcmd2);
    }
}

