/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzcif;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcip;
import com.google.android.gms.internal.zzcix;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcjb;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import com.google.android.gms.internal.zzclz;
import com.google.android.gms.internal.zzcmf;
import com.google.android.gms.internal.zzcmg;
import com.google.android.gms.internal.zzcmh;
import com.google.android.gms.internal.zzcmi;
import com.google.android.gms.internal.zzcmj;
import com.google.android.gms.internal.zzcmk;
import com.google.android.gms.internal.zzcml;
import com.google.android.gms.internal.zzcmm;
import com.google.android.gms.internal.zzcmn;
import com.google.android.gms.internal.zzcmo;
import com.google.android.gms.internal.zzcmp;
import com.google.android.gms.internal.zzcmq;
import com.google.android.gms.internal.zzcmr;
import com.google.android.gms.internal.zzcms;
import com.google.android.gms.internal.zzcni;
import com.google.android.gms.internal.zzcnl;
import com.google.android.gms.internal.zzcno;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@Hide
public final class zzcme
extends zzcli {
    private final zzcms zza;
    private zzcjb zzb;
    private volatile Boolean zzc;
    private final zzcip zzd;
    private final zzcni zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzcip zzg;

    protected zzcme(zzckj zzckj2) {
        super(zzckj2);
        this.zze = new zzcni(zzckj2.zzu());
        this.zza = new zzcms(this);
        this.zzd = new zzcmf(this, zzckj2);
        this.zzg = new zzcmk(this, zzckj2);
    }

    @Override
    protected final boolean zzw() {
        return false;
    }

    @WorkerThread
    public final boolean zzy() {
        ((zzclh)this).zzc();
        this.zzaq();
        return this.zzb != null;
    }

    @WorkerThread
    protected final void zzz() {
        ((zzclh)this).zzc();
        this.zzaq();
        zzcif zzcif2 = this.zza(true);
        this.zza(new zzcml(this, zzcif2));
    }

    @WorkerThread
    final void zza(zzcjb zzcjb2, zzbgl zzbgl2, zzcif zzcif2) {
        ((zzclh)this).zzc();
        this.zzaq();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<zzbgl> arrayList = new ArrayList<zzbgl>();
            n = 0;
            List<zzbgl> list = ((zzclh)this).zzm().zza(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (zzbgl2 != null && n < 100) {
                arrayList.add(zzbgl2);
            }
            ArrayList<zzbgl> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                zzbgl zzbgl3 = (zzbgl)e;
                if (zzbgl3 instanceof zzcix) {
                    try {
                        zzcjb2.zza((zzcix)zzbgl3, zzcif2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzclh)this).zzt().zzy().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zzbgl3 instanceof zzcnl) {
                    try {
                        zzcjb2.zza((zzcnl)zzbgl3, zzcif2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzclh)this).zzt().zzy().zza("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zzbgl3 instanceof zzcii) {
                    try {
                        zzcjb2.zza((zzcii)zzbgl3, zzcif2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzclh)this).zzt().zzy().zza("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzclh)this).zzt().zzy().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzcix zzcix2, String string) {
        zzbq.zza((Object)((Object)zzcix2));
        ((zzclh)this).zzc();
        this.zzaq();
        boolean bl = ((zzclh)this).zzm().zza(zzcix2);
        zzcif zzcif2 = this.zza(true);
        this.zza(new zzcmm(this, true, bl, zzcix2, zzcif2, string));
    }

    @WorkerThread
    protected final void zza(zzcii zzcii2) {
        zzbq.zza((Object)((Object)zzcii2));
        ((zzclh)this).zzc();
        this.zzaq();
        boolean bl = ((zzclh)this).zzm().zza(zzcii2);
        zzcii zzcii3 = new zzcii(zzcii2);
        zzcif zzcif2 = this.zza(true);
        this.zza(new zzcmn(this, true, bl, zzcii3, zzcif2, zzcii2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcii>> atomicReference, String string, String string2, String string3) {
        ((zzclh)this).zzc();
        this.zzaq();
        zzcif zzcif2 = this.zza(false);
        this.zza(new zzcmo(this, atomicReference, string, string2, string3, zzcif2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcnl>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzclh)this).zzc();
        this.zzaq();
        zzcif zzcif2 = this.zza(false);
        this.zza(new zzcmp(this, atomicReference, string, string2, string3, bl, zzcif2));
    }

    @WorkerThread
    protected final void zza(zzcnl zzcnl2) {
        ((zzclh)this).zzc();
        this.zzaq();
        boolean bl = ((zzclh)this).zzm().zza(zzcnl2);
        zzcif zzcif2 = this.zza(true);
        this.zza(new zzcmq(this, bl, zzcnl2, zzcif2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcnl>> atomicReference, boolean bl) {
        ((zzclh)this).zzc();
        this.zzaq();
        zzcif zzcif2 = this.zza(false);
        this.zza(new zzcmr(this, atomicReference, zzcif2, bl));
    }

    @WorkerThread
    protected final void zzaa() {
        ((zzclh)this).zzc();
        this.zzaq();
        zzcif zzcif2 = this.zza(false);
        ((zzclh)this).zzm().zzy();
        this.zza(new zzcmg(this, zzcif2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzclh)this).zzc();
        this.zzaq();
        zzcif zzcif2 = this.zza(false);
        this.zza(new zzcmh(this, atomicReference, zzcif2));
    }

    @WorkerThread
    protected final void zzab() {
        ((zzclh)this).zzc();
        this.zzaq();
        zzcif zzcif2 = this.zza(true);
        this.zza(new zzcmi(this, zzcif2));
    }

    @WorkerThread
    protected final void zza(zzclz zzclz2) {
        ((zzclh)this).zzc();
        this.zzaq();
        this.zza(new zzcmj(this, zzclz2));
    }

    @WorkerThread
    private final void zzaf() {
        ((zzclh)this).zzc();
        this.zze.zza();
        this.zzd.zza(zzciz.zzam.zzb());
    }

    @WorkerThread
    final void zzac() {
        Intent intent;
        Object object;
        zzcme zzcme2;
        ((zzclh)this).zzc();
        this.zzaq();
        if (this.zzy()) {
            return;
        }
        if (this.zzc == null) {
            boolean bl;
            zzcme2 = this;
            ((zzclh)zzcme2).zzc();
            zzcme2.zzaq();
            object = ((zzclh)zzcme2).zzu().zzaa();
            if (object != null && ((Boolean)object).booleanValue()) {
                bl = true;
            } else {
                boolean bl2;
                boolean bl3;
                if (((zzclh)zzcme2).zzg().zzac() == 1) {
                    bl3 = true;
                    bl2 = true;
                } else {
                    ((zzclh)zzcme2).zzt().zzae().zza("Checking service availability");
                    zzcno zzcno2 = ((zzclh)zzcme2).zzp();
                    int n = com.google.android.gms.common.zzf.zza().isGooglePlayServicesAvailable(((zzclh)zzcno2).zzl());
                    switch (n) {
                        case 0: {
                            ((zzclh)zzcme2).zzt().zzae().zza("Service available");
                            bl3 = true;
                            bl2 = true;
                            break;
                        }
                        case 1: {
                            ((zzclh)zzcme2).zzt().zzae().zza("Service missing");
                            bl3 = false;
                            bl2 = true;
                            break;
                        }
                        case 18: {
                            ((zzclh)zzcme2).zzt().zzaa().zza("Service updating");
                            bl3 = true;
                            bl2 = true;
                            break;
                        }
                        case 2: {
                            ((zzclh)zzcme2).zzt().zzad().zza("Service container out of date");
                            if (12210L < 11800L) {
                                bl3 = false;
                                bl2 = true;
                                break;
                            }
                            Boolean bl4 = ((zzclh)zzcme2).zzu().zzaa();
                            bl3 = bl4 == null || bl4 != false;
                            bl2 = false;
                            break;
                        }
                        case 3: {
                            ((zzclh)zzcme2).zzt().zzaa().zza("Service disabled");
                            bl3 = false;
                            bl2 = false;
                            break;
                        }
                        case 9: {
                            ((zzclh)zzcme2).zzt().zzaa().zza("Service invalid");
                            bl3 = false;
                            bl2 = false;
                            break;
                        }
                        default: {
                            ((zzclh)zzcme2).zzt().zzaa().zza("Unexpected service status", n);
                            bl3 = false;
                            bl2 = false;
                        }
                    }
                }
                if (bl2) {
                    ((zzclh)zzcme2).zzu().zza(bl3);
                }
                bl = bl3;
            }
            this.zzc = bl;
        }
        if (this.zzc.booleanValue()) {
            this.zza.zza();
            return;
        }
        zzcme2 = this;
        object = ((zzclh)zzcme2).zzl().getPackageManager();
        List list = object.queryIntentServices(intent = new Intent().setClassName(((zzclh)zzcme2).zzl(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
        if (list != null && list.size() > 0) {
            Intent intent2 = new Intent("com.google.android.gms.measurement.START");
            intent2.setComponent(new ComponentName(((zzclh)this).zzl(), "com.google.android.gms.measurement.AppMeasurementService"));
            this.zza.zza(intent2);
            return;
        }
        ((zzclh)this).zzt().zzy().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
    }

    final Boolean zzad() {
        return this.zzc;
    }

    @WorkerThread
    protected final void zza(zzcjb zzcjb2) {
        ((zzclh)this).zzc();
        zzbq.zza((Object)zzcjb2);
        this.zzb = zzcjb2;
        this.zzaf();
        this.zzah();
    }

    @WorkerThread
    public final void zzae() {
        ((zzclh)this).zzc();
        this.zzaq();
        try {
            com.google.android.gms.common.stats.zza.zza();
            zzcms zzcms2 = this.zza;
            Context context = ((zzclh)this).zzl();
            context.unbindService((ServiceConnection)zzcms2);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zza(ComponentName componentName) {
        ((zzclh)this).zzc();
        if (this.zzb != null) {
            this.zzb = null;
            ((zzclh)this).zzt().zzae().zza("Disconnected from device MeasurementService", componentName);
            zzcme zzcme2 = this;
            ((zzclh)zzcme2).zzc();
            zzcme2.zzac();
        }
    }

    @WorkerThread
    private final void zzag() {
        ((zzclh)this).zzc();
        if (!this.zzy()) {
            return;
        }
        ((zzclh)this).zzt().zzae().zza("Inactivity, disconnecting from the service");
        this.zzae();
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzclh)this).zzc();
        if (this.zzy()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzclh)this).zzt().zzy().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzac();
    }

    @WorkerThread
    private final void zzah() {
        ((zzclh)this).zzc();
        ((zzclh)this).zzt().zzae().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                ((zzclh)this).zzt().zzy().zza("Task exception while flushing queue", throwable);
            }
        }
        this.zzf.clear();
        this.zzg.zzc();
    }

    @WorkerThread
    @Nullable
    private final zzcif zza(boolean bl) {
        return ((zzclh)this).zzg().zza(bl ? ((zzclh)this).zzt().zzaf() : null);
    }

    static /* synthetic */ zzcms zza(zzcme zzcme2) {
        return zzcme2.zza;
    }

    static /* synthetic */ void zza(zzcme zzcme2, ComponentName componentName) {
        zzcme2.zza(componentName);
    }

    static /* synthetic */ zzcjb zza(zzcme zzcme2, zzcjb zzcjb2) {
        zzcme2.zzb = null;
        return null;
    }

    static /* synthetic */ void zzb(zzcme zzcme2) {
        zzcme2.zzah();
    }

    static /* synthetic */ void zzc(zzcme zzcme2) {
        zzcme2.zzag();
    }

    static /* synthetic */ zzcjb zzd(zzcme zzcme2) {
        return zzcme2.zzb;
    }

    static /* synthetic */ void zze(zzcme zzcme2) {
        zzcme2.zzaf();
    }
}

