/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzcjb;
import com.google.android.gms.internal.zzcjd;
import com.google.android.gms.internal.zzcji;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcme;
import com.google.android.gms.internal.zzcmt;
import com.google.android.gms.internal.zzcmu;
import com.google.android.gms.internal.zzcmv;
import com.google.android.gms.internal.zzcmw;
import com.google.android.gms.internal.zzcmx;

public final class zzcms
implements ServiceConnection,
zzf,
zzg {
    private volatile boolean zzb;
    private volatile zzcji zzc;
    final /* synthetic */ zzcme zza;

    protected zzcms(zzcme zzcme2) {
        this.zza = zzcme2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzclh)this.zza).zzc();
        Context context = ((zzclh)this.zza).zzl();
        zza zza2 = com.google.android.gms.common.stats.zza.zza();
        zzcms zzcms2 = this;
        synchronized (zzcms2) {
            if (this.zzb) {
                ((zzclh)this.zza).zzt().zzae().zza("Connection attempt already in progress");
                return;
            }
            ((zzclh)this.zza).zzt().zzae().zza("Using local app measurement service");
            this.zzb = true;
            zza2.zza(context, intent, (ServiceConnection)zzcme.zza(this.zza), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzbq.zzb((String)"MeasurementServiceConnection.onServiceConnected");
        zzcms zzcms2 = this;
        synchronized (zzcms2) {
            IInterface iInterface;
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzclh)this.zza).zzt().zzy().zza("Service connected with null binder");
                return;
            }
            zzcjb zzcjb2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IBinder iBinder2 = iBinder;
                    zzcjb2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzcjb ? (zzcjb)iInterface : new zzcjd(iBinder2));
                    ((zzclh)this.zza).zzt().zzae().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzclh)this.zza).zzt().zzy().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzclh)this.zza).zzt().zzy().zza("Service connect failed to get IMeasurementService");
            }
            if (zzcjb2 == null) {
                this.zzb = false;
                try {
                    com.google.android.gms.common.stats.zza.zza();
                    zzcms zzcms3 = zzcme.zza(this.zza);
                    iInterface = ((zzclh)this.zza).zzl();
                    iInterface.unbindService((ServiceConnection)zzcms3);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzcjb2;
                ((zzclh)this.zza).zzs().zza(new zzcmt(this, (zzcjb)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        zzbq.zzb((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzclh)this.zza).zzt().zzad().zza("Service disconnected");
        ((zzclh)this.zza).zzs().zza(new zzcmu(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza() {
        ((zzclh)this.zza).zzc();
        Context context = ((zzclh)this.zza).zzl();
        zzcms zzcms2 = this;
        synchronized (zzcms2) {
            if (this.zzb) {
                ((zzclh)this.zza).zzt().zzae().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null) {
                ((zzclh)this.zza).zzt().zzae().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzcji(context, Looper.getMainLooper(), this, this);
            ((zzclh)this.zza).zzt().zzae().zza("Connecting to remote service");
            this.zzb = true;
            this.zzc.zzz();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(@Nullable Bundle bundle) {
        zzbq.zzb((String)"MeasurementServiceConnection.onConnected");
        zzcms zzcms2 = this;
        synchronized (zzcms2) {
            try {
                zzcjb zzcjb2 = (zzcjb)this.zzc.zzaf();
                this.zzc = null;
                ((zzclh)this.zza).zzs().zza(new zzcmv(this, zzcjb2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    @MainThread
    public final void zza(int n) {
        zzbq.zzb((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzclh)this.zza).zzt().zzad().zza("Service connection suspended");
        ((zzclh)this.zza).zzs().zza(new zzcmw(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(@NonNull ConnectionResult connectionResult) {
        zzbq.zzb((String)"MeasurementServiceConnection.onConnectionFailed");
        zzcjj zzcjj2 = this.zza.zzp.zzg();
        if (zzcjj2 != null) {
            zzcjj2.zzaa().zza("Service connection failed", connectionResult);
        }
        zzcms zzcms2 = this;
        synchronized (zzcms2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzclh)this.zza).zzs().zza(new zzcmx(this));
    }

    static /* synthetic */ boolean zza(zzcms zzcms2, boolean bl) {
        zzcms2.zzb = false;
        return false;
    }
}

