/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcie;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcik;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcio;
import com.google.android.gms.internal.zzcis;
import com.google.android.gms.internal.zzcit;
import com.google.android.gms.internal.zzcix;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import com.google.android.gms.internal.zzcni;
import com.google.android.gms.internal.zzcnl;
import com.google.android.gms.internal.zzcnn;
import com.google.android.gms.internal.zzcno;
import com.google.android.gms.internal.zzcnr;
import com.google.android.gms.internal.zzcns;
import com.google.android.gms.internal.zzcnv;
import com.google.android.gms.internal.zzcob;
import com.google.android.gms.internal.zzcoc;
import com.google.android.gms.internal.zzcoe;
import com.google.android.gms.internal.zzcof;
import com.google.android.gms.internal.zzflj;
import com.google.android.gms.internal.zzflk;
import com.google.android.gms.internal.zzflm;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class zzcil
extends zzcli {
    private static final String[] zzjgw = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;"};
    private static final String[] zzjgx = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zzjgy = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;"};
    private static final String[] zzjgz = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zzjha = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;"};
    private static final String[] zzjhb = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private final zzcio zzjhc;
    private final zzcni zzjhd = new zzcni(this.zzxx());

    zzcil(zzckj zzckj2) {
        super(zzckj2);
        String string = "google_app_measurement.db";
        this.zzjhc = new zzcio(this, this.getContext(), string);
    }

    @Override
    protected final boolean zzazq() {
        return false;
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzyk();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzyk();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzyk();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zzc(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzayp().zzbau().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzwj();
        try {
            return this.zzjhc.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzayp().zzbaw().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzcit zzae(String string, String string2) {
        zzbq.zzgv((String)string);
        zzbq.zzgv((String)string2);
        this.zzwj();
        this.zzyk();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Boolean bl = null;
            if (!cursor.isNull(6)) {
                bl = cursor.getLong(6) == 1L;
            }
            zzcit zzcit2 = new zzcit(string, string2, l, l2, l3, l4, l5, l6, bl);
            if (cursor.moveToNext()) {
                this.zzayp().zzbau().zzj("Got multiple records for event aggregates, expected one. appId", zzcjj.zzjs(string));
            }
            zzcit zzcit3 = zzcit2;
            return zzcit3;
        }
    }

    @WorkerThread
    public final void zza(zzcit zzcit2) {
        zzbq.checkNotNull((Object)zzcit2);
        this.zzwj();
        this.zzyk();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcit2.zzcm);
        contentValues.put("name", zzcit2.name);
        contentValues.put("lifetime_count", Long.valueOf(zzcit2.zzjhs));
        contentValues.put("current_bundle_count", Long.valueOf(zzcit2.zzjht));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzcit2.zzjhu));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzcit2.zzjhv));
        contentValues.put("last_sampled_complex_event_id", zzcit2.zzjhw);
        contentValues.put("last_sampling_rate", zzcit2.zzjhx);
        Long l = null;
        if (zzcit2.zzjhy != null && zzcit2.zzjhy.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzayp().zzbau().zzj("Failed to insert/update event aggregates (got -1). appId", zzcjj.zzjs(zzcit2.zzcm));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzayp().zzbau().zze("Error storing event aggregates. appId", zzcjj.zzjs(zzcit2.zzcm), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzaf(String string, String string2) {
        zzbq.zzgv((String)string);
        zzbq.zzgv((String)string2);
        this.zzwj();
        this.zzyk();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzayp().zzbba().zzj("Deleted user attribute rows", n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzayp().zzbau().zzd("Error deleting user attribute. appId", zzcjj.zzjs(string), this.zzayk().zzjr(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzcnn zzcnn2) {
        zzbq.checkNotNull((Object)zzcnn2);
        this.zzwj();
        this.zzyk();
        if (this.zzag(zzcnn2.zzcm, zzcnn2.name) == null && (zzcno.zzkh(zzcnn2.name) ? this.zzc("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzcnn2.zzcm}) >= 25L : this.zzc("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzcnn2.zzcm, zzcnn2.zzjgm}) >= 25L)) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcnn2.zzcm);
        contentValues.put("origin", zzcnn2.zzjgm);
        contentValues.put("name", zzcnn2.name);
        contentValues.put("set_timestamp", Long.valueOf(zzcnn2.zzjsi));
        zzcil.zza(contentValues, "value", zzcnn2.value);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzayp().zzbau().zzj("Failed to insert/update user property (got -1). appId", zzcjj.zzjs(zzcnn2.zzcm));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzayp().zzbau().zze("Error storing user property. appId", zzcjj.zzjs(zzcnn2.zzcm), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzcnn zzag(String string, String string2) {
        zzbq.zzgv((String)string);
        zzbq.zzgv((String)string2);
        this.zzwj();
        this.zzyk();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzcnn zzcnn2 = new zzcnn(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzayp().zzbau().zzj("Got multiple records for user property, expected one. appId", zzcjj.zzjs(string));
            }
            zzcnn zzcnn3 = zzcnn2;
            return zzcnn3;
        }
    }

    @WorkerThread
    public final List<zzcnn> zzji(String string) {
        zzbq.zzgv((String)string);
        this.zzwj();
        this.zzyk();
        ArrayList<zzcnn> arrayList = new ArrayList<zzcnn>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcnn> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzayp().zzbau().zzj("Read invalid user property value, ignoring it. appId", zzcjj.zzjs(string));
                    continue;
                }
                zzcnn zzcnn2 = new zzcnn(string, string2, (String)object, l, object2);
                arrayList.add(zzcnn2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzcnn> zzh(String string, String string2, String string3) {
        zzbq.zzgv((String)string);
        this.zzwj();
        this.zzyk();
        ArrayList<zzcnn> arrayList = new ArrayList<zzcnn>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, stringBuilder.toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcnn> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzayp().zzbau().zzj("Read more than the max allowed user properties, ignoring excess", 1000);
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzayp().zzbau().zzd("(2)Read invalid user property value, ignoring it", zzcjj.zzjs(string), string2, string3);
                    continue;
                }
                zzcnn zzcnn2 = new zzcnn(string, string2, (String)object, l, object2);
                arrayList.add(zzcnn2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzcii zzcii2) {
        zzbq.checkNotNull((Object)((Object)zzcii2));
        this.zzwj();
        this.zzyk();
        if (this.zzag(zzcii2.packageName, zzcii2.zzjgn.name) == null && this.zzc("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzcii2.packageName}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcii2.packageName);
        contentValues.put("origin", zzcii2.zzjgm);
        contentValues.put("name", zzcii2.zzjgn.name);
        zzcil.zza(contentValues, "value", zzcii2.zzjgn.getValue());
        contentValues.put("active", Boolean.valueOf(zzcii2.zzjgp));
        contentValues.put("trigger_event_name", zzcii2.zzjgq);
        contentValues.put("trigger_timeout", Long.valueOf(zzcii2.zzjgs));
        this.zzayl();
        contentValues.put("timed_out_event", zzcno.zza((Parcelable)zzcii2.zzjgr));
        contentValues.put("creation_timestamp", Long.valueOf(zzcii2.zzjgo));
        this.zzayl();
        contentValues.put("triggered_event", zzcno.zza((Parcelable)zzcii2.zzjgt));
        contentValues.put("triggered_timestamp", Long.valueOf(zzcii2.zzjgn.zzjsi));
        contentValues.put("time_to_live", Long.valueOf(zzcii2.zzjgu));
        this.zzayl();
        contentValues.put("expired_event", zzcno.zza((Parcelable)zzcii2.zzjgv));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzayp().zzbau().zzj("Failed to insert/update conditional user property (got -1)", zzcjj.zzjs(zzcii2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzayp().zzbau().zze("Error storing conditional user property", zzcjj.zzjs(zzcii2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzcii zzah(String string, String string2) {
        zzbq.zzgv((String)string);
        zzbq.zzgv((String)string2);
        this.zzwj();
        this.zzyk();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzcix zzcix2 = this.zzayl().zzb(cursor.getBlob(5), zzcix.CREATOR);
            long l2 = cursor.getLong(6);
            zzcix zzcix3 = this.zzayl().zzb(cursor.getBlob(7), zzcix.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzcix zzcix4 = this.zzayl().zzb(cursor.getBlob(10), zzcix.CREATOR);
            zzcnl zzcnl2 = new zzcnl(string2, l3, object, string3);
            zzcii zzcii2 = new zzcii(string, string3, zzcnl2, l2, bl, string4, zzcix2, l, zzcix3, l4, zzcix4);
            if (cursor.moveToNext()) {
                this.zzayp().zzbau().zze("Got multiple records for conditional property, expected one", zzcjj.zzjs(string), this.zzayk().zzjr(string2));
            }
            zzcii zzcii3 = zzcii2;
            return zzcii3;
        }
    }

    @WorkerThread
    public final int zzai(String string, String string2) {
        zzbq.zzgv((String)string);
        zzbq.zzgv((String)string2);
        this.zzwj();
        this.zzyk();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzayp().zzbau().zzd("Error deleting conditional property", zzcjj.zzjs(string), this.zzayk().zzjr(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzcii> zzi(String string, String string2, String string3) {
        zzbq.zzgv((String)string);
        this.zzwj();
        this.zzyk();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzd(stringBuilder.toString(), stringArray);
    }

    public final List<zzcii> zzd(String string, String[] stringArray) {
        this.zzwj();
        this.zzyk();
        ArrayList<zzcii> arrayList = new ArrayList<zzcii>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcii> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzayp().zzbau().zzj("Read more than the max allowed conditional properties, ignoring extra", 1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzcix zzcix2 = this.zzayl().zzb(cursor.getBlob(7), zzcix.CREATOR);
                long l2 = cursor.getLong(8);
                zzcix zzcix3 = this.zzayl().zzb(cursor.getBlob(9), zzcix.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzcix zzcix4 = this.zzayl().zzb(cursor.getBlob(12), zzcix.CREATOR);
                zzcnl zzcnl2 = new zzcnl(string3, l3, object2, string2);
                zzcii zzcii2 = new zzcii((String)object, string2, zzcnl2, l2, bl, string4, zzcix2, l, zzcix3, l4, zzcix4);
                arrayList.add(zzcii2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzcie zzjj(String string) {
        zzbq.zzgv((String)string);
        this.zzwj();
        this.zzyk();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzcie zzcie2 = new zzcie(this.zzjev, string);
            zzcie2.zziy(cursor.getString(0));
            zzcie2.zziz(cursor.getString(1));
            zzcie2.zzja(cursor.getString(2));
            zzcie2.zzaq(cursor.getLong(3));
            zzcie2.zzal(cursor.getLong(4));
            zzcie2.zzam(cursor.getLong(5));
            zzcie2.setAppVersion(cursor.getString(6));
            zzcie2.zzjc(cursor.getString(7));
            zzcie2.zzao(cursor.getLong(8));
            zzcie2.zzap(cursor.getLong(9));
            zzcie2.setMeasurementEnabled(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzcie2.zzat(cursor.getLong(11));
            zzcie2.zzau(cursor.getLong(12));
            zzcie2.zzav(cursor.getLong(13));
            zzcie2.zzaw(cursor.getLong(14));
            zzcie2.zzar(cursor.getLong(15));
            zzcie2.zzas(cursor.getLong(16));
            zzcie2.zzan(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzcie2.zzjb(cursor.getString(18));
            zzcie2.zzay(cursor.getLong(19));
            zzcie2.zzax(cursor.getLong(20));
            zzcie2.zzjd(cursor.getString(21));
            zzcie2.zzaz(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzcie2.zzbq(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzcie2.zzays();
            if (cursor.moveToNext()) {
                this.zzayp().zzbau().zzj("Got multiple records for app, expected one. appId", zzcjj.zzjs(string));
            }
            zzcie zzcie3 = zzcie2;
            return zzcie3;
        }
    }

    @WorkerThread
    public final void zza(zzcie zzcie2) {
        zzbq.checkNotNull((Object)zzcie2);
        this.zzwj();
        this.zzyk();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcie2.getAppId());
        contentValues.put("app_instance_id", zzcie2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzcie2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzcie2.zzayt());
        contentValues.put("last_bundle_index", Long.valueOf(zzcie2.zzazc()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzcie2.zzayv()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzcie2.zzayw()));
        contentValues.put("app_version", zzcie2.zzwo());
        contentValues.put("app_store", zzcie2.zzayy());
        contentValues.put("gmp_version", Long.valueOf(zzcie2.zzayz()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzcie2.zzaza()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzcie2.zzazb()));
        contentValues.put("day", Long.valueOf(zzcie2.zzazg()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzcie2.zzazh()));
        contentValues.put("daily_events_count", Long.valueOf(zzcie2.zzazi()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzcie2.zzazj()));
        contentValues.put("config_fetched_time", Long.valueOf(zzcie2.zzazd()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzcie2.zzaze()));
        contentValues.put("app_version_int", Long.valueOf(zzcie2.zzayx()));
        contentValues.put("firebase_instance_id", zzcie2.zzayu());
        contentValues.put("daily_error_events_count", Long.valueOf(zzcie2.zzazl()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzcie2.zzazk()));
        contentValues.put("health_monitor_sample", zzcie2.zzazm());
        contentValues.put("android_id", Long.valueOf(zzcie2.zzazo()));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzcie2.zzazp()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzcie2.getAppId()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzayp().zzbau().zzj("Failed to insert/update app (got -1). appId", zzcjj.zzjs(zzcie2.getAppId()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzayp().zzbau().zze("Error storing app. appId", zzcjj.zzjs(zzcie2.getAppId()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzjk(String string) {
        zzbq.zzgv((String)string);
        this.zzwj();
        this.zzyk();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzayr().zzb(string2, zzciz.zzjjc);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzayp().zzbau().zze("Error deleting over the limit events. appId", zzcjj.zzjs(string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzcim zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        zzbq.zzgv((String)string);
        this.zzwj();
        this.zzyk();
        String[] stringArray = new String[]{string};
        zzcim zzcim2 = new zzcim();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzayp().zzbaw().zzj("Not updating daily counts, app is not known. appId", zzcjj.zzjs(string));
                zzcim zzcim3 = zzcim2;
                return zzcim3;
            }
            if (cursor.getLong(0) == l) {
                zzcim2.zzjhf = cursor.getLong(1);
                zzcim2.zzjhe = cursor.getLong(2);
                zzcim2.zzjhg = cursor.getLong(3);
                zzcim2.zzjhh = cursor.getLong(4);
                zzcim2.zzjhi = cursor.getLong(5);
            }
            if (bl) {
                ++zzcim2.zzjhf;
            }
            if (bl2) {
                ++zzcim2.zzjhe;
            }
            if (bl3) {
                ++zzcim2.zzjhg;
            }
            if (bl4) {
                ++zzcim2.zzjhh;
            }
            if (bl5) {
                ++zzcim2.zzjhi;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzcim2.zzjhe));
            contentValues.put("daily_events_count", Long.valueOf(zzcim2.zzjhf));
            contentValues.put("daily_conversions_count", Long.valueOf(zzcim2.zzjhg));
            contentValues.put("daily_error_events_count", Long.valueOf(zzcim2.zzjhh));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzcim2.zzjhi));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzcim zzcim4 = zzcim2;
            return zzcim4;
        }
    }

    @WorkerThread
    public final byte[] zzjl(String string) {
        zzbq.zzgv((String)string);
        this.zzwj();
        this.zzyk();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzayp().zzbau().zzj("Got multiple records for app config, expected one. appId", zzcjj.zzjs(string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzcoe zzcoe2, boolean bl) {
        byte[] byArray;
        this.zzwj();
        this.zzyk();
        zzbq.checkNotNull((Object)((Object)zzcoe2));
        zzbq.zzgv((String)zzcoe2.zzcm);
        zzbq.checkNotNull((Object)zzcoe2.zzjuu);
        this.zzazy();
        long l = this.zzxx().currentTimeMillis();
        if (zzcoe2.zzjuu < l - zzcik.zzazs() || zzcoe2.zzjuu > l + zzcik.zzazs()) {
            this.zzayp().zzbaw().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzcjj.zzjs(zzcoe2.zzcm), l, zzcoe2.zzjuu);
        }
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = new byte[zzcoe2.zzhs()];
            zzflk zzflk2 = zzflk.zzp((byte[])byArray2, (int)0, (int)byArray3.length);
            zzcoe2.zza(zzflk2);
            zzflk2.zzcyx();
            byArray = this.zzayl().zzr(byArray2);
        }
        catch (IOException iOException) {
            this.zzayp().zzbau().zze("Data loss. Failed to serialize bundle. appId", zzcjj.zzjs(zzcoe2.zzcm), iOException);
            return false;
        }
        this.zzayp().zzbba().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcoe2.zzcm);
        contentValues.put("bundle_end_timestamp", zzcoe2.zzjuu);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzayp().zzbau().zzj("Failed to insert bundle (got -1). appId", zzcjj.zzjs(zzcoe2.zzcm));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzayp().zzbau().zze("Error storing bundle. appId", zzcjj.zzjs(zzcoe2.zzcm), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final String zzazw() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public final boolean zzazx() {
        return this.zzc("select count(1) > 0 from queue where has_realtime = 1", null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzcoe, Long>> zzl(String string, int n, int n2) {
        this.zzwj();
        this.zzyk();
        zzbq.checkArgument((n > 0 ? 1 : 0) != 0);
        zzbq.checkArgument((n2 > 0 ? 1 : 0) != 0);
        zzbq.zzgv((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzcoe, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzcoe, Long>> arrayList = new ArrayList<Pair<zzcoe, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzayl().zzs((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzayp().zzbau().zze("Failed to unzip queued bundle. appId", zzcjj.zzjs(string), iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                byte[] byArray2 = byArray;
                object = zzflj.zzo((byte[])byArray, (int)0, (int)byArray2.length);
                zzcoe zzcoe2 = new zzcoe();
                try {
                    zzcoe2.zza((zzflj)object);
                }
                catch (IOException iOException) {
                    this.zzayp().zzbau().zze("Failed to merge queued bundle. appId", zzcjj.zzjs(string), iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzcoe, Long>)Pair.create((Object)((Object)zzcoe2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzcoe, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzazy() {
        this.zzwj();
        this.zzyk();
        if (!this.zzbae()) {
            return;
        }
        long l = this.zzayq().zzjlq.get();
        long l2 = this.zzxx().elapsedRealtime();
        if (Math.abs(l2 - l) > zzciz.zzjjl.get()) {
            this.zzayq().zzjlq.set(l2);
            zzcil zzcil2 = this;
            zzcil2.zzwj();
            zzcil2.zzyk();
            if (zzcil2.zzbae()) {
                SQLiteDatabase sQLiteDatabase = zzcil2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzcil2.zzxx().currentTimeMillis()), String.valueOf(zzcik.zzazs())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzcil2.zzayp().zzbba().zzj("Deleted stale rows. rowsDeleted", n);
                }
            }
        }
    }

    @WorkerThread
    final void zza(String string, zzcnr[] zzcnrArray) {
        this.zzyk();
        this.zzwj();
        zzbq.zzgv((String)string);
        zzbq.checkNotNull((Object)zzcnrArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzcil zzcil2 = this;
            zzcil2.zzyk();
            zzcil2.zzwj();
            zzbq.zzgv((String)string2);
            Object object = zzcil2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzcnrArray;
            int n2 = zzcnrArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzcns zzcns2;
                int n3;
                int n4;
                zzcnr zzcnr2 = object2[n];
                object = zzcnr2;
                string2 = string;
                zzcil2 = this;
                zzcil2.zzyk();
                zzcil2.zzwj();
                zzbq.zzgv((String)string2);
                zzbq.checkNotNull((Object)object);
                zzbq.checkNotNull((Object)object.zzjsv);
                zzbq.checkNotNull((Object)object.zzjsu);
                if (object.zzjst == null) {
                    zzcil2.zzayp().zzbaw().zzj("Audience with no ID. appId", zzcjj.zzjs(string2));
                    continue;
                }
                int n5 = object.zzjst;
                zzflm[] zzflmArray = object.zzjsv;
                int n6 = object.zzjsv.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzflmArray[n4].zzjsx != null) continue;
                    zzcil2.zzayp().zzbaw().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzcjj.zzjs(string2), object.zzjst);
                    continue block3;
                }
                zzflmArray = object.zzjsu;
                n6 = object.zzjsu.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzflmArray[n4].zzjsx != null) continue;
                    zzcil2.zzayp().zzbaw().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzcjj.zzjs(string2), object.zzjst);
                    continue block3;
                }
                boolean bl = true;
                zzflm[] zzflmArray2 = object.zzjsv;
                n4 = object.zzjsv.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzcns2 = zzflmArray2[n3];
                    if (zzcil2.zza(string2, n5, zzcns2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    zzflmArray2 = object.zzjsu;
                    n4 = object.zzjsu.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzcns2 = zzflmArray2[n3];
                        if (zzcil2.zza(string2, n5, (zzcnv)((Object)zzcns2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzcil zzcil3 = zzcil2;
                zzcil3.zzyk();
                zzcil3.zzwj();
                zzbq.zzgv((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzcil3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzcnr[] zzcnrArray2 = zzcnrArray;
            n = zzcnrArray.length;
            for (int i = 0; i < n; ++i) {
                zzcnr zzcnr3 = zzcnrArray2[i];
                object2.add(zzcnr3.zzjst);
            }
            this.zze(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzcns zzcns2) {
        byte[] byArray;
        this.zzyk();
        this.zzwj();
        zzbq.zzgv((String)string);
        zzbq.checkNotNull((Object)((Object)zzcns2));
        if (TextUtils.isEmpty((CharSequence)zzcns2.zzjsy)) {
            this.zzayp().zzbaw().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzcjj.zzjs(string), n, String.valueOf(zzcns2.zzjsx));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzcns2.zzhs()];
            zzflk zzflk2 = zzflk.zzp((byte[])byArray, (int)0, (int)byArray2.length);
            zzcns2.zza(zzflk2);
            zzflk2.zzcyx();
        }
        catch (IOException iOException) {
            this.zzayp().zzbau().zze("Configuration loss. Failed to serialize event filter. appId", zzcjj.zzjs(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzcns2.zzjsx);
        contentValues.put("event_name", zzcns2.zzjsy);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzayp().zzbau().zzj("Failed to insert event filter (got -1). appId", zzcjj.zzjs(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzayp().zzbau().zze("Error storing event filter. appId", zzcjj.zzjs(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzcnv zzcnv2) {
        byte[] byArray;
        this.zzyk();
        this.zzwj();
        zzbq.zzgv((String)string);
        zzbq.checkNotNull((Object)((Object)zzcnv2));
        if (TextUtils.isEmpty((CharSequence)zzcnv2.zzjtn)) {
            this.zzayp().zzbaw().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzcjj.zzjs(string), n, String.valueOf(zzcnv2.zzjsx));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzcnv2.zzhs()];
            zzflk zzflk2 = zzflk.zzp((byte[])byArray, (int)0, (int)byArray2.length);
            zzcnv2.zza(zzflk2);
            zzflk2.zzcyx();
        }
        catch (IOException iOException) {
            this.zzayp().zzbau().zze("Configuration loss. Failed to serialize property filter. appId", zzcjj.zzjs(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzcnv2.zzjsx);
        contentValues.put("property_name", zzcnv2.zzjtn);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzayp().zzbau().zzj("Failed to insert property filter (got -1). appId", zzcjj.zzjs(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzayp().zzbau().zze("Error storing property filter. appId", zzcjj.zzjs(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzcns>> zzaj(String string, String string2) {
        this.zzyk();
        this.zzwj();
        zzbq.zzgv((String)string);
        zzbq.zzgv((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzcns>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzflj zzflj2 = zzflj.zzo((byte[])byArray, (int)0, (int)byArray.length);
                zzcns zzcns2 = new zzcns();
                try {
                    zzcns2.zza(zzflj2);
                }
                catch (IOException iOException) {
                    this.zzayp().zzbau().zze("Failed to merge filter. appId", zzcjj.zzjs(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzcns> arrayList = (ArrayList<zzcns>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzcns>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzcns2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzcnv>> zzak(String string, String string2) {
        this.zzyk();
        this.zzwj();
        zzbq.zzgv((String)string);
        zzbq.zzgv((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzcnv>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzflj zzflj2 = zzflj.zzo((byte[])byArray, (int)0, (int)byArray.length);
                zzcnv zzcnv2 = new zzcnv();
                try {
                    zzcnv2.zza(zzflj2);
                }
                catch (IOException iOException) {
                    this.zzayp().zzbau().zze("Failed to merge filter", zzcjj.zzjs(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzcnv> arrayList = (ArrayList<zzcnv>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzcnv>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzcnv2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zze(String string, List<Integer> list) {
        Object object;
        long l;
        zzbq.zzgv((String)string);
        this.zzyk();
        this.zzwj();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zzc("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzayp().zzbau().zze("Database error querying filters. appId", zzcjj.zzjs(string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzayr().zzb(string2, zzciz.zzjjs);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzcof> zzjm(String string) {
        this.zzyk();
        this.zzwj();
        zzbq.zzgv((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzflj zzflj2 = zzflj.zzo((byte[])byArray, (int)0, (int)byArray.length);
                zzcof zzcof2 = new zzcof();
                try {
                    zzcof2.zza(zzflj2);
                }
                catch (IOException iOException) {
                    this.zzayp().zzbau().zzd("Failed to merge filter results. appId, audienceId, error", zzcjj.zzjs(string), n, iOException);
                    continue;
                }
                arrayMap.put(n, zzcof2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        zzbq.zzgv((String)string);
        zzbq.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzayp().zzbau().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzayp().zzbau().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzayp().zzbau().zzj("Loaded invalid unknown value type, ignoring it", n3);
        return null;
    }

    @WorkerThread
    public final long zzazz() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    protected final long zzal(String string, String string2) {
        zzbq.zzgv((String)string);
        zzbq.zzgv((String)string2);
        this.zzwj();
        this.zzyk();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzayp().zzbau().zze("Failed to insert column (got -1). appId", zzcjj.zzjs(string), string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzayp().zzbau().zze("Failed to update column (got 0). appId", zzcjj.zzjs(string), string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzayp().zzbau().zzd("Error inserting column. appId", zzcjj.zzjs(string), string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzbaa() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzcoe zzcoe2) throws IOException {
        long l;
        Object object;
        byte[] byArray;
        this.zzwj();
        this.zzyk();
        zzbq.checkNotNull((Object)((Object)zzcoe2));
        zzbq.zzgv((String)zzcoe2.zzcm);
        try {
            byArray = new byte[zzcoe2.zzhs()];
            object = byArray;
            zzflk zzflk2 = zzflk.zzp((byte[])byArray, (int)0, (int)((byte[])object).length);
            zzcoe2.zza(zzflk2);
            zzflk2.zzcyx();
        }
        catch (IOException iOException) {
            this.zzayp().zzbau().zze("Data loss. Failed to serialize event metadata. appId", zzcjj.zzjs(zzcoe2.zzcm), iOException);
            throw iOException;
        }
        byte[] byArray2 = byArray;
        object = this.zzayl();
        zzbq.checkNotNull((Object)byArray2);
        ((zzclh)object).zzwj();
        MessageDigest messageDigest = zzcno.zzeq("MD5");
        if (messageDigest == null) {
            ((zzclh)object).zzayp().zzbau().log("Failed to get MD5");
            l = 0L;
        } else {
            l = zzcno.zzt(messageDigest.digest(byArray2));
        }
        long l2 = l;
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcoe2.zzcm);
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzayp().zzbau().zze("Error storing raw event metadata. appId", zzcjj.zzjs(zzcoe2.zzcm), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l2;
    }

    public final boolean zzbab() {
        return this.zzc("select count(1) > 0 from raw_events", null) != 0L;
    }

    public final boolean zzbac() {
        return this.zzc("select count(1) > 0 from raw_events where realtime = 1", null) != 0L;
    }

    public final void zzai(List<Long> list) {
        zzbq.checkNotNull(list);
        this.zzwj();
        this.zzyk();
        StringBuilder stringBuilder = new StringBuilder("rowid in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i));
        }
        stringBuilder.append(")");
        int n = this.getWritableDatabase().delete("raw_events", stringBuilder.toString(), null);
        if (n != list.size()) {
            this.zzayp().zzbau().zze("Deleted fewer rows from raw events table than expected", n, list.size());
        }
    }

    public final long zzjn(String string) {
        zzbq.zzgv((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzba(long l) {
        this.zzwj();
        this.zzyk();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzayp().zzbba().log("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzbad() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final Pair<zzcob, Long> zzb(String string, Long l) {
        this.zzwj();
        this.zzyk();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select main_event, children_to_process from main_event_params where app_id=? and event_id=?", new String[]{string, String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzayp().zzbba().log("Main event not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            Long l2 = cursor.getLong(1);
            byte[] byArray2 = byArray;
            zzflj zzflj2 = zzflj.zzo((byte[])byArray, (int)0, (int)byArray2.length);
            zzcob zzcob2 = new zzcob();
            try {
                zzcob2.zza(zzflj2);
            }
            catch (IOException iOException) {
                this.zzayp().zzbau().zzd("Failed to merge main event. appId, eventId", zzcjj.zzjs(string), l, iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            Pair pair = Pair.create((Object)((Object)zzcob2), (Object)l2);
            return pair;
        }
        return null;
    }

    public final boolean zza(String string, Long l, long l2, zzcob zzcob2) {
        byte[] byArray;
        this.zzwj();
        this.zzyk();
        zzbq.checkNotNull((Object)((Object)zzcob2));
        zzbq.zzgv((String)string);
        zzbq.checkNotNull((Object)l);
        try {
            byte[] byArray2 = byArray = new byte[zzcob2.zzhs()];
            zzflk zzflk2 = zzflk.zzp((byte[])byArray, (int)0, (int)byArray2.length);
            zzcob2.zza(zzflk2);
            zzflk2.zzcyx();
        }
        catch (IOException iOException) {
            this.zzayp().zzbau().zzd("Data loss. Failed to serialize event params/data. appId, eventId", zzcjj.zzjs(string), l, iOException);
            return false;
        }
        this.zzayp().zzbba().zze("Saving complex main event, appId, data size", this.zzayk().zzjp(string), byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("event_id", l);
        contentValues.put("children_to_process", Long.valueOf(l2));
        contentValues.put("main_event", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1L) {
                this.zzayp().zzbau().zzj("Failed to insert complex main event (got -1). appId", zzcjj.zzjs(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzayp().zzbau().zze("Error storing complex main event. appId", zzcjj.zzjs(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(zzcis zzcis2, long l, boolean bl) {
        Object object;
        zzcoc zzcoc2;
        String string2;
        this.zzwj();
        this.zzyk();
        zzbq.checkNotNull((Object)zzcis2);
        zzbq.zzgv((String)zzcis2.zzcm);
        zzcob zzcob2 = new zzcob();
        new zzcob().zzjuk = zzcis2.zzjhq;
        zzcob2.zzjui = new zzcoc[zzcis2.zzjhr.size()];
        int n = 0;
        for (String string2 : zzcis2.zzjhr) {
            zzcoc2 = new zzcoc();
            zzcob2.zzjui[n++] = zzcoc2;
            zzcoc2.name = string2;
            Object object2 = zzcis2.zzjhr.get(string2);
            this.zzayl().zza(zzcoc2, object2);
        }
        try {
            byte[] byArray = new byte[zzcob2.zzhs()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzcoc2 = zzflk.zzp((byte[])byArray, (int)0, (int)byArray2.length);
            zzcob2.zza((zzflk)zzcoc2);
            zzcoc2.zzcyx();
        }
        catch (IOException iOException) {
            this.zzayp().zzbau().zze("Data loss. Failed to serialize event params/data. appId", zzcjj.zzjs(zzcis2.zzcm), iOException);
            return false;
        }
        this.zzayp().zzbba().zze("Saving event, name, data size", this.zzayk().zzjp(zzcis2.name), ((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzcis2.zzcm);
        string2.put("name", zzcis2.name);
        string2.put("timestamp", Long.valueOf(zzcis2.timestamp));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzayp().zzbau().zzj("Failed to insert raw event (got -1). appId", zzcjj.zzjs(zzcis2.zzcm));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzayp().zzbau().zze("Error storing raw event. appId", zzcjj.zzjs(zzcis2.zzcm), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzbae() {
        return this.getContext().getDatabasePath("google_app_measurement.db").exists();
    }

    @WorkerThread
    private static boolean zza(zzcjj zzcjj2, SQLiteDatabase sQLiteDatabase, String string) {
        if (zzcjj2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
            boolean bl = cursor.moveToFirst();
            return bl;
        }
    }

    @WorkerThread
    private static Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
        try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
            Collections.addAll(hashSet, cursor.getColumnNames());
        }
        return hashSet;
    }

    @WorkerThread
    private static void zza(zzcjj zzcjj2, SQLiteDatabase sQLiteDatabase, String string, String string2, String[] stringArray) throws SQLiteException {
        if (zzcjj2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        Set<String> set = zzcil.zzb(sQLiteDatabase, string);
        for (String string3 : string2.split(",")) {
            if (set.remove(string3)) continue;
            throw new SQLiteException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Table ").append(string).append(" is missing required column: ").append(string3).toString());
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                if (set.remove(stringArray[i])) continue;
                sQLiteDatabase.execSQL(stringArray[i + 1]);
            }
        }
        if (!set.isEmpty()) {
            zzcjj2.zzbaw().zze("Table has extra columns. table, columns", string, TextUtils.join((CharSequence)", ", set));
        }
    }

    @WorkerThread
    static void zza(zzcjj zzcjj2, SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, String[] stringArray) throws SQLiteException {
        if (zzcjj2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (!zzcil.zza(zzcjj2, sQLiteDatabase, string)) {
            sQLiteDatabase.execSQL(string2);
        }
        try {
            zzcil.zza(zzcjj2, sQLiteDatabase, string, string3, stringArray);
            return;
        }
        catch (SQLiteException sQLiteException) {
            zzcjj2.zzbau().zzj("Failed to verify columns on table that was just created", string);
            throw sQLiteException;
        }
    }

    static void zza(zzcjj zzcjj2, SQLiteDatabase sQLiteDatabase) {
        if (zzcjj2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        File file = new File(sQLiteDatabase.getPath());
        if (!file.setReadable(false, false)) {
            zzcjj2.zzbaw().log("Failed to turn off database read permission");
        }
        if (!file.setWritable(false, false)) {
            zzcjj2.zzbaw().log("Failed to turn off database write permission");
        }
        if (!file.setReadable(true, true)) {
            zzcjj2.zzbaw().log("Failed to turn on database read permission for owner");
        }
        if (!file.setWritable(true, true)) {
            zzcjj2.zzbaw().log("Failed to turn on database write permission for owner");
        }
    }

    static /* synthetic */ zzcni zza(zzcil zzcil2) {
        return zzcil2.zzjhd;
    }

    static /* synthetic */ String[] zzbaf() {
        return zzjgw;
    }

    static /* synthetic */ String[] zzbag() {
        return zzjgx;
    }

    static /* synthetic */ String[] zzbah() {
        return zzjgy;
    }

    static /* synthetic */ String[] zzbai() {
        return zzjha;
    }

    static /* synthetic */ String[] zzbaj() {
        return zzjgz;
    }

    static /* synthetic */ String[] zzbak() {
        return zzjhb;
    }
}

