/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzcko;
import com.google.android.gms.internal.zzcmz;
import com.google.android.gms.internal.zzcna;
import com.google.android.gms.internal.zzcnb;
import com.google.android.gms.internal.zzcnc;
import com.google.android.gms.internal.zzcno;

public final class zzcmy<T extends Context> {
    private final T zzjru;

    public zzcmy(T t) {
        zzbq.checkNotNull(t);
        this.zzjru = t;
    }

    public static boolean zzg(Context context, boolean bl) {
        zzbq.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzcno.zzp(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzcno.zzp(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    @MainThread
    public final void onCreate() {
        zzckj.zzed(this.zzjru).zzayp().zzbba().log("Local AppMeasurementService is starting up");
    }

    @MainThread
    public final void onDestroy() {
        zzckj.zzed(this.zzjru).zzayp().zzbba().log("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public final int onStartCommand(Intent intent, int n, int n2) {
        zzcjj zzcjj2 = zzckj.zzed(this.zzjru).zzayp();
        if (intent == null) {
            zzcjj2.zzbaw().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzcjj2.zzbba().zze("Local AppMeasurementService called. startId, action", n2, string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zzl(new zzcmz(this, n2, zzcjj2, intent));
        }
        return 2;
    }

    private final void zzl(Runnable runnable) {
        zzckj zzckj2 = zzckj.zzed(this.zzjru);
        zzckj2.zzayp();
        zzckj2.zzayo().zzh(new zzcnb(this, zzckj2, runnable));
    }

    @MainThread
    public final IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzayp().zzbau().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzcko(zzckj.zzed(this.zzjru));
        }
        this.zzayp().zzbaw().zzj("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public final boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzayp().zzbau().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzayp().zzbba().zzj("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzcjj zzcjj2 = zzckj.zzed(this.zzjru).zzayp();
        String string = jobParameters.getExtras().getString("action");
        zzcjj2.zzbba().zzj("Local AppMeasurementJobService called. action", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zzl(new zzcna(this, zzcjj2, jobParameters));
        }
        return true;
    }

    @MainThread
    public final void onRebind(Intent intent) {
        if (intent == null) {
            this.zzayp().zzbau().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzayp().zzbba().zzj("onRebind called. action", string);
    }

    private final zzcjj zzayp() {
        return zzckj.zzed(this.zzjru).zzayp();
    }

    final /* synthetic */ void zza(zzcjj zzcjj2, JobParameters jobParameters) {
        zzcjj2.zzbba().log("AppMeasurementJobService processed last upload request.");
        ((zzcnc)this.zzjru).zza(jobParameters, false);
    }

    final /* synthetic */ void zza(int n, zzcjj zzcjj2, Intent intent) {
        if (((zzcnc)this.zzjru).callServiceStopSelfResult(n)) {
            zzcjj2.zzbba().zzj("Local AppMeasurementService processed last upload request. StartId", n);
            this.zzayp().zzbba().log("Completed wakeful intent.");
            ((zzcnc)this.zzjru).zzl(intent);
        }
    }
}

