/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgn;
import com.google.android.gms.internal.zzbih;
import com.google.android.gms.internal.zzcif;
import com.google.android.gms.internal.zzciu;
import com.google.android.gms.internal.zzcix;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import com.google.android.gms.internal.zzcob;
import com.google.android.gms.internal.zzcoc;
import com.google.android.gms.internal.zzcod;
import com.google.android.gms.internal.zzcog;
import com.google.android.gms.internal.zzflk;
import com.google.android.gms.measurement.AppMeasurement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.security.auth.x500.X500Principal;

public final class zzcno
extends zzcli {
    private static String[] zzjsm = new String[]{"firebase_"};
    private SecureRandom zzjsn;
    private final AtomicLong zzjso = new AtomicLong(0L);
    private int zzjsp;

    zzcno(zzckj zzckj2) {
        super(zzckj2);
    }

    @Override
    protected final boolean zzazq() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void zzbap() {
        ((zzclh)this).zzwj();
        SecureRandom secureRandom = new SecureRandom();
        long l = secureRandom.nextLong();
        if (l == 0L && (l = secureRandom.nextLong()) == 0L) {
            ((zzclh)this).zzayp().zzbaw().log("Utils falling back to Random for random id");
        }
        this.zzjso.set(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long zzbcq() {
        if (this.zzjso.get() == 0L) {
            AtomicLong atomicLong = this.zzjso;
            synchronized (atomicLong) {
                return new Random(System.nanoTime() ^ ((zzclh)this).zzxx().currentTimeMillis()).nextLong() + (long)(++this.zzjsp);
            }
        }
        AtomicLong atomicLong = this.zzjso;
        synchronized (atomicLong) {
            this.zzjso.compareAndSet(-1L, 1L);
            return this.zzjso.getAndIncrement();
        }
    }

    @WorkerThread
    final SecureRandom zzbcr() {
        ((zzclh)this).zzwj();
        if (this.zzjsn == null) {
            this.zzjsn = new SecureRandom();
        }
        return this.zzjsn;
    }

    static boolean zzkh(String string) {
        zzbq.zzgv((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    public final Bundle zzp(@NonNull Uri uri) {
        if (uri == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            if (uri.isHierarchical()) {
                string = uri.getQueryParameter("utm_campaign");
                string2 = uri.getQueryParameter("utm_source");
                string3 = uri.getQueryParameter("utm_medium");
                string4 = uri.getQueryParameter("gclid");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ((zzclh)this).zzayp().zzbaw().zzj("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
            return null;
        }
        if (!(TextUtils.isEmpty(string) && TextUtils.isEmpty(string2) && TextUtils.isEmpty(string3) && TextUtils.isEmpty(string4))) {
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                bundle.putString("campaign", string);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                bundle.putString("source", string2);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                bundle.putString("medium", string3);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                bundle.putString("gclid", string4);
            }
            if (!TextUtils.isEmpty((CharSequence)(string9 = uri.getQueryParameter("utm_term")))) {
                bundle.putString("term", string9);
            }
            if (!TextUtils.isEmpty((CharSequence)(string8 = uri.getQueryParameter("utm_content")))) {
                bundle.putString("content", string8);
            }
            if (!TextUtils.isEmpty((CharSequence)(string7 = uri.getQueryParameter("aclid")))) {
                bundle.putString("aclid", string7);
            }
            if (!TextUtils.isEmpty((CharSequence)(string6 = uri.getQueryParameter("cp1")))) {
                bundle.putString("cp1", string6);
            }
            if (!TextUtils.isEmpty((CharSequence)(string5 = uri.getQueryParameter("anid")))) {
                bundle.putString("anid", string5);
            }
            return bundle;
        }
        return null;
    }

    public static boolean zzn(Intent intent) {
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        return "android-app://com.google.android.googlequicksearchbox/https/www.google.com".equals(string) || "https://www.google.com".equals(string) || "android-app://com.google.appcrawler".equals(string);
    }

    final boolean zzaq(String string, String string2) {
        int n;
        if (string2 == null) {
            ((zzclh)this).zzayp().zzbau().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            ((zzclh)this).zzayp().zzbau().zzj("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            ((zzclh)this).zzayp().zzbau().zze("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            ((zzclh)this).zzayp().zzbau().zze("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    private final boolean zzar(String string, String string2) {
        int n;
        if (string2 == null) {
            ((zzclh)this).zzayp().zzbau().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            ((zzclh)this).zzayp().zzbau().zzj("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2) && n2 != 95) {
            ((zzclh)this).zzayp().zzbau().zze("Name must start with a letter or _ (underscore). Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            ((zzclh)this).zzayp().zzbau().zze("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zza(String string, String[] stringArray, String string2) {
        boolean bl;
        String string3;
        block6: {
            if (string2 == null) {
                ((zzclh)this).zzayp().zzbau().zzj("Name is required and can't be null. Type", string);
                return false;
            }
            string3 = string2;
            zzbq.checkNotNull((Object)string3);
            for (int i = 0; i < zzjsm.length; ++i) {
                if (!string3.startsWith(zzjsm[i])) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            ((zzclh)this).zzayp().zzbau().zze("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null) {
            boolean bl2;
            block7: {
                String[] stringArray2 = stringArray;
                string3 = string2;
                zzbq.checkNotNull((Object)stringArray2);
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!zzcno.zzas(string3, stringArray2[i])) continue;
                    bl2 = true;
                    break block7;
                }
                bl2 = false;
            }
            if (bl2) {
                ((zzclh)this).zzayp().zzbau().zze("Name is reserved. Type, name", string, string2);
                return false;
            }
        }
        return true;
    }

    final boolean zzb(String string, int n, String string2) {
        if (string2 == null) {
            ((zzclh)this).zzayp().zzbau().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.codePointCount(0, string2.length()) > n) {
            ((zzclh)this).zzayp().zzbau().zzd("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    public final int zzki(String string) {
        if (!this.zzar("event", string)) {
            return 2;
        }
        if (!this.zza("event", AppMeasurement.Event.zzjew, string)) {
            return 13;
        }
        if (!this.zzb("event", 40, string)) {
            return 2;
        }
        return 0;
    }

    public final int zzkj(String string) {
        if (!this.zzaq("user property", string)) {
            return 6;
        }
        if (!this.zza("user property", AppMeasurement.UserProperty.zzjfa, string)) {
            return 15;
        }
        if (!this.zzb("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    public final int zzkk(String string) {
        if (!this.zzar("user property", string)) {
            return 6;
        }
        if (!this.zza("user property", AppMeasurement.UserProperty.zzjfa, string)) {
            return 15;
        }
        if (!this.zzb("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    private final int zzkl(String string) {
        if (!this.zzaq("event param", string)) {
            return 3;
        }
        if (!this.zza("event param", null, string)) {
            return 14;
        }
        if (!this.zzb("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    private final int zzkm(String string) {
        if (!this.zzar("event param", string)) {
            return 3;
        }
        if (!this.zza("event param", null, string)) {
            return 14;
        }
        if (!this.zzb("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    private final boolean zza(String string, String string2, int n, Object object, boolean bl) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string3 = String.valueOf(object);
            if (string3.codePointCount(0, string3.length()) > n) {
                ((zzclh)this).zzayp().zzbaw().zzd("Value is too long; discarded. Value kind, name, value length", string, string2, string3.length());
                return false;
            }
            return true;
        }
        if (object instanceof Bundle && bl) {
            return true;
        }
        if (object instanceof Parcelable[] && bl) {
            for (Parcelable parcelable : (Parcelable[])object) {
                if (parcelable instanceof Bundle) continue;
                ((zzclh)this).zzayp().zzbaw().zze("All Parcelable[] elements must be of type Bundle. Value type, name", parcelable.getClass(), string2);
                return false;
            }
            return true;
        }
        if (object instanceof ArrayList && bl) {
            ArrayList arrayList = (ArrayList)object;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList.get(i);
                Object e2 = e;
                if (e instanceof Bundle) continue;
                ((zzclh)this).zzayp().zzbaw().zze("All ArrayList elements must be of type Bundle. Value type, name", e2.getClass(), string2);
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean zzkn(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            ((zzclh)this).zzayp().zzbau().log("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
            return false;
        }
        String string2 = string;
        zzbq.checkNotNull((Object)string2);
        String string3 = "^1:\\d+:android:[a-f0-9]+$";
        if (!string2.matches(string3)) {
            ((zzclh)this).zzayp().zzbau().zzj("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", string);
            return false;
        }
        return true;
    }

    private static Object zza(int n, Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long || object instanceof Double) {
            return object;
        }
        if (object instanceof Integer) {
            return (long)((Integer)object).intValue();
        }
        if (object instanceof Byte) {
            return (long)((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return (long)((Short)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            return zzcno.zza(String.valueOf(object), n, bl);
        }
        return null;
    }

    public static String zza(String string, int n, boolean bl) {
        if (string.codePointCount(0, string.length()) > n) {
            if (bl) {
                return String.valueOf(string.substring(0, string.offsetByCodePoints(0, n))).concat("...");
            }
            return null;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private final int zza(String var1_1, Object var2_2, boolean var3_3) {
        block6: {
            block7: {
                if (!var3_3) break block6;
                var8_4 = var2_2;
                var7_5 = var1_1;
                var6_6 = "param";
                var5_7 = this;
                if (!(var8_4 instanceof Parcelable[])) break block7;
                var9_8 = ((Parcelable[])var8_4).length;
                ** GOTO lbl14
            }
            if (!(var8_4 instanceof ArrayList)) {
                v0 = true;
            } else {
                var9_8 = ((ArrayList)var8_4).size();
lbl14:
                // 2 sources

                if (var9_8 > 1000) {
                    var5_7.zzayp().zzbaw().zzd("Parameter array is too long; discarded. Value kind, name, array length", var6_6, var7_5, var9_8);
                    v0 = false;
                } else {
                    v0 = true;
                }
            }
            if (!v0) {
                return 17;
            }
        }
        if (var4_9 = zzcno.zzkp(var1_1) != false ? this.zza("param", var1_1, 256, var2_2, var3_3) : this.zza("param", var1_1, 100, var2_2, var3_3)) {
            return 0;
        }
        return 4;
    }

    public final Object zzk(String string, Object object) {
        if ("_ev".equals(string)) {
            return zzcno.zza(256, object, true);
        }
        return zzcno.zza(zzcno.zzkp(string) ? 256 : 100, object, false);
    }

    public static Bundle[] zzaf(Object object) {
        if (object instanceof Bundle) {
            return new Bundle[]{(Bundle)object};
        }
        if (object instanceof Parcelable[]) {
            return (Bundle[])Arrays.copyOf((Parcelable[])object, ((Parcelable[])object).length, Bundle[].class);
        }
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            return arrayList.toArray(new Bundle[arrayList.size()]);
        }
        return null;
    }

    public final Bundle zza(String string, Bundle bundle, @Nullable List<String> list, boolean bl, boolean bl2) {
        Bundle bundle2 = null;
        if (bundle != null) {
            bundle2 = new Bundle(bundle);
            int n = 0;
            for (String string2 : bundle.keySet()) {
                String string3;
                int n2 = 0;
                if (list == null || !list.contains(string2)) {
                    if (bl) {
                        n2 = this.zzkl(string2);
                    }
                    if (n2 == 0) {
                        n2 = this.zzkm(string2);
                    }
                }
                if (n2 != 0) {
                    if (zzcno.zzd(bundle2, n2)) {
                        string3 = zzcno.zza(string2, 40, true);
                        bundle2.putString("_ev", string3);
                        if (n2 == 3) {
                            zzcno.zzb(bundle2, (Object)string2);
                        }
                    }
                    bundle2.remove(string2);
                    continue;
                }
                n2 = this.zza(string2, bundle.get(string2), bl2);
                if (n2 != 0 && !"_ev".equals(string2)) {
                    if (zzcno.zzd(bundle2, n2)) {
                        string3 = zzcno.zza(string2, 40, true);
                        bundle2.putString("_ev", string3);
                        zzcno.zzb(bundle2, bundle.get(string2));
                    }
                    bundle2.remove(string2);
                    continue;
                }
                if (!zzcno.zzkh(string2) || ++n <= 25) continue;
                string3 = new StringBuilder(48).append("Event can't contain more than 25 params").toString();
                ((zzclh)this).zzayp().zzbau().zze(string3, ((zzclh)this).zzayk().zzjp(string), ((zzclh)this).zzayk().zzac(bundle));
                zzcno.zzd(bundle2, 5);
                bundle2.remove(string2);
            }
        }
        return bundle2;
    }

    private static boolean zzd(Bundle bundle, int n) {
        if (bundle.getLong("_err") == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    private static void zzb(Bundle bundle, Object object) {
        zzbq.checkNotNull((Object)bundle);
        if (object != null && (object instanceof String || object instanceof CharSequence)) {
            String string = String.valueOf(object);
            bundle.putLong("_el", (long)string.length());
        }
    }

    private static int zzko(String string) {
        if ("_ldl".equals(string)) {
            return 2048;
        }
        if ("_id".equals(string)) {
            return 256;
        }
        return 36;
    }

    public final int zzl(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zza("user property referrer", string, zzcno.zzko(string), object, false) : this.zza("user property", string, zzcno.zzko(string), object, false);
        if (bl) {
            return 0;
        }
        return 7;
    }

    public final Object zzm(String string, Object object) {
        if ("_ldl".equals(string)) {
            return zzcno.zza(zzcno.zzko(string), object, true);
        }
        return zzcno.zza(zzcno.zzko(string), object, false);
    }

    public final void zza(zzcog zzcog2, Object object) {
        zzbq.checkNotNull((Object)object);
        zzcog2.zzgim = null;
        zzcog2.zzjum = null;
        zzcog2.zzjsl = null;
        if (object instanceof String) {
            zzcog2.zzgim = (String)object;
            return;
        }
        if (object instanceof Long) {
            zzcog2.zzjum = (Long)object;
            return;
        }
        if (object instanceof Double) {
            zzcog2.zzjsl = (Double)object;
            return;
        }
        ((zzclh)this).zzayp().zzbau().zzj("Ignoring invalid (type) user attribute value", object);
    }

    public final void zza(zzcoc zzcoc2, Object object) {
        zzbq.checkNotNull((Object)object);
        zzcoc2.zzgim = null;
        zzcoc2.zzjum = null;
        zzcoc2.zzjsl = null;
        if (object instanceof String) {
            zzcoc2.zzgim = (String)object;
            return;
        }
        if (object instanceof Long) {
            zzcoc2.zzjum = (Long)object;
            return;
        }
        if (object instanceof Double) {
            zzcoc2.zzjsl = (Double)object;
            return;
        }
        ((zzclh)this).zzayp().zzbau().zzj("Ignoring invalid (type) event param value", object);
    }

    public final void zza(Bundle bundle, String string, Object object) {
        if (bundle == null) {
            return;
        }
        if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
            return;
        }
        if (object instanceof String) {
            String string2 = String.valueOf(object);
            bundle.putString(string, string2);
            return;
        }
        if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
            return;
        }
        if (string != null) {
            String string3 = object != null ? object.getClass().getSimpleName() : null;
            ((zzclh)this).zzayp().zzbax().zze("Not putting event parameter. Invalid value type. name, type", ((zzclh)this).zzayk().zzjq(string), string3);
        }
    }

    public final void zza(int n, String string, String string2, int n2) {
        this.zza(null, n, string, string2, n2);
    }

    public final void zza(String string, int n, String string2, String string3, int n2) {
        Bundle bundle = new Bundle();
        zzcno.zzd(bundle, n);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            bundle.putLong("_el", (long)n2);
        }
        this.zzjev.zzayd().zzd("auto", "_err", bundle);
    }

    public final byte[] zzr(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            ((zzclh)this).zzayp().zzbau().zzj("Failed to gzip content", iOException);
            throw iOException;
        }
    }

    public final byte[] zzs(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            ((zzclh)this).zzayp().zzbau().zzj("Failed to ungzip content", iOException);
            throw iOException;
        }
    }

    static MessageDigest zzeq(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string);
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return null;
    }

    static long zzt(byte[] byArray) {
        zzbq.checkNotNull((Object)byArray);
        zzbq.checkState((byArray.length > 0 ? 1 : 0) != 0);
        long l = 0L;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0 && i >= byArray.length - 8; --i) {
            l += ((long)byArray[i] & 0xFFL) << n;
            n += 8;
        }
        return l;
    }

    public final byte[] zzb(zzcod zzcod2) {
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = new byte[zzcod2.zzhs()];
            zzflk zzflk2 = zzflk.zzp((byte[])byArray, (int)0, (int)byArray2.length);
            zzcod2.zza(zzflk2);
            zzflk2.zzcyx();
            return byArray;
        }
        catch (IOException iOException) {
            ((zzclh)this).zzayp().zzbau().zzj("Data loss. Failed to serialize batch", iOException);
            return null;
        }
    }

    public final boolean zzf(long l, long l2) {
        if (l == 0L || l2 <= 0L) {
            return true;
        }
        return Math.abs(((zzclh)this).zzxx().currentTimeMillis() - l) > l2;
    }

    public static boolean zzp(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ServiceInfo serviceInfo = packageManager.getServiceInfo(new ComponentName(context, string), 0);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @WorkerThread
    public final boolean zzeh(String string) {
        ((zzclh)this).zzwj();
        if (zzbih.zzdd((Context)((zzclh)this).getContext()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        ((zzclh)this).zzayp().zzbaz().zzj("Permission not granted", string);
        return false;
    }

    public static boolean zzkp(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    public static boolean zzas(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static long[] zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                int n2 = i;
                lArray[n2] = lArray[n2] | 1L << j;
            }
        }
        return lArray;
    }

    public static boolean zza(long[] lArray, int n) {
        if (n >= lArray.length << 6) {
            return false;
        }
        return (lArray[n / 64] & 1L << n % 64) != 0L;
    }

    public final boolean zzkq(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return ((zzclh)this).zzayr().zzazu().equals(string);
    }

    static boolean zzkr(String string) {
        return string != null && string.matches("(\\+|-)?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    final boolean zzks(String string) {
        return "1".equals(((zzclh)this).zzaym().zzam(string, "measurement.upload.blacklist_internal"));
    }

    final boolean zzkt(String string) {
        return "1".equals(((zzclh)this).zzaym().zzam(string, "measurement.upload.blacklist_public"));
    }

    final Bundle zzad(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zzk(string, bundle.get(string));
                if (object == null) {
                    ((zzclh)this).zzayp().zzbaw().zzj("Param value can't be null", ((zzclh)this).zzayk().zzjq(string));
                    continue;
                }
                this.zza(bundle2, string, object);
            }
        }
        return bundle2;
    }

    public static zzcoc zza(zzcob zzcob2, String string) {
        zzcoc[] zzcocArray = zzcob2.zzjui;
        int n = zzcob2.zzjui.length;
        for (int i = 0; i < n; ++i) {
            zzcoc zzcoc2 = zzcocArray[i];
            if (!zzcoc2.name.equals(string)) continue;
            return zzcoc2;
        }
        return null;
    }

    public static Object zzb(zzcob zzcob2, String string) {
        zzcoc zzcoc2 = zzcno.zza(zzcob2, string);
        if (zzcoc2 != null) {
            if (zzcoc2.zzgim != null) {
                return zzcoc2.zzgim;
            }
            if (zzcoc2.zzjum != null) {
                return zzcoc2.zzjum;
            }
            if (zzcoc2.zzjsl != null) {
                return zzcoc2.zzjsl;
            }
        }
        return null;
    }

    static zzcoc[] zza(zzcoc[] zzcocArray, String string, Object object) {
        zzcoc[] zzcocArray2 = zzcocArray;
        int n = zzcocArray.length;
        for (int i = 0; i < n; ++i) {
            zzcoc zzcoc2 = zzcocArray2[i];
            if (!string.equals(zzcoc2.name)) continue;
            zzcoc2.zzjum = null;
            zzcoc2.zzgim = null;
            zzcoc2.zzjsl = null;
            if (object instanceof Long) {
                zzcoc2.zzjum = (Long)object;
            } else if (object instanceof String) {
                zzcoc2.zzgim = (String)object;
            } else if (object instanceof Double) {
                zzcoc2.zzjsl = (Double)object;
            }
            return zzcocArray;
        }
        zzcocArray2 = new zzcoc[zzcocArray.length + 1];
        System.arraycopy(zzcocArray, 0, zzcocArray2, 0, zzcocArray.length);
        zzcoc zzcoc3 = new zzcoc();
        new zzcoc().name = string;
        if (object instanceof Long) {
            zzcoc3.zzjum = (Long)object;
        } else if (object instanceof String) {
            zzcoc3.zzgim = (String)object;
        } else if (object instanceof Double) {
            zzcoc3.zzjsl = (Double)object;
        }
        zzcocArray2[zzcocArray.length] = zzcoc3;
        return zzcocArray2;
    }

    final zzcix zza(String string, Bundle bundle, String string2, long l, boolean bl, boolean bl2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzki(string) != 0) {
            ((zzclh)this).zzayp().zzbau().zzj("Invalid conditional property event name", ((zzclh)this).zzayk().zzjr(string));
            throw new IllegalArgumentException();
        }
        bundle = bundle != null ? new Bundle(bundle) : new Bundle();
        bundle.putString("_o", string2);
        List<String> list = Collections.singletonList("_o");
        Bundle bundle2 = this.zza(string, bundle, list, false, false);
        Bundle bundle3 = this.zzad(bundle2);
        return new zzcix(string, new zzciu(bundle3), string2, l);
    }

    @WorkerThread
    final long zzab(Context context, String string) {
        ((zzclh)this).zzwj();
        zzbq.checkNotNull((Object)context);
        zzbq.zzgv((String)string);
        long l = 0L;
        PackageManager packageManager = context.getPackageManager();
        MessageDigest messageDigest = zzcno.zzeq("MD5");
        if (messageDigest == null) {
            ((zzclh)this).zzayp().zzbau().log("Could not get MD5 instance");
            l = -1L;
        } else if (packageManager != null) {
            try {
                if (!this.zzac(context, string)) {
                    PackageInfo packageInfo = zzbih.zzdd((Context)context).getPackageInfo(((zzclh)this).getContext().getPackageName(), 64);
                    if (packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                        l = zzcno.zzt(messageDigest.digest(packageInfo.signatures[0].toByteArray()));
                    } else {
                        ((zzclh)this).zzayp().zzbaw().log("Could not get signatures");
                        l = -1L;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzclh)this).zzayp().zzbau().zzj("Package name not found", (Object)nameNotFoundException);
            }
        }
        return l;
    }

    private final boolean zzac(Context context, String string) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        try {
            PackageInfo packageInfo = zzbih.zzdd((Context)context).getPackageInfo(string, 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                return ((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(signature.toByteArray()))).getSubjectX500Principal().equals(x500Principal);
            }
        }
        catch (CertificateException certificateException) {
            ((zzclh)this).zzayp().zzbau().zzj("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzclh)this).zzayp().zzbau().zzj("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }

    @WorkerThread
    static boolean zzd(zzcix zzcix2, zzcif zzcif2) {
        zzbq.checkNotNull((Object)((Object)zzcix2));
        zzbq.checkNotNull((Object)((Object)zzcif2));
        return !TextUtils.isEmpty((CharSequence)zzcif2.zzjfl);
    }

    @WorkerThread
    static boolean zzku(String string) {
        zzbq.zzgv((String)string);
        switch (string) {
            case "_in": 
            case "_ui": 
            case "_ug": {
                return true;
            }
        }
        return false;
    }

    final <T extends Parcelable> T zzb(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (zzbgn zzbgn2) {
            ((zzclh)this).zzayp().zzbau().log("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    static byte[] zza(Parcelable parcelable) {
        if (parcelable == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcelable.writeToParcel(parcel, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            parcel.recycle();
        }
    }

    public static Object zzag(Object object) {
        Object object2;
        if (object == null) {
            return null;
        }
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            object2 = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException exception) {
                return null;
            }
        }
        objectOutputStream.close();
        objectInputStream.close();
        return object2;
    }

    @Nullable
    public static String zza(String string, String[] stringArray, String[] stringArray2) {
        zzbq.checkNotNull((Object)stringArray);
        zzbq.checkNotNull((Object)stringArray2);
        int n = Math.min(stringArray.length, stringArray2.length);
        for (int i = 0; i < n; ++i) {
            if (!zzcno.zzas(string, stringArray[i])) continue;
            return stringArray2[i];
        }
        return null;
    }
}

