/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzig;
import com.google.android.gms.internal.measurement.zzih;
import com.google.android.gms.internal.measurement.zzik;
import java.util.Map;

public final class zzdx
extends zzhj {
    private final Map<String, Long> zzada;
    private final Map<String, Integer> zzadb = new ArrayMap();
    private long zzadc;

    public zzdx(zzgl zzgl2) {
        super(zzgl2);
        this.zzada = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzhj)this).zzgg().zzil().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzhj)this).zzbt().elapsedRealtime();
        ((zzhj)this).zzgf().zzc(new zzdy(this, string, l));
    }

    @WorkerThread
    private final void zza(String string, long l) {
        Integer n;
        ((zzhj)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzadb.isEmpty()) {
            this.zzadc = l;
        }
        if ((n = this.zzadb.get(string)) != null) {
            this.zzadb.put(string, n + 1);
            return;
        }
        if (this.zzadb.size() >= 100) {
            ((zzhj)this).zzgg().zzin().log("Too many ads visible");
            return;
        }
        this.zzadb.put(string, 1);
        this.zzada.put(string, l);
    }

    public final void endAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzhj)this).zzgg().zzil().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzhj)this).zzbt().elapsedRealtime();
        ((zzhj)this).zzgf().zzc(new zzdz(this, string, l));
    }

    @WorkerThread
    private final void zzb(String string, long l) {
        ((zzhj)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        Integer n = this.zzadb.get(string);
        if (n != null) {
            zzik zzik2 = ((zzhj)this).zzfy().zzkk();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzadb.remove(string);
                Long l2 = this.zzada.get(string);
                if (l2 == null) {
                    ((zzhj)this).zzgg().zzil().log("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzada.remove(string);
                    this.zza(string, l3, zzik2);
                }
                if (this.zzadb.isEmpty()) {
                    if (this.zzadc == 0L) {
                        ((zzhj)this).zzgg().zzil().log("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzadc, zzik2);
                    this.zzadc = 0L;
                }
                return;
            }
            this.zzadb.put(string, n2);
            return;
        }
        ((zzhj)this).zzgg().zzil().zzg("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, zzig zzig2) {
        if (zzig2 == null) {
            ((zzhj)this).zzgg().zzir().log("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzhj)this).zzgg().zzir().zzg("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzih.zza(zzig2, bundle, true);
        ((zzhj)this).zzfu().zza("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, zzig zzig2) {
        if (zzig2 == null) {
            ((zzhj)this).zzgg().zzir().log("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzhj)this).zzgg().zzir().zzg("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzih.zza(zzig2, bundle, true);
        ((zzhj)this).zzfu().zza("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzk(long l) {
        zzik zzik2 = ((zzhj)this).zzfy().zzkk();
        for (String string : this.zzada.keySet()) {
            long l2 = this.zzada.get(string);
            this.zza(string, l - l2, zzik2);
        }
        if (!this.zzada.isEmpty()) {
            this.zza(l - this.zzadc, zzik2);
        }
        this.zzl(l);
    }

    @WorkerThread
    private final void zzl(long l) {
        for (String string : this.zzada.keySet()) {
            this.zzada.put(string, l);
        }
        if (!this.zzada.isEmpty()) {
            this.zzadc = l;
        }
    }

    static /* synthetic */ void zza(zzdx zzdx2, String string, long l) {
        zzdx2.zza(string, l);
    }

    static /* synthetic */ void zzb(zzdx zzdx2, String string, long l) {
        zzdx2.zzb(string, l);
    }

    static /* synthetic */ void zza(zzdx zzdx2, long l) {
        zzdx2.zzl(l);
    }
}

