/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhj;
import java.lang.reflect.InvocationTargetException;

public final class zzeh
extends zzhj {
    private Boolean zzxu;

    zzeh(zzgl zzgl2) {
        super(zzgl2);
    }

    @WorkerThread
    public final int zzar(@Size(min=1L) String string) {
        return this.zzb(string, zzew.zzagz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzds() {
        if (this.zzxu == null) {
            zzeh zzeh2 = this;
            synchronized (zzeh2) {
                if (this.zzxu == null) {
                    ApplicationInfo applicationInfo = ((zzhj)this).getContext().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzxu = string2 != null && string2.equals(string);
                    }
                    if (this.zzxu == null) {
                        this.zzxu = Boolean.TRUE;
                        ((zzhj)this).zzgg().zzil().log("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzxu;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzex<Long> zzex2) {
        if (string == null) {
            return zzex2.get();
        }
        String string2 = ((zzhj)this).zzgd().zzm(string, zzex2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzex2.get();
        }
        try {
            long l = Long.parseLong(string2);
            return zzex2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzex2.get();
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzex<Integer> zzex2) {
        if (string == null) {
            return zzex2.get();
        }
        String string2 = ((zzhj)this).zzgd().zzm(string, zzex2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzex2.get();
        }
        try {
            int n = Integer.parseInt(string2);
            return zzex2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzex2.get();
        }
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzex<Double> zzex2) {
        if (string == null) {
            return zzex2.get();
        }
        String string2 = ((zzhj)this).zzgd().zzm(string, zzex2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzex2.get();
        }
        try {
            double d = Double.parseDouble(string2);
            return zzex2.get(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzex2.get();
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzex<Boolean> zzex2) {
        if (string == null) {
            return zzex2.get();
        }
        String string2 = ((zzhj)this).zzgd().zzm(string, zzex2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzex2.get();
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zzex2.get(bl);
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzas(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        try {
            if (((zzhj)this).getContext().getPackageManager() == null) {
                ((zzhj)this).zzgg().zzil().log("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzhj)this).getContext()).getApplicationInfo(((zzhj)this).getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzhj)this).zzgg().zzil().log("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            if (applicationInfo.metaData == null) {
                ((zzhj)this).zzgg().zzil().log("Failed to load metadata: Metadata bundle is null");
                return null;
            }
            if (!applicationInfo.metaData.containsKey(string)) {
                return null;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzhj)this).zzgg().zzil().zzg("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public final boolean zzhi() {
        Boolean bl = this.zzas("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public static long zzhj() {
        return zzew.zzaho.get();
    }

    public static long zzhk() {
        return zzew.zzago.get();
    }

    public final String zzhl() {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, "debug.firebase.analytics.app", "");
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzhj)this).zzgg().zzil().zzg("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzhj)this).zzgg().zzil().zzg("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzhj)this).zzgg().zzil().zzg("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzhj)this).zzgg().zzil().zzg("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return "";
    }

    public static boolean zzhm() {
        return zzew.zzagj.get();
    }

    public final boolean zzat(String string) {
        return "1".equals(((zzhj)this).zzgd().zzm(string, "gaia_collection_enabled"));
    }

    @WorkerThread
    final boolean zzau(String string) {
        return this.zzd(string, zzew.zzahx);
    }

    @WorkerThread
    final boolean zzav(String string) {
        return this.zzd(string, zzew.zzaic);
    }
}

