/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzaba;
import com.google.android.gms.internal.measurement.zzabb;
import com.google.android.gms.internal.measurement.zzabd;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.android.gms.internal.measurement.zzjp;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzju;
import com.google.android.gms.internal.measurement.zzjv;
import com.google.android.gms.internal.measurement.zzjy;
import com.google.android.gms.internal.measurement.zzjz;
import com.google.android.gms.internal.measurement.zzkc;
import com.google.android.gms.internal.measurement.zzki;
import com.google.android.gms.internal.measurement.zzkj;
import com.google.android.gms.internal.measurement.zzkl;
import com.google.android.gms.internal.measurement.zzkm;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class zzei
extends zzhk {
    private static final String[] zzaeu = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;"};
    private static final String[] zzaev = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zzaew = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;", "ssaid_reporting_enabled", "ALTER TABLE apps ADD COLUMN ssaid_reporting_enabled INTEGER;"};
    private static final String[] zzaex = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zzaey = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;", "retry_count", "ALTER TABLE queue ADD COLUMN retry_count INTEGER;"};
    private static final String[] zzaez = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private final zzel zzafa;
    private final zzjp zzafb = new zzjp(this.zzbt());

    zzei(zzgl zzgl2) {
        super(zzgl2);
        String string = "google_app_measurement.db";
        this.zzafa = new zzel(this, this.getContext(), string);
    }

    @Override
    protected final boolean zzhh() {
        return false;
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzch();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzch();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzch();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzgg().zzil().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @VisibleForTesting
    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzab();
        try {
            return this.zzafa.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzin().zzg("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzeq zze(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Boolean bl = null;
            if (!cursor.isNull(6)) {
                bl = cursor.getLong(6) == 1L;
            }
            zzeq zzeq2 = new zzeq(string, string2, l, l2, l3, l4, l5, l6, bl);
            if (cursor.moveToNext()) {
                this.zzgg().zzil().zzg("Got multiple records for event aggregates, expected one. appId", zzfg.zzbh(string));
            }
            zzeq zzeq3 = zzeq2;
            return zzeq3;
        }
    }

    @WorkerThread
    public final void zza(zzeq zzeq2) {
        Preconditions.checkNotNull((Object)zzeq2);
        this.zzab();
        this.zzch();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzeq2.zztd);
        contentValues.put("name", zzeq2.name);
        contentValues.put("lifetime_count", Long.valueOf(zzeq2.zzafp));
        contentValues.put("current_bundle_count", Long.valueOf(zzeq2.zzafq));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzeq2.zzafr));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzeq2.zzafs));
        contentValues.put("last_sampled_complex_event_id", zzeq2.zzaft);
        contentValues.put("last_sampling_rate", zzeq2.zzafu);
        Long l = null;
        if (zzeq2.zzafv != null && zzeq2.zzafv.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzgg().zzil().zzg("Failed to insert/update event aggregates (got -1). appId", zzfg.zzbh(zzeq2.zztd));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzil().zze("Error storing event aggregates. appId", zzfg.zzbh(zzeq2.zztd), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzf(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzgg().zzir().zzg("Deleted user attribute rows", n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzil().zzd("Error deleting user attribute. appId", zzfg.zzbh(string), this.zzgb().zzbg(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzju zzju2) {
        Preconditions.checkNotNull((Object)zzju2);
        this.zzab();
        this.zzch();
        if (this.zzg(zzju2.zztd, zzju2.name) == null && (zzjv.zzbv(zzju2.name) ? this.zza("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzju2.zztd}) >= 25L : this.zza("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzju2.zztd, zzju2.zzaek}) >= 25L)) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzju2.zztd);
        contentValues.put("origin", zzju2.zzaek);
        contentValues.put("name", zzju2.name);
        contentValues.put("set_timestamp", Long.valueOf(zzju2.zzaqu));
        zzei.zza(contentValues, "value", zzju2.value);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzgg().zzil().zzg("Failed to insert/update user property (got -1). appId", zzfg.zzbh(zzju2.zztd));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzil().zze("Error storing user property. appId", zzfg.zzbh(zzju2.zztd), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzju zzg(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzju zzju2 = new zzju(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzgg().zzil().zzg("Got multiple records for user property, expected one. appId", zzfg.zzbh(string));
            }
            zzju zzju3 = zzju2;
            return zzju3;
        }
    }

    @WorkerThread
    public final List<zzju> zzaw(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        ArrayList<zzju> arrayList = new ArrayList<zzju>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzju> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzgg().zzil().zzg("Read invalid user property value, ignoring it. appId", zzfg.zzbh(string));
                    continue;
                }
                zzju zzju2 = new zzju(string, string2, (String)object, l, object2);
                arrayList.add(zzju2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzju> zzb(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        ArrayList<zzju> arrayList = new ArrayList<zzju>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, stringBuilder.toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzju> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzgg().zzil().zzg("Read more than the max allowed user properties, ignoring excess", 1000);
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzgg().zzil().zzd("(2)Read invalid user property value, ignoring it", zzfg.zzbh(string), string2, string3);
                    continue;
                }
                zzju zzju2 = new zzju(string, string2, (String)object, l, object2);
                arrayList.add(zzju2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzef zzef2) {
        Preconditions.checkNotNull((Object)((Object)zzef2));
        this.zzab();
        this.zzch();
        if (this.zzg(zzef2.packageName, zzef2.zzael.name) == null && this.zza("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzef2.packageName}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzef2.packageName);
        contentValues.put("origin", zzef2.zzaek);
        contentValues.put("name", zzef2.zzael.name);
        zzei.zza(contentValues, "value", zzef2.zzael.getValue());
        contentValues.put("active", Boolean.valueOf(zzef2.zzaen));
        contentValues.put("trigger_event_name", zzef2.zzaeo);
        contentValues.put("trigger_timeout", Long.valueOf(zzef2.zzaeq));
        this.zzgc();
        contentValues.put("timed_out_event", zzjv.zza((Parcelable)zzef2.zzaep));
        contentValues.put("creation_timestamp", Long.valueOf(zzef2.zzaem));
        this.zzgc();
        contentValues.put("triggered_event", zzjv.zza((Parcelable)zzef2.zzaer));
        contentValues.put("triggered_timestamp", Long.valueOf(zzef2.zzael.zzaqu));
        contentValues.put("time_to_live", Long.valueOf(zzef2.zzaes));
        this.zzgc();
        contentValues.put("expired_event", zzjv.zza((Parcelable)zzef2.zzaet));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzgg().zzil().zzg("Failed to insert/update conditional user property (got -1)", zzfg.zzbh(zzef2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzil().zze("Error storing conditional user property", zzfg.zzbh(zzef2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzef zzh(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzeu zzeu2 = this.zzgc().zza(cursor.getBlob(5), zzeu.CREATOR);
            long l2 = cursor.getLong(6);
            zzeu zzeu3 = this.zzgc().zza(cursor.getBlob(7), zzeu.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzeu zzeu4 = this.zzgc().zza(cursor.getBlob(10), zzeu.CREATOR);
            zzjs zzjs2 = new zzjs(string2, l3, object, string3);
            zzef zzef2 = new zzef(string, string3, zzjs2, l2, bl, string4, zzeu2, l, zzeu3, l4, zzeu4);
            if (cursor.moveToNext()) {
                this.zzgg().zzil().zze("Got multiple records for conditional property, expected one", zzfg.zzbh(string), this.zzgb().zzbg(string2));
            }
            zzef zzef3 = zzef2;
            return zzef3;
        }
    }

    @WorkerThread
    public final int zzi(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzil().zzd("Error deleting conditional property", zzfg.zzbh(string), this.zzgb().zzbg(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzef> zzc(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzb(stringBuilder.toString(), stringArray);
    }

    public final List<zzef> zzb(String string, String[] stringArray) {
        this.zzab();
        this.zzch();
        ArrayList<zzef> arrayList = new ArrayList<zzef>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzef> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzgg().zzil().zzg("Read more than the max allowed conditional properties, ignoring extra", 1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzeu zzeu2 = this.zzgc().zza(cursor.getBlob(7), zzeu.CREATOR);
                long l2 = cursor.getLong(8);
                zzeu zzeu3 = this.zzgc().zza(cursor.getBlob(9), zzeu.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzeu zzeu4 = this.zzgc().zza(cursor.getBlob(12), zzeu.CREATOR);
                zzjs zzjs2 = new zzjs(string3, l3, object2, string2);
                zzef zzef2 = new zzef((String)object, string2, zzjs2, l2, bl, string4, zzeu2, l, zzeu3, l4, zzeu4);
                arrayList.add(zzef2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzeb zzax(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled", "ssaid_reporting_enabled"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzeb zzeb2 = new zzeb(this.zzacr, string);
            zzeb2.zzal(cursor.getString(0));
            zzeb2.zzam(cursor.getString(1));
            zzeb2.zzan(cursor.getString(2));
            zzeb2.zzr(cursor.getLong(3));
            zzeb2.zzm(cursor.getLong(4));
            zzeb2.zzn(cursor.getLong(5));
            zzeb2.setAppVersion(cursor.getString(6));
            zzeb2.zzap(cursor.getString(7));
            zzeb2.zzp(cursor.getLong(8));
            zzeb2.zzq(cursor.getLong(9));
            zzeb2.setMeasurementEnabled(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzeb2.zzu(cursor.getLong(11));
            zzeb2.zzv(cursor.getLong(12));
            zzeb2.zzw(cursor.getLong(13));
            zzeb2.zzx(cursor.getLong(14));
            zzeb2.zzs(cursor.getLong(15));
            zzeb2.zzt(cursor.getLong(16));
            zzeb2.zzo(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzeb2.zzao(cursor.getString(18));
            zzeb2.zzz(cursor.getLong(19));
            zzeb2.zzy(cursor.getLong(20));
            zzeb2.zzaq(cursor.getString(21));
            zzeb2.zzaa(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzeb2.zzd(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzeb2.zze(cursor.isNull(24) || cursor.getInt(24) != 0);
            zzeb2.zzgj();
            if (cursor.moveToNext()) {
                this.zzgg().zzil().zzg("Got multiple records for app, expected one. appId", zzfg.zzbh(string));
            }
            zzeb zzeb3 = zzeb2;
            return zzeb3;
        }
    }

    @WorkerThread
    public final void zza(zzeb zzeb2) {
        Preconditions.checkNotNull((Object)zzeb2);
        this.zzab();
        this.zzch();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzeb2.zzah());
        contentValues.put("app_instance_id", zzeb2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzeb2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzeb2.zzgk());
        contentValues.put("last_bundle_index", Long.valueOf(zzeb2.zzgs()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzeb2.zzgm()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzeb2.zzgn()));
        contentValues.put("app_version", zzeb2.zzag());
        contentValues.put("app_store", zzeb2.zzgp());
        contentValues.put("gmp_version", Long.valueOf(zzeb2.zzgq()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzeb2.zzgr()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzeb2.isMeasurementEnabled()));
        contentValues.put("day", Long.valueOf(zzeb2.zzgw()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzeb2.zzgx()));
        contentValues.put("daily_events_count", Long.valueOf(zzeb2.zzgy()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzeb2.zzgz()));
        contentValues.put("config_fetched_time", Long.valueOf(zzeb2.zzgt()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzeb2.zzgu()));
        contentValues.put("app_version_int", Long.valueOf(zzeb2.zzgo()));
        contentValues.put("firebase_instance_id", zzeb2.zzgl());
        contentValues.put("daily_error_events_count", Long.valueOf(zzeb2.zzhb()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzeb2.zzha()));
        contentValues.put("health_monitor_sample", zzeb2.zzhc());
        contentValues.put("android_id", Long.valueOf(zzeb2.zzhe()));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzeb2.zzhf()));
        contentValues.put("ssaid_reporting_enabled", Boolean.valueOf(zzeb2.zzhg()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzeb2.zzah()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzgg().zzil().zzg("Failed to insert/update app (got -1). appId", zzfg.zzbh(zzeb2.zzah()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzil().zze("Error storing app. appId", zzfg.zzbh(zzeb2.zzah()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzay(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzgi().zzb(string2, zzew.zzaha);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzil().zze("Error deleting over the limit events. appId", zzfg.zzbh(string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzej zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        String[] stringArray = new String[]{string};
        zzej zzej2 = new zzej();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzgg().zzin().zzg("Not updating daily counts, app is not known. appId", zzfg.zzbh(string));
                zzej zzej3 = zzej2;
                return zzej3;
            }
            if (cursor.getLong(0) == l) {
                zzej2.zzafd = cursor.getLong(1);
                zzej2.zzafc = cursor.getLong(2);
                zzej2.zzafe = cursor.getLong(3);
                zzej2.zzaff = cursor.getLong(4);
                zzej2.zzafg = cursor.getLong(5);
            }
            if (bl) {
                ++zzej2.zzafd;
            }
            if (bl2) {
                ++zzej2.zzafc;
            }
            if (bl3) {
                ++zzej2.zzafe;
            }
            if (bl4) {
                ++zzej2.zzaff;
            }
            if (bl5) {
                ++zzej2.zzafg;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzej2.zzafc));
            contentValues.put("daily_events_count", Long.valueOf(zzej2.zzafd));
            contentValues.put("daily_conversions_count", Long.valueOf(zzej2.zzafe));
            contentValues.put("daily_error_events_count", Long.valueOf(zzej2.zzaff));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzej2.zzafg));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzej zzej4 = zzej2;
            return zzej4;
        }
    }

    @WorkerThread
    public final byte[] zzaz(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzgg().zzil().zzg("Got multiple records for app config, expected one. appId", zzfg.zzbh(string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzkl zzkl2, boolean bl) {
        byte[] byArray;
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)((Object)zzkl2));
        Preconditions.checkNotEmpty((String)zzkl2.zztd);
        Preconditions.checkNotNull((Object)zzkl2.zzath);
        this.zzhp();
        long l = this.zzbt().currentTimeMillis();
        if (zzkl2.zzath < l - zzeh.zzhj() || zzkl2.zzath > l + zzeh.zzhj()) {
            this.zzgg().zzin().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzfg.zzbh(zzkl2.zztd), l, zzkl2.zzath);
        }
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = new byte[zzkl2.zzwg()];
            zzabb zzabb2 = zzabb.zzb((byte[])byArray2, (int)0, (int)byArray3.length);
            zzkl2.zza(zzabb2);
            zzabb2.zzvy();
            byArray = this.zzgc().zza(byArray2);
        }
        catch (IOException iOException) {
            this.zzgg().zzil().zze("Data loss. Failed to serialize bundle. appId", zzfg.zzbh(zzkl2.zztd), iOException);
            return false;
        }
        this.zzgg().zzir().zzg("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzkl2.zztd);
        contentValues.put("bundle_end_timestamp", zzkl2.zzath);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        if (zzkl2.zzaue != null) {
            contentValues.put("retry_count", zzkl2.zzaue);
        }
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzgg().zzil().zzg("Failed to insert bundle (got -1). appId", zzfg.zzbh(zzkl2.zztd));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzil().zze("Error storing bundle. appId", zzfg.zzbh(zzkl2.zztd), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final String zzhn() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public final boolean zzho() {
        return this.zza("select count(1) > 0 from queue where has_realtime = 1", (String[])null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzkl, Long>> zzb(String string, int n, int n2) {
        this.zzab();
        this.zzch();
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((n2 > 0 ? 1 : 0) != 0);
        Preconditions.checkNotEmpty((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data", "retry_count"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzkl, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzkl, Long>> arrayList = new ArrayList<Pair<zzkl, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzgc().zzb((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzgg().zzil().zze("Failed to unzip queued bundle. appId", zzfg.zzbh(string), iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                byte[] byArray2 = byArray;
                object = zzaba.zza((byte[])byArray, (int)0, (int)byArray2.length);
                zzkl zzkl2 = new zzkl();
                try {
                    zzkl2.zzb((zzaba)object);
                }
                catch (IOException iOException) {
                    this.zzgg().zzil().zze("Failed to merge queued bundle. appId", zzfg.zzbh(string), iOException);
                    continue;
                }
                if (!cursor.isNull(2)) {
                    zzkl2.zzaue = cursor.getInt(2);
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzkl, Long>)Pair.create((Object)((Object)zzkl2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzkl, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzhp() {
        this.zzab();
        this.zzch();
        if (!this.zzhv()) {
            return;
        }
        long l = this.zzgh().zzajw.get();
        long l2 = this.zzbt().elapsedRealtime();
        if (Math.abs(l2 - l) > zzew.zzahj.get()) {
            this.zzgh().zzajw.set(l2);
            zzei zzei2 = this;
            zzei2.zzab();
            zzei2.zzch();
            if (zzei2.zzhv()) {
                SQLiteDatabase sQLiteDatabase = zzei2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzei2.zzbt().currentTimeMillis()), String.valueOf(zzeh.zzhj())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzei2.zzgg().zzir().zzg("Deleted stale rows. rowsDeleted", n);
                }
            }
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzc(List<Long> list) {
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull(list);
        Preconditions.checkNotZero((int)list.size());
        if (!this.zzhv()) {
            return;
        }
        String string = TextUtils.join((CharSequence)",", list);
        String string2 = new StringBuilder(2 + String.valueOf(string).length()).append("(").append(string).append(")").toString();
        if (this.zza(new StringBuilder(80 + String.valueOf(string2).length()).append("SELECT COUNT(1) FROM queue WHERE rowid IN ").append(string2).append(" AND retry_count =  2147483647 LIMIT 1").toString(), (String[])null) > 0L) {
            this.zzgg().zzin().log("The number of upload retries exceeds the limit. Will remain unchanged.");
        }
        try {
            this.getWritableDatabase().execSQL(new StringBuilder(127 + String.valueOf(string2).length()).append("UPDATE queue SET retry_count = IFNULL(retry_count, 0) + 1 WHERE rowid IN ").append(string2).append(" AND (retry_count IS NULL OR retry_count < 2147483647)").toString());
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzil().zzg("Error incrementing retry count. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, zzjy[] zzjyArray) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzjyArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzei zzei2 = this;
            zzei2.zzch();
            zzei2.zzab();
            Preconditions.checkNotEmpty((String)string2);
            Object object = zzei2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzjyArray;
            int n2 = zzjyArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzjz zzjz2;
                int n3;
                int n4;
                zzjy zzjy2 = object2[n];
                object = zzjy2;
                string2 = string;
                zzei2 = this;
                zzei2.zzch();
                zzei2.zzab();
                Preconditions.checkNotEmpty((String)string2);
                Preconditions.checkNotNull((Object)object);
                Preconditions.checkNotNull((Object)object.zzari);
                Preconditions.checkNotNull((Object)object.zzarh);
                if (object.zzarg == null) {
                    zzei2.zzgg().zzin().zzg("Audience with no ID. appId", zzfg.zzbh(string2));
                    continue;
                }
                int n5 = object.zzarg;
                zzabd[] zzabdArray = object.zzari;
                int n6 = object.zzari.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzabdArray[n4].zzark != null) continue;
                    zzei2.zzgg().zzin().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzfg.zzbh(string2), object.zzarg);
                    continue block3;
                }
                zzabdArray = object.zzarh;
                n6 = object.zzarh.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzabdArray[n4].zzark != null) continue;
                    zzei2.zzgg().zzin().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzfg.zzbh(string2), object.zzarg);
                    continue block3;
                }
                boolean bl = true;
                zzabd[] zzabdArray2 = object.zzari;
                n4 = object.zzari.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzjz2 = zzabdArray2[n3];
                    if (zzei2.zza(string2, n5, zzjz2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    zzabdArray2 = object.zzarh;
                    n4 = object.zzarh.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzjz2 = zzabdArray2[n3];
                        if (zzei2.zza(string2, n5, (zzkc)((Object)zzjz2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzei zzei3 = zzei2;
                zzei3.zzch();
                zzei3.zzab();
                Preconditions.checkNotEmpty((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzei3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzjy[] zzjyArray2 = zzjyArray;
            n = zzjyArray.length;
            for (int i = 0; i < n; ++i) {
                zzjy zzjy3 = zzjyArray2[i];
                object2.add(zzjy3.zzarg);
            }
            this.zza(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzjz zzjz2) {
        byte[] byArray;
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzjz2));
        if (TextUtils.isEmpty((CharSequence)zzjz2.zzarl)) {
            this.zzgg().zzin().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzfg.zzbh(string), n, String.valueOf(zzjz2.zzark));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzjz2.zzwg()];
            zzabb zzabb2 = zzabb.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzjz2.zza(zzabb2);
            zzabb2.zzvy();
        }
        catch (IOException iOException) {
            this.zzgg().zzil().zze("Configuration loss. Failed to serialize event filter. appId", zzfg.zzbh(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzjz2.zzark);
        contentValues.put("event_name", zzjz2.zzarl);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzgg().zzil().zzg("Failed to insert event filter (got -1). appId", zzfg.zzbh(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzil().zze("Error storing event filter. appId", zzfg.zzbh(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzkc zzkc2) {
        byte[] byArray;
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzkc2));
        if (TextUtils.isEmpty((CharSequence)zzkc2.zzasa)) {
            this.zzgg().zzin().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzfg.zzbh(string), n, String.valueOf(zzkc2.zzark));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzkc2.zzwg()];
            zzabb zzabb2 = zzabb.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkc2.zza(zzabb2);
            zzabb2.zzvy();
        }
        catch (IOException iOException) {
            this.zzgg().zzil().zze("Configuration loss. Failed to serialize property filter. appId", zzfg.zzbh(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzkc2.zzark);
        contentValues.put("property_name", zzkc2.zzasa);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzgg().zzil().zzg("Failed to insert property filter (got -1). appId", zzfg.zzbh(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzil().zze("Error storing property filter. appId", zzfg.zzbh(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzjz>> zzj(String string, String string2) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzjz>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzaba zzaba2 = zzaba.zza((byte[])byArray, (int)0, (int)byArray.length);
                zzjz zzjz2 = new zzjz();
                try {
                    zzjz2.zzb(zzaba2);
                }
                catch (IOException iOException) {
                    this.zzgg().zzil().zze("Failed to merge filter. appId", zzfg.zzbh(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzjz> arrayList = (ArrayList<zzjz>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzjz>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzjz2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzkc>> zzk(String string, String string2) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzkc>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzaba zzaba2 = zzaba.zza((byte[])byArray, (int)0, (int)byArray.length);
                zzkc zzkc2 = new zzkc();
                try {
                    zzkc2.zzb(zzaba2);
                }
                catch (IOException iOException) {
                    this.zzgg().zzil().zze("Failed to merge filter", zzfg.zzbh(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzkc> arrayList = (ArrayList<zzkc>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzkc>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzkc2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zza(String string, List<Integer> list) {
        Object object;
        long l;
        Preconditions.checkNotEmpty((String)string);
        this.zzch();
        this.zzab();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zza("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzil().zze("Database error querying filters. appId", zzfg.zzbh(string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzgi().zzb(string2, zzew.zzahq);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzkm> zzba(String string) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzaba zzaba2 = zzaba.zza((byte[])byArray, (int)0, (int)byArray.length);
                zzkm zzkm2 = new zzkm();
                try {
                    zzkm2.zzb(zzaba2);
                }
                catch (IOException iOException) {
                    this.zzgg().zzil().zzd("Failed to merge filter results. appId, audienceId, error", zzfg.zzbh(string), n, iOException);
                    continue;
                }
                arrayMap.put(n, zzkm2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @VisibleForTesting
    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzgg().zzil().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzgg().zzil().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzgg().zzil().zzg("Loaded invalid unknown value type, ignoring it", n3);
        return null;
    }

    @WorkerThread
    public final long zzhq() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    @VisibleForTesting
    protected final long zzl(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzgg().zzil().zze("Failed to insert column (got -1). appId", zzfg.zzbh(string), string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzgg().zzil().zze("Failed to update column (got 0). appId", zzfg.zzbh(string), string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzil().zzd("Error inserting column. appId", zzfg.zzbh(string), string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzhr() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzkl zzkl2) throws IOException {
        long l;
        Object object;
        byte[] byArray;
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)((Object)zzkl2));
        Preconditions.checkNotEmpty((String)zzkl2.zztd);
        try {
            byArray = new byte[zzkl2.zzwg()];
            object = byArray;
            zzabb zzabb2 = zzabb.zzb((byte[])byArray, (int)0, (int)((byte[])object).length);
            zzkl2.zza(zzabb2);
            zzabb2.zzvy();
        }
        catch (IOException iOException) {
            this.zzgg().zzil().zze("Data loss. Failed to serialize event metadata. appId", zzfg.zzbh(zzkl2.zztd), iOException);
            throw iOException;
        }
        byte[] byArray2 = byArray;
        object = this.zzgc();
        Preconditions.checkNotNull((Object)byArray2);
        ((zzhj)object).zzab();
        MessageDigest messageDigest = zzjv.getMessageDigest("MD5");
        if (messageDigest == null) {
            ((zzhj)object).zzgg().zzil().log("Failed to get MD5");
            l = 0L;
        } else {
            l = zzjv.zzc(messageDigest.digest(byArray2));
        }
        long l2 = l;
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzkl2.zztd);
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzil().zze("Error storing raw event metadata. appId", zzfg.zzbh(zzkl2.zztd), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l2;
    }

    public final boolean zzhs() {
        return this.zza("select count(1) > 0 from raw_events", (String[])null) != 0L;
    }

    public final boolean zzht() {
        return this.zza("select count(1) > 0 from raw_events where realtime = 1", (String[])null) != 0L;
    }

    public final long zzbb(String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzab(long l) {
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzgg().zzir().log("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzhu() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final Pair<zzki, Long> zza(String string, Long l) {
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select main_event, children_to_process from main_event_params where app_id=? and event_id=?", new String[]{string, String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzgg().zzir().log("Main event not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            Long l2 = cursor.getLong(1);
            byte[] byArray2 = byArray;
            zzaba zzaba2 = zzaba.zza((byte[])byArray, (int)0, (int)byArray2.length);
            zzki zzki2 = new zzki();
            try {
                zzki2.zzb(zzaba2);
            }
            catch (IOException iOException) {
                this.zzgg().zzil().zzd("Failed to merge main event. appId, eventId", zzfg.zzbh(string), l, iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            Pair pair = Pair.create((Object)((Object)zzki2), (Object)l2);
            return pair;
        }
        return null;
    }

    public final boolean zza(String string, Long l, long l2, zzki zzki2) {
        byte[] byArray;
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)((Object)zzki2));
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)l);
        try {
            byte[] byArray2 = byArray = new byte[zzki2.zzwg()];
            zzabb zzabb2 = zzabb.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzki2.zza(zzabb2);
            zzabb2.zzvy();
        }
        catch (IOException iOException) {
            this.zzgg().zzil().zzd("Data loss. Failed to serialize event params/data. appId, eventId", zzfg.zzbh(string), l, iOException);
            return false;
        }
        this.zzgg().zzir().zze("Saving complex main event, appId, data size", this.zzgb().zzbe(string), byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("event_id", l);
        contentValues.put("children_to_process", Long.valueOf(l2));
        contentValues.put("main_event", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1L) {
                this.zzgg().zzil().zzg("Failed to insert complex main event (got -1). appId", zzfg.zzbh(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzil().zze("Error storing complex main event. appId", zzfg.zzbh(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(zzep zzep2, long l, boolean bl) {
        Object object;
        zzkj zzkj2;
        String string2;
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)zzep2);
        Preconditions.checkNotEmpty((String)zzep2.zztd);
        zzki zzki2 = new zzki();
        new zzki().zzasx = zzep2.zzafn;
        zzki2.zzasv = new zzkj[zzep2.zzafo.size()];
        int n = 0;
        for (String string2 : zzep2.zzafo) {
            zzkj2 = new zzkj();
            zzki2.zzasv[n++] = zzkj2;
            zzkj2.name = string2;
            Object object2 = zzep2.zzafo.get(string2);
            this.zzgc().zza(zzkj2, object2);
        }
        try {
            byte[] byArray = new byte[zzki2.zzwg()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzkj2 = zzabb.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzki2.zza((zzabb)zzkj2);
            zzkj2.zzvy();
        }
        catch (IOException iOException) {
            this.zzgg().zzil().zze("Data loss. Failed to serialize event params/data. appId", zzfg.zzbh(zzep2.zztd), iOException);
            return false;
        }
        this.zzgg().zzir().zze("Saving event, name, data size", this.zzgb().zzbe(zzep2.name), ((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzep2.zztd);
        string2.put("name", zzep2.name);
        string2.put("timestamp", Long.valueOf(zzep2.timestamp));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzgg().zzil().zzg("Failed to insert raw event (got -1). appId", zzfg.zzbh(zzep2.zztd));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgg().zzil().zze("Error storing raw event. appId", zzfg.zzbh(zzep2.zztd), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzhv() {
        return this.getContext().getDatabasePath("google_app_measurement.db").exists();
    }

    @WorkerThread
    private static boolean zza(zzfg zzfg2, SQLiteDatabase sQLiteDatabase, String string) {
        if (zzfg2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
            boolean bl = cursor.moveToFirst();
            return bl;
        }
    }

    @WorkerThread
    private static Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
        try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
            Collections.addAll(hashSet, cursor.getColumnNames());
        }
        return hashSet;
    }

    @WorkerThread
    static void zza(zzfg zzfg2, SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, String[] stringArray) throws SQLiteException {
        if (zzfg2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (!zzei.zza(zzfg2, sQLiteDatabase, string)) {
            sQLiteDatabase.execSQL(string2);
        }
        try {
            String[] stringArray2 = stringArray;
            String string4 = string3;
            String string5 = string;
            SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
            zzfg zzfg3 = zzfg2;
            if (zzfg3 == null) {
                throw new IllegalArgumentException("Monitor must not be null");
            }
            Set<String> set = zzei.zzb(sQLiteDatabase2, string5);
            for (String string6 : string4.split(",")) {
                if (set.remove(string6)) continue;
                throw new SQLiteException(new StringBuilder(35 + String.valueOf(string5).length() + String.valueOf(string6).length()).append("Table ").append(string5).append(" is missing required column: ").append(string6).toString());
            }
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; i += 2) {
                    if (set.remove(stringArray2[i])) continue;
                    sQLiteDatabase2.execSQL(stringArray2[i + 1]);
                }
            }
            if (!set.isEmpty()) {
                zzfg3.zzin().zze("Table has extra columns. table, columns", string5, TextUtils.join((CharSequence)", ", set));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            zzfg2.zzil().zzg("Failed to verify columns on table that was just created", string);
            throw sQLiteException;
        }
    }

    static void zza(zzfg zzfg2, SQLiteDatabase sQLiteDatabase) {
        if (zzfg2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        File file = new File(sQLiteDatabase.getPath());
        if (!file.setReadable(false, false)) {
            zzfg2.zzin().log("Failed to turn off database read permission");
        }
        if (!file.setWritable(false, false)) {
            zzfg2.zzin().log("Failed to turn off database write permission");
        }
        if (!file.setReadable(true, true)) {
            zzfg2.zzin().log("Failed to turn on database read permission for owner");
        }
        if (!file.setWritable(true, true)) {
            zzfg2.zzin().log("Failed to turn on database write permission for owner");
        }
    }

    static /* synthetic */ zzjp zza(zzei zzei2) {
        return zzei2.zzafb;
    }

    static /* synthetic */ String[] zzhw() {
        return zzaeu;
    }

    static /* synthetic */ String[] zzhx() {
        return zzaev;
    }

    static /* synthetic */ String[] zzhy() {
        return zzaew;
    }

    static /* synthetic */ String[] zzhz() {
        return zzaey;
    }

    static /* synthetic */ String[] zzia() {
        return zzaex;
    }

    static /* synthetic */ String[] zzib() {
        return zzaez;
    }
}

