/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.firebase.iid.FirebaseInstanceId;
import java.math.BigInteger;
import java.util.Locale;

public final class zzfb
extends zzhk {
    private String zztd;
    private String zztc;
    private int zzaie;
    private String zzado;
    private String zztb;
    private long zzaif;
    private long zzads;
    private int zzaei;
    private String zzadh;

    zzfb(zzgl zzgl2) {
        super(zzgl2);
    }

    @Override
    protected final boolean zzhh() {
        return true;
    }

    @Override
    protected final void zzig() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzhj)this).getContext().getPackageName();
        PackageManager packageManager = ((zzhj)this).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzhj)this).zzgg().zzil().zzg("PackageManager is null, app identity information might be inaccurate. appId", zzfg.zzbh(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzhj)this).zzgg().zzil().zzg("Error retrieving app installer package name. appId", zzfg.zzbh(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzhj)this).getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzhj)this).zzgg().zzil().zze("Error retrieving package info. appId, appName", zzfg.zzbh(string4), string3);
            }
        }
        this.zztd = string4;
        this.zzado = string;
        this.zztc = string2;
        this.zzaie = n;
        this.zztb = string3;
        this.zzaif = 0L;
        packageInfo = GoogleServices.initialize((Context)((zzhj)this).getContext());
        boolean bl = packageInfo != null && packageInfo.isSuccess();
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzfb zzfb2 = this;
            if (packageInfo2 == null) {
                ((zzhj)zzfb2).zzgg().zzil().log("GoogleService failed to initialize (no status)");
            } else {
                ((zzhj)zzfb2).zzgg().zzil().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzhj)this).zzgi().zzas("firebase_analytics_collection_enabled");
            if (((zzhj)this).zzgi().zzhi()) {
                ((zzhj)this).zzgg().zzip().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                ((zzhj)this).zzgg().zzip().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && GoogleServices.isMeasurementExplicitlyDisabled()) {
                ((zzhj)this).zzgg().zzip().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzhj)this).zzgg().zzir().log("Collection enabled");
            }
        }
        this.zzadh = "";
        this.zzads = 0L;
        try {
            object = GoogleServices.getGoogleAppId();
            Object object2 = this.zzadh = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (bl2) {
                ((zzhj)this).zzgg().zzir().zze("App package, google app id", this.zztd, this.zzadh);
            }
        }
        catch (IllegalStateException illegalStateException) {
            ((zzhj)this).zzgg().zzil().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzfg.zzbh(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzaei = InstantApps.isInstantApp((Context)((zzhj)this).getContext()) ? 1 : 0;
            return;
        }
        this.zzaei = 0;
    }

    @WorkerThread
    final zzec zzbd(String string) {
        ((zzhj)this).zzab();
        String string2 = this.zzah();
        String string3 = this.getGmpAppId();
        zzfb zzfb2 = this;
        zzfb2.zzch();
        String string4 = zzfb2.zztc;
        long l = this.zzii();
        zzfb2 = this;
        zzfb2.zzch();
        String string5 = zzfb2.zzado;
        zzfb2 = this;
        zzfb2.zzch();
        ((zzhj)zzfb2).zzab();
        if (zzfb2.zzaif == 0L) {
            zzfb2.zzaif = zzfb2.zzacr.zzgc().zzd(((zzhj)zzfb2).getContext(), ((zzhj)zzfb2).getContext().getPackageName());
        }
        long l2 = zzfb2.zzaif;
        boolean bl = this.zzacr.isEnabled();
        boolean bl2 = !((zzhj)this).zzgh().zzakm;
        String string6 = this.zzgl();
        this.zzch();
        Boolean bl3 = ((zzhj)this).zzgi().zzas("google_analytics_adid_collection_enabled");
        boolean bl4 = bl3 == null || bl3 != false;
        bl3 = ((zzhj)this).zzgi().zzas("google_analytics_ssaid_collection_enabled");
        return new zzec(string2, string3, string4, l, string5, 12451L, l2, string, bl, bl2, string6, 0L, this.zzacr.zzju(), this.zzij(), bl4, bl3 == null || bl3 != false, ((zzhj)this).zzgh().zzja());
    }

    @WorkerThread
    final String zzih() {
        byte[] byArray = new byte[16];
        ((zzhj)this).zzgc().zzku().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    private final String zzgl() {
        ((zzhj)this).zzab();
        String string = this.zztd;
        if (((zzhj)this).zzgi().zzd(string, zzew.zzaib) && !this.zzacr.isEnabled()) {
            return null;
        }
        try {
            return FirebaseInstanceId.getInstance().getId();
        }
        catch (IllegalStateException illegalStateException) {
            ((zzhj)this).zzgg().zzin().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String zzah() {
        this.zzch();
        return this.zztd;
    }

    final String getGmpAppId() {
        this.zzch();
        return this.zzadh;
    }

    final int zzii() {
        this.zzch();
        return this.zzaie;
    }

    final int zzij() {
        this.zzch();
        return this.zzaei;
    }
}

