/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.support.annotation.GuardedBy;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzfj;
import com.google.android.gms.internal.measurement.zzfr;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.android.gms.measurement.AppMeasurement;

public final class zzfg
extends zzhk {
    private char zzaim = '\u0000';
    private long zzadp = -1L;
    @GuardedBy(value="this")
    private String zzain;
    private final zzfi zzaio = new zzfi(this, 6, false, false);
    private final zzfi zzaip = new zzfi(this, 6, true, false);
    private final zzfi zzaiq = new zzfi(this, 6, false, true);
    private final zzfi zzair = new zzfi(this, 5, false, false);
    private final zzfi zzais = new zzfi(this, 5, true, false);
    private final zzfi zzait = new zzfi(this, 5, false, true);
    private final zzfi zzaiu = new zzfi(this, 4, false, false);
    private final zzfi zzaiv = new zzfi(this, 3, false, false);
    private final zzfi zzaiw = new zzfi(this, 2, false, false);

    zzfg(zzgl zzgl2) {
        super(zzgl2);
    }

    public final zzfi zzil() {
        return this.zzaio;
    }

    public final zzfi zzim() {
        return this.zzaip;
    }

    public final zzfi zzin() {
        return this.zzair;
    }

    public final zzfi zzio() {
        return this.zzait;
    }

    public final zzfi zzip() {
        return this.zzaiu;
    }

    public final zzfi zziq() {
        return this.zzaiv;
    }

    public final zzfi zzir() {
        return this.zzaiw;
    }

    @Override
    protected final boolean zzhh() {
        return false;
    }

    protected static Object zzbh(String string) {
        if (string == null) {
            return null;
        }
        return new zzfj(string);
    }

    protected final void zza(int n, boolean bl, boolean bl2, String string, Object object, Object object2, Object object3) {
        if (!bl && this.isLoggable(n)) {
            String string2 = zzfg.zza(false, string, object, object2, object3);
            this.zza(n, string2);
        }
        if (!bl2 && n >= 5) {
            Object object4 = object3;
            Object object5 = object2;
            Object object6 = object;
            String string3 = string;
            int n2 = n;
            zzfg zzfg2 = this;
            Preconditions.checkNotNull((Object)string3);
            zzgg zzgg2 = zzfg2.zzacr.zzjn();
            if (zzgg2 == null) {
                zzfg2.zza(6, "Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzgg2.isInitialized()) {
                zzfg2.zza(6, "Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= 9) {
                n2 = 8;
            }
            int n3 = n2;
            zzgg2.zzc(new zzfh(zzfg2, n3, string3, object6, object5, object4));
        }
    }

    @VisibleForTesting
    protected final boolean isLoggable(int n) {
        return Log.isLoggable((String)this.zzis(), (int)n);
    }

    @VisibleForTesting
    protected final void zza(int n, String string) {
        Log.println((int)n, (String)this.zzis(), (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String zzis() {
        zzfg zzfg2 = this;
        synchronized (zzfg2) {
            if (this.zzain == null) {
                this.zzain = zzew.zzagl.get();
            }
            return this.zzain;
        }
    }

    static String zza(boolean bl, String string, Object object, Object object2, Object object3) {
        if (string == null) {
            string = "";
        }
        String string2 = zzfg.zza(bl, object);
        String string3 = zzfg.zza(bl, object2);
        String string4 = zzfg.zza(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string5 = ": ";
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(string5);
            stringBuilder.append(string2);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append(string5);
            stringBuilder.append(string3);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            stringBuilder.append(string5);
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    private static String zza(boolean bl, Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return String.valueOf(object);
            }
            if (Math.abs((Long)object) < 100L) {
                return String.valueOf(object);
            }
            String string = String.valueOf(object).charAt(0) == '-' ? "-" : "";
            String string2 = String.valueOf(Math.abs((Long)object));
            long l = Math.round(Math.pow(10.0, string2.length() - 1));
            long l2 = Math.round(Math.pow(10.0, string2.length()) - 1.0);
            return new StringBuilder(43 + String.valueOf(string).length() + String.valueOf(string).length()).append(string).append(l).append("...").append(string).append(l2).toString();
        }
        if (object instanceof Boolean) {
            return String.valueOf(object);
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            StringBuilder stringBuilder = new StringBuilder(bl ? throwable.getClass().getName() : throwable.toString());
            String string = zzfg.zzbi(AppMeasurement.class.getCanonicalName());
            String string3 = zzfg.zzbi(zzgl.class.getCanonicalName());
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String string4;
                String string5;
                if (stackTraceElement.isNativeMethod() || (string5 = stackTraceElement.getClassName()) == null || !(string4 = zzfg.zzbi(string5)).equals(string) && !string4.equals(string3)) continue;
                stringBuilder.append(": ");
                stringBuilder.append(stackTraceElement);
                break;
            }
            return stringBuilder.toString();
        }
        if (object instanceof zzfj) {
            return zzfj.zza((zzfj)object);
        }
        if (bl) {
            return "-";
        }
        return String.valueOf(object);
    }

    private static String zzbi(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public final String zzit() {
        Pair<String, Long> pair = ((zzhj)this).zzgh().zzajs.zzfh();
        if (pair == null || pair == zzfr.zzajr) {
            return null;
        }
        String string = String.valueOf(pair.second);
        String string2 = (String)pair.first;
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(":").append(string2).toString();
    }

    static /* synthetic */ char zza(zzfg zzfg2) {
        return zzfg2.zzaim;
    }

    static /* synthetic */ char zza(zzfg zzfg2, char c) {
        zzfg2.zzaim = c;
        return zzfg2.zzaim;
    }

    static /* synthetic */ long zzb(zzfg zzfg2) {
        return zzfg2.zzadp;
    }

    static /* synthetic */ long zza(zzfg zzfg2, long l) {
        zzfg2.zzadp = 12451L;
        return 12451L;
    }
}

