/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzft;
import com.google.android.gms.internal.measurement.zzfu;
import com.google.android.gms.internal.measurement.zzfv;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.android.gms.internal.measurement.zzjv;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzfr
extends zzhk {
    @VisibleForTesting
    static final Pair<String, Long> zzajr = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzaba;
    public zzfv zzajs;
    public final zzfu zzajt = new zzfu(this, "last_upload", 0L);
    public final zzfu zzaju = new zzfu(this, "last_upload_attempt", 0L);
    public final zzfu zzajv = new zzfu(this, "backoff", 0L);
    public final zzfu zzajw = new zzfu(this, "last_delete_stale", 0L);
    public final zzfu zzajx;
    public final zzfu zzajy;
    public final zzfu zzajz;
    public final zzfw zzaka;
    private String zzakb;
    private boolean zzakc;
    private long zzakd;
    private String zzake;
    private long zzakf;
    private final Object zzakg;
    public final zzfu zzakh = new zzfu(this, "time_before_start", 10000L);
    public final zzfu zzaki = new zzfu(this, "session_timeout", 1800000L);
    public final zzft zzakj = new zzft(this, "start_new_session", true);
    public final zzfu zzakk = new zzfu(this, "last_pause_time", 0L);
    public final zzfu zzakl = new zzfu(this, "time_active", 0L);
    public boolean zzakm;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzbj(String string) {
        this.zzab();
        long l = this.zzbt().elapsedRealtime();
        if (this.zzakb != null && l < this.zzakd) {
            return new Pair((Object)this.zzakb, (Object)this.zzakc);
        }
        String string2 = string;
        this.zzakd = l + this.zzgi().zza(string2, zzew.zzagm);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zzakb = info.getId();
                this.zzakc = info.isLimitAdTrackingEnabled();
            }
            if (this.zzakb == null) {
                this.zzakb = "";
            }
        }
        catch (Throwable throwable) {
            this.zzgg().zziq().zzg("Unable to get advertising id", throwable);
            this.zzakb = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzakb, (Object)this.zzakc);
    }

    @WorkerThread
    final String zzbk(String string) {
        this.zzab();
        String string2 = (String)this.zzbj((String)string).first;
        MessageDigest messageDigest = zzjv.getMessageDigest("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzfr(zzgl zzgl2) {
        super(zzgl2);
        this.zzajx = new zzfu(this, "midnight_offset", 0L);
        this.zzajy = new zzfu(this, "first_open_time", 0L);
        this.zzajz = new zzfu(this, "app_install_time", 0L);
        this.zzaka = new zzfw(this, "app_instance_id", null);
        this.zzakg = new Object();
    }

    @Override
    protected final boolean zzhh() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void zzig() {
        this.zzaba = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzakm = this.zzaba.getBoolean("has_been_opened", false);
        if (!this.zzakm) {
            SharedPreferences.Editor editor = this.zzaba.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzajs = new zzfv(this, "health_monitor", Math.max(0L, zzew.zzagn.get()), null);
    }

    @WorkerThread
    private final SharedPreferences zziu() {
        this.zzab();
        this.zzch();
        return this.zzaba;
    }

    @WorkerThread
    final void zzbl(String string) {
        this.zzab();
        SharedPreferences.Editor editor = this.zziu().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zziv() {
        this.zzab();
        return this.zziu().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzbm(String string) {
        Object object = this.zzakg;
        synchronized (object) {
            this.zzake = string;
            this.zzakf = this.zzbt().elapsedRealtime();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zziw() {
        Object object = this.zzakg;
        synchronized (object) {
            if (Math.abs(this.zzbt().elapsedRealtime() - this.zzakf) < 1000L) {
                return this.zzake;
            }
            return null;
        }
    }

    @WorkerThread
    final Boolean zzix() {
        this.zzab();
        if (!this.zziu().contains("use_service")) {
            return null;
        }
        return this.zziu().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzf(boolean bl) {
        this.zzab();
        this.zzgg().zzir().zzg("Setting useService", bl);
        SharedPreferences.Editor editor = this.zziu().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zziy() {
        this.zzab();
        this.zzgg().zzir().log("Clearing collection preferences.");
        boolean bl = this.zziu().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzg(true);
        }
        SharedPreferences.Editor editor = this.zziu().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzab();
        this.zzgg().zzir().zzg("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zziu().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzg(boolean bl) {
        this.zzab();
        return this.zziu().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected final String zziz() {
        this.zzab();
        String string = this.zziu().getString("previous_os_version", null);
        this.zzfw().zzch();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zziu().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzh(boolean bl) {
        this.zzab();
        this.zzgg().zzir().zzg("Updating deferred analytics collection", bl);
        SharedPreferences.Editor editor = this.zziu().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzja() {
        this.zzab();
        return this.zziu().getBoolean("deferred_analytics_collection", false);
    }

    @WorkerThread
    final boolean zzjb() {
        return this.zzaba.contains("deferred_analytics_collection");
    }

    static /* synthetic */ SharedPreferences zza(zzfr zzfr2) {
        return zzfr2.zziu();
    }
}

