/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.PackageManagerWrapper;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzfz;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzr;
import java.util.List;

public final class zzfx {
    private final zzgl zzacr;
    @VisibleForTesting
    volatile zzr zzakv;
    @VisibleForTesting
    private ServiceConnection zzakw;

    zzfx(zzgl zzgl2) {
        this.zzacr = zzgl2;
    }

    @WorkerThread
    protected final void zzjd() {
        ((zzhj)this.zzacr.zzgf()).zzab();
        if (!this.zzje()) {
            this.zzacr.zzgg().zzip().log("Install Referrer Reporter is not available");
            this.zzakw = null;
            return;
        }
        this.zzakw = new zzfz(this, null);
        this.zzacr.zzgg().zzip().log("Install Referrer Reporter is initializing");
        zzfx zzfx2 = this;
        ((zzhj)zzfx2.zzacr.zzgf()).zzab();
        Intent intent = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
        intent.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
        PackageManager packageManager = zzfx2.zzacr.getContext().getPackageManager();
        if (packageManager == null) {
            zzfx2.zzacr.zzgg().zzin().log("Failed to obtain Package Manager to verify binding conditions");
            return;
        }
        List list = packageManager.queryIntentServices(intent, 0);
        if (list != null && !list.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
            if (resolveInfo.serviceInfo != null) {
                String string = resolveInfo.serviceInfo.packageName;
                if (resolveInfo.serviceInfo.name != null && zzfx2.zzakw != null && "com.android.vending".equals(string) && zzfx2.zzje()) {
                    Intent intent2 = new Intent(intent);
                    try {
                        boolean bl = ConnectionTracker.getInstance().bindService(zzfx2.zzacr.getContext(), intent2, zzfx2.zzakw, 1);
                        zzfx2.zzacr.zzgg().zzip().zzg("Install Referrer Service is", bl ? "available" : "not available");
                        return;
                    }
                    catch (Exception exception) {
                        zzfx2.zzacr.zzgg().zzil().zzg("Exception occurred while binding to Install Referrer Service", exception.getMessage());
                        return;
                    }
                }
                zzfx2.zzacr.zzgg().zzip().log("Play Store missing or incompatible. Version 8.3.73 or later required");
            }
            return;
        }
        zzfx2.zzacr.zzgg().zzip().log("Play Service for fetching Install Referrer is unavailable on device");
    }

    @VisibleForTesting
    private final boolean zzje() {
        try {
            PackageManagerWrapper packageManagerWrapper = Wrappers.packageManager((Context)this.zzacr.getContext());
            if (packageManagerWrapper == null) {
                this.zzacr.zzgg().zzip().log("Failed to retrieve Package Manager to check Play Store compatibility");
                return false;
            }
            return packageManagerWrapper.getPackageInfo((String)"com.android.vending", (int)128).versionCode >= 80837300;
        }
        catch (Exception exception) {
            this.zzacr.zzgg().zzip().zzg("Failed to retrieve Play Store version", exception);
            return false;
        }
    }

    @WorkerThread
    @Nullable
    @VisibleForTesting
    final Bundle zzjf() {
        Bundle bundle;
        ((zzhj)this.zzacr.zzgf()).zzab();
        if (this.zzakv == null) {
            this.zzacr.zzgg().zzin().log("Attempting to use Install Referrer Service while it is not initialized");
            return null;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putString("package_name", this.zzacr.getContext().getPackageName());
        try {
            bundle = this.zzakv.zza(bundle2);
            if (bundle == null) {
                this.zzacr.zzgg().zzil().log("Install Referrer Service returned a null response");
                return null;
            }
        }
        catch (Exception exception) {
            this.zzacr.zzgg().zzil().zzg("Exception occurred while retrieving the Install Referrer", exception.getMessage());
            return null;
        }
        return bundle;
    }

    @WorkerThread
    @VisibleForTesting
    final void zzc(Bundle bundle) {
        long l;
        ((zzhj)this.zzacr.zzgf()).zzab();
        if (bundle == null) {
            return;
        }
        long l2 = bundle.getLong("install_begin_timestamp_seconds", 0L) * 1000L;
        if (l2 == 0L) {
            this.zzacr.zzgg().zzil().log("Service response is missing Install Referrer install timestamp");
            return;
        }
        String string = bundle.getString("install_referrer");
        if (string == null || string.isEmpty()) {
            this.zzacr.zzgg().zzil().log("No referrer defined in install referrer response");
            return;
        }
        this.zzacr.zzgg().zzir().zzg("InstallReferrer API result", string);
        String string2 = String.valueOf(string);
        Bundle bundle2 = this.zzacr.zzgc().zza(Uri.parse((String)(string2.length() != 0 ? "?".concat(string2) : new String("?"))));
        if (bundle2 == null) {
            this.zzacr.zzgg().zzil().log("No campaign params defined in install referrer result");
            return;
        }
        String string3 = bundle2.getString("medium");
        if (string3 != null && !"(not set)".equalsIgnoreCase(string3) && !"organic".equalsIgnoreCase(string3)) {
            l = bundle.getLong("referrer_click_timestamp_seconds", 0L) * 1000L;
            if (l == 0L) {
                this.zzacr.zzgg().zzil().log("Install Referrer is missing click timestamp for ad campaign");
                return;
            }
            bundle2.putLong("click_timestamp", l);
        }
        if (l2 == (l = this.zzacr.zzgh().zzajz.get())) {
            this.zzacr.zzgg().zzir().log("Campaign has already been logged");
            return;
        }
        bundle2.putString("_cis", "referrer API");
        this.zzacr.zzgh().zzajz.set(l2);
        this.zzacr.zzfu().zza("auto", "_cmp", bundle2);
        if (this.zzakw != null) {
            ConnectionTracker.getInstance().unbindService(this.zzacr.getContext(), this.zzakw);
        }
    }

    static /* synthetic */ zzgl zza(zzfx zzfx2) {
        return zzfx2.zzacr;
    }
}

