/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzgc;
import com.google.android.gms.internal.measurement.zzgd;
import com.google.android.gms.internal.measurement.zzge;
import com.google.android.gms.internal.measurement.zzgl;

public final class zzgb {
    private final zzge zzakz;

    public zzgb(zzge zzge2) {
        Preconditions.checkNotNull((Object)zzge2);
        this.zzakz = zzge2;
    }

    public static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void onReceive(Context context, Intent intent) {
        zzgl zzgl2 = zzgl.zzg(context);
        zzfg zzfg2 = zzgl2.zzgg();
        if (intent == null) {
            zzfg2.zzin().log("Receiver called with null intent");
            return;
        }
        String string = intent.getAction();
        zzfg2.zzir().zzg("Local receiver got", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzfg2.zzir().log("Starting wakeful intent.");
            this.zzakz.doStartService(context, intent2);
            return;
        }
        if ("com.android.vending.INSTALL_REFERRER".equals(string)) {
            try {
                zzgl2.zzgf().zzc(new zzgc(this, zzgl2, zzfg2));
            }
            catch (Exception exception) {
                zzfg2.zzin().zzg("Install Referrer Reporter encountered a problem", exception);
            }
            BroadcastReceiver.PendingResult pendingResult = this.zzakz.doGoAsync();
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzfg2.zzir().log("Install referrer extras are null");
                if (pendingResult != null) {
                    pendingResult.finish();
                }
                return;
            }
            zzfg2.zzip().zzg("Install referrer extras are", string2);
            if (!string2.contains("?")) {
                String string3 = String.valueOf(string2);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            Uri uri = Uri.parse((String)string2);
            Bundle bundle = zzgl2.zzgc().zza(uri);
            if (bundle == null) {
                zzfg2.zzir().log("No campaign defined in install referrer broadcast");
                if (pendingResult != null) {
                    pendingResult.finish();
                    return;
                }
            } else {
                long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzfg2.zzin().log("Install referrer is missing timestamp");
                }
                zzgl2.zzgf().zzc(new zzgd(this, zzgl2, l, bundle, context, zzfg2, pendingResult));
            }
        }
    }
}

