/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzaba;
import com.google.android.gms.internal.measurement.zzabb;
import com.google.android.gms.internal.measurement.zzabd;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.android.gms.internal.measurement.zzjv;
import com.google.android.gms.internal.measurement.zzjy;
import com.google.android.gms.internal.measurement.zzjz;
import com.google.android.gms.internal.measurement.zzka;
import com.google.android.gms.internal.measurement.zzkc;
import com.google.android.gms.internal.measurement.zzke;
import com.google.android.gms.internal.measurement.zzkf;
import com.google.android.gms.internal.measurement.zzkg;
import com.google.android.gms.measurement.AppMeasurement;
import java.io.IOException;
import java.util.Map;

public final class zzgf
extends zzhk {
    @VisibleForTesting
    private static int zzald = 65535;
    @VisibleForTesting
    private static int zzale = 2;
    private final Map<String, Map<String, String>> zzalf = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzalg = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzalh = new ArrayMap();
    private final Map<String, zzkf> zzali = new ArrayMap();
    private final Map<String, Map<String, Integer>> zzalj;
    private final Map<String, String> zzalk = new ArrayMap();

    zzgf(zzgl zzgl2) {
        super(zzgl2);
        this.zzalj = new ArrayMap();
    }

    @WorkerThread
    private final void zzbo(String string) {
        this.zzch();
        ((zzhj)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzali.get(string) == null) {
            byte[] byArray = ((zzhj)this).zzga().zzaz(string);
            if (byArray == null) {
                this.zzalf.put(string, null);
                this.zzalg.put(string, null);
                this.zzalh.put(string, null);
                this.zzali.put(string, null);
                this.zzalk.put(string, null);
                this.zzalj.put(string, null);
                return;
            }
            zzkf zzkf2 = this.zza(string, byArray);
            this.zzalf.put(string, zzgf.zza(zzkf2));
            this.zza(string, zzkf2);
            this.zzali.put(string, zzkf2);
            this.zzalk.put(string, null);
        }
    }

    @WorkerThread
    protected final zzkf zzbp(String string) {
        this.zzch();
        ((zzhj)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        this.zzbo(string);
        return this.zzali.get(string);
    }

    @WorkerThread
    protected final String zzbq(String string) {
        ((zzhj)this).zzab();
        return this.zzalk.get(string);
    }

    @WorkerThread
    protected final void zzbr(String string) {
        ((zzhj)this).zzab();
        this.zzalk.put(string, null);
    }

    @WorkerThread
    final void zzbs(String string) {
        ((zzhj)this).zzab();
        this.zzali.remove(string);
    }

    @WorkerThread
    final String zzm(String string, String string2) {
        ((zzhj)this).zzab();
        this.zzbo(string);
        Map<String, String> map = this.zzalf.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    private static Map<String, String> zza(zzkf zzkf2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzkf2 != null && zzkf2.zzasm != null) {
            zzkg[] zzkgArray = zzkf2.zzasm;
            int n = zzkf2.zzasm.length;
            for (int i = 0; i < n; ++i) {
                zzkg zzkg2 = zzkgArray[i];
                if (zzkg2 == null) continue;
                arrayMap.put(zzkg2.zznt, zzkg2.value);
            }
        }
        return arrayMap;
    }

    private final void zza(String string, zzkf zzkf2) {
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zzkf2 != null && zzkf2.zzasn != null) {
            zzke[] zzkeArray = zzkf2.zzasn;
            int n = zzkf2.zzasn.length;
            for (int i = 0; i < n; ++i) {
                zzke zzke2 = zzkeArray[i];
                if (TextUtils.isEmpty((CharSequence)zzke2.name)) {
                    ((zzhj)this).zzgg().zzin().log("EventConfig contained null event name");
                    continue;
                }
                String string2 = AppMeasurement.Event.zzak(zzke2.name);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    zzke2.name = string2;
                }
                arrayMap.put(zzke2.name, zzke2.zzash);
                arrayMap2.put(zzke2.name, zzke2.zzasi);
                if (zzke2.zzasj == null) continue;
                if (zzke2.zzasj < zzale || zzke2.zzasj > zzald) {
                    ((zzhj)this).zzgg().zzin().zze("Invalid sampling rate. Event name, sample rate", zzke2.name, zzke2.zzasj);
                    continue;
                }
                arrayMap3.put(zzke2.name, zzke2.zzasj);
            }
        }
        this.zzalg.put(string, (Map<String, Boolean>)arrayMap);
        this.zzalh.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzalj.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    protected final boolean zza(String string, byte[] byArray, String string2) {
        this.zzch();
        ((zzhj)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        zzkf zzkf2 = this.zza(string, byArray);
        if (zzkf2 == null) {
            return false;
        }
        this.zza(string, zzkf2);
        this.zzali.put(string, zzkf2);
        this.zzalk.put(string, string2);
        this.zzalf.put(string, zzgf.zza(zzkf2));
        Object object = zzkf2.zzaso;
        String string3 = string;
        Object object2 = ((zzhj)this).zzft();
        Preconditions.checkNotNull((Object)object);
        for (zzjy zzjy2 : object) {
            String string4;
            zzjz zzjz2;
            int n;
            zzabd[] zzabdArray = zzjy2.zzari;
            int n2 = zzjy2.zzari.length;
            for (n = 0; n < n2; ++n) {
                zzjz2 = zzabdArray[n];
                string4 = AppMeasurement.Event.zzak(zzjz2.zzarl);
                if (string4 != null) {
                    zzjz2.zzarl = string4;
                }
                zzka[] zzkaArray = zzjz2.zzarm;
                int n3 = zzjz2.zzarm.length;
                for (int i = 0; i < n3; ++i) {
                    zzka zzka2 = zzkaArray[i];
                    String string5 = AppMeasurement.Param.zzak(zzka2.zzart);
                    if (string5 == null) continue;
                    zzka2.zzart = string5;
                }
            }
            zzabdArray = zzjy2.zzarh;
            n2 = zzjy2.zzarh.length;
            for (n = 0; n < n2; ++n) {
                zzjz2 = zzabdArray[n];
                string4 = AppMeasurement.UserProperty.zzak(((zzkc)((Object)zzjz2)).zzasa);
                if (string4 == null) continue;
                ((zzkc)((Object)zzjz2)).zzasa = string4;
            }
        }
        ((zzhj)object2).zzga().zza(string3, (zzjy[])object);
        try {
            zzkf2.zzaso = null;
            byte[] byArray2 = new byte[zzkf2.zzwg()];
            object2 = byArray2;
            zzabb zzabb2 = zzabb.zzb((byte[])byArray2, (int)0, (int)((Object)object2).length);
            zzkf2.zza(zzabb2);
            byArray = byArray2;
        }
        catch (IOException iOException) {
            ((zzhj)this).zzgg().zzin().zze("Unable to serialize reduced-size config. Storing full config instead. appId", zzfg.zzbh(string), iOException);
        }
        object = byArray;
        string3 = string;
        object2 = ((zzhj)this).zzga();
        Preconditions.checkNotEmpty((String)string3);
        ((zzhj)object2).zzab();
        ((zzhk)object2).zzch();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", (byte[])object);
        try {
            if ((long)((zzei)object2).getWritableDatabase().update("apps", contentValues, "app_id = ?", new String[]{string3}) == 0L) {
                ((zzhj)object2).zzgg().zzil().zzg("Failed to update remote config (got 0). appId", zzfg.zzbh(string3));
            }
        }
        catch (SQLiteException sQLiteException) {
            ((zzhj)object2).zzgg().zzil().zze("Error storing remote config. appId", zzfg.zzbh(string3), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    final boolean zzn(String string, String string2) {
        ((zzhj)this).zzab();
        this.zzbo(string);
        if (((zzhj)this).zzgc().zzce(string) && zzjv.zzcb(string2)) {
            return true;
        }
        if (((zzhj)this).zzgc().zzcf(string) && zzjv.zzbv(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzalg.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzo(String string, String string2) {
        ((zzhj)this).zzab();
        this.zzbo(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzalh.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final int zzp(String string, String string2) {
        ((zzhj)this).zzab();
        this.zzbo(string);
        Map<String, Integer> map = this.zzalj.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    private final zzkf zza(String string, byte[] byArray) {
        if (byArray == null) {
            return new zzkf();
        }
        byte[] byArray2 = byArray;
        zzaba zzaba2 = zzaba.zza((byte[])byArray, (int)0, (int)byArray2.length);
        zzkf zzkf2 = new zzkf();
        try {
            zzkf2.zzb(zzaba2);
            ((zzhj)this).zzgg().zzir().zze("Parsed config. version, gmp_app_id", zzkf2.zzask, zzkf2.zzadh);
        }
        catch (IOException iOException) {
            ((zzhj)this).zzgg().zzin().zze("Unable to merge remote config. appId", zzfg.zzbh(string), iOException);
            return new zzkf();
        }
        return zzkf2;
    }

    @Override
    protected final boolean zzhh() {
        return false;
    }
}

