/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.os.Looper;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzgi;
import com.google.android.gms.internal.measurement.zzgj;
import com.google.android.gms.internal.measurement.zzgk;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzhk;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class zzgg
extends zzhk {
    private ExecutorService zzall;
    private zzgk zzalm;
    private zzgk zzaln;
    private final PriorityBlockingQueue<zzgj<?>> zzalo;
    private final BlockingQueue<zzgj<?>> zzalp;
    private final Thread.UncaughtExceptionHandler zzalq;
    private final Thread.UncaughtExceptionHandler zzalr;
    private final Object zzals = new Object();
    private final Semaphore zzalt = new Semaphore(2);
    private volatile boolean zzalu;
    private static final AtomicLong zzalv = new AtomicLong(Long.MIN_VALUE);

    zzgg(zzgl zzgl2) {
        super(zzgl2);
        this.zzalo = new PriorityBlockingQueue();
        this.zzalp = new LinkedBlockingQueue();
        this.zzalq = new zzgi(this, "Thread death: Uncaught exception on worker thread");
        this.zzalr = new zzgi(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzhh() {
        return false;
    }

    @Override
    public final void zzab() {
        if (Thread.currentThread() != this.zzalm) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzfr() {
        if (Thread.currentThread() != this.zzaln) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public final boolean zzjg() {
        return Thread.currentThread() == this.zzalm;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzch();
        Preconditions.checkNotNull(callable);
        zzgj zzgj2 = new zzgj(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzalm) {
            if (!this.zzalo.isEmpty()) {
                ((zzhj)this).zzgg().zzin().log("Callable skipped the worker queue.");
            }
            zzgj2.run();
        } else {
            this.zza(zzgj2);
        }
        return zzgj2;
    }

    public final <V> Future<V> zzc(Callable<V> callable) throws IllegalStateException {
        this.zzch();
        Preconditions.checkNotNull(callable);
        zzgj zzgj2 = new zzgj(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzalm) {
            zzgj2.run();
        } else {
            this.zza(zzgj2);
        }
        return zzgj2;
    }

    public final void zzc(Runnable runnable) throws IllegalStateException {
        this.zzch();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzgj(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzgj<?> zzgj2) {
        Object object = this.zzals;
        synchronized (object) {
            this.zzalo.add(zzgj2);
            if (this.zzalm == null) {
                this.zzalm = new zzgk(this, "Measurement Worker", this.zzalo);
                this.zzalm.setUncaughtExceptionHandler(this.zzalq);
                this.zzalm.start();
            } else {
                this.zzalm.zzjj();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzd(Runnable runnable) throws IllegalStateException {
        this.zzch();
        Preconditions.checkNotNull((Object)runnable);
        zzgj zzgj2 = new zzgj(this, runnable, false, "Task exception on network thread");
        zzgg zzgg2 = this;
        Object object = zzgg2.zzals;
        synchronized (object) {
            zzgg2.zzalp.add(zzgj2);
            if (zzgg2.zzaln == null) {
                zzgg2.zzaln = new zzgk(zzgg2, "Measurement Network", zzgg2.zzalp);
                zzgg2.zzaln.setUncaughtExceptionHandler(zzgg2.zzalr);
                zzgg2.zzaln.start();
            } else {
                zzgg2.zzaln.zzjj();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecutorService zzjh() {
        Object object = this.zzals;
        synchronized (object) {
            if (this.zzall == null) {
                this.zzall = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzall;
        }
    }

    static /* synthetic */ Semaphore zza(zzgg zzgg2) {
        return zzgg2.zzalt;
    }

    static /* synthetic */ boolean zzb(zzgg zzgg2) {
        return zzgg2.zzalu;
    }

    static /* synthetic */ Object zzc(zzgg zzgg2) {
        return zzgg2.zzals;
    }

    static /* synthetic */ zzgk zzd(zzgg zzgg2) {
        return zzgg2.zzalm;
    }

    static /* synthetic */ zzgk zza(zzgg zzgg2, zzgk zzgk2) {
        zzgg2.zzalm = null;
        return null;
    }

    static /* synthetic */ zzgk zze(zzgg zzgg2) {
        return zzgg2.zzaln;
    }

    static /* synthetic */ zzgk zzb(zzgg zzgg2, zzgk zzgk2) {
        zzgg2.zzaln = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzji() {
        return zzalv;
    }
}

