/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzaba;
import com.google.android.gms.internal.measurement.zzabb;
import com.google.android.gms.internal.measurement.zzdx;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzek;
import com.google.android.gms.internal.measurement.zzeo;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfc;
import com.google.android.gms.internal.measurement.zzfe;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzfo;
import com.google.android.gms.internal.measurement.zzfp;
import com.google.android.gms.internal.measurement.zzfr;
import com.google.android.gms.internal.measurement.zzfx;
import com.google.android.gms.internal.measurement.zzgb;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzgo;
import com.google.android.gms.internal.measurement.zzgp;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.android.gms.internal.measurement.zzhl;
import com.google.android.gms.internal.measurement.zzhm;
import com.google.android.gms.internal.measurement.zzif;
import com.google.android.gms.internal.measurement.zzih;
import com.google.android.gms.internal.measurement.zzil;
import com.google.android.gms.internal.measurement.zzjf;
import com.google.android.gms.internal.measurement.zzjk;
import com.google.android.gms.internal.measurement.zzjq;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzju;
import com.google.android.gms.internal.measurement.zzjv;
import com.google.android.gms.internal.measurement.zzkf;
import com.google.android.gms.internal.measurement.zzkh;
import com.google.android.gms.internal.measurement.zzki;
import com.google.android.gms.internal.measurement.zzkj;
import com.google.android.gms.internal.measurement.zzkk;
import com.google.android.gms.internal.measurement.zzkl;
import com.google.android.gms.internal.measurement.zzkn;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class zzgl {
    private static volatile zzgl zzamc;
    private final Context zzqs;
    private final zzeh zzamd;
    private final zzfr zzame;
    private final zzfg zzamf;
    private final zzgg zzamg;
    private final zzjk zzamh;
    private final zzgf zzami;
    private final AppMeasurement zzamj;
    private final FirebaseAnalytics zzamk;
    private final zzjv zzaml;
    private final zzfe zzamm;
    private final zzfk zzamn;
    private final Clock zzrj;
    private final zzih zzamo;
    private final zzhm zzamp;
    private final zzdx zzamq;
    private zzei zzamr;
    private zzfc zzams;
    private zzil zzamt;
    private zzeo zzamu;
    private zzfb zzamv;
    private zzfp zzamw;
    private zzjq zzamx;
    private zzee zzamy;
    private zzfx zzamz;
    private boolean zzvj = false;
    private boolean zzana;
    private Boolean zzanb;
    private long zzanc;
    private FileLock zzand;
    private FileChannel zzane;
    private List<Long> zzanf;
    private List<Runnable> zzang;
    private int zzanh;
    private int zzani;
    private long zzanj;
    @VisibleForTesting
    private long zzank;
    private boolean zzanl;
    private boolean zzanm;
    private boolean zzann;
    private final long zzaeh;

    private zzgl(zzhl zzhl2) {
        zzdx zzdx2;
        Preconditions.checkNotNull((Object)zzhl2);
        this.zzqs = zzhl2.zzqs;
        this.zzanj = -1L;
        this.zzrj = DefaultClock.getInstance();
        this.zzaeh = this.zzrj.currentTimeMillis();
        zzgl zzgl2 = this;
        this.zzamd = new zzeh(zzgl2);
        zzgl2 = this;
        zzfr zzfr2 = new zzfr(zzgl2);
        zzfr2.zzm();
        this.zzame = zzfr2;
        zzgl2 = this;
        zzfg zzfg2 = new zzfg(zzgl2);
        zzfg2.zzm();
        this.zzamf = zzfg2;
        zzgl2 = this;
        zzjv zzjv2 = new zzjv(zzgl2);
        zzjv2.zzm();
        this.zzaml = zzjv2;
        zzgl2 = this;
        zzfe zzfe2 = new zzfe(zzgl2);
        zzfe2.zzm();
        this.zzamm = zzfe2;
        zzgl2 = this;
        this.zzamq = zzdx2 = new zzdx(zzgl2);
        zzgl2 = this;
        zzfk zzfk2 = new zzfk(zzgl2);
        zzfk2.zzm();
        this.zzamn = zzfk2;
        zzgl2 = this;
        zzih zzih2 = new zzih(zzgl2);
        zzih2.zzm();
        this.zzamo = zzih2;
        zzgl2 = this;
        zzhm zzhm2 = new zzhm(zzgl2);
        zzhm2.zzm();
        this.zzamp = zzhm2;
        zzgl2 = this;
        this.zzamj = new AppMeasurement(zzgl2);
        zzgl2 = this;
        this.zzamk = new FirebaseAnalytics(zzgl2);
        zzgl2 = this;
        zzjk zzjk2 = new zzjk(zzgl2);
        zzjk2.zzm();
        this.zzamh = zzjk2;
        zzgl2 = this;
        zzgf zzgf2 = new zzgf(zzgl2);
        zzgf2.zzm();
        this.zzami = zzgf2;
        zzgl2 = this;
        zzgg zzgg2 = new zzgg(zzgl2);
        zzgg2.zzm();
        this.zzamg = zzgg2;
        zzgl2 = this;
        if (zzgl2.zzqs.getApplicationContext() instanceof Application) {
            zzhm zzhm3 = zzgl2.zzfu();
            if (((zzhj)zzhm3).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzhj)zzhm3).getContext().getApplicationContext();
                if (zzhm3.zzaoi == null) {
                    zzhm3.zzaoi = new zzif(zzhm3, null);
                }
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhm3.zzaoi);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhm3.zzaoi);
                ((zzhj)zzhm3).zzgg().zzir().log("Registered activity lifecycle callback");
            }
        } else {
            zzgl2.zzgg().zzin().log("Application context is not an Application");
        }
        this.zzamg.zzc(new zzgm(this, zzhl2));
    }

    @WorkerThread
    protected final boolean zzjk() {
        this.zzch();
        ((zzhj)this.zzgf()).zzab();
        if (this.zzanb == null || this.zzanc == 0L || this.zzanb != null && !this.zzanb.booleanValue() && Math.abs(this.zzrj.elapsedRealtime() - this.zzanc) > 1000L) {
            this.zzanc = this.zzrj.elapsedRealtime();
            this.zzanb = this.zzgc().zzx("android.permission.INTERNET") && this.zzgc().zzx("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzqs).isCallerInstantApp() || zzgb.zza(this.zzqs) && zzjf.zza(this.zzqs, false));
            if (this.zzanb.booleanValue()) {
                this.zzanb = this.zzgc().zzbz(this.zzfv().getGmpAppId());
            }
        }
        return this.zzanb;
    }

    @WorkerThread
    private final void zza(zzhl zzhl2) {
        String string;
        zzfi zzfi2;
        ((zzhj)this.zzgf()).zzab();
        zzgl zzgl2 = this;
        zzeo zzeo2 = new zzeo(zzgl2);
        zzeo2.zzm();
        this.zzamu = zzeo2;
        zzgl2 = this;
        zzfb zzfb2 = new zzfb(zzgl2);
        zzfb2.zzm();
        this.zzamv = zzfb2;
        zzgl2 = this;
        zzei zzei2 = new zzei(zzgl2);
        zzei2.zzm();
        this.zzamr = zzei2;
        zzgl2 = this;
        zzfc zzfc2 = new zzfc(zzgl2);
        zzfc2.zzm();
        this.zzams = zzfc2;
        zzgl2 = this;
        zzee zzee2 = new zzee(zzgl2);
        zzee2.zzm();
        this.zzamy = zzee2;
        zzgl2 = this;
        zzil zzil2 = new zzil(zzgl2);
        zzil2.zzm();
        this.zzamt = zzil2;
        zzgl2 = this;
        zzjq zzjq2 = new zzjq(zzgl2);
        zzjq2.zzm();
        this.zzamx = zzjq2;
        zzgl2 = this;
        this.zzamw = new zzfp(zzgl2);
        this.zzaml.zzkd();
        this.zzame.zzkd();
        zzgl2 = this;
        this.zzamz = new zzfx(zzgl2);
        this.zzamv.zzkd();
        this.zzgg().zzip().zzg("App measurement is starting up, version", 12451L);
        this.zzgg().zzip().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string2 = zzfb2.zzah();
        if (this.zzgc().zzcc(string2)) {
            zzfi2 = this.zzgg().zzip();
            string = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
        } else {
            zzfi2 = this.zzgg().zzip();
            String string3 = String.valueOf(string2);
            string = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
        }
        zzfi2.log(string);
        this.zzgg().zziq().log("Debug-level message logging enabled");
        if (this.zzanh != this.zzani) {
            this.zzgg().zzil().zze("Not all components initialized", this.zzanh, this.zzani);
        }
        this.zzvj = true;
    }

    @WorkerThread
    protected final void start() {
        ((zzhj)this.zzgf()).zzab();
        this.zzga().zzhp();
        if (this.zzgh().zzajt.get() == 0L) {
            this.zzgh().zzajt.set(this.zzrj.currentTimeMillis());
        }
        if (Long.valueOf(this.zzgh().zzajy.get()) == 0L) {
            this.zzgg().zzir().zzg("Persisting first open", this.zzaeh);
            this.zzgh().zzajy.set(this.zzaeh);
        }
        if (!this.zzjk()) {
            if (this.isEnabled()) {
                if (!this.zzgc().zzx("android.permission.INTERNET")) {
                    this.zzgg().zzil().log("App is missing INTERNET permission");
                }
                if (!this.zzgc().zzx("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzgg().zzil().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!Wrappers.packageManager((Context)this.zzqs).isCallerInstantApp()) {
                    if (!zzgb.zza(this.zzqs)) {
                        this.zzgg().zzil().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzjf.zza(this.zzqs, false)) {
                        this.zzgg().zzil().log("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzgg().zzil().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzfv().getGmpAppId())) {
                String string = this.zzgh().zziv();
                if (string == null) {
                    this.zzgh().zzbl(this.zzfv().getGmpAppId());
                } else if (!string.equals(this.zzfv().getGmpAppId())) {
                    this.zzgg().zzip().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzgh().zziy();
                    this.zzamt.disconnect();
                    this.zzamt.zzdf();
                    this.zzgh().zzbl(this.zzfv().getGmpAppId());
                    this.zzgh().zzajy.set(this.zzaeh);
                    this.zzgh().zzaka.zzbn(null);
                }
            }
            this.zzfu().zzbm(this.zzgh().zzaka.zzjc());
            if (!TextUtils.isEmpty((CharSequence)this.zzfv().getGmpAppId())) {
                boolean bl = this.isEnabled();
                if (!this.zzgh().zzjb() && !this.zzamd.zzhi()) {
                    this.zzgh().zzh(!bl);
                }
                if (!this.zzamd.zzav(this.zzfv().zzah()) || bl) {
                    this.zzfu().zzkj();
                }
                this.zzfx().zza(new AtomicReference<String>());
            }
        }
        this.zzjy();
    }

    public final zzeh zzgi() {
        return this.zzamd;
    }

    public final zzfr zzgh() {
        zzgl.zza((zzhj)this.zzame);
        return this.zzame;
    }

    public final zzfg zzgg() {
        zzgl.zza(this.zzamf);
        return this.zzamf;
    }

    public final zzfg zzjl() {
        if (this.zzamf != null && this.zzamf.isInitialized()) {
            return this.zzamf;
        }
        return null;
    }

    public final zzgg zzgf() {
        zzgl.zza(this.zzamg);
        return this.zzamg;
    }

    public final zzjk zzge() {
        zzgl.zza(this.zzamh);
        return this.zzamh;
    }

    public final zzgf zzgd() {
        zzgl.zza(this.zzami);
        return this.zzami;
    }

    public final zzfx zzjm() {
        return this.zzamz;
    }

    final zzgg zzjn() {
        return this.zzamg;
    }

    public final zzhm zzfu() {
        zzgl.zza(this.zzamp);
        return this.zzamp;
    }

    public final AppMeasurement zzjo() {
        return this.zzamj;
    }

    public final FirebaseAnalytics zzjp() {
        return this.zzamk;
    }

    public final zzjv zzgc() {
        zzgl.zza((zzhj)this.zzaml);
        return this.zzaml;
    }

    public final zzfe zzgb() {
        zzgl.zza((zzhj)this.zzamm);
        return this.zzamm;
    }

    public final zzei zzga() {
        zzgl.zza(this.zzamr);
        return this.zzamr;
    }

    public final zzfc zzfz() {
        zzgl.zza(this.zzams);
        return this.zzams;
    }

    public final zzfk zzjq() {
        zzgl.zza(this.zzamn);
        return this.zzamn;
    }

    public final Context getContext() {
        return this.zzqs;
    }

    public final Clock zzbt() {
        return this.zzrj;
    }

    public final zzih zzfy() {
        zzgl.zza(this.zzamo);
        return this.zzamo;
    }

    public final zzil zzfx() {
        zzgl.zza(this.zzamt);
        return this.zzamt;
    }

    public final zzeo zzfw() {
        zzgl.zza(this.zzamu);
        return this.zzamu;
    }

    public final zzfb zzfv() {
        zzgl.zza(this.zzamv);
        return this.zzamv;
    }

    private final zzfp zzjr() {
        if (this.zzamw == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzamw;
    }

    private final zzjq zzjs() {
        zzgl.zza(this.zzamx);
        return this.zzamx;
    }

    public final zzee zzft() {
        zzgl.zza(this.zzamy);
        return this.zzamy;
    }

    public final zzdx zzfs() {
        zzgl.zza(this.zzamq);
        return this.zzamq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzgl zzg(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzamc != null) return zzamc;
        Class<zzgl> clazz = zzgl.class;
        synchronized (zzgl.class) {
            if (zzamc != null) return zzamc;
            zzhl zzhl2 = new zzhl(context);
            zzamc = new zzgl(zzhl2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzamc;
        }
    }

    @VisibleForTesting
    final void zzd(zzec zzec2) {
        String string = zzec2.packageName;
        zzei zzei2 = this.zzga();
        Preconditions.checkNotEmpty((String)string);
        zzei2.zzab();
        zzei2.zzch();
        try {
            SQLiteDatabase sQLiteDatabase = zzei2.getWritableDatabase();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzei2.zzgg().zzir().zze("Reset analytics data. app, records", string, n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzei2.zzgg().zzil().zze("Error resetting analytics data. appId, error", zzfg.zzbh(string), (Object)sQLiteException);
        }
        zzec zzec3 = this.zza(this.zzqs, zzec2.packageName, zzec2.zzadh, zzec2.zzadr, zzec2.zzadt, zzec2.zzadu);
        if (!this.zzamd.zzav(zzec2.packageName) || zzec2.zzadr) {
            this.zzg(zzec3);
        }
    }

    private final zzec zza(Context context, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        String string3 = "Unknown";
        String string4 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string5 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzgg().zzil().log("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string3 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzgg().zzil().zzg("Error retrieving installer package name. appId", zzfg.zzbh(string));
        }
        if (string3 == null) {
            string3 = "manual_install";
        } else if ("com.android.vending".equals(string3)) {
            string3 = "";
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = Wrappers.packageManager((Context)context).getApplicationLabel(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string5 = charSequence.toString();
                }
                string4 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzgg().zzil().zze("Error retrieving newly installed package info. appId, appName", zzfg.zzbh(string), string5);
            return null;
        }
        return new zzec(string, string2, string4, n, string3, 12451L, this.zzgc().zzd(context, string), null, bl, false, "", 0L, 0L, 0, bl2, bl3, false);
    }

    final void zzch() {
        if (!this.zzvj) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zza(zzhk zzhk2) {
        if (zzhk2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzhk2.isInitialized()) {
            String string = String.valueOf(zzhk2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzhj zzhj2) {
        if (zzhj2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzjt() {
        ((zzhj)this.zzgf()).zzab();
        String string = "google_app_measurement.db";
        File file = this.zzqs.getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzane = new RandomAccessFile(file2, "rw").getChannel();
            this.zzand = this.zzane.tryLock();
            if (this.zzand != null) {
                this.zzgg().zzir().log("Storage concurrent access okay");
                return true;
            }
            this.zzgg().zzil().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzgg().zzil().zzg("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzgg().zzil().zzg("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        ((zzhj)this.zzgf()).zzab();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzgg().zzil().log("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzgg().zzin().zzg("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzgg().zzil().zzg("Failed to read from channel", iOException);
        }
        return n;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        ((zzhj)this.zzgf()).zzab();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzgg().zzil().log("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzgg().zzil().zzg("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzgg().zzil().zzg("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public final boolean isEnabled() {
        ((zzhj)this.zzgf()).zzab();
        this.zzch();
        if (this.zzamd.zzhi()) {
            return false;
        }
        Boolean bl = this.zzamd.zzas("firebase_analytics_collection_enabled");
        boolean bl2 = bl != null ? bl : !GoogleServices.isMeasurementExplicitlyDisabled();
        return this.zzgh().zzg(bl2);
    }

    final void zze(zzec zzec2) {
        ((zzhj)this.zzgf()).zzab();
        this.zzch();
        Preconditions.checkNotEmpty((String)zzec2.packageName);
        this.zzh(zzec2);
    }

    final long zzju() {
        Long l = this.zzgh().zzajy.get();
        if (l == 0L) {
            return this.zzaeh;
        }
        return Math.min(this.zzaeh, l);
    }

    private final long zzjv() {
        long l = this.zzrj.currentTimeMillis();
        zzfr zzfr2 = this.zzgh();
        zzfr2.zzch();
        zzfr2.zzab();
        long l2 = zzfr2.zzajx.get();
        if (l2 == 0L) {
            l2 = 1L + (long)zzfr2.zzgc().zzku().nextInt(86400000);
            zzfr2.zzajx.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    private final zzec zzbt(String string) {
        zzeb zzeb2 = this.zzga().zzax(string);
        if (zzeb2 == null || TextUtils.isEmpty((CharSequence)zzeb2.zzag())) {
            this.zzgg().zziq().zzg("No app data available; dropping", string);
            return null;
        }
        Boolean bl = this.zzc(zzeb2);
        if (bl != null && !bl.booleanValue()) {
            this.zzgg().zzil().zzg("App version does not match; dropping. appId", zzfg.zzbh(string));
            return null;
        }
        return new zzec(string, zzeb2.getGmpAppId(), zzeb2.zzag(), zzeb2.zzgo(), zzeb2.zzgp(), zzeb2.zzgq(), zzeb2.zzgr(), null, zzeb2.isMeasurementEnabled(), false, zzeb2.zzgl(), zzeb2.zzhe(), 0L, 0, zzeb2.zzhf(), zzeb2.zzhg(), false);
    }

    @WorkerThread
    final void zzb(zzeu zzeu2, String string) {
        zzeb zzeb2 = this.zzga().zzax(string);
        if (zzeb2 == null || TextUtils.isEmpty((CharSequence)zzeb2.zzag())) {
            this.zzgg().zziq().zzg("No app data available; dropping event", string);
            return;
        }
        Boolean bl = this.zzc(zzeb2);
        if (bl == null) {
            if (!"_ui".equals(zzeu2.name)) {
                this.zzgg().zzin().zzg("Could not find package. appId", zzfg.zzbh(string));
            }
        } else if (!bl.booleanValue()) {
            this.zzgg().zzil().zzg("App version does not match; dropping event. appId", zzfg.zzbh(string));
            return;
        }
        zzec zzec2 = new zzec(string, zzeb2.getGmpAppId(), zzeb2.zzag(), zzeb2.zzgo(), zzeb2.zzgp(), zzeb2.zzgq(), zzeb2.zzgr(), null, zzeb2.isMeasurementEnabled(), false, zzeb2.zzgl(), zzeb2.zzhe(), 0L, 0, zzeb2.zzhf(), zzeb2.zzhg(), false);
        this.zzb(zzeu2, zzec2);
    }

    @WorkerThread
    final void zzb(zzeu zzeu2, zzec zzec2) {
        Preconditions.checkNotNull((Object)((Object)zzec2));
        Preconditions.checkNotEmpty((String)zzec2.packageName);
        ((zzhj)this.zzgf()).zzab();
        this.zzch();
        String string = zzec2.packageName;
        long l = zzeu2.zzafz;
        this.zzgc();
        if (!zzjv.zzd(zzeu2, zzec2)) {
            return;
        }
        if (!zzec2.zzadr) {
            this.zzh(zzec2);
            return;
        }
        this.zzga().beginTransaction();
        try {
            AbstractSafeParcelable abstractSafeParcelable;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzei zzei2 = this.zzga();
            Preconditions.checkNotEmpty((String)string3);
            zzei2.zzab();
            zzei2.zzch();
            if (l2 < 0L) {
                zzei2.zzgg().zzin().zze("Invalid time querying timed out conditional properties", zzfg.zzbh(string3), l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzei2.zzb(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzgg().zziq().zzd("User property timed out", object22.packageName, this.zzgb().zzbg(object22.zzael.name), object22.zzael.getValue());
                if (object22.zzaep != null) {
                    this.zzc(new zzeu(object22.zzaep, l), zzec2);
                }
                this.zzga().zzi(string, object22.zzael.name);
            }
            l2 = l;
            string3 = string;
            zzei2 = this.zzga();
            Preconditions.checkNotEmpty((String)string3);
            zzei2.zzab();
            zzei2.zzch();
            if (l2 < 0L) {
                zzei2.zzgg().zzin().zze("Invalid time querying expired conditional properties", zzfg.zzbh(string3), l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzei2.zzb(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzef)((Object)object4.next());
                if (object == null) continue;
                this.zzgg().zziq().zzd("User property expired", object.packageName, this.zzgb().zzbg(object.zzael.name), object.zzael.getValue());
                this.zzga().zzf(string, object.zzael.name);
                if (object.zzaet != null) {
                    object22.add(object.zzaet);
                }
                this.zzga().zzi(string, object.zzael.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzeu)((Object)e);
                this.zzc(new zzeu((zzeu)((Object)object), l), zzec2);
            }
            long l3 = l;
            String string4 = zzeu2.name;
            string3 = string;
            zzei2 = this.zzga();
            Preconditions.checkNotEmpty((String)string3);
            Preconditions.checkNotEmpty((String)string4);
            zzei2.zzab();
            zzei2.zzch();
            if (l3 < 0L) {
                zzei2.zzgg().zzin().zzd("Invalid time querying triggered conditional properties", zzfg.zzbh(string3), zzei2.zzgb().zzbe(string4), l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzei2.zzb((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                abstractSafeParcelable = (zzef)((Object)iterator.next());
                if (abstractSafeParcelable == null) continue;
                zzjs zzjs2 = abstractSafeParcelable.zzael;
                zzju zzju2 = new zzju(abstractSafeParcelable.packageName, abstractSafeParcelable.zzaek, zzjs2.name, l, zzjs2.getValue());
                if (this.zzga().zza(zzju2)) {
                    this.zzgg().zziq().zzd("User property triggered", abstractSafeParcelable.packageName, this.zzgb().zzbg(zzju2.name), zzju2.value);
                } else {
                    this.zzgg().zzil().zzd("Too many active user properties, ignoring", zzfg.zzbh(abstractSafeParcelable.packageName), this.zzgb().zzbg(zzju2.name), zzju2.value);
                }
                if (abstractSafeParcelable.zzaer != null) {
                    object.add(abstractSafeParcelable.zzaer);
                }
                abstractSafeParcelable.zzael = new zzjs(zzju2);
                abstractSafeParcelable.zzaen = true;
                this.zzga().zza((zzef)abstractSafeParcelable);
            }
            this.zzc(zzeu2, zzec2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                abstractSafeParcelable = (zzeu)((Object)e);
                this.zzc(new zzeu((zzeu)abstractSafeParcelable, l), zzec2);
            }
            this.zzga().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzga().endTransaction();
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final void zzc(zzeu var1_1, zzec var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.packageName);
        var3_3 = System.nanoTime();
        this.zzgf().zzab();
        this.zzch();
        var5_4 = var2_2.packageName;
        this.zzgc();
        if (!zzjv.zzd(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzadr) {
            this.zzh(var2_2);
            return;
        }
        if (this.zzgd().zzn(var5_4, var1_1.name)) {
            this.zzgg().zzin().zze("Dropping blacklisted event. appId", zzfg.zzbh(var5_4), this.zzgb().zzbe(var1_1.name));
            var6_5 = this.zzgc().zzce(var5_4) != false || this.zzgc().zzcf(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.name)) {
                this.zzgc().zza(var5_4, 11, "_ev", var1_1.name, 0);
            }
            if (var6_5 && (var7_7 = this.zzga().zzax(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzgu(), var7_7.zzgt());
                if (Math.abs(this.zzrj.currentTimeMillis() - var8_9) > zzew.zzahk.get()) {
                    this.zzgg().zziq().log("Fetching config for blacklisted app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        if (this.zzgg().isLoggable(2)) {
            this.zzgg().zzir().zzg("Logging event", this.zzgb().zzb(var1_1));
        }
        this.zzga().beginTransaction();
        try {
            block45: {
                block46: {
                    this.zzh(var2_2);
                    if (("_iap".equals(var1_1.name) || "ecommerce_purchase".equals(var1_1.name)) && !this.zza(var5_4, var1_1)) {
                        this.zzga().setTransactionSuccessful();
                        return;
                    }
                    var6_6 = zzjv.zzbv(var1_1.name);
                    var7_8 = "_err".equals(var1_1.name);
                    var8_10 = this.zzga().zza(this.zzjv(), var5_4, true, var6_6, false, var7_8, false);
                    var9_11 = var8_10.zzafd - (long)zzew.zzagv.get().intValue();
                    if (var9_11 > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzgg().zzil().zze("Data loss. Too many events logged. appId, count", zzfg.zzbh(var5_4), var8_10.zzafd);
                        }
                        this.zzga().setTransactionSuccessful();
                        return;
                    }
                    if (var6_6 && (var9_11 = var8_10.zzafc - (long)zzew.zzagx.get().intValue()) > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzgg().zzil().zze("Data loss. Too many public events logged. appId, count", zzfg.zzbh(var5_4), var8_10.zzafc);
                        }
                        this.zzgc().zza(var5_4, 16, "_ev", var1_1.name, 0);
                        this.zzga().setTransactionSuccessful();
                        return;
                    }
                    if (var7_8) {
                        var19_12 = var2_2.packageName;
                        var20_13 = this.zzamd.zzb((String)var19_12, zzew.zzagw);
                        var9_11 = var8_10.zzaff - (long)Math.max(0, var20_13 = Math.min(1000000, var20_13));
                        if (var9_11 > 0L) {
                            if (var9_11 == 1L) {
                                this.zzgg().zzil().zze("Too many error events logged. appId, count", zzfg.zzbh(var5_4), var8_10.zzaff);
                            }
                            this.zzga().setTransactionSuccessful();
                            return;
                        }
                    }
                    var11_15 = var1_1.zzafo.zzif();
                    this.zzgc().zza(var11_15, "_o", (Object)var1_1.zzaek);
                    if (this.zzgc().zzcc(var5_4)) {
                        this.zzgc().zza(var11_15, "_dbg", 1L);
                        this.zzgc().zza(var11_15, "_r", 1L);
                    }
                    if ((var12_16 = this.zzga().zzay(var5_4)) > 0L) {
                        this.zzgg().zzin().zze("Data lost. Too many events stored on disk, deleted. appId", zzfg.zzbh(var5_4), var12_16);
                    }
                    var14_17 = new zzep(this, var1_1.zzaek, var5_4, var1_1.name, var1_1.zzafz, 0L, var11_15);
                    var15_18 = this.zzga().zze(var5_4, var14_17.name);
                    if (var15_18 == null) {
                        if (this.zzga().zzbb(var5_4) >= 500L && var6_6) {
                            this.zzgg().zzil().zzd("Too many event names used, ignoring event. appId, name, supported count", zzfg.zzbh(var5_4), this.zzgb().zzbe(var14_17.name), 500);
                            this.zzgc().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var16_19 = new zzeq(var5_4, var14_17.name, 0L, 0L, var14_17.timestamp, 0L, null, null, null);
                    } else {
                        var14_17 = var14_17.zza(this, var15_18.zzafr);
                        var16_19 = var15_18.zzac(var14_17.timestamp);
                    }
                    this.zzga().zza(var16_19);
                    var20_14 = var2_2;
                    var19_12 = var14_17;
                    var18_20 = this;
                    var18_20.zzgf().zzab();
                    var18_20.zzch();
                    Preconditions.checkNotNull((Object)var19_12);
                    Preconditions.checkNotNull((Object)var20_14);
                    Preconditions.checkNotEmpty((String)var19_12.zztd);
                    Preconditions.checkArgument((boolean)var19_12.zztd.equals(var20_14.packageName));
                    var21_21 = new zzkl();
                    new zzkl().zzatc = 1;
                    var21_21.zzatk = "android";
                    var21_21.zztd = var20_14.packageName;
                    var21_21.zzado = var20_14.zzado;
                    var21_21.zztc = var20_14.zztc;
                    var21_21.zzatw = var20_14.zzadn == -2147483648L ? null : Integer.valueOf((int)var20_14.zzadn);
                    var21_21.zzato = var20_14.zzadp;
                    var21_21.zzadh = var20_14.zzadh;
                    var21_21.zzats = var20_14.zzadq == 0L ? null : Long.valueOf(var20_14.zzadq);
                    var22_22 = var18_20.zzgh().zzbj(var20_14.packageName);
                    if (var22_22 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var22_22.first))) {
                        if (var20_14.zzadt) {
                            var21_21.zzatq = (String)var22_22.first;
                            var21_21.zzatr = (Boolean)var22_22.second;
                        }
                    } else if (!var18_20.zzfw().zzf(var18_20.zzqs) && var20_14.zzadu) {
                        var23_23 = Settings.Secure.getString((ContentResolver)var18_20.zzqs.getContentResolver(), (String)"android_id");
                        if (var23_23 == null) {
                            var18_20.zzgg().zzin().zzg("null secure ID. appId", zzfg.zzbh(var21_21.zztd));
                            var23_23 = "null";
                        } else if (var23_23.isEmpty()) {
                            var18_20.zzgg().zzin().zzg("empty secure ID. appId", zzfg.zzbh(var21_21.zztd));
                        }
                        var21_21.zzatz = var23_23;
                    }
                    var18_20.zzfw().zzch();
                    var21_21.zzatm = Build.MODEL;
                    var18_20.zzfw().zzch();
                    var21_21.zzatl = Build.VERSION.RELEASE;
                    var21_21.zzatn = (int)var18_20.zzfw().zzic();
                    var21_21.zzafl = var18_20.zzfw().zzid();
                    var21_21.zzatp = null;
                    var21_21.zzatf = null;
                    var21_21.zzatg = null;
                    var21_21.zzath = null;
                    var21_21.zzaub = var20_14.zzads;
                    if (var18_20.isEnabled() && zzeh.zzhm()) {
                        var21_21.zzauc = null;
                    }
                    if ((var23_23 = var18_20.zzga().zzax(var20_14.packageName)) == null) {
                        var23_23 = new zzeb(var18_20, var20_14.packageName);
                        var23_23.zzal(var18_20.zzfv().zzih());
                        var23_23.zzao(var20_14.zzadj);
                        var23_23.zzam(var20_14.zzadh);
                        var23_23.zzan(var18_20.zzgh().zzbk(var20_14.packageName));
                        var23_23.zzr(0L);
                        var23_23.zzm(0L);
                        var23_23.zzn(0L);
                        var23_23.setAppVersion(var20_14.zztc);
                        var23_23.zzo(var20_14.zzadn);
                        var23_23.zzap(var20_14.zzado);
                        var23_23.zzp(var20_14.zzadp);
                        var23_23.zzq(var20_14.zzadq);
                        var23_23.setMeasurementEnabled(var20_14.zzadr);
                        var23_23.zzaa(var20_14.zzads);
                        var18_20.zzga().zza((zzeb)var23_23);
                    }
                    var21_21.zzadg = var23_23.getAppInstanceId();
                    var21_21.zzadj = var23_23.zzgl();
                    var24_24 = var18_20.zzga().zzaw(var20_14.packageName);
                    var21_21.zzate = new zzkn[var24_24.size()];
                    for (var25_25 = 0; var25_25 < var24_24.size(); ++var25_25) {
                        var21_21.zzate[var25_25] = var26_27 = new zzkn();
                        var26_27.name = var24_24.get((int)var25_25).name;
                        var26_27.zzaui = var24_24.get((int)var25_25).zzaqu;
                        var18_20.zzgc().zza(var26_27, var24_24.get((int)var25_25).value);
                    }
                    try {
                        var25_26 = var18_20.zzga().zza(var21_21);
                    }
                    catch (IOException var27_28) {
                        var18_20.zzgg().zzil().zze("Data loss. Failed to insert raw event metadata. appId", zzfg.zzbh(var21_21.zztd), var27_28);
                        break block45;
                    }
                    v0 = var18_20.zzga();
                    var29_29 = var19_12;
                    var28_30 = var18_20;
                    if (var29_29.zzafo == null) ** GOTO lbl-1000
                    for (Object var31_33 : var29_29.zzafo) {
                        if (!"_r".equals(var31_33)) continue;
                        v1 = true;
                        break block46;
                    }
                    var30_32 = var28_30.zzgd().zzo(var29_29.zztd, var29_29.name);
                    var31_33 = var28_30.zzga().zza(var28_30.zzjv(), var29_29.zztd, false, false, false, false, false);
                    if (var30_32 && var31_33.zzafg < (long)var28_30.zzamd.zzar(var29_29.zztd)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                }
                if (v0.zza((zzep)var19_12, var25_26, v1)) {
                    var18_20.zzank = 0L;
                }
            }
            this.zzga().setTransactionSuccessful();
            if (this.zzgg().isLoggable(2)) {
                this.zzgg().zzir().zzg("Event recorded", this.zzgb().zza(var14_17));
            }
        }
        finally {
            this.zzga().endTransaction();
        }
        this.zzjy();
        this.zzgg().zzir().zzg("Background event processing time, ms", (System.nanoTime() - var3_3 + 500000L) / 1000000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean zza(String string, zzeu zzeu2) {
        long l;
        String string2;
        block10: {
            string2 = zzeu2.zzafo.getString("currency");
            if ("ecommerce_purchase".equals(zzeu2.name)) {
                double d = zzeu2.zzafo.zzbc("value") * 1000000.0;
                if (d == 0.0) {
                    d = (double)zzeu2.zzafo.getLong("value").longValue() * 1000000.0;
                }
                if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                    l = Math.round(d);
                    break block10;
                } else {
                    this.zzgg().zzin().zze("Data lost. Currency value is too big. appId", zzfg.zzbh(string), d);
                    return false;
                }
            }
            l = zzeu2.zzafo.getLong("value");
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
            String string3 = String.valueOf("_ltv_");
            String string4 = String.valueOf(string2);
            String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            zzju zzju2 = this.zzga().zzg(string, string5);
            if (zzju2 == null || !(zzju2.value instanceof Long)) {
                String string6 = string;
                int n = this.zzamd.zzb(string6, zzew.zzahp) - 1;
                string6 = string;
                zzei zzei2 = this.zzga();
                Preconditions.checkNotEmpty((String)string6);
                zzei2.zzab();
                zzei2.zzch();
                try {
                    zzei2.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string6, string6, String.valueOf(n)});
                }
                catch (SQLiteException sQLiteException) {
                    zzei2.zzgg().zzil().zze("Error pruning currencies. appId", zzfg.zzbh(string6), (Object)sQLiteException);
                }
                zzju2 = new zzju(string, zzeu2.zzaek, string5, this.zzrj.currentTimeMillis(), l);
            } else {
                long l2 = (Long)zzju2.value;
                zzju2 = new zzju(string, zzeu2.zzaek, string5, this.zzrj.currentTimeMillis(), l2 + l);
            }
            if (!this.zzga().zza(zzju2)) {
                this.zzgg().zzil().zzd("Too many unique user properties are set. Ignoring user property. appId", zzfg.zzbh(string), this.zzgb().zzbg(zzju2.name), zzju2.value);
                this.zzgc().zza(string, 9, null, null, 0);
            }
        }
        return true;
    }

    @WorkerThread
    final void zzd(zzef zzef2) {
        zzec zzec2 = this.zzbt(zzef2.packageName);
        if (zzec2 != null) {
            this.zzb(zzef2, zzec2);
        }
    }

    @WorkerThread
    final void zzb(zzef zzef2, zzec zzec2) {
        Preconditions.checkNotNull((Object)((Object)zzef2));
        Preconditions.checkNotEmpty((String)zzef2.packageName);
        Preconditions.checkNotNull((Object)zzef2.zzaek);
        Preconditions.checkNotNull((Object)((Object)zzef2.zzael));
        Preconditions.checkNotEmpty((String)zzef2.zzael.name);
        ((zzhj)this.zzgf()).zzab();
        this.zzch();
        if (TextUtils.isEmpty((CharSequence)zzec2.zzadh)) {
            return;
        }
        if (!zzec2.zzadr) {
            this.zzh(zzec2);
            return;
        }
        zzef zzef3 = new zzef(zzef2);
        new zzef(zzef2).zzaen = false;
        this.zzga().beginTransaction();
        try {
            boolean bl = false;
            zzef zzef4 = this.zzga().zzh(zzef3.packageName, zzef3.zzael.name);
            if (zzef4 != null && !zzef4.zzaek.equals(zzef3.zzaek)) {
                this.zzgg().zzin().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", this.zzgb().zzbg(zzef3.zzael.name), zzef3.zzaek, zzef4.zzaek);
            }
            if (zzef4 != null && zzef4.zzaen) {
                zzef3.zzaek = zzef4.zzaek;
                zzef3.zzaem = zzef4.zzaem;
                zzef3.zzaeq = zzef4.zzaeq;
                zzef3.zzaeo = zzef4.zzaeo;
                zzef3.zzaer = zzef4.zzaer;
                zzef3.zzaen = zzef4.zzaen;
                zzef3.zzael = new zzjs(zzef3.zzael.name, zzef4.zzael.zzaqu, zzef3.zzael.getValue(), zzef4.zzael.zzaek);
            } else if (TextUtils.isEmpty((CharSequence)zzef3.zzaeo)) {
                zzef3.zzael = new zzjs(zzef3.zzael.name, zzef3.zzaem, zzef3.zzael.getValue(), zzef3.zzael.zzaek);
                zzef3.zzaen = true;
                bl = true;
            }
            if (zzef3.zzaen) {
                zzjs zzjs2 = zzef3.zzael;
                zzju zzju2 = new zzju(zzef3.packageName, zzef3.zzaek, zzjs2.name, zzjs2.zzaqu, zzjs2.getValue());
                if (this.zzga().zza(zzju2)) {
                    this.zzgg().zziq().zzd("User property updated immediately", zzef3.packageName, this.zzgb().zzbg(zzju2.name), zzju2.value);
                } else {
                    this.zzgg().zzil().zzd("(2)Too many active user properties, ignoring", zzfg.zzbh(zzef3.packageName), this.zzgb().zzbg(zzju2.name), zzju2.value);
                }
                if (bl && zzef3.zzaer != null) {
                    zzeu zzeu2 = new zzeu(zzef3.zzaer, zzef3.zzaem);
                    this.zzc(zzeu2, zzec2);
                }
            }
            if (this.zzga().zza(zzef3)) {
                this.zzgg().zziq().zzd("Conditional property added", zzef3.packageName, this.zzgb().zzbg(zzef3.zzael.name), zzef3.zzael.getValue());
            } else {
                this.zzgg().zzil().zzd("Too many conditional properties, ignoring", zzfg.zzbh(zzef3.packageName), this.zzgb().zzbg(zzef3.zzael.name), zzef3.zzael.getValue());
            }
            this.zzga().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzga().endTransaction();
        }
    }

    @WorkerThread
    final void zze(zzef zzef2) {
        zzec zzec2 = this.zzbt(zzef2.packageName);
        if (zzec2 != null) {
            this.zzc(zzef2, zzec2);
        }
    }

    @WorkerThread
    final void zzc(zzef zzef2, zzec zzec2) {
        Preconditions.checkNotNull((Object)((Object)zzef2));
        Preconditions.checkNotEmpty((String)zzef2.packageName);
        Preconditions.checkNotNull((Object)((Object)zzef2.zzael));
        Preconditions.checkNotEmpty((String)zzef2.zzael.name);
        ((zzhj)this.zzgf()).zzab();
        this.zzch();
        if (TextUtils.isEmpty((CharSequence)zzec2.zzadh)) {
            return;
        }
        if (!zzec2.zzadr) {
            this.zzh(zzec2);
            return;
        }
        this.zzga().beginTransaction();
        try {
            this.zzh(zzec2);
            zzef zzef3 = this.zzga().zzh(zzef2.packageName, zzef2.zzael.name);
            if (zzef3 != null) {
                this.zzgg().zziq().zze("Removing conditional user property", zzef2.packageName, this.zzgb().zzbg(zzef2.zzael.name));
                this.zzga().zzi(zzef2.packageName, zzef2.zzael.name);
                if (zzef3.zzaen) {
                    this.zzga().zzf(zzef2.packageName, zzef2.zzael.name);
                }
                if (zzef2.zzaet != null) {
                    Bundle bundle = null;
                    if (zzef2.zzaet.zzafo != null) {
                        bundle = zzef2.zzaet.zzafo.zzif();
                    }
                    zzeu zzeu2 = this.zzgc().zza(zzef2.zzaet.name, bundle, zzef3.zzaek, zzef2.zzaet.zzafz, true, false);
                    this.zzc(zzeu2, zzec2);
                }
            } else {
                this.zzgg().zzin().zze("Conditional user property doesn't exist", zzfg.zzbh(zzef2.packageName), this.zzgb().zzbg(zzef2.zzael.name));
            }
            this.zzga().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzga().endTransaction();
        }
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzeu zzeu2, @Size(min=1L) String string) {
        Long l;
        this.zzch();
        ((zzhj)this.zzgf()).zzab();
        zzgl.zzfq();
        Preconditions.checkNotNull((Object)((Object)zzeu2));
        Preconditions.checkNotEmpty((String)string);
        zzkk zzkk2 = new zzkk();
        this.zzga().beginTransaction();
        try {
            zzeq zzeq2;
            long l2;
            Object object;
            zzeb zzeb2 = this.zzga().zzax(string);
            if (zzeb2 == null) {
                this.zzgg().zziq().zzg("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzeb2.isMeasurementEnabled()) {
                this.zzgg().zziq().zzg("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (("_iap".equals(zzeu2.name) || "ecommerce_purchase".equals(zzeu2.name)) && !this.zza(string, zzeu2)) {
                this.zzgg().zzin().zzg("Failed to handle purchase event at single event bundle creation. appId", zzfg.zzbh(string));
            }
            boolean bl = this.zzamd.zzau(string);
            l = 0L;
            if (bl && "_e".equals(zzeu2.name)) {
                if (zzeu2.zzafo == null || zzeu2.zzafo.size() == 0) {
                    this.zzgg().zzin().zzg("The engagement event does not contain any parameters. appId", zzfg.zzbh(string));
                } else if (zzeu2.zzafo.getLong("_et") == null) {
                    this.zzgg().zzin().zzg("The engagement event does not include duration. appId", zzfg.zzbh(string));
                } else {
                    l = zzeu2.zzafo.getLong("_et");
                }
            }
            zzkl zzkl2 = new zzkl();
            zzkk2.zzata = new zzkl[]{zzkl2};
            zzkl2.zzatc = 1;
            zzkl2.zzatk = "android";
            zzkl2.zztd = zzeb2.zzah();
            zzkl2.zzado = zzeb2.zzgp();
            zzkl2.zztc = zzeb2.zzag();
            long l3 = zzeb2.zzgo();
            zzkl2.zzatw = l3 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l3);
            zzkl2.zzato = zzeb2.zzgq();
            zzkl2.zzadh = zzeb2.getGmpAppId();
            zzkl2.zzats = zzeb2.zzgr();
            if (this.isEnabled() && zzeh.zzhm() && this.zzamd.zzat(zzkl2.zztd)) {
                zzkl2.zzauc = null;
            }
            Pair<String, Boolean> pair = this.zzgh().zzbj(zzeb2.zzah());
            if (zzeb2.zzhf() && pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                zzkl2.zzatq = (String)pair.first;
                zzkl2.zzatr = (Boolean)pair.second;
            }
            this.zzfw().zzch();
            zzkl2.zzatm = Build.MODEL;
            this.zzfw().zzch();
            zzkl2.zzatl = Build.VERSION.RELEASE;
            zzkl2.zzatn = (int)this.zzfw().zzic();
            zzkl2.zzafl = this.zzfw().zzid();
            zzkl2.zzadg = zzeb2.getAppInstanceId();
            zzkl2.zzadj = zzeb2.zzgl();
            List<zzju> list = this.zzga().zzaw(zzeb2.zzah());
            zzkl2.zzate = new zzkn[list.size()];
            zzju zzju2 = null;
            if (bl) {
                zzju2 = this.zzga().zzg(zzkl2.zztd, "_lte");
                if (zzju2 == null || zzju2.value == null) {
                    zzju2 = new zzju(zzkl2.zztd, "auto", "_lte", this.zzrj.currentTimeMillis(), l);
                } else if (l > 0L) {
                    zzju2 = new zzju(zzkl2.zztd, "auto", "_lte", this.zzrj.currentTimeMillis(), (Long)zzju2.value + l);
                }
            }
            zzkn zzkn2 = null;
            for (int i = 0; i < list.size(); ++i) {
                object = new zzkn();
                zzkl2.zzate[i] = object;
                ((zzkn)((Object)object)).name = list.get((int)i).name;
                ((zzkn)((Object)object)).zzaui = list.get((int)i).zzaqu;
                this.zzgc().zza((zzkn)((Object)object), list.get((int)i).value);
                if (!bl || !"_lte".equals(((zzkn)((Object)object)).name)) continue;
                zzkn2 = object;
                ((zzkn)((Object)object)).zzasz = (Long)zzju2.value;
                zzkn2.zzaui = this.zzrj.currentTimeMillis();
            }
            if (bl && zzkn2 == null) {
                zzkn2 = new zzkn();
                new zzkn().name = "_lte";
                zzkn2.zzaui = this.zzrj.currentTimeMillis();
                zzkn2.zzasz = (Long)zzju2.value;
                zzkl2.zzate = Arrays.copyOf(zzkl2.zzate, zzkl2.zzate.length + 1);
                zzkl2.zzate[zzkl2.zzate.length - 1] = zzkn2;
            }
            if (l > 0L) {
                this.zzga().zza(zzju2);
            }
            Bundle bundle = zzeu2.zzafo.zzif();
            if ("_iap".equals(zzeu2.name)) {
                bundle.putLong("_c", 1L);
                this.zzgg().zziq().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzeu2.zzaek);
            if (this.zzgc().zzcc(zzkl2.zztd)) {
                this.zzgc().zza(bundle, "_dbg", 1L);
                this.zzgc().zza(bundle, "_r", 1L);
            }
            if ((object = this.zzga().zze(string, zzeu2.name)) == null) {
                l2 = 0L;
                zzeq2 = new zzeq(string, zzeu2.name, 1L, 0L, zzeu2.zzafz, 0L, null, null, null);
                this.zzga().zza(zzeq2);
            } else {
                l2 = ((zzeq)object).zzafr;
                zzeq2 = ((zzeq)object).zzac(zzeu2.zzafz).zzie();
                this.zzga().zza(zzeq2);
            }
            zzep zzep2 = new zzep(this, zzeu2.zzaek, string, zzeu2.name, zzeu2.zzafz, l2, bundle);
            zzki zzki2 = new zzki();
            zzkl2.zzatd = new zzki[]{zzki2};
            zzki2.zzasw = zzep2.timestamp;
            zzki2.name = zzep2.name;
            zzki2.zzasx = zzep2.zzafn;
            zzki2.zzasv = new zzkj[zzep2.zzafo.size()];
            int n = 0;
            for (String string2 : zzep2.zzafo) {
                zzkj zzkj2 = new zzkj();
                zzki2.zzasv[n++] = zzkj2;
                zzkj2.name = string2;
                Object object2 = zzep2.zzafo.get(string2);
                this.zzgc().zza(zzkj2, object2);
            }
            zzkl2.zzatv = this.zza(zzeb2.zzah(), zzkl2.zzate, zzkl2.zzatd);
            zzkl2.zzatg = zzki2.zzasw;
            zzkl2.zzath = zzki2.zzasw;
            long l4 = zzeb2.zzgn();
            zzkl2.zzatj = l4 != 0L ? Long.valueOf(l4) : null;
            long l5 = zzeb2.zzgm();
            if (l5 == 0L) {
                l5 = l4;
            }
            zzkl2.zzati = l5 != 0L ? Long.valueOf(l5) : null;
            zzeb2.zzgv();
            zzkl2.zzatt = (int)zzeb2.zzgs();
            zzkl2.zzatp = 12451L;
            zzkl2.zzatf = this.zzrj.currentTimeMillis();
            zzkl2.zzatu = Boolean.TRUE;
            zzeb2.zzm(zzkl2.zzatg);
            zzeb2.zzn(zzkl2.zzath);
            this.zzga().zza(zzeb2);
            this.zzga().setTransactionSuccessful();
        }
        finally {
            this.zzga().endTransaction();
        }
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = new byte[zzkk2.zzwg()];
            l = zzabb.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkk2.zza((zzabb)l);
            l.zzvy();
            return this.zzgc().zza(byArray);
        }
        catch (IOException iOException) {
            this.zzgg().zzil().zze("Data loss. Failed to bundle and serialize. appId", zzfg.zzbh(string), iOException);
            return null;
        }
    }

    public final String zzf(zzec zzec2) {
        Future<String> future = this.zzgf().zzb(new zzgn(this, zzec2));
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzgg().zzil().zze("Failed to get app instance id. appId", zzfg.zzbh(zzec2.packageName), exception);
            return null;
        }
    }

    static void zzfq() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    @WorkerThread
    final void zzb(zzjs zzjs2, zzec zzec2) {
        ((zzhj)this.zzgf()).zzab();
        this.zzch();
        if (TextUtils.isEmpty((CharSequence)zzec2.zzadh)) {
            return;
        }
        if (!zzec2.zzadr) {
            this.zzh(zzec2);
            return;
        }
        int n = this.zzgc().zzby(zzjs2.name);
        if (n != 0) {
            this.zzgc();
            String string = zzjv.zza(zzjs2.name, 24, true);
            int n2 = zzjs2.name != null ? zzjs2.name.length() : 0;
            this.zzgc().zza(zzec2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzgc().zzi(zzjs2.name, zzjs2.getValue());
        if (n != 0) {
            this.zzgc();
            String string = zzjv.zza(zzjs2.name, 24, true);
            Object object = zzjs2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzgc().zza(zzec2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzgc().zzj(zzjs2.name, zzjs2.getValue());
        if (object == null) {
            return;
        }
        zzju zzju2 = new zzju(zzec2.packageName, zzjs2.zzaek, zzjs2.name, zzjs2.zzaqu, object);
        this.zzgg().zziq().zze("Setting user property", this.zzgb().zzbg(zzju2.name), object);
        this.zzga().beginTransaction();
        try {
            this.zzh(zzec2);
            boolean bl = this.zzga().zza(zzju2);
            this.zzga().setTransactionSuccessful();
            if (bl) {
                this.zzgg().zziq().zze("User property set", this.zzgb().zzbg(zzju2.name), zzju2.value);
            } else {
                this.zzgg().zzil().zze("Too many unique user properties are set. Ignoring user property", this.zzgb().zzbg(zzju2.name), zzju2.value);
                this.zzgc().zza(zzec2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzga().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzjs zzjs2, zzec zzec2) {
        ((zzhj)this.zzgf()).zzab();
        this.zzch();
        if (TextUtils.isEmpty((CharSequence)zzec2.zzadh)) {
            return;
        }
        if (!zzec2.zzadr) {
            this.zzh(zzec2);
            return;
        }
        this.zzgg().zziq().zzg("Removing user property", this.zzgb().zzbg(zzjs2.name));
        this.zzga().beginTransaction();
        try {
            this.zzh(zzec2);
            this.zzga().zzf(zzec2.packageName, zzjs2.name);
            this.zzga().setTransactionSuccessful();
            this.zzgg().zziq().zzg("User property removed", this.zzgb().zzbg(zzjs2.name));
            return;
        }
        finally {
            this.zzga().endTransaction();
        }
    }

    @WorkerThread
    public final void zzjw() {
        ((zzhj)this.zzgf()).zzab();
        this.zzch();
        this.zzann = true;
        try {
            String string;
            Boolean bl = this.zzfx().zzkn();
            if (bl == null) {
                this.zzgg().zzin().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzgg().zzil().log("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzank > 0L) {
                this.zzjy();
                return;
            }
            Object object = this;
            ((zzhj)((zzgl)object).zzgf()).zzab();
            if (((zzgl)object).zzanf != null) {
                this.zzgg().zzir().log("Uploading requested multiple times");
                return;
            }
            if (!this.zzjq().zzew()) {
                this.zzgg().zzir().log("Network not connected, ignoring upload request");
                this.zzjy();
                return;
            }
            long l = this.zzrj.currentTimeMillis();
            long l2 = l - zzeh.zzhk();
            this.zzd(null, l2);
            long l3 = this.zzgh().zzajt.get();
            if (l3 != 0L) {
                this.zzgg().zziq().zzg("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzga().zzhn()))) {
                if (this.zzanj == -1L) {
                    this.zzanj = this.zzga().zzhu();
                }
                Object object2 = string;
                int n = this.zzamd.zzb((String)object2, zzew.zzagr);
                object2 = string;
                object = this.zzamd;
                int n2 = Math.max(0, ((zzeh)object).zzb((String)object2, zzew.zzags));
                List<Pair<zzkl, Long>> list = this.zzga().zzb(string, n, n2);
                if (!list.isEmpty()) {
                    Object object3;
                    String string2 = null;
                    Object object4 = list.iterator();
                    while (object4.hasNext()) {
                        zzkl zzkl2 = (zzkl)((Object)object4.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzkl2.zzatq)) continue;
                        string2 = zzkl2.zzatq;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object3 = (zzkl)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzkl)((Object)object3)).zzatq) || ((zzkl)((Object)object3)).zzatq.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object4 = new zzkk();
                    new zzkk().zzata = new zzkl[list.size()];
                    object3 = new ArrayList(list.size());
                    boolean bl2 = zzeh.zzhm() && this.zzamd.zzat(string);
                    for (int i = 0; i < ((zzkk)((Object)object4)).zzata.length; ++i) {
                        ((zzkk)((Object)object4)).zzata[i] = (zzkl)((Object)list.get((int)i).first);
                        object3.add((Long)list.get((int)i).second);
                        ((zzkk)((Object)object4)).zzata[i].zzatp = 12451L;
                        ((zzkk)((Object)object4)).zzata[i].zzatf = l;
                        ((zzkk)((Object)object4)).zzata[i].zzatu = false;
                        if (bl2) continue;
                        ((zzkk)((Object)object4)).zzata[i].zzauc = null;
                    }
                    String string3 = null;
                    if (this.zzgg().isLoggable(2)) {
                        string3 = this.zzgb().zza((zzkk)((Object)object4));
                    }
                    byte[] byArray = this.zzgc().zzb((zzkk)((Object)object4));
                    String string4 = zzew.zzahb.get();
                    try {
                        URL uRL = new URL(string4);
                        object2 = object3;
                        object = this;
                        Preconditions.checkArgument((!object2.isEmpty() ? 1 : 0) != 0);
                        if (((zzgl)object).zzanf != null) {
                            ((zzgl)object).zzgg().zzil().log("Set uploading progress before finishing the previous upload");
                        } else {
                            ((zzgl)object).zzanf = new ArrayList<Long>((Collection<Long>)object2);
                        }
                        this.zzgh().zzaju.set(l);
                        String string5 = "?";
                        if (((zzkk)((Object)object4)).zzata.length > 0) {
                            string5 = ((zzkk)((Object)object4)).zzata[0].zztd;
                        }
                        this.zzgg().zzir().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                        this.zzanm = true;
                        zzgo zzgo2 = new zzgo(this, string);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object2 = string;
                        object = this.zzjq();
                        ((zzhj)object).zzab();
                        ((zzhk)object).zzch();
                        Preconditions.checkNotNull((Object)uRL2);
                        Preconditions.checkNotNull((Object)byArray2);
                        Preconditions.checkNotNull((Object)zzgo2);
                        ((zzhj)object).zzgf().zzd(new zzfo((zzfk)object, (String)object2, uRL2, byArray2, null, zzgo2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzgg().zzil().zze("Failed to parse upload URL. Not uploading. appId", zzfg.zzbh(string), string4);
                    }
                }
            } else {
                zzeb zzeb2;
                this.zzanj = -1L;
                String string6 = this.zzga().zzab(l - zzeh.zzhk());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzeb2 = this.zzga().zzax(string6)) != null) {
                    this.zzb(zzeb2);
                }
            }
            return;
        }
        finally {
            this.zzann = false;
            this.zzkc();
        }
    }

    @WorkerThread
    private final void zzb(zzeb zzeb2) {
        ((zzhj)this.zzgf()).zzab();
        if (TextUtils.isEmpty((CharSequence)zzeb2.getGmpAppId())) {
            this.zzb(zzeb2.zzah(), 204, null, null, null);
            return;
        }
        Object object = zzeb2.getAppInstanceId();
        String string = zzeb2.getGmpAppId();
        Uri.Builder builder = new Uri.Builder();
        String string2 = String.valueOf(string);
        builder.scheme(zzew.zzagp.get()).encodedAuthority(zzew.zzagq.get()).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", (String)object).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "12451");
        String string3 = builder.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzgg().zzir().zzg("Fetching remote configuration", zzeb2.zzah());
            zzkf zzkf2 = this.zzgd().zzbp(zzeb2.zzah());
            ArrayMap arrayMap = null;
            String string4 = this.zzgd().zzbq(zzeb2.zzah());
            if (zzkf2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzanl = true;
            zzgp zzgp2 = new zzgp(this);
            builder = arrayMap;
            object = uRL;
            string = zzeb2.zzah();
            zzfk zzfk2 = this.zzjq();
            ((zzhj)zzfk2).zzab();
            zzfk2.zzch();
            Preconditions.checkNotNull((Object)object);
            Preconditions.checkNotNull((Object)zzgp2);
            ((zzhj)zzfk2).zzgf().zzd(new zzfo(zzfk2, string, (URL)object, null, (Map)builder, zzgp2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzgg().zzil().zze("Failed to parse config URL. Not fetching. appId", zzfg.zzbh(zzeb2.zzah()), string3);
            return;
        }
    }

    @WorkerThread
    private final boolean zzd(String string, long l) {
        this.zzga().beginTransaction();
        try {
            block101: {
                zzkj[] zzkjArray;
                Object object;
                int n2;
                int n3;
                Object object2;
                Object object3;
                Object object4;
                zza zza2;
                block99: {
                    zza zza3 = zza2 = new zza(null);
                    long l2 = this.zzanj;
                    long l3 = l;
                    object4 = null;
                    object3 = this.zzga();
                    Preconditions.checkNotNull((Object)zza3);
                    ((zzhj)object3).zzab();
                    ((zzhk)object3).zzch();
                    object2 = null;
                    try {
                        String[] stringArray;
                        String string2;
                        String string3;
                        String string4;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = ((zzei)object3).getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string4 = l2 != -1L ? "rowid <= ? and " : "";
                            object2 = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string4).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string4).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!object2.moveToFirst()) break block99;
                            object4 = object2.getString(0);
                            string3 = object2.getString(1);
                            object2.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string4 = l2 != -1L ? " and rowid <= ?" : "";
                            object2 = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string4).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string4).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!object2.moveToFirst()) break block99;
                            string3 = object2.getString(0);
                            object2.close();
                        }
                        object2 = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{object4, string3}, null, null, "rowid", "2");
                        if (!object2.moveToFirst()) {
                            ((zzhj)object3).zzgg().zzil().zzg("Raw event metadata record is missing. appId", zzfg.zzbh((String)object4));
                            break block99;
                        }
                        byte[] byArray = object2.getBlob(0);
                        string4 = zzaba.zza((byte[])byArray, (int)0, (int)byArray.length);
                        zzkl zzkl2 = new zzkl();
                        try {
                            zzkl2.zzb((zzaba)string4);
                        }
                        catch (IOException iOException) {
                            ((zzhj)object3).zzgg().zzil().zze("Data loss. Failed to merge raw event metadata. appId", zzfg.zzbh((String)object4), iOException);
                            if (object2 != null) {
                                object2.close();
                            }
                            break block99;
                        }
                        if (object2.moveToNext()) {
                            ((zzhj)object3).zzgg().zzin().zzg("Get multiple raw event metadata records, expected one. appId", zzfg.zzbh((String)object4));
                        }
                        object2.close();
                        zza3.zzb(zzkl2);
                        if (l2 != -1L) {
                            string2 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{object4, string3, String.valueOf(l2)};
                        } else {
                            string2 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{object4, string3};
                        }
                        object2 = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string2, stringArray, null, null, "rowid", null);
                        if (!object2.moveToFirst()) {
                            ((zzhj)object3).zzgg().zzin().zzg("Raw event data disappeared while in transaction. appId", zzfg.zzbh((String)object4));
                            break block99;
                        }
                        do {
                            long l4 = object2.getLong(0);
                            byArray = object2.getBlob(3);
                            string4 = zzaba.zza((byte[])byArray, (int)0, (int)byArray.length);
                            zzki zzki2 = new zzki();
                            try {
                                zzki2.zzb((zzaba)string4);
                            }
                            catch (IOException iOException) {
                                ((zzhj)object3).zzgg().zzil().zze("Data loss. Failed to merge raw event. appId", zzfg.zzbh((String)object4), iOException);
                                continue;
                            }
                            zzki2.name = object2.getString(1);
                            zzki2.zzasw = object2.getLong(2);
                            if (!zza3.zza(l4, zzki2)) break;
                        } while (object2.moveToNext());
                    }
                    catch (SQLiteException sQLiteException) {
                        ((zzhj)object3).zzgg().zzil().zze("Data loss. Error selecting raw event. appId", zzfg.zzbh(object4), (Object)sQLiteException);
                    }
                    finally {
                        if (object2 != null) {
                            object2.close();
                        }
                    }
                }
                object3 = zza2;
                if (((zza)object3).zzanu == null || ((zza)object3).zzanu.isEmpty()) break block101;
                boolean bl = false;
                zzkl zzkl3 = zza2.zzans;
                zza2.zzans.zzatd = new zzki[zza2.zzanu.size()];
                int n4 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzamd.zzau(zzkl3.zztd);
                for (n3 = 0; n3 < zza2.zzanu.size(); ++n3) {
                    zzki zzki3;
                    block103: {
                        int zzkjArray3;
                        boolean bl3;
                        block102: {
                            bl3 = bl;
                            zzki3 = zza2.zzanu.get(n3);
                            if (this.zzgd().zzn(zza2.zzans.zztd, zzki3.name)) {
                                this.zzgg().zzin().zze("Dropping blacklisted raw event. appId", zzfg.zzbh(zza2.zzans.zztd), this.zzgb().zzbe(zzki3.name));
                                if (this.zzgc().zzce(zza2.zzans.zztd) || this.zzgc().zzcf(zza2.zzans.zztd) || "_err".equals(zzki3.name)) continue;
                                this.zzgc().zza(zza2.zzans.zztd, 11, "_ev", zzki3.name, 0);
                                continue;
                            }
                            n2 = this.zzgd().zzo(zza2.zzans.zztd, zzki3.name);
                            if (n2 != 0) break block102;
                            this.zzgc();
                            if (!zzjv.zzcg(zzki3.name)) break block103;
                        }
                        boolean bl4 = false;
                        boolean n = false;
                        if (zzki3.zzasv == null) {
                            zzki3.zzasv = new zzkj[0];
                        }
                        zzkj[] i = zzki3.zzasv;
                        int zzkj2 = zzki3.zzasv.length;
                        for (zzkjArray3 = 0; zzkjArray3 < zzkj2; ++zzkjArray3) {
                            object = i[zzkjArray3];
                            if ("_c".equals(((zzkj)((Object)object)).name)) {
                                ((zzkj)((Object)object)).zzasz = 1L;
                                bl4 = true;
                                continue;
                            }
                            if (!"_r".equals(((zzkj)((Object)object)).name)) continue;
                            ((zzkj)((Object)object)).zzasz = 1L;
                            n = true;
                        }
                        if (!bl4 && n2 != 0) {
                            this.zzgg().zzir().zzg("Marking event as conversion", this.zzgb().zzbe(zzki3.name));
                            i = Arrays.copyOf(zzki3.zzasv, zzki3.zzasv.length + 1);
                            zzkj zzkj3 = new zzkj();
                            new zzkj().name = "_c";
                            zzkj3.zzasz = 1L;
                            i[i.length - 1] = zzkj3;
                            zzki3.zzasv = i;
                        }
                        if (!n) {
                            this.zzgg().zzir().zzg("Marking event as real-time", this.zzgb().zzbe(zzki3.name));
                            i = Arrays.copyOf(zzki3.zzasv, zzki3.zzasv.length + 1);
                            zzkj zzki4 = new zzkj();
                            new zzkj().name = "_r";
                            zzki4.zzasz = 1L;
                            i[i.length - 1] = zzki4;
                            zzki3.zzasv = i;
                        }
                        bl = true;
                        if (this.zzga().zza((long)this.zzjv(), (String)zza2.zzans.zztd, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzafg > (long)this.zzamd.zzar(zza2.zzans.zztd)) {
                            for (zzkj2 = 0; zzkj2 < zzki3.zzasv.length; ++zzkj2) {
                                if (!"_r".equals(zzki3.zzasv[zzkj2].name)) continue;
                                zzkj[] string5 = new zzkj[zzki3.zzasv.length - 1];
                                if (zzkj2 > 0) {
                                    System.arraycopy(zzki3.zzasv, 0, string5, 0, zzkj2);
                                }
                                if (zzkj2 < string5.length) {
                                    System.arraycopy(zzki3.zzasv, zzkj2 + 1, string5, zzkj2, string5.length - zzkj2);
                                }
                                zzki3.zzasv = string5;
                                break;
                            }
                            bl = bl3;
                        }
                        if (zzjv.zzbv(zzki3.name) && n2 != 0 && this.zzga().zza((long)this.zzjv(), (String)zza2.zzans.zztd, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzafe > (long)this.zzamd.zzb((String)(object4 = zza2.zzans.zztd), zzew.zzagy)) {
                            this.zzgg().zzin().zzg("Too many conversions. Not logging as conversion. appId", zzfg.zzbh(zza2.zzans.zztd));
                            zzkjArray3 = 0;
                            object = null;
                            zzkjArray = zzki3.zzasv;
                            int bl7 = zzki3.zzasv.length;
                            for (int j = 0; j < bl7; ++j) {
                                zzkj zzkj3 = zzkjArray[j];
                                if ("_c".equals(zzkj3.name)) {
                                    object = zzkj3;
                                    continue;
                                }
                                if (!"_err".equals(zzkj3.name)) continue;
                                zzkjArray3 = 1;
                            }
                            if (zzkjArray3 != 0 && object != null) {
                                zzki3.zzasv = (zzkj[])ArrayUtils.removeAll((Object[])zzki3.zzasv, (Object[])new zzkj[]{object});
                            } else if (object != null) {
                                ((zzkj)((Object)object)).name = "_err";
                                ((zzkj)((Object)object)).zzasz = 10L;
                            } else {
                                this.zzgg().zzil().zzg("Did not find conversion parameter. appId", zzfg.zzbh(zza2.zzans.zztd));
                            }
                        }
                    }
                    if (bl2 && "_e".equals(zzki3.name)) {
                        if (zzki3.zzasv == null || zzki3.zzasv.length == 0) {
                            this.zzgg().zzin().zzg("Engagement event does not contain any parameters. appId", zzfg.zzbh(zza2.zzans.zztd));
                        } else {
                            this.zzgc();
                            Long l6 = (Long)zzjv.zzb(zzki3, "_et");
                            if (l6 == null) {
                                this.zzgg().zzin().zzg("Engagement event does not include duration. appId", zzfg.zzbh(zza2.zzans.zztd));
                            } else {
                                l5 += l6.longValue();
                            }
                        }
                    }
                    zzkl3.zzatd[n4++] = zzki3;
                }
                if (n4 < zza2.zzanu.size()) {
                    zzkl3.zzatd = Arrays.copyOf(zzkl3.zzatd, n4);
                }
                if (bl2) {
                    zzju zzju2 = this.zzga().zzg(zzkl3.zztd, "_lte");
                    zzju2 = zzju2 == null || zzju2.value == null ? new zzju(zzkl3.zztd, "auto", "_lte", this.zzrj.currentTimeMillis(), l5) : new zzju(zzkl3.zztd, "auto", "_lte", this.zzrj.currentTimeMillis(), (Long)zzju2.value + l5);
                    zzkn zzkn2 = new zzkn();
                    new zzkn().name = "_lte";
                    zzkn2.zzaui = this.zzrj.currentTimeMillis();
                    zzkn2.zzasz = (Long)zzju2.value;
                    boolean bl5 = false;
                    for (n2 = 0; n2 < zzkl3.zzate.length; ++n2) {
                        if (!"_lte".equals(zzkl3.zzate[n2].name)) continue;
                        zzkl3.zzate[n2] = zzkn2;
                        bl5 = true;
                        break;
                    }
                    if (!bl5) {
                        zzkl3.zzate = Arrays.copyOf(zzkl3.zzate, zzkl3.zzate.length + 1);
                        zzkl3.zzate[zza2.zzans.zzate.length - 1] = zzkn2;
                    }
                    if (l5 > 0L) {
                        this.zzga().zza(zzju2);
                        this.zzgg().zziq().zzg("Updated lifetime engagement user property with value. Value", zzju2.value);
                    }
                }
                zzkl3.zzatv = this.zza(zzkl3.zztd, zzkl3.zzate, zzkl3.zzatd);
                if (zzew.zzagk.get().booleanValue()) {
                    object4 = zza2.zzans.zztd;
                    object3 = this.zzamd;
                    if ("1".equals(((zzhj)object3).zzgd().zzm((String)object4, "measurement.event_sampling_enabled"))) {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        zzki[] zzkiArray = new zzki[zzkl3.zzatd.length];
                        int n8 = 0;
                        SecureRandom secureRandom = this.zzgc().zzku();
                        zzki[] zzkiArray2 = zzkl3.zzatd;
                        int n = zzkl3.zzatd.length;
                        for (int i = 0; i < n; ++i) {
                            boolean bl3;
                            int n5;
                            zzki zzki2;
                            block100: {
                                zzki2 = zzkiArray2[i];
                                if (zzki2.name.equals("_ep")) {
                                    this.zzgc();
                                    String n9 = (String)zzjv.zzb(zzki2, "_en");
                                    object = (zzeq)hashMap.get(n9);
                                    if (object == null) {
                                        object = this.zzga().zze(zza2.zzans.zztd, n9);
                                        hashMap.put(n9, object);
                                    }
                                    if (((zzeq)object).zzaft != null) continue;
                                    if (((zzeq)object).zzafu > 1L) {
                                        this.zzgc();
                                        zzki2.zzasv = zzjv.zza(zzki2.zzasv, "_sr", ((zzeq)object).zzafu);
                                    }
                                    if (((zzeq)object).zzafv != null && ((zzeq)object).zzafv.booleanValue()) {
                                        this.zzgc();
                                        zzki2.zzasv = zzjv.zza(zzki2.zzasv, "_efs", 1L);
                                    }
                                    zzkiArray[n8++] = zzki2;
                                    continue;
                                }
                                n5 = 1;
                                Long l7 = 1L;
                                object4 = "_dbg";
                                object3 = zzki2;
                                if (TextUtils.isEmpty((CharSequence)object4) || l7 == null) {
                                    bl3 = false;
                                } else {
                                    zzkj[] zzkjArray4 = ((zzki)((Object)((Object)object3))).zzasv;
                                    int n6 = ((zzki)((Object)((Object)object3))).zzasv.length;
                                    for (int j = 0; j < n6; ++j) {
                                        object2 = zzkjArray4[j];
                                        if (!((String)object4).equals(object2.name)) continue;
                                        bl3 = l7 instanceof Long && ((Object)l7).equals(object2.zzasz) || l7 instanceof String && ((Object)l7).equals(object2.zzajf) || l7 instanceof Double && ((Object)l7).equals(object2.zzaqx);
                                        break block100;
                                    }
                                    bl3 = false;
                                }
                            }
                            if (!bl3) {
                                n5 = this.zzgd().zzp(zza2.zzans.zztd, zzki2.name);
                            }
                            if (n5 <= 0) {
                                this.zzgg().zzin().zze("Sample rate must be positive. event, rate", zzki2.name, n5);
                                zzkiArray[n8++] = zzki2;
                                continue;
                            }
                            object = (zzeq)hashMap.get(zzki2.name);
                            if (object == null && (object = this.zzga().zze(zza2.zzans.zztd, zzki2.name)) == null) {
                                this.zzgg().zzin().zze("Event being bundled has no eventAggregate. appId, eventName", zza2.zzans.zztd, zzki2.name);
                                object = new zzeq(zza2.zzans.zztd, zzki2.name, 1L, 1L, zzki2.zzasw, 0L, null, null, null);
                            }
                            this.zzgc();
                            zzkjArray = (zzkj[])zzjv.zzb(zzki2, "_eid");
                            Boolean bl4 = zzkjArray != null;
                            if (n5 == 1) {
                                zzkiArray[n8++] = zzki2;
                                if (!bl4.booleanValue() || ((zzeq)object).zzaft == null && ((zzeq)object).zzafu == null && ((zzeq)object).zzafv == null) continue;
                                object = ((zzeq)object).zza(null, null, null);
                                hashMap.put(zzki2.name, object);
                                continue;
                            }
                            if (secureRandom.nextInt(n5) == 0) {
                                this.zzgc();
                                zzki2.zzasv = zzjv.zza(zzki2.zzasv, "_sr", n5);
                                zzkiArray[n8++] = zzki2;
                                if (bl4.booleanValue()) {
                                    object = ((zzeq)object).zza(null, Long.valueOf(n5), null);
                                }
                                hashMap.put(zzki2.name, ((zzeq)object).zzad(zzki2.zzasw));
                                continue;
                            }
                            long l2 = ((zzeq)object).zzafs;
                            if (Math.abs(zzki2.zzasw - l2) >= 86400000L) {
                                this.zzgc();
                                zzki2.zzasv = zzjv.zza(zzki2.zzasv, "_efs", 1L);
                                this.zzgc();
                                zzki2.zzasv = zzjv.zza(zzki2.zzasv, "_sr", n5);
                                zzkiArray[n8++] = zzki2;
                                if (bl4.booleanValue()) {
                                    object = ((zzeq)object).zza(null, Long.valueOf(n5), true);
                                }
                                hashMap.put(zzki2.name, ((zzeq)object).zzad(zzki2.zzasw));
                                continue;
                            }
                            if (!bl4.booleanValue()) continue;
                            hashMap.put(zzki2.name, ((zzeq)object).zza((Long)zzkjArray, null, null));
                        }
                        if (n8 < zzkl3.zzatd.length) {
                            zzkl3.zzatd = Arrays.copyOf(zzkiArray, n8);
                        }
                        for (Map.Entry entry : hashMap.entrySet()) {
                            this.zzga().zza((zzeq)entry.getValue());
                        }
                    }
                }
                zzkl3.zzatg = Long.MAX_VALUE;
                zzkl3.zzath = Long.MIN_VALUE;
                for (n3 = 0; n3 < zzkl3.zzatd.length; ++n3) {
                    zzki zzki5 = zzkl3.zzatd[n3];
                    if (zzki5.zzasw < zzkl3.zzatg) {
                        zzkl3.zzatg = zzki5.zzasw;
                    }
                    if (zzki5.zzasw <= zzkl3.zzath) continue;
                    zzkl3.zzath = zzki5.zzasw;
                }
                String string6 = zza2.zzans.zztd;
                zzeb zzeb2 = this.zzga().zzax(string6);
                if (zzeb2 == null) {
                    this.zzgg().zzil().zzg("Bundling raw events w/o app info. appId", zzfg.zzbh(zza2.zzans.zztd));
                } else if (zzkl3.zzatd.length > 0) {
                    long l9 = zzeb2.zzgn();
                    zzkl3.zzatj = l9 != 0L ? Long.valueOf(l9) : null;
                    long l10 = zzeb2.zzgm();
                    if (l10 == 0L) {
                        l10 = l9;
                    }
                    zzkl3.zzati = l10 != 0L ? Long.valueOf(l10) : null;
                    zzeb2.zzgv();
                    zzkl3.zzatt = (int)zzeb2.zzgs();
                    zzeb2.zzm(zzkl3.zzatg);
                    zzeb2.zzn(zzkl3.zzath);
                    zzkl3.zzaef = zzeb2.zzhd();
                    this.zzga().zza(zzeb2);
                }
                if (zzkl3.zzatd.length > 0) {
                    zzkf zzkf2 = this.zzgd().zzbp(zza2.zzans.zztd);
                    if (zzkf2 == null || zzkf2.zzask == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzans.zzadh)) {
                            zzkl3.zzaua = -1L;
                        } else {
                            this.zzgg().zzin().zzg("Did not find measurement config or missing version info. appId", zzfg.zzbh(zza2.zzans.zztd));
                        }
                    } else {
                        zzkl3.zzaua = zzkf2.zzask;
                    }
                    this.zzga().zza(zzkl3, bl);
                }
                object4 = zza2.zzant;
                object3 = this.zzga();
                Preconditions.checkNotNull((Object)object4);
                ((zzhj)object3).zzab();
                ((zzhk)object3).zzch();
                StringBuilder stringBuilder = new StringBuilder("rowid in (");
                for (int sQLiteException = 0; sQLiteException < object4.size(); ++sQLiteException) {
                    if (sQLiteException != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append((Long)object4.get(sQLiteException));
                }
                stringBuilder.append(")");
                int n11 = ((zzei)object3).getWritableDatabase().delete("raw_events", stringBuilder.toString(), null);
                if (n11 != object4.size()) {
                    ((zzhj)object3).zzgg().zzil().zze("Deleted fewer rows from raw events table than expected", n11, object4.size());
                }
                object4 = string6;
                object3 = this.zzga();
                stringBuilder = ((zzei)object3).getWritableDatabase();
                try {
                    stringBuilder.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{object4, object4});
                }
                catch (SQLiteException sQLiteException) {
                    ((zzhj)object3).zzgg().zzil().zze("Failed to remove unused event metadata. appId", zzfg.zzbh((String)object4), (Object)sQLiteException);
                }
                this.zzga().setTransactionSuccessful();
                return true;
            }
            this.zzga().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzga().endTransaction();
        }
    }

    private final zzkh[] zza(String string, zzkn[] zzknArray, zzki[] zzkiArray) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzft().zza(string, zzkiArray, zzknArray);
    }

    @VisibleForTesting
    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        ((zzhj)this.zzgf()).zzab();
        this.zzch();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzgg().zzir().zzg("onConfigFetched. Response size", byArray.length);
            this.zzga().beginTransaction();
            try {
                boolean bl;
                zzeb zzeb2 = this.zzga().zzax(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzeb2 == null) {
                    this.zzgg().zzin().zzg("App does not exist in onConfigFetched. appId", zzfg.zzbh(string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzgd().zzbp(string) == null && !this.zzgd().zza(string, null, null) : !this.zzgd().zza(string, byArray, string2)) {
                        return;
                    }
                    zzeb2.zzs(this.zzrj.currentTimeMillis());
                    this.zzga().zza(zzeb2);
                    if (n == 404) {
                        this.zzgg().zzio().zzg("Config not found. Using empty config. appId", string);
                    } else {
                        this.zzgg().zzir().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                    }
                    if (this.zzjq().zzew() && this.zzjx()) {
                        this.zzjw();
                    } else {
                        this.zzjy();
                    }
                } else {
                    zzeb2.zzt(this.zzrj.currentTimeMillis());
                    this.zzga().zza(zzeb2);
                    this.zzgg().zzir().zze("Fetching config failed. code, error", n, throwable);
                    this.zzgd().zzbr(string);
                    this.zzgh().zzaju.set(this.zzrj.currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzgh().zzajv.set(this.zzrj.currentTimeMillis());
                    }
                    this.zzjy();
                }
                this.zzga().setTransactionSuccessful();
            }
            finally {
                this.zzga().endTransaction();
            }
            return;
        }
        finally {
            this.zzanl = false;
            this.zzkc();
        }
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(int n, Throwable throwable, byte[] byArray, String string) {
        ((zzhj)this.zzgf()).zzab();
        this.zzch();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzanf;
            this.zzanf = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzgh().zzajt.set(this.zzrj.currentTimeMillis());
                    this.zzgh().zzaju.set(0L);
                    this.zzjy();
                    this.zzgg().zzir().zze("Successful upload. Got network response. code, size", n, byArray.length);
                    this.zzga().beginTransaction();
                    try {
                        for (Long l : list) {
                            long l2 = l;
                            zzei zzei2 = this.zzga();
                            zzei2.zzab();
                            zzei2.zzch();
                            SQLiteDatabase sQLiteDatabase = zzei2.getWritableDatabase();
                            String[] stringArray = new String[]{String.valueOf(l2)};
                            try {
                                if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                throw new SQLiteException("Deleted fewer rows from queue than expected");
                            }
                            catch (SQLiteException sQLiteException) {
                                zzei2.zzgg().zzil().zzg("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                throw sQLiteException;
                            }
                        }
                        this.zzga().setTransactionSuccessful();
                    }
                    finally {
                        this.zzga().endTransaction();
                    }
                    if (this.zzjq().zzew() && this.zzjx()) {
                        this.zzjw();
                    } else {
                        this.zzanj = -1L;
                        this.zzjy();
                    }
                    this.zzank = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzgg().zzil().zzg("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzank = this.zzrj.elapsedRealtime();
                    this.zzgg().zzir().zzg("Disable upload, time", this.zzank);
                }
            } else {
                String string2;
                this.zzgg().zzir().zze("Network upload failed. Will retry later. code, error", n, throwable);
                this.zzgh().zzaju.set(this.zzrj.currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzgh().zzajv.set(this.zzrj.currentTimeMillis());
                }
                if (this.zzamd.zzd(string2 = string, zzew.zzaia)) {
                    this.zzga().zzc(list);
                }
                this.zzjy();
            }
            return;
        }
        finally {
            this.zzanm = false;
            this.zzkc();
        }
    }

    private final boolean zzjx() {
        ((zzhj)this.zzgf()).zzab();
        this.zzch();
        return this.zzga().zzhs() || !TextUtils.isEmpty((CharSequence)this.zzga().zzhn());
    }

    @WorkerThread
    private final void zzjy() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            ((zzhj)this.zzgf()).zzab();
            this.zzch();
            if (!this.zzkb()) {
                return;
            }
            if (this.zzank > 0L) {
                l3 = this.zzrj.elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzank);
                if (l2 > 0L) {
                    this.zzgg().zzir().zzg("Upload has been suspended. Will update scheduling later in approximately ms", l2);
                    this.zzjr().unregister();
                    this.zzjs().cancel();
                    return;
                }
                this.zzank = 0L;
            }
            if (!this.zzjk() || !this.zzjx()) {
                this.zzgg().zzir().log("Nothing to upload or uploading impossible");
                this.zzjr().unregister();
                this.zzjs().cancel();
                return;
            }
            zzgl zzgl2 = this;
            long l4 = zzgl2.zzrj.currentTimeMillis();
            long l5 = Math.max(0L, zzew.zzahl.get());
            boolean bl = zzgl2.zzga().zzht() || zzgl2.zzga().zzho();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzgl2.zzamd.zzhl())) && !".none.".equals(string) ? Math.max(0L, zzew.zzahg.get()) : Math.max(0L, zzew.zzahf.get())) : Math.max(0L, zzew.zzahe.get());
            long l7 = zzgl2.zzgh().zzajt.get();
            long l8 = zzgl2.zzgh().zzaju.get();
            long l9 = zzgl2.zzga().zzhq();
            long l10 = zzgl2.zzga().zzhr();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzgl2.zzgc().zza(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, zzew.zzahn.get())); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, zzew.zzahm.get()) * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzgg().zzir().log("Next upload time is 0");
            this.zzjr().unregister();
            this.zzjs().cancel();
            return;
        }
        if (!this.zzjq().zzew()) {
            this.zzgg().zzir().log("No network");
            this.zzjr().zzet();
            this.zzjs().cancel();
            return;
        }
        l2 = this.zzgh().zzajv.get();
        long l16 = Math.max(0L, zzew.zzahc.get());
        if (!this.zzgc().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzjr().unregister();
        long l17 = l3 - this.zzrj.currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, zzew.zzahh.get());
            this.zzgh().zzajt.set(this.zzrj.currentTimeMillis());
        }
        this.zzgg().zzir().zzg("Upload scheduled in approximately ms", l17);
        this.zzjs().zzh(l17);
    }

    public final void zzi(boolean bl) {
        this.zzjy();
    }

    final void zzb(zzhk zzhk2) {
        ++this.zzanh;
    }

    final void zzjz() {
        ++this.zzani;
    }

    @WorkerThread
    public final void zzg(zzec zzec2) {
        int n;
        ((zzhj)this.zzgf()).zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)((Object)zzec2));
        Preconditions.checkNotEmpty((String)zzec2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzec2.zzadh)) {
            return;
        }
        zzeb zzeb2 = this.zzga().zzax(zzec2.packageName);
        if (zzeb2 != null && TextUtils.isEmpty((CharSequence)zzeb2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzec2.zzadh)) {
            zzeb2.zzs(0L);
            this.zzga().zza(zzeb2);
            this.zzgd().zzbs(zzec2.packageName);
        }
        if (!zzec2.zzadr) {
            this.zzh(zzec2);
            return;
        }
        long l = zzec2.zzaeh;
        if (l == 0L) {
            l = this.zzrj.currentTimeMillis();
        }
        if ((n = zzec2.zzaei) != 0 && n != 1) {
            this.zzgg().zzin().zze("Incorrect app type, assuming installed app. appId, appType", zzfg.zzbh(zzec2.packageName), n);
            n = 0;
        }
        this.zzga().beginTransaction();
        try {
            zzeu zzeu2;
            Object object;
            long l2 = l;
            zzec zzec3 = zzec2;
            zzgl zzgl2 = this;
            zzeb zzeb3 = zzgl2.zzga().zzax(zzec3.packageName);
            if (zzeb3 != null && zzeb3.getGmpAppId() != null && !zzeb3.getGmpAppId().equals(zzec3.zzadh)) {
                zzgl2.zzgg().zzin().zzg("New GMP App Id passed in. Removing cached database data. appId", zzfg.zzbh(zzeb3.zzah()));
                String string = zzeb3.zzah();
                zzei zzei2 = zzgl2.zzga();
                zzei2.zzch();
                zzei2.zzab();
                Preconditions.checkNotEmpty((String)string);
                try {
                    SQLiteDatabase sQLiteDatabase = zzei2.getWritableDatabase();
                    String[] stringArray = new String[]{string};
                    int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                    if (n2 > 0) {
                        zzei2.zzgg().zzir().zze("Deleted application data. app, records", string, n2);
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzei2.zzgg().zzil().zze("Error deleting application data. appId, error", zzfg.zzbh(string), (Object)sQLiteException);
                }
                zzeb3 = null;
            }
            if (zzeb3 != null) {
                if (zzeb3.zzgo() != Integer.MIN_VALUE) {
                    if (zzeb3.zzgo() != zzec3.zzadn) {
                        object = new Bundle();
                        object.putString("_pv", zzeb3.zzag());
                        zzeu2 = new zzeu("_au", new zzer((Bundle)object), "auto", l2);
                        zzgl2.zzb(zzeu2, zzec3);
                    }
                } else if (zzeb3.zzag() != null && !zzeb3.zzag().equals(zzec3.zztc)) {
                    object = new Bundle();
                    object.putString("_pv", zzeb3.zzag());
                    zzeu2 = new zzeu("_au", new zzer((Bundle)object), "auto", l2);
                    zzgl2.zzb(zzeu2, zzec3);
                }
            }
            this.zzh(zzec2);
            zzeq zzeq2 = null;
            if (n == 0) {
                zzeq2 = this.zzga().zze(zzec2.packageName, "_f");
            } else if (n == 1) {
                zzeq2 = this.zzga().zze(zzec2.packageName, "_v");
            }
            if (zzeq2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    AbstractSafeParcelable abstractSafeParcelable;
                    zzjs zzjs2 = new zzjs("_fot", l, l3, "auto");
                    this.zzb(zzjs2, zzec2);
                    l2 = l;
                    zzec3 = zzec2;
                    zzgl2 = this;
                    ((zzhj)zzgl2.zzgf()).zzab();
                    zzgl2.zzch();
                    zzeb3 = new Bundle();
                    zzeb3.putLong("_c", 1L);
                    zzeb3.putLong("_r", 1L);
                    zzeb3.putLong("_uwa", 0L);
                    zzeb3.putLong("_pfo", 0L);
                    zzeb3.putLong("_sys", 0L);
                    zzeb3.putLong("_sysu", 0L);
                    if (zzgl2.zzamd.zzav(zzec3.packageName) && zzec3.zzaej) {
                        zzeb3.putLong("_dac", 1L);
                    }
                    if (zzgl2.zzqs.getPackageManager() == null) {
                        zzgl2.zzgg().zzil().zzg("PackageManager is null, first open report might be inaccurate. appId", zzfg.zzbh(zzec3.packageName));
                    } else {
                        zzeu2 = null;
                        try {
                            zzeu2 = Wrappers.packageManager((Context)zzgl2.zzqs).getPackageInfo(zzec3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzgl2.zzgg().zzil().zze("Package info is null, first open report might be inaccurate. appId", zzfg.zzbh(zzec3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzeu2 != null && ((PackageInfo)zzeu2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzeu2).firstInstallTime != ((PackageInfo)zzeu2).lastUpdateTime) {
                                zzeb3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            abstractSafeParcelable = new zzjs("_fi", l2, bl ? 1L : 0L, "auto");
                            zzgl2.zzb((zzjs)abstractSafeParcelable, zzec3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzgl2.zzqs).getApplicationInfo(zzec3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzgl2.zzgg().zzil().zze("Application info is null, first open report might be inaccurate. appId", zzfg.zzbh(zzec3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzeb3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzeb3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzec3.packageName;
                    zzei zzei3 = zzgl2.zzga();
                    Preconditions.checkNotEmpty((String)string);
                    zzei3.zzab();
                    zzei3.zzch();
                    long l4 = zzei3.zzl(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzeb3.putLong("_pfo", l4);
                    }
                    abstractSafeParcelable = new zzeu("_f", new zzer((Bundle)zzeb3), "auto", l2);
                    zzgl2.zzb((zzeu)abstractSafeParcelable, zzec3);
                } else if (n == 1) {
                    zzjs zzjs3 = new zzjs("_fvt", l, l3, "auto");
                    this.zzb(zzjs3, zzec2);
                    l2 = l;
                    zzec3 = zzec2;
                    zzgl2 = this;
                    ((zzhj)zzgl2.zzgf()).zzab();
                    zzgl2.zzch();
                    zzeb3 = new Bundle();
                    zzeb3.putLong("_c", 1L);
                    zzeb3.putLong("_r", 1L);
                    if (zzgl2.zzamd.zzav(zzec3.packageName) && zzec3.zzaej) {
                        zzeb3.putLong("_dac", 1L);
                    }
                    object = new zzeu("_v", new zzer((Bundle)zzeb3), "auto", l2);
                    zzgl2.zzb((zzeu)((Object)object), zzec3);
                }
                l2 = l;
                zzec3 = zzec2;
                zzgl2 = this;
                zzeb3 = new Bundle();
                zzeb3.putLong("_et", 1L);
                object = new zzeu("_e", new zzer((Bundle)zzeb3), "auto", l2);
                zzgl2.zzb((zzeu)((Object)object), zzec3);
            } else if (zzec2.zzaeg) {
                l2 = l;
                zzec3 = zzec2;
                zzgl2 = this;
                zzeb3 = new Bundle();
                object = new zzeu("_cd", new zzer((Bundle)zzeb3), "auto", l2);
                zzgl2.zzb((zzeu)((Object)object), zzec3);
            }
            this.zzga().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzga().endTransaction();
        }
    }

    @WorkerThread
    private final zzeb zzh(zzec zzec2) {
        ((zzhj)this.zzgf()).zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)((Object)zzec2));
        Preconditions.checkNotEmpty((String)zzec2.packageName);
        zzeb zzeb2 = this.zzga().zzax(zzec2.packageName);
        String string = this.zzgh().zzbk(zzec2.packageName);
        boolean bl = false;
        if (zzeb2 == null) {
            zzeb2 = new zzeb(this, zzec2.packageName);
            zzeb2.zzal(this.zzfv().zzih());
            zzeb2.zzan(string);
            bl = true;
        } else if (!string.equals(zzeb2.zzgk())) {
            zzeb2.zzan(string);
            zzeb2.zzal(this.zzfv().zzih());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzec2.zzadh) && !zzec2.zzadh.equals(zzeb2.getGmpAppId())) {
            zzeb2.zzam(zzec2.zzadh);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzec2.zzadj) && !zzec2.zzadj.equals(zzeb2.zzgl())) {
            zzeb2.zzao(zzec2.zzadj);
            bl = true;
        }
        if (zzec2.zzadp != 0L && zzec2.zzadp != zzeb2.zzgq()) {
            zzeb2.zzp(zzec2.zzadp);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzec2.zztc) && !zzec2.zztc.equals(zzeb2.zzag())) {
            zzeb2.setAppVersion(zzec2.zztc);
            bl = true;
        }
        if (zzec2.zzadn != zzeb2.zzgo()) {
            zzeb2.zzo(zzec2.zzadn);
            bl = true;
        }
        if (zzec2.zzado != null && !zzec2.zzado.equals(zzeb2.zzgp())) {
            zzeb2.zzap(zzec2.zzado);
            bl = true;
        }
        if (zzec2.zzadq != zzeb2.zzgr()) {
            zzeb2.zzq(zzec2.zzadq);
            bl = true;
        }
        if (zzec2.zzadr != zzeb2.isMeasurementEnabled()) {
            zzeb2.setMeasurementEnabled(zzec2.zzadr);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzec2.zzaef) && !zzec2.zzaef.equals(zzeb2.zzhc())) {
            zzeb2.zzaq(zzec2.zzaef);
            bl = true;
        }
        if (zzec2.zzads != zzeb2.zzhe()) {
            zzeb2.zzaa(zzec2.zzads);
            bl = true;
        }
        if (zzec2.zzadt != zzeb2.zzhf()) {
            zzeb2.zzd(zzec2.zzadt);
            bl = true;
        }
        if (zzec2.zzadu != zzeb2.zzhg()) {
            zzeb2.zze(zzec2.zzadu);
            bl = true;
        }
        if (bl) {
            this.zzga().zza(zzeb2);
        }
        return zzeb2;
    }

    @WorkerThread
    final void zzka() {
        ((zzhj)this.zzgf()).zzab();
        this.zzch();
        if (!this.zzana) {
            this.zzgg().zzip().log("This instance being marked as an uploader");
            zzgl zzgl2 = this;
            ((zzhj)zzgl2.zzgf()).zzab();
            zzgl2.zzch();
            if (zzgl2.zzkb() && zzgl2.zzjt()) {
                int n;
                int n2 = zzgl2.zza(zzgl2.zzane);
                int n3 = n = zzgl2.zzfv().zzii();
                int n4 = n2;
                zzgl zzgl3 = zzgl2;
                ((zzhj)zzgl3.zzgf()).zzab();
                if (n4 > n3) {
                    zzgl3.zzgg().zzil().zze("Panic: can't downgrade version. Previous, current version", n4, n3);
                } else if (n4 < n3) {
                    if (zzgl3.zza(n3, zzgl3.zzane)) {
                        zzgl3.zzgg().zzir().zze("Storage version upgraded. Previous, current version", n4, n3);
                    } else {
                        zzgl3.zzgg().zzil().zze("Storage version upgrade failed. Previous, current version", n4, n3);
                    }
                }
            }
            this.zzana = true;
            this.zzjy();
        }
    }

    @WorkerThread
    private final boolean zzkb() {
        ((zzhj)this.zzgf()).zzab();
        this.zzch();
        return this.zzana;
    }

    @WorkerThread
    final void zze(Runnable runnable) {
        ((zzhj)this.zzgf()).zzab();
        if (this.zzang == null) {
            this.zzang = new ArrayList<Runnable>();
        }
        this.zzang.add(runnable);
    }

    @WorkerThread
    private final void zzkc() {
        ((zzhj)this.zzgf()).zzab();
        if (this.zzanl || this.zzanm || this.zzann) {
            this.zzgg().zzir().zzd("Not stopping services. fetch, network, upload", this.zzanl, this.zzanm, this.zzann);
            return;
        }
        this.zzgg().zzir().log("Stopping uploading service(s)");
        if (this.zzang == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzang.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzang.clear();
    }

    @WorkerThread
    private final Boolean zzc(zzeb zzeb2) {
        try {
            if (zzeb2.zzgo() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzqs).getPackageInfo((String)zzeb2.zzah(), (int)0).versionCode;
                if (zzeb2.zzgo() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzqs).getPackageInfo((String)zzeb2.zzah(), (int)0).versionName;
                if (zzeb2.zzag() != null && zzeb2.zzag().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    static /* synthetic */ void zza(zzgl zzgl2, zzhl zzhl2) {
        zzgl2.zza(zzhl2);
    }

    static /* synthetic */ zzeb zza(zzgl zzgl2, zzec zzec2) {
        return zzgl2.zzh(zzec2);
    }

    final class zza
    implements zzek {
        zzkl zzans;
        List<Long> zzant;
        List<zzki> zzanu;
        private long zzanv;

        private zza() {
        }

        @Override
        public final void zzb(zzkl zzkl2) {
            Preconditions.checkNotNull((Object)((Object)zzkl2));
            this.zzans = zzkl2;
        }

        @Override
        public final boolean zza(long l, zzki zzki2) {
            Preconditions.checkNotNull((Object)((Object)zzki2));
            if (this.zzanu == null) {
                this.zzanu = new ArrayList<zzki>();
            }
            if (this.zzant == null) {
                this.zzant = new ArrayList<Long>();
            }
            if (this.zzanu.size() > 0 && zza.zza(this.zzanu.get(0)) != zza.zza(zzki2)) {
                return false;
            }
            long l2 = this.zzanv + (long)zzki2.zzwg();
            if (l2 >= (long)Math.max(0, zzew.zzagt.get())) {
                return false;
            }
            this.zzanv = l2;
            this.zzanu.add(zzki2);
            this.zzant.add(l);
            return this.zzanu.size() < Math.max(1, zzew.zzagu.get());
        }

        private static long zza(zzki zzki2) {
            return zzki2.zzasw / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzgm zzgm2) {
            this();
        }
    }
}

