/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzgr;
import com.google.android.gms.internal.measurement.zzgs;
import com.google.android.gms.internal.measurement.zzgt;
import com.google.android.gms.internal.measurement.zzgu;
import com.google.android.gms.internal.measurement.zzgv;
import com.google.android.gms.internal.measurement.zzgw;
import com.google.android.gms.internal.measurement.zzgx;
import com.google.android.gms.internal.measurement.zzgy;
import com.google.android.gms.internal.measurement.zzgz;
import com.google.android.gms.internal.measurement.zzha;
import com.google.android.gms.internal.measurement.zzhb;
import com.google.android.gms.internal.measurement.zzhc;
import com.google.android.gms.internal.measurement.zzhd;
import com.google.android.gms.internal.measurement.zzhe;
import com.google.android.gms.internal.measurement.zzhf;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzju;
import com.google.android.gms.internal.measurement.zzjv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzgq
extends zzez {
    private final zzgl zzacr;
    private Boolean zzanw;
    @Nullable
    private String zzanx;

    public zzgq(zzgl zzgl2) {
        this(zzgl2, null);
    }

    private zzgq(zzgl zzgl2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzgl2);
        this.zzacr = zzgl2;
        this.zzanx = null;
    }

    @Override
    @BinderThread
    public final void zzb(zzec zzec2) {
        this.zzb(zzec2, false);
        this.zzacr.zzgf().zzc(new zzgr(this, zzec2));
    }

    @Override
    @BinderThread
    public final void zza(zzeu zzeu2, zzec zzec2) {
        Preconditions.checkNotNull((Object)((Object)zzeu2));
        this.zzb(zzec2, false);
        this.zzacr.zzgf().zzc(new zzhb(this, zzeu2, zzec2));
    }

    @Override
    @BinderThread
    public final void zza(zzeu zzeu2, String string, String string2) {
        Preconditions.checkNotNull((Object)((Object)zzeu2));
        Preconditions.checkNotEmpty((String)string);
        this.zzc(string, true);
        this.zzacr.zzgf().zzc(new zzhc(this, zzeu2, string));
    }

    @Override
    @BinderThread
    public final byte[] zza(zzeu zzeu2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzeu2));
        this.zzc(string, true);
        this.zzacr.zzgg().zziq().zzg("Log and bundle. event", this.zzacr.zzgb().zzbe(zzeu2.name));
        long l = this.zzacr.zzbt().nanoTime() / 1000000L;
        Future<byte[]> future = this.zzacr.zzgf().zzc(new zzhd(this, zzeu2, string));
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.zzacr.zzgg().zzil().zzg("Log and bundle returned null. appId", zzfg.zzbh(string));
                byArray = new byte[]{};
            }
            long l2 = this.zzacr.zzbt().nanoTime() / 1000000L;
            this.zzacr.zzgg().zziq().zzd("Log and bundle processed. event, size, time_ms", this.zzacr.zzgb().zzbe(zzeu2.name), byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzacr.zzgg().zzil().zzd("Failed to log and bundle. appId, event, error", zzfg.zzbh(string), this.zzacr.zzgb().zzbe(zzeu2.name), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzjs zzjs2, zzec zzec2) {
        Preconditions.checkNotNull((Object)((Object)zzjs2));
        this.zzb(zzec2, false);
        if (zzjs2.getValue() == null) {
            this.zzacr.zzgf().zzc(new zzhe(this, zzjs2, zzec2));
            return;
        }
        this.zzacr.zzgf().zzc(new zzhf(this, zzjs2, zzec2));
    }

    @Override
    @BinderThread
    public final List<zzjs> zza(zzec zzec2, boolean bl) {
        this.zzb(zzec2, false);
        Future<List<zzju>> future = this.zzacr.zzgf().zzb(new zzhg(this, zzec2));
        try {
            List<zzju> list = future.get();
            ArrayList<zzjs> arrayList = new ArrayList<zzjs>(list.size());
            for (zzju zzju2 : list) {
                if (!bl && zzjv.zzcb(zzju2.name)) continue;
                arrayList.add(new zzjs(zzju2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzacr.zzgg().zzil().zze("Failed to get user attributes. appId", zzfg.zzbh(zzec2.packageName), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzec zzec2) {
        this.zzb(zzec2, false);
        zzhh zzhh2 = new zzhh(this, zzec2);
        if (this.zzacr.zzgf().zzjg()) {
            zzhh2.run();
            return;
        }
        this.zzacr.zzgf().zzc(zzhh2);
    }

    @BinderThread
    private final void zzb(zzec zzec2, boolean bl) {
        Preconditions.checkNotNull((Object)((Object)zzec2));
        this.zzc(zzec2.packageName, false);
        this.zzacr.zzgc().zzbz(zzec2.zzadh);
    }

    @BinderThread
    private final void zzc(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzacr.zzgg().zzil().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzgq zzgq2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzgq2 = this;
                    if (!bl2) break block9;
                    if (zzgq2.zzanw == null) {
                        zzgq2.zzanw = "com.google.android.gms".equals(zzgq2.zzanx) || UidVerifier.isGooglePlayServicesUid((Context)zzgq2.zzacr.getContext(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzgq2.zzacr.getContext()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzgq2.zzanw.booleanValue()) break block10;
                }
                if (zzgq2.zzanx == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzgq2.zzacr.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzgq2.zzanx = string2;
                }
                if (!string2.equals(zzgq2.zzanx)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzacr.zzgg().zzil().zzg("Measurement Service called with invalid calling package. appId", zzfg.zzbh(string));
            throw securityException;
        }
    }

    @Override
    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zzacr.zzgf().zzc(new zzhi(this, string2, string3, string, l));
    }

    @Override
    @BinderThread
    public final String zzc(zzec zzec2) {
        this.zzb(zzec2, false);
        return this.zzacr.zzf(zzec2);
    }

    @Override
    @BinderThread
    public final void zza(zzef zzef2, zzec zzec2) {
        Preconditions.checkNotNull((Object)((Object)zzef2));
        Preconditions.checkNotNull((Object)((Object)zzef2.zzael));
        this.zzb(zzec2, false);
        zzef zzef3 = new zzef(zzef2);
        new zzef(zzef2).packageName = zzec2.packageName;
        if (zzef2.zzael.getValue() == null) {
            this.zzacr.zzgf().zzc(new zzgs(this, zzef3, zzec2));
            return;
        }
        this.zzacr.zzgf().zzc(new zzgt(this, zzef3, zzec2));
    }

    @Override
    @BinderThread
    public final void zzb(zzef zzef2) {
        Preconditions.checkNotNull((Object)((Object)zzef2));
        Preconditions.checkNotNull((Object)((Object)zzef2.zzael));
        this.zzc(zzef2.packageName, true);
        zzef zzef3 = new zzef(zzef2);
        if (zzef2.zzael.getValue() == null) {
            this.zzacr.zzgf().zzc(new zzgu(this, zzef3));
            return;
        }
        this.zzacr.zzgf().zzc(new zzgv(this, zzef3));
    }

    @Override
    @BinderThread
    public final List<zzjs> zza(String string, String string2, boolean bl, zzec zzec2) {
        this.zzb(zzec2, false);
        Future<List<zzju>> future = this.zzacr.zzgf().zzb(new zzgw(this, zzec2, string, string2));
        try {
            List<zzju> list = future.get();
            ArrayList<zzjs> arrayList = new ArrayList<zzjs>(list.size());
            for (zzju zzju2 : list) {
                if (!bl && zzjv.zzcb(zzju2.name)) continue;
                arrayList.add(new zzjs(zzju2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzacr.zzgg().zzil().zze("Failed to get user attributes. appId", zzfg.zzbh(zzec2.packageName), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzjs> zza(String string, String string2, String string3, boolean bl) {
        this.zzc(string, true);
        Future<List<zzju>> future = this.zzacr.zzgf().zzb(new zzgx(this, string, string2, string3));
        try {
            List<zzju> list = future.get();
            ArrayList<zzjs> arrayList = new ArrayList<zzjs>(list.size());
            for (zzju zzju2 : list) {
                if (!bl && zzjv.zzcb(zzju2.name)) continue;
                arrayList.add(new zzjs(zzju2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzacr.zzgg().zzil().zze("Failed to get user attributes. appId", zzfg.zzbh(string), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzef> zza(String string, String string2, zzec zzec2) {
        this.zzb(zzec2, false);
        Future<List<zzef>> future = this.zzacr.zzgf().zzb(new zzgy(this, zzec2, string, string2));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzacr.zzgg().zzil().zzg("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzef> zze(String string, String string2, String string3) {
        this.zzc(string, true);
        Future<List<zzef>> future = this.zzacr.zzgf().zzb(new zzgz(this, string, string2, string3));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzacr.zzgg().zzil().zzg("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final void zzd(zzec zzec2) {
        this.zzc(zzec2.packageName, false);
        this.zzacr.zzgf().zzc(new zzha(this, zzec2));
    }

    static /* synthetic */ zzgl zza(zzgq zzgq2) {
        return zzgq2.zzacr;
    }
}

