/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.android.gms.internal.measurement.zzhn;
import com.google.android.gms.internal.measurement.zzho;
import com.google.android.gms.internal.measurement.zzhp;
import com.google.android.gms.internal.measurement.zzhq;
import com.google.android.gms.internal.measurement.zzhr;
import com.google.android.gms.internal.measurement.zzhs;
import com.google.android.gms.internal.measurement.zzht;
import com.google.android.gms.internal.measurement.zzhu;
import com.google.android.gms.internal.measurement.zzhv;
import com.google.android.gms.internal.measurement.zzhw;
import com.google.android.gms.internal.measurement.zzhx;
import com.google.android.gms.internal.measurement.zzhy;
import com.google.android.gms.internal.measurement.zzhz;
import com.google.android.gms.internal.measurement.zzia;
import com.google.android.gms.internal.measurement.zzib;
import com.google.android.gms.internal.measurement.zzic;
import com.google.android.gms.internal.measurement.zzid;
import com.google.android.gms.internal.measurement.zzie;
import com.google.android.gms.internal.measurement.zzif;
import com.google.android.gms.internal.measurement.zzih;
import com.google.android.gms.internal.measurement.zzik;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzjv;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class zzhm
extends zzhk {
    @VisibleForTesting
    protected zzif zzaoi;
    private AppMeasurement.EventInterceptor zzaoj;
    private final Set<AppMeasurement.OnEventListener> zzaok = new CopyOnWriteArraySet<AppMeasurement.OnEventListener>();
    private boolean zzaol;
    private final AtomicReference<String> zzaom = new AtomicReference();
    @VisibleForTesting
    protected boolean zzaon = true;

    protected zzhm(zzgl zzgl2) {
        super(zzgl2);
    }

    @Override
    protected final boolean zzhh() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Boolean zzke() {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzhj)this).zzgf().zzc(new zzhn(this, atomicReference));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhj)this).zzgg().zzin().log("Interrupted waiting for boolean test flag value");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            return (Boolean)atomicReference.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzkf() {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzhj)this).zzgf().zzc(new zzhx(this, atomicReference));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhj)this).zzgg().zzin().log("Interrupted waiting for String test flag value");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Long zzkg() {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzhj)this).zzgf().zzc(new zzhy(this, atomicReference));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhj)this).zzgg().zzin().log("Interrupted waiting for long test flag value");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            return (Long)atomicReference.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Integer zzkh() {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzhj)this).zzgf().zzc(new zzhz(this, atomicReference));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhj)this).zzgg().zzin().log("Interrupted waiting for int test flag value");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            return (Integer)atomicReference.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Double zzki() {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzhj)this).zzgf().zzc(new zzia(this, atomicReference));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhj)this).zzgg().zzin().log("Interrupted waiting for double test flag value");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            return (Double)atomicReference.get();
        }
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzch();
        ((zzhj)this).zzgf().zzc(new zzib(this, bl));
    }

    @WorkerThread
    private final void zzj(boolean bl) {
        ((zzhj)this).zzab();
        this.zzch();
        ((zzhj)this).zzgg().zziq().zzg("Setting app measurement enabled (FE)", bl);
        ((zzhj)this).zzgh().setMeasurementEnabled(bl);
        if (((zzhj)this).zzgi().zzav(((zzhj)this).zzfv().zzah())) {
            if (this.zzacr.isEnabled() && this.zzaon) {
                ((zzhj)this).zzgg().zziq().log("Recording app launch after enabling measurement for the first time (FE)");
                this.zzkj();
                return;
            }
            ((zzhj)this).zzfx().zzkm();
            return;
        }
        ((zzhj)this).zzfx().zzkm();
    }

    public final void setMinimumSessionDuration(long l) {
        ((zzhj)this).zzgf().zzc(new zzic(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        ((zzhj)this).zzgf().zzc(new zzid(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        boolean bl2 = this.zzaoj == null || zzjv.zzcb(string2);
        this.zza(string, string2, bundle, true, bl2, true, null);
    }

    public final void zza(String string, String string2, Bundle bundle) {
        boolean bl = this.zzaoj == null || zzjv.zzcb(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    public final void zza(String string, String string2, Bundle bundle, long l) {
        this.zza(string, string2, l, bundle, false, true, true, null);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zza(string, string2, ((zzhj)this).zzbt().currentTimeMillis(), bundle, true, bl2, bl3, null);
    }

    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Bundle bundle3 = bundle;
        if (bundle3 == null) {
            bundle2 = new Bundle();
        } else {
            Bundle bundle4 = new Bundle(bundle3);
            for (String string4 : bundle4.keySet()) {
                int n;
                Object object;
                Object object2 = bundle4.get(string4);
                if (object2 instanceof Bundle) {
                    bundle4.putBundle(string4, new Bundle((Bundle)object2));
                    continue;
                }
                if (object2 instanceof Parcelable[]) {
                    object = (Parcelable[])object2;
                    for (n = 0; n < ((Parcelable[])object).length; ++n) {
                        if (!(object[n] instanceof Bundle)) continue;
                        object[n] = new Bundle((Bundle)object[n]);
                    }
                    continue;
                }
                if (!(object2 instanceof ArrayList)) continue;
                object = (ArrayList)object2;
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    Object e = ((ArrayList)object).get(n);
                    if (!(e instanceof Bundle)) continue;
                    ((ArrayList)object).set(n, new Bundle((Bundle)e));
                }
            }
            bundle2 = bundle4;
        }
        Bundle bundle5 = bundle2;
        ((zzhj)this).zzgf().zzc(new zzie(this, string, string2, l, bundle5, bl, bl2, bl3, string3));
    }

    @WorkerThread
    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Object object;
        Object object2;
        Object object3;
        zzik zzik2;
        zzik zzik3;
        zzik zzik4;
        Object object4;
        zzhk zzhk2;
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        Preconditions.checkNotNull((Object)bundle);
        ((zzhj)this).zzab();
        this.zzch();
        if (!this.zzacr.isEnabled()) {
            ((zzhj)this).zzgg().zziq().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzaol) {
            this.zzaol = true;
            zzhk2 = this;
            try {
                object4 = Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                Class<?> clazz = object4;
                zzhm zzhm2 = zzhk2;
                try {
                    clazz.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzhj)zzhm2).getContext());
                }
                catch (Exception exception) {
                    ((zzhj)zzhm2).zzgg().zzin().zzg("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                zzhk2.zzgg().zzip().log("Tag Manager is not found and thus will not be used");
            }
        }
        if (bl3 && !"_iap".equals(string2)) {
            int n;
            object4 = string2;
            zzhk2 = this.zzacr.zzgc();
            if ((!((zzjv)zzhk2).zzq("event", (String)object4) ? 2 : (!((zzjv)zzhk2).zza("event", AppMeasurement.Event.zzacs, (String)object4) ? 13 : (n = !((zzjv)zzhk2).zza("event", 40, (String)object4) ? 2 : 0))) != 0) {
                this.zzacr.zzgc();
                String string4 = zzjv.zza(string2, 40, true);
                int n2 = string2 != null ? string2.length() : 0;
                this.zzacr.zzgc().zza(n, "_ev", string4, n2);
                return;
            }
        }
        if ((zzik4 = ((zzhj)this).zzfy().zzkk()) != null && !bundle.containsKey("_sc")) {
            zzik4.zzapq = true;
        }
        zzik zzik5 = zzik4;
        zzih.zza(zzik5, bundle, bl && bl3);
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzjv.zzcb(string2);
        if (bl && this.zzaoj != null && !bl5 && !bl4) {
            ((zzhj)this).zzgg().zziq().zze("Passing event to registered event handler (FE)", ((zzhj)this).zzgb().zzbe(string2), ((zzhj)this).zzgb().zzb(bundle));
            this.zzaoj.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzacr.zzjk()) {
            return;
        }
        int n = ((zzhj)this).zzgc().zzbw(string2);
        if (n != 0) {
            ((zzhj)this).zzgc();
            String string5 = zzjv.zza(string2, 40, true);
            int n3 = string2 != null ? string2.length() : 0;
            this.zzacr.zzgc().zza(string3, n, "_ev", string5, n3);
            return;
        }
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        Bundle bundle3 = ((zzhj)this).zzgc().zza(string2, bundle, list, bl3, true);
        zzhk2 = bundle3;
        if (bundle3 == null || !zzhk2.containsKey("_sc") || !zzhk2.containsKey("_si")) {
            zzik3 = null;
        } else {
            object4 = zzhk2.getString("_sn");
            String string6 = zzhk2.getString("_sc");
            Long l2 = zzhk2.getLong("_si");
            zzik3 = zzik2 = new zzik((String)object4, string6, l2);
        }
        if (zzik3 == null) {
            zzik2 = zzik5;
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l3 = ((zzhj)this).zzgc().zzku().nextLong();
        int n4 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object[] objectArray2 = objectArray;
        int n5 = objectArray.length;
        for (int i = 0; i < n5; ++i) {
            object3 = objectArray2[i];
            object2 = bundle3.get((String)object3);
            ((zzhj)this).zzgc();
            object = zzjv.zze(object2);
            if (object == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])object).length);
            for (int j = 0; j < ((Bundle[])object).length; ++j) {
                Bundle object5 = object[j];
                zzih.zza(zzik2, object5, true);
                bundle2 = ((zzhj)this).zzgc().zza("_ep", object5, list, bl3, false);
                bundle2.putString("_en", string2);
                bundle2.putLong("_eid", l3);
                bundle2.putString("_gn", (String)object3);
                bundle2.putInt("_ll", ((Bundle[])object).length);
                bundle2.putInt("_i", j);
                arrayList.add(bundle2);
            }
            n4 += ((Bundle[])object).length;
        }
        if (n4 != 0) {
            bundle3.putLong("_eid", l3);
            bundle3.putInt("_epc", n4);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle4 = (Bundle)arrayList.get(i);
            object3 = i != 0 ? "_ep" : string2;
            bundle4.putString("_o", string);
            object2 = bl2 ? ((zzhj)this).zzgc().zzd(bundle4) : bundle4;
            ((zzhj)this).zzgg().zziq().zze("Logging event (FE)", ((zzhj)this).zzgb().zzbe(string2), ((zzhj)this).zzgb().zzb((Bundle)object2));
            object = new zzeu((String)object3, new zzer((Bundle)object2), string, l);
            ((zzhj)this).zzfx().zzc((zzeu)((Object)object), string3);
            if (bl4) continue;
            for (AppMeasurement.OnEventListener onEventListener : this.zzaok) {
                bundle2 = new Bundle((Bundle)object2);
                onEventListener.onEvent(string, string2, bundle2, l);
            }
        }
        if (((zzhj)this).zzfy().zzkk() != null && "_ae".equals(string2)) {
            ((zzhj)this).zzge().zzm(true);
        }
    }

    public final void zza(String string, String string2, Object object) {
        Preconditions.checkNotEmpty((String)string);
        long l = ((zzhj)this).zzbt().currentTimeMillis();
        int n = ((zzhj)this).zzgc().zzby(string2);
        if (n != 0) {
            ((zzhj)this).zzgc();
            String string3 = zzjv.zza(string2, 24, true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzacr.zzgc().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = ((zzhj)this).zzgc().zzi(string2, object);
            if (n != 0) {
                ((zzhj)this).zzgc();
                String string4 = zzjv.zza(string2, 24, true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n3 = String.valueOf(object).length();
                }
                this.zzacr.zzgc().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = ((zzhj)this).zzgc().zzj(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzhj)this).zzgf().zzc(new zzho(this, string, string2, object, l));
    }

    @WorkerThread
    private final void zza(String string, String string2, Object object, long l) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ((zzhj)this).zzab();
        this.zzch();
        if (!this.zzacr.isEnabled()) {
            ((zzhj)this).zzgg().zziq().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzacr.zzjk()) {
            return;
        }
        ((zzhj)this).zzgg().zziq().zze("Setting user property (FE)", ((zzhj)this).zzgb().zzbe(string2), object);
        zzjs zzjs2 = new zzjs(string2, l, object, string);
        ((zzhj)this).zzfx().zzb(zzjs2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzjs> zzk(boolean bl) {
        this.zzch();
        ((zzhj)this).zzgg().zziq().log("Fetching user attributes (FE)");
        if (((zzhj)this).zzgf().zzjg()) {
            ((zzhj)this).zzgg().zzil().log("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzhj)this).zzgf();
        if (zzgg.isMainThread()) {
            ((zzhj)this).zzgg().zzil().log("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzacr.zzgf().zzc(new zzhp(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhj)this).zzgg().zzin().zzg("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzhj)this).zzgg().zzin().log("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    public final Task<String> getAppInstanceId() {
        try {
            String string = ((zzhj)this).zzgh().zziw();
            if (string != null) {
                return Tasks.forResult((Object)string);
            }
            return Tasks.call((Executor)((zzhj)this).zzgf().zzjh(), (Callable)new zzhq(this));
        }
        catch (Exception exception) {
            ((zzhj)this).zzgg().zzin().log("Failed to schedule task for getAppInstanceId");
            return Tasks.forException((Exception)exception);
        }
    }

    @Nullable
    public final String zziw() {
        return this.zzaom.get();
    }

    final void zzbm(@Nullable String string) {
        this.zzaom.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final String zzae(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzhj)this).zzgf().zzc(new zzhr(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                ((zzhj)this).zzgg().zzin().log("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    public final void resetAnalyticsData() {
        ((zzhj)this).zzgf().zzc(new zzhs(this));
    }

    @WorkerThread
    public final void zzkj() {
        ((zzhj)this).zzab();
        this.zzch();
        if (!this.zzacr.zzjk()) {
            return;
        }
        ((zzhj)this).zzfx().zzkj();
        this.zzaon = false;
        String string = ((zzhj)this).zzgh().zziz();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            ((zzhj)this).zzfw().zzch();
            if (!string.equals(Build.VERSION.RELEASE)) {
                Bundle bundle = new Bundle();
                bundle.putString("_po", string);
                this.zza("auto", "_ou", bundle);
            }
        }
    }

    @WorkerThread
    public final void setEventInterceptor(AppMeasurement.EventInterceptor eventInterceptor) {
        ((zzhj)this).zzab();
        this.zzch();
        if (eventInterceptor != null && eventInterceptor != this.zzaoj) {
            Preconditions.checkState((this.zzaoj == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzaoj = eventInterceptor;
    }

    public final void registerOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        this.zzch();
        Preconditions.checkNotNull((Object)onEventListener);
        if (!this.zzaok.add(onEventListener)) {
            ((zzhj)this).zzgg().zzin().log("OnEventListener already registered");
        }
    }

    public final void unregisterOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        this.zzch();
        Preconditions.checkNotNull((Object)onEventListener);
        if (!this.zzaok.remove(onEventListener)) {
            ((zzhj)this).zzgg().zzin().log("OnEventListener had not been registered");
        }
    }

    public final void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            ((zzhj)this).zzgg().zzin().log("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public final void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mAppId);
        ((zzhj)this).zzfq();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private final void zza(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = ((zzhj)this).zzbt().currentTimeMillis();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mOrigin);
        Preconditions.checkNotNull((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        if (((zzhj)this).zzgc().zzby(string) != 0) {
            ((zzhj)this).zzgg().zzil().zzg("Invalid conditional user property name", ((zzhj)this).zzgb().zzbg(string));
            return;
        }
        if (((zzhj)this).zzgc().zzi(string, object) != 0) {
            ((zzhj)this).zzgg().zzil().zze("Invalid conditional user property value", ((zzhj)this).zzgb().zzbg(string), object);
            return;
        }
        Object object2 = ((zzhj)this).zzgc().zzj(string, object);
        if (object2 == null) {
            ((zzhj)this).zzgg().zzil().zze("Unable to normalize conditional user property value", ((zzhj)this).zzgb().zzbg(string), object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (!(TextUtils.isEmpty((CharSequence)conditionalUserProperty.mTriggerEventName) || l2 <= 15552000000L && l2 >= 1L)) {
            ((zzhj)this).zzgg().zzil().zze("Invalid conditional user property timeout", ((zzhj)this).zzgb().zzbg(string), l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > 15552000000L || l3 < 1L) {
            ((zzhj)this).zzgg().zzil().zze("Invalid conditional user property time to live", ((zzhj)this).zzgb().zzbg(string), l3);
            return;
        }
        ((zzhj)this).zzgf().zzc(new zzht(this, conditionalUserProperty));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotEmpty((String)string);
        ((zzhj)this).zzfq();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzhj)this).zzbt().currentTimeMillis();
        Preconditions.checkNotEmpty((String)string2);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        ((zzhj)this).zzgf().zzc(new zzhu(this, conditionalUserProperty));
    }

    @WorkerThread
    private final void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzeu zzeu2;
        zzeu zzeu3;
        zzeu zzeu4;
        ((zzhj)this).zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mOrigin);
        Preconditions.checkNotNull((Object)conditionalUserProperty.mValue);
        if (!this.zzacr.isEnabled()) {
            ((zzhj)this).zzgg().zziq().log("Conditional property not sent since Firebase Analytics is disabled");
            return;
        }
        zzjs zzjs2 = new zzjs(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzeu4 = ((zzhj)this).zzgc().zza(conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzeu3 = ((zzhj)this).zzgc().zza(conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzeu2 = ((zzhj)this).zzgc().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzef zzef2 = new zzef(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzjs2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzeu3, conditionalUserProperty.mTriggerTimeout, zzeu4, conditionalUserProperty.mTimeToLive, zzeu2);
        ((zzhj)this).zzfx().zzf(zzef2);
    }

    @WorkerThread
    private final void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzeu zzeu2;
        ((zzhj)this).zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        if (!this.zzacr.isEnabled()) {
            ((zzhj)this).zzgg().zziq().log("Conditional property not cleared since Firebase Analytics is disabled");
            return;
        }
        zzjs zzjs2 = new zzjs(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzeu2 = ((zzhj)this).zzgc().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzef zzef2 = new zzef(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzjs2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzeu2);
        ((zzhj)this).zzfx().zzf(zzef2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        return this.zzf(null, string, string2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        ((zzhj)this).zzfq();
        return this.zzf(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final List<AppMeasurement.ConditionalUserProperty> zzf(String string, String string2, String string3) {
        if (((zzhj)this).zzgf().zzjg()) {
            ((zzhj)this).zzgg().zzil().log("Cannot get conditional user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzhj)this).zzgf();
        if (zzgg.isMainThread()) {
            ((zzhj)this).zzgg().zzil().log("Cannot get conditional user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzacr.zzgf().zzc(new zzhv(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhj)this).zzgg().zzin().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzhj)this).zzgg().zzin().zzg("Timed out waiting for get conditional user properties", string);
                return Collections.emptyList();
            }
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzef zzef2 = (zzef)((Object)iterator.next());
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
                new AppMeasurement.ConditionalUserProperty().mAppId = string;
                conditionalUserProperty.mOrigin = string2;
                conditionalUserProperty.mCreationTimestamp = zzef2.zzaem;
                conditionalUserProperty.mName = zzef2.zzael.name;
                conditionalUserProperty.mValue = zzef2.zzael.getValue();
                conditionalUserProperty.mActive = zzef2.zzaen;
                conditionalUserProperty.mTriggerEventName = zzef2.zzaeo;
                if (zzef2.zzaep != null) {
                    conditionalUserProperty.mTimedOutEventName = zzef2.zzaep.name;
                    if (zzef2.zzaep.zzafo != null) {
                        conditionalUserProperty.mTimedOutEventParams = zzef2.zzaep.zzafo.zzif();
                    }
                }
                conditionalUserProperty.mTriggerTimeout = zzef2.zzaeq;
                if (zzef2.zzaer != null) {
                    conditionalUserProperty.mTriggeredEventName = zzef2.zzaer.name;
                    if (zzef2.zzaer.zzafo != null) {
                        conditionalUserProperty.mTriggeredEventParams = zzef2.zzaer.zzafo.zzif();
                    }
                }
                conditionalUserProperty.mTriggeredTimestamp = zzef2.zzael.zzaqu;
                conditionalUserProperty.mTimeToLive = zzef2.zzaes;
                if (zzef2.zzaet != null) {
                    conditionalUserProperty.mExpiredEventName = zzef2.zzaet.name;
                    if (zzef2.zzaet.zzafo != null) {
                        conditionalUserProperty.mExpiredEventParams = zzef2.zzaet.zzafo.zzif();
                    }
                }
                arrayList.add(conditionalUserProperty);
            }
            return arrayList;
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        Preconditions.checkNotEmpty((String)string);
        ((zzhj)this).zzfq();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzhj)this).zzgf().zzjg()) {
            ((zzhj)this).zzgg().zzil().log("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzhj)this).zzgf();
        if (zzgg.isMainThread()) {
            ((zzhj)this).zzgg().zzil().log("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzacr.zzgf().zzc(new zzhw(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhj)this).zzgg().zzin().zzg("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzhj)this).zzgg().zzin().log("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzjs zzjs2 = (zzjs)((Object)iterator.next());
                arrayMap.put(zzjs2.name, zzjs2.getValue());
            }
            return arrayMap;
        }
    }

    static /* synthetic */ void zza(zzhm zzhm2, boolean bl) {
        zzhm2.zzj(bl);
    }

    static /* synthetic */ void zza(zzhm zzhm2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzhm2.zzb(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzhm zzhm2, String string, String string2, Object object, long l) {
        zzhm2.zza(string, string2, object, l);
    }

    static /* synthetic */ void zza(zzhm zzhm2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzhm2.zzb(conditionalUserProperty);
    }

    static /* synthetic */ void zzb(zzhm zzhm2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzhm2.zzc(conditionalUserProperty);
    }
}

