/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzdx;
import com.google.android.gms.internal.measurement.zzea;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.android.gms.internal.measurement.zzig;
import com.google.android.gms.internal.measurement.zzii;
import com.google.android.gms.internal.measurement.zzij;
import com.google.android.gms.internal.measurement.zzik;
import com.google.android.gms.internal.measurement.zzjv;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class zzih
extends zzhk {
    @VisibleForTesting
    protected zzik zzapc;
    private volatile zzig zzapd;
    private zzig zzape;
    private long zzapf;
    private final Map<Activity, zzik> zzapg = new ArrayMap();
    private final CopyOnWriteArrayList<AppMeasurement.zza> zzaph = new CopyOnWriteArrayList();
    private boolean zzapi;
    private zzig zzapj;
    private String zzapk;

    public zzih(zzgl zzgl2) {
        super(zzgl2);
    }

    @Override
    protected final boolean zzhh() {
        return false;
    }

    @WorkerThread
    public final zzik zzkk() {
        this.zzch();
        ((zzhj)this).zzab();
        return this.zzapc;
    }

    @MainThread
    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        ((zzhj)this).zzgf();
        if (!zzgg.isMainThread()) {
            ((zzhj)this).zzgg().zzin().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzapi) {
            ((zzhj)this).zzgg().zzin().log("Cannot call setCurrentScreen from onScreenChangeCallback");
            return;
        }
        if (this.zzapd == null) {
            ((zzhj)this).zzgg().zzin().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzapg.get(activity) == null) {
            ((zzhj)this).zzgg().zzin().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzih.zzbu(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzapd.zzapa.equals(string2);
        boolean bl2 = zzjv.zzs(this.zzapd.zzug, string);
        if (bl && bl2) {
            ((zzhj)this).zzgg().zzio().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzhj)this).zzgg().zzin().zzg("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzhj)this).zzgg().zzin().zzg("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzhj)this).zzgg().zzir().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzik zzik2 = new zzik(string, string2, ((zzhj)this).zzgc().zzkt());
        this.zzapg.put(activity, zzik2);
        this.zza(activity, zzik2, true);
    }

    public final zzig zzkl() {
        zzig zzig2 = this.zzapd;
        if (zzig2 == null) {
            return null;
        }
        return new zzig(zzig2);
    }

    @MainThread
    public final void registerOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        if (zza2 == null) {
            ((zzhj)this).zzgg().zzin().log("Attempting to register null OnScreenChangeCallback");
            return;
        }
        this.zzaph.remove(zza2);
        this.zzaph.add(zza2);
    }

    @MainThread
    public final void unregisterOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        this.zzaph.remove(zza2);
    }

    @MainThread
    private final void zza(Activity activity, zzik zzik2, boolean bl) {
        Object object;
        Object object2;
        zzig zzig2 = null;
        if (this.zzapd != null) {
            zzig2 = this.zzapd;
        } else if (this.zzape != null && Math.abs(((zzhj)this).zzbt().elapsedRealtime() - this.zzapf) < 1000L) {
            zzig2 = this.zzape;
        }
        zzig zzig3 = null;
        if (zzig2 != null) {
            zzig3 = new zzig(zzig2);
        }
        boolean bl2 = true;
        this.zzapi = true;
        try {
            object2 = this.zzaph.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                try {
                    bl2 &= object.zza(zzig3, zzik2);
                }
                catch (Exception exception) {
                    ((zzhj)this).zzgg().zzil().zzg("onScreenChangeCallback threw exception", exception);
                }
            }
        }
        catch (Exception exception) {
            ((zzhj)this).zzgg().zzil().zzg("onScreenChangeCallback loop threw exception", exception);
        }
        finally {
            this.zzapi = false;
        }
        Object object3 = object2 = this.zzapd == null ? this.zzape : this.zzapd;
        if (bl2) {
            if (zzik2.zzapa == null) {
                zzik2.zzapa = zzih.zzbu(activity.getClass().getCanonicalName());
            }
            object = new zzik(zzik2);
            this.zzape = this.zzapd;
            this.zzapf = ((zzhj)this).zzbt().elapsedRealtime();
            this.zzapd = object;
            ((zzhj)this).zzgf().zzc(new zzii(this, bl, (zzig)object2, (zzik)object));
        }
    }

    @WorkerThread
    private final void zza(@NonNull zzik zzik2) {
        ((zzhj)this).zzfs().zzk(((zzhj)this).zzbt().elapsedRealtime());
        if (((zzhj)this).zzge().zzm(zzik2.zzapq)) {
            zzik2.zzapq = false;
        }
    }

    public static void zza(zzig zzig2, Bundle bundle, boolean bl) {
        if (bundle != null && zzig2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzig2.zzug != null) {
                bundle.putString("_sn", zzig2.zzug);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzig2.zzapa);
            bundle.putLong("_si", zzig2.zzapb);
            return;
        }
        if (bundle != null && zzig2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzig zzig2) {
        ((zzhj)this).zzab();
        zzih zzih2 = this;
        synchronized (zzih2) {
            if (this.zzapk == null || this.zzapk.equals(string) || zzig2 != null) {
                this.zzapk = string;
                this.zzapj = zzig2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zzbu(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    final zzik zze(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzik zzik2 = this.zzapg.get(activity);
        if (zzik2 == null) {
            String string = zzih.zzbu(activity.getClass().getCanonicalName());
            zzik2 = new zzik(null, string, ((zzhj)this).zzgc().zzkt());
            this.zzapg.put(activity, zzik2);
        }
        return zzik2;
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzik zzik2 = this.zze(activity);
        this.zza(activity, zzik2, false);
        zzdx zzdx2 = ((zzhj)this).zzfs();
        long l = ((zzhj)zzdx2).zzbt().elapsedRealtime();
        ((zzhj)zzdx2).zzgf().zzc(new zzea(zzdx2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzik zzik2 = this.zze(activity);
        this.zzape = this.zzapd;
        this.zzapf = ((zzhj)this).zzbt().elapsedRealtime();
        this.zzapd = null;
        ((zzhj)this).zzgf().zzc(new zzij(this, zzik2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzik zzik2 = this.zzapg.get(activity);
        if (zzik2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzik2.zzapb);
        bundle2.putString("name", zzik2.zzug);
        bundle2.putString("referrer_name", zzik2.zzapa);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzapg.remove(activity);
    }

    static /* synthetic */ void zza(zzih zzih2, zzik zzik2) {
        zzih2.zza(zzik2);
    }
}

