/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.android.gms.internal.measurement.zzig;
import com.google.android.gms.internal.measurement.zzim;
import com.google.android.gms.internal.measurement.zzin;
import com.google.android.gms.internal.measurement.zzio;
import com.google.android.gms.internal.measurement.zzip;
import com.google.android.gms.internal.measurement.zziq;
import com.google.android.gms.internal.measurement.zzir;
import com.google.android.gms.internal.measurement.zzis;
import com.google.android.gms.internal.measurement.zzit;
import com.google.android.gms.internal.measurement.zziu;
import com.google.android.gms.internal.measurement.zziv;
import com.google.android.gms.internal.measurement.zziw;
import com.google.android.gms.internal.measurement.zzix;
import com.google.android.gms.internal.measurement.zziy;
import com.google.android.gms.internal.measurement.zziz;
import com.google.android.gms.internal.measurement.zzjp;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzjv;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzil
extends zzhk {
    private final zziz zzapr;
    private zzey zzaps;
    private volatile Boolean zzapt;
    private final zzem zzapu;
    private final zzjp zzapv;
    private final List<Runnable> zzapw = new ArrayList<Runnable>();
    private final zzem zzapx;

    protected zzil(zzgl zzgl2) {
        super(zzgl2);
        this.zzapv = new zzjp(zzgl2.zzbt());
        this.zzapr = new zziz(this);
        this.zzapu = new zzim(this, zzgl2);
        this.zzapx = new zzir(this, zzgl2);
    }

    @Override
    protected final boolean zzhh() {
        return false;
    }

    @WorkerThread
    public final boolean isConnected() {
        ((zzhj)this).zzab();
        this.zzch();
        return this.zzaps != null;
    }

    @WorkerThread
    protected final void zzkm() {
        ((zzhj)this).zzab();
        this.zzch();
        zzec zzec2 = this.zzl(true);
        this.zzf(new zzis(this, zzec2));
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzey zzey2, AbstractSafeParcelable abstractSafeParcelable, zzec zzec2) {
        ((zzhj)this).zzab();
        this.zzch();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            List<AbstractSafeParcelable> list = ((zzhj)this).zzfz().zzp(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzeu) {
                    try {
                        zzey2.zza((zzeu)abstractSafeParcelable2, zzec2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhj)this).zzgg().zzil().zzg("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzjs) {
                    try {
                        zzey2.zza((zzjs)abstractSafeParcelable2, zzec2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhj)this).zzgg().zzil().zzg("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzef) {
                    try {
                        zzey2.zza((zzef)abstractSafeParcelable2, zzec2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhj)this).zzgg().zzil().zzg("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzhj)this).zzgg().zzil().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzc(zzeu zzeu2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzeu2));
        ((zzhj)this).zzab();
        this.zzch();
        boolean bl = ((zzhj)this).zzfz().zza(zzeu2);
        zzec zzec2 = this.zzl(true);
        this.zzf(new zzit(this, true, bl, zzeu2, zzec2, string));
    }

    @WorkerThread
    protected final void zzf(zzef zzef2) {
        Preconditions.checkNotNull((Object)((Object)zzef2));
        ((zzhj)this).zzab();
        this.zzch();
        boolean bl = ((zzhj)this).zzfz().zzc(zzef2);
        zzef zzef3 = new zzef(zzef2);
        zzec zzec2 = this.zzl(true);
        this.zzf(new zziu(this, true, bl, zzef3, zzec2, zzef2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzef>> atomicReference, String string, String string2, String string3) {
        ((zzhj)this).zzab();
        this.zzch();
        zzec zzec2 = this.zzl(false);
        this.zzf(new zziv(this, atomicReference, string, string2, string3, zzec2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzjs>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzhj)this).zzab();
        this.zzch();
        zzec zzec2 = this.zzl(false);
        this.zzf(new zziw(this, atomicReference, string, string2, string3, bl, zzec2));
    }

    @WorkerThread
    protected final void zzb(zzjs zzjs2) {
        ((zzhj)this).zzab();
        this.zzch();
        boolean bl = ((zzhj)this).zzfz().zza(zzjs2);
        zzec zzec2 = this.zzl(true);
        this.zzf(new zzix(this, bl, zzjs2, zzec2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzjs>> atomicReference, boolean bl) {
        ((zzhj)this).zzab();
        this.zzch();
        zzec zzec2 = this.zzl(false);
        this.zzf(new zziy(this, atomicReference, zzec2, bl));
    }

    @WorkerThread
    protected final void resetAnalyticsData() {
        ((zzhj)this).zzab();
        this.zzch();
        zzec zzec2 = this.zzl(false);
        ((zzhj)this).zzfz().resetAnalyticsData();
        this.zzf(new zzin(this, zzec2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzhj)this).zzab();
        this.zzch();
        zzec zzec2 = this.zzl(false);
        this.zzf(new zzio(this, atomicReference, zzec2));
    }

    @WorkerThread
    protected final void zzkj() {
        ((zzhj)this).zzab();
        this.zzch();
        zzec zzec2 = this.zzl(true);
        this.zzf(new zzip(this, zzec2));
    }

    @WorkerThread
    protected final void zza(zzig zzig2) {
        ((zzhj)this).zzab();
        this.zzch();
        this.zzf(new zziq(this, zzig2));
    }

    @WorkerThread
    private final void zzcu() {
        ((zzhj)this).zzab();
        this.zzapv.start();
        this.zzapu.zzh(zzew.zzahr.get());
    }

    @WorkerThread
    final void zzdf() {
        Intent intent;
        Object object;
        zzil zzil2;
        ((zzhj)this).zzab();
        this.zzch();
        if (this.isConnected()) {
            return;
        }
        if (this.zzapt == null) {
            boolean bl;
            zzil2 = this;
            ((zzhj)zzil2).zzab();
            zzil2.zzch();
            object = ((zzhj)zzil2).zzgh().zzix();
            if (object != null && ((Boolean)object).booleanValue()) {
                bl = true;
            } else {
                boolean bl2;
                boolean bl3;
                if (((zzhj)zzil2).zzfv().zzij() == 1) {
                    bl3 = true;
                    bl2 = true;
                } else {
                    ((zzhj)zzil2).zzgg().zzir().log("Checking service availability");
                    zzjv zzjv2 = ((zzhj)zzil2).zzgc();
                    int n = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(((zzhj)zzjv2).getContext(), 12451);
                    switch (n) {
                        case 0: {
                            ((zzhj)zzil2).zzgg().zzir().log("Service available");
                            bl3 = true;
                            bl2 = true;
                            break;
                        }
                        case 1: {
                            ((zzhj)zzil2).zzgg().zzir().log("Service missing");
                            bl3 = false;
                            bl2 = true;
                            break;
                        }
                        case 18: {
                            ((zzhj)zzil2).zzgg().zzin().log("Service updating");
                            bl3 = true;
                            bl2 = true;
                            break;
                        }
                        case 2: {
                            ((zzhj)zzil2).zzgg().zziq().log("Service container out of date");
                            if (((zzhj)zzil2).zzgc().zzkv() < 12400) {
                                bl3 = false;
                                bl2 = true;
                                break;
                            }
                            Boolean bl4 = ((zzhj)zzil2).zzgh().zzix();
                            bl3 = bl4 == null || bl4 != false;
                            bl2 = false;
                            break;
                        }
                        case 3: {
                            ((zzhj)zzil2).zzgg().zzin().log("Service disabled");
                            bl3 = false;
                            bl2 = false;
                            break;
                        }
                        case 9: {
                            ((zzhj)zzil2).zzgg().zzin().log("Service invalid");
                            bl3 = false;
                            bl2 = false;
                            break;
                        }
                        default: {
                            ((zzhj)zzil2).zzgg().zzin().zzg("Unexpected service status", n);
                            bl3 = false;
                            bl2 = false;
                        }
                    }
                }
                if (bl2) {
                    ((zzhj)zzil2).zzgh().zzf(bl3);
                }
                bl = bl3;
            }
            this.zzapt = bl;
        }
        if (this.zzapt.booleanValue()) {
            this.zzapr.zzkp();
            return;
        }
        zzil2 = this;
        object = ((zzhj)zzil2).getContext().getPackageManager();
        List list = object.queryIntentServices(intent = new Intent().setClassName(((zzhj)zzil2).getContext(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
        if (list != null && list.size() > 0) {
            Intent intent2 = new Intent("com.google.android.gms.measurement.START");
            intent2.setComponent(new ComponentName(((zzhj)this).getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
            this.zzapr.zzc(intent2);
            return;
        }
        ((zzhj)this).zzgg().zzil().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
    }

    final Boolean zzkn() {
        return this.zzapt;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzey zzey2) {
        ((zzhj)this).zzab();
        Preconditions.checkNotNull((Object)zzey2);
        this.zzaps = zzey2;
        this.zzcu();
        this.zzko();
    }

    @WorkerThread
    public final void disconnect() {
        ((zzhj)this).zzab();
        this.zzch();
        try {
            ConnectionTracker.getInstance().unbindService(((zzhj)this).getContext(), (ServiceConnection)this.zzapr);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzaps = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        ((zzhj)this).zzab();
        if (this.zzaps != null) {
            this.zzaps = null;
            ((zzhj)this).zzgg().zzir().zzg("Disconnected from device MeasurementService", componentName);
            zzil zzil2 = this;
            ((zzhj)zzil2).zzab();
            zzil2.zzdf();
        }
    }

    @WorkerThread
    private final void zzcv() {
        ((zzhj)this).zzab();
        if (!this.isConnected()) {
            return;
        }
        ((zzhj)this).zzgg().zzir().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzf(Runnable runnable) throws IllegalStateException {
        ((zzhj)this).zzab();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zzapw.size() >= 1000L) {
            ((zzhj)this).zzgg().zzil().log("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzapw.add(runnable);
        this.zzapx.zzh(60000L);
        this.zzdf();
    }

    @WorkerThread
    private final void zzko() {
        ((zzhj)this).zzab();
        ((zzhj)this).zzgg().zzir().zzg("Processing queued up service tasks", this.zzapw.size());
        for (Runnable runnable : this.zzapw) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                ((zzhj)this).zzgg().zzil().zzg("Task exception while flushing queue", throwable);
            }
        }
        this.zzapw.clear();
        this.zzapx.cancel();
    }

    @WorkerThread
    @Nullable
    private final zzec zzl(boolean bl) {
        return ((zzhj)this).zzfv().zzbd(bl ? ((zzhj)this).zzgg().zzit() : null);
    }

    static /* synthetic */ zziz zza(zzil zzil2) {
        return zzil2.zzapr;
    }

    static /* synthetic */ void zza(zzil zzil2, ComponentName componentName) {
        zzil2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzey zza(zzil zzil2, zzey zzey2) {
        zzil2.zzaps = null;
        return null;
    }

    static /* synthetic */ void zzb(zzil zzil2) {
        zzil2.zzko();
    }

    static /* synthetic */ void zzc(zzil zzil2) {
        zzil2.zzcv();
    }

    static /* synthetic */ zzey zzd(zzil zzil2) {
        return zzil2.zzaps;
    }

    static /* synthetic */ void zze(zzil zzil2) {
        zzil2.zzcu();
    }
}

