/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzfa;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzil;
import com.google.android.gms.internal.measurement.zzja;
import com.google.android.gms.internal.measurement.zzjb;
import com.google.android.gms.internal.measurement.zzjc;
import com.google.android.gms.internal.measurement.zzjd;
import com.google.android.gms.internal.measurement.zzje;

@VisibleForTesting
public final class zziz
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzaqf;
    private volatile zzff zzaqg;
    final /* synthetic */ zzil zzapy;

    protected zziz(zzil zzil2) {
        this.zzapy = zzil2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzc(Intent intent) {
        ((zzhj)this.zzapy).zzab();
        Context context = ((zzhj)this.zzapy).getContext();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zziz zziz2 = this;
        synchronized (zziz2) {
            if (this.zzaqf) {
                ((zzhj)this.zzapy).zzgg().zzir().log("Connection attempt already in progress");
                return;
            }
            ((zzhj)this.zzapy).zzgg().zzir().log("Using local app measurement service");
            this.zzaqf = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzil.zza(this.zzapy), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zziz zziz2 = this;
        synchronized (zziz2) {
            String string;
            if (iBinder == null) {
                this.zzaqf = false;
                ((zzhj)this.zzapy).zzgg().zzil().log("Service connected with null binder");
                return;
            }
            zzey zzey2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzey2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzey ? (zzey)iInterface : new zzfa(iBinder2));
                    ((zzhj)this.zzapy).zzgg().zzir().log("Bound to IMeasurementService interface");
                } else {
                    ((zzhj)this.zzapy).zzgg().zzil().zzg("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzhj)this.zzapy).zzgg().zzil().log("Service connect failed to get IMeasurementService");
            }
            if (zzey2 == null) {
                this.zzaqf = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzhj)this.zzapy).getContext(), (ServiceConnection)zzil.zza(this.zzapy));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzey2;
                ((zzhj)this.zzapy).zzgf().zzc(new zzja(this, (zzey)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzhj)this.zzapy).zzgg().zziq().log("Service disconnected");
        ((zzhj)this.zzapy).zzgf().zzc(new zzjb(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzkp() {
        ((zzhj)this.zzapy).zzab();
        Context context = ((zzhj)this.zzapy).getContext();
        zziz zziz2 = this;
        synchronized (zziz2) {
            if (this.zzaqf) {
                ((zzhj)this.zzapy).zzgg().zzir().log("Connection attempt already in progress");
                return;
            }
            if (this.zzaqg != null) {
                ((zzhj)this.zzapy).zzgg().zzir().log("Already awaiting connection attempt");
                return;
            }
            this.zzaqg = new zzff(context, Looper.getMainLooper(), this, this);
            ((zzhj)this.zzapy).zzgg().zzir().log("Connecting to remote service");
            this.zzaqf = true;
            this.zzaqg.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zziz zziz2 = this;
        synchronized (zziz2) {
            try {
                zzey zzey2 = (zzey)this.zzaqg.getService();
                this.zzaqg = null;
                ((zzhj)this.zzapy).zzgf().zzc(new zzjc(this, zzey2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzaqg = null;
                this.zzaqf = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzhj)this.zzapy).zzgg().zziq().log("Service connection suspended");
        ((zzhj)this.zzapy).zzgf().zzc(new zzjd(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzfg zzfg2 = this.zzapy.zzacr.zzjl();
        if (zzfg2 != null) {
            zzfg2.zzin().zzg("Service connection failed", connectionResult);
        }
        zziz zziz2 = this;
        synchronized (zziz2) {
            this.zzaqf = false;
            this.zzaqg = null;
        }
        ((zzhj)this.zzapy).zzgf().zzc(new zzje(this));
    }

    static /* synthetic */ boolean zza(zziz zziz2, boolean bl) {
        zziz2.zzaqf = false;
        return false;
    }
}

