/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzgq;
import com.google.android.gms.internal.measurement.zzjg;
import com.google.android.gms.internal.measurement.zzjh;
import com.google.android.gms.internal.measurement.zzji;
import com.google.android.gms.internal.measurement.zzjj;
import com.google.android.gms.internal.measurement.zzjv;

public final class zzjf<T extends Context> {
    private final T zzabh;

    public zzjf(T t) {
        Preconditions.checkNotNull(t);
        this.zzabh = t;
    }

    public static boolean zza(Context context, boolean bl) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzjv.zzc(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzjv.zzc(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    @MainThread
    public final void onCreate() {
        zzgl.zzg(this.zzabh).zzgg().zzir().log("Local AppMeasurementService is starting up");
    }

    @MainThread
    public final void onDestroy() {
        zzgl.zzg(this.zzabh).zzgg().zzir().log("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public final int onStartCommand(Intent intent, int n, int n2) {
        zzfg zzfg2 = zzgl.zzg(this.zzabh).zzgg();
        if (intent == null) {
            zzfg2.zzin().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzfg2.zzir().zze("Local AppMeasurementService called. startId, action", n2, string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zzb(new zzjg(this, n2, zzfg2, intent));
        }
        return 2;
    }

    private final void zzb(Runnable runnable) {
        zzgl zzgl2 = zzgl.zzg(this.zzabh);
        zzgl2.zzgg();
        zzgl2.zzgf().zzc(new zzji(this, zzgl2, runnable));
    }

    @MainThread
    public final IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzgg().zzil().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzgq(zzgl.zzg(this.zzabh));
        }
        this.zzgg().zzin().zzg("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public final boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzgg().zzil().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzgg().zzir().zzg("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzfg zzfg2 = zzgl.zzg(this.zzabh).zzgg();
        String string = jobParameters.getExtras().getString("action");
        zzfg2.zzir().zzg("Local AppMeasurementJobService called. action", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zzb(new zzjh(this, zzfg2, jobParameters));
        }
        return true;
    }

    @MainThread
    public final void onRebind(Intent intent) {
        if (intent == null) {
            this.zzgg().zzil().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzgg().zzir().zzg("onRebind called. action", string);
    }

    private final zzfg zzgg() {
        return zzgl.zzg(this.zzabh).zzgg();
    }

    final /* synthetic */ void zza(zzfg zzfg2, JobParameters jobParameters) {
        zzfg2.zzir().log("AppMeasurementJobService processed last upload request.");
        ((zzjj)this.zzabh).zza(jobParameters, false);
    }

    final /* synthetic */ void zza(int n, zzfg zzfg2, Intent intent) {
        if (((zzjj)this.zzabh).callServiceStopSelfResult(n)) {
            zzfg2.zzir().zzg("Local AppMeasurementService processed last upload request. StartId", n);
            this.zzgg().zzir().log("Completed wakeful intent.");
            ((zzjj)this.zzabh).zzb(intent);
        }
    }
}

