/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzgb;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.android.gms.internal.measurement.zzjf;
import com.google.android.gms.internal.measurement.zzjr;

public final class zzjq
extends zzhk {
    private final AlarmManager zzyd = (AlarmManager)((zzhj)this).getContext().getSystemService("alarm");
    private final zzem zzaqs;
    private Integer zzye;

    protected zzjq(zzgl zzgl2) {
        super(zzgl2);
        this.zzaqs = new zzjr(this, zzgl2, zzgl2);
    }

    @Override
    protected final boolean zzhh() {
        this.zzyd.cancel(this.zzek());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzks();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzks() {
        JobScheduler jobScheduler = (JobScheduler)((zzhj)this).getContext().getSystemService("jobscheduler");
        ((zzhj)this).zzgg().zzir().zzg("Cancelling job. JobID", this.getJobId());
        jobScheduler.cancel(this.getJobId());
    }

    public final void zzh(long l) {
        this.zzch();
        if (!zzgb.zza(((zzhj)this).getContext())) {
            ((zzhj)this).zzgg().zziq().log("Receiver not registered/enabled");
        }
        if (!zzjf.zza(((zzhj)this).getContext(), false)) {
            ((zzhj)this).zzgg().zziq().log("Service not registered/enabled");
        }
        this.cancel();
        long l2 = ((zzhj)this).zzbt().elapsedRealtime() + l;
        if (l < Math.max(0L, zzew.zzahi.get()) && !this.zzaqs.zzef()) {
            ((zzhj)this).zzgg().zzir().log("Scheduling upload with DelayedRunnable");
            this.zzaqs.zzh(l);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            ((zzhj)this).zzgg().zzir().log("Scheduling upload with JobScheduler");
            long l3 = l;
            zzjq zzjq2 = this;
            ComponentName componentName = new ComponentName(((zzhj)zzjq2).getContext(), "com.google.android.gms.measurement.AppMeasurementJobService");
            JobScheduler jobScheduler = (JobScheduler)((zzhj)zzjq2).getContext().getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(zzjq2.getJobId(), componentName);
            builder.setMinimumLatency(l3);
            builder.setOverrideDeadline(l3 << 1);
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            builder.setExtras(persistableBundle);
            JobInfo jobInfo = builder.build();
            ((zzhj)zzjq2).zzgg().zzir().zzg("Scheduling job. JobID", zzjq2.getJobId());
            jobScheduler.schedule(jobInfo);
            return;
        }
        ((zzhj)this).zzgg().zzir().log("Scheduling upload with AlarmManager");
        this.zzyd.setInexactRepeating(2, l2, Math.max(zzew.zzahd.get(), l), this.zzek());
    }

    private final int getJobId() {
        if (this.zzye == null) {
            String string = String.valueOf(((zzhj)this).getContext().getPackageName());
            this.zzye = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzye;
    }

    public final void cancel() {
        this.zzch();
        this.zzyd.cancel(this.zzek());
        this.zzaqs.cancel();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzks();
        }
    }

    private final PendingIntent zzek() {
        Intent intent = new Intent().setClassName(((zzhj)this).getContext(), "com.google.android.gms.measurement.AppMeasurementReceiver");
        intent.setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)((zzhj)this).getContext(), (int)0, (Intent)intent, (int)0);
    }
}

