/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzabv;
import com.google.android.gms.internal.measurement.zzabw;
import com.google.android.gms.internal.measurement.zzaby;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzjm;
import com.google.android.gms.internal.measurement.zzjq;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzjx;
import com.google.android.gms.internal.measurement.zzjz;
import com.google.android.gms.internal.measurement.zzka;
import com.google.android.gms.internal.measurement.zzkd;
import com.google.android.gms.internal.measurement.zzke;
import com.google.android.gms.internal.measurement.zzkh;
import com.google.android.gms.internal.measurement.zzkn;
import com.google.android.gms.internal.measurement.zzko;
import com.google.android.gms.internal.measurement.zzkq;
import com.google.android.gms.internal.measurement.zzkr;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class zzei
extends zzjq {
    private static final String[] zzaev = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;"};
    private static final String[] zzaew = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zzaex = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;", "ssaid_reporting_enabled", "ALTER TABLE apps ADD COLUMN ssaid_reporting_enabled INTEGER;"};
    private static final String[] zzaey = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zzaez = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;", "retry_count", "ALTER TABLE queue ADD COLUMN retry_count INTEGER;"};
    private static final String[] zzafa = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private final zzel zzafb;
    private final zzjm zzafc = new zzjm(this.zzbt());

    zzei(zzjr zzjr2) {
        super(zzjr2);
        String string = "google_app_measurement.db";
        this.zzafb = new zzel(this, this.getContext(), string);
    }

    @Override
    protected final boolean zzhf() {
        return false;
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzch();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzch();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzch();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzge().zzim().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @VisibleForTesting
    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzab();
        try {
            return this.zzafb.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzip().zzg("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzeq zzf(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Boolean bl = null;
            if (!cursor.isNull(6)) {
                bl = cursor.getLong(6) == 1L;
            }
            zzeq zzeq2 = new zzeq(string, string2, l, l2, l3, l4, l5, l6, bl);
            if (cursor.moveToNext()) {
                this.zzge().zzim().zzg("Got multiple records for event aggregates, expected one. appId", zzfg.zzbm(string));
            }
            zzeq zzeq3 = zzeq2;
            return zzeq3;
        }
    }

    @WorkerThread
    public final void zza(zzeq zzeq2) {
        Preconditions.checkNotNull((Object)zzeq2);
        this.zzab();
        this.zzch();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzeq2.zzti);
        contentValues.put("name", zzeq2.name);
        contentValues.put("lifetime_count", Long.valueOf(zzeq2.zzafr));
        contentValues.put("current_bundle_count", Long.valueOf(zzeq2.zzafs));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzeq2.zzaft));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzeq2.zzafu));
        contentValues.put("last_sampled_complex_event_id", zzeq2.zzafv);
        contentValues.put("last_sampling_rate", zzeq2.zzafw);
        Long l = null;
        if (zzeq2.zzafx != null && zzeq2.zzafx.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzge().zzim().zzg("Failed to insert/update event aggregates (got -1). appId", zzfg.zzbm(zzeq2.zzti));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzim().zze("Error storing event aggregates. appId", zzfg.zzbm(zzeq2.zzti), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzg(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzge().zzit().zzg("Deleted user attribute rows", n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzim().zzd("Error deleting user attribute. appId", zzfg.zzbm(string), this.zzga().zzbl(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzjz zzjz2) {
        Preconditions.checkNotNull((Object)zzjz2);
        this.zzab();
        this.zzch();
        if (this.zzh(zzjz2.zzti, zzjz2.name) == null && (zzka.zzcc(zzjz2.name) ? this.zza("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzjz2.zzti}) >= 25L : this.zza("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzjz2.zzti, zzjz2.origin}) >= 25L)) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzjz2.zzti);
        contentValues.put("origin", zzjz2.origin);
        contentValues.put("name", zzjz2.name);
        contentValues.put("set_timestamp", Long.valueOf(zzjz2.zzaqz));
        zzei.zza(contentValues, "value", zzjz2.value);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzge().zzim().zzg("Failed to insert/update user property (got -1). appId", zzfg.zzbm(zzjz2.zzti));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzim().zze("Error storing user property. appId", zzfg.zzbm(zzjz2.zzti), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzjz zzh(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzjz zzjz2 = new zzjz(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzge().zzim().zzg("Got multiple records for user property, expected one. appId", zzfg.zzbm(string));
            }
            zzjz zzjz3 = zzjz2;
            return zzjz3;
        }
    }

    @WorkerThread
    public final List<zzjz> zzbb(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        ArrayList<zzjz> arrayList = new ArrayList<zzjz>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzjz> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzge().zzim().zzg("Read invalid user property value, ignoring it. appId", zzfg.zzbm(string));
                    continue;
                }
                zzjz zzjz2 = new zzjz(string, string2, (String)object, l, object2);
                arrayList.add(zzjz2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzjz> zzb(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        ArrayList<zzjz> arrayList = new ArrayList<zzjz>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, stringBuilder.toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzjz> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzge().zzim().zzg("Read more than the max allowed user properties, ignoring excess", 1000);
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzge().zzim().zzd("(2)Read invalid user property value, ignoring it", zzfg.zzbm(string), string2, string3);
                    continue;
                }
                zzjz zzjz2 = new zzjz(string, string2, (String)object, l, object2);
                arrayList.add(zzjz2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzed zzed2) {
        Preconditions.checkNotNull((Object)((Object)zzed2));
        this.zzab();
        this.zzch();
        if (this.zzh(zzed2.packageName, zzed2.zzaep.name) == null && this.zza("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzed2.packageName}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzed2.packageName);
        contentValues.put("origin", zzed2.origin);
        contentValues.put("name", zzed2.zzaep.name);
        zzei.zza(contentValues, "value", zzed2.zzaep.getValue());
        contentValues.put("active", Boolean.valueOf(zzed2.active));
        contentValues.put("trigger_event_name", zzed2.triggerEventName);
        contentValues.put("trigger_timeout", Long.valueOf(zzed2.triggerTimeout));
        this.zzgb();
        contentValues.put("timed_out_event", zzka.zza((Parcelable)zzed2.zzaeq));
        contentValues.put("creation_timestamp", Long.valueOf(zzed2.creationTimestamp));
        this.zzgb();
        contentValues.put("triggered_event", zzka.zza((Parcelable)zzed2.zzaer));
        contentValues.put("triggered_timestamp", Long.valueOf(zzed2.zzaep.zzaqz));
        contentValues.put("time_to_live", Long.valueOf(zzed2.timeToLive));
        this.zzgb();
        contentValues.put("expired_event", zzka.zza((Parcelable)zzed2.zzaes));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzge().zzim().zzg("Failed to insert/update conditional user property (got -1)", zzfg.zzbm(zzed2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzim().zze("Error storing conditional user property", zzfg.zzbm(zzed2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzed zzi(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzeu zzeu2 = this.zzgb().zza(cursor.getBlob(5), zzeu.CREATOR);
            long l2 = cursor.getLong(6);
            zzeu zzeu3 = this.zzgb().zza(cursor.getBlob(7), zzeu.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzeu zzeu4 = this.zzgb().zza(cursor.getBlob(10), zzeu.CREATOR);
            zzjx zzjx2 = new zzjx(string2, l3, object, string3);
            zzed zzed2 = new zzed(string, string3, zzjx2, l2, bl, string4, zzeu2, l, zzeu3, l4, zzeu4);
            if (cursor.moveToNext()) {
                this.zzge().zzim().zze("Got multiple records for conditional property, expected one", zzfg.zzbm(string), this.zzga().zzbl(string2));
            }
            zzed zzed3 = zzed2;
            return zzed3;
        }
    }

    @WorkerThread
    public final int zzj(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzim().zzd("Error deleting conditional property", zzfg.zzbm(string), this.zzga().zzbl(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzed> zzc(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzb(stringBuilder.toString(), stringArray);
    }

    public final List<zzed> zzb(String string, String[] stringArray) {
        this.zzab();
        this.zzch();
        ArrayList<zzed> arrayList = new ArrayList<zzed>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzed> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzge().zzim().zzg("Read more than the max allowed conditional properties, ignoring extra", 1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzeu zzeu2 = this.zzgb().zza(cursor.getBlob(7), zzeu.CREATOR);
                long l2 = cursor.getLong(8);
                zzeu zzeu3 = this.zzgb().zza(cursor.getBlob(9), zzeu.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzeu zzeu4 = this.zzgb().zza(cursor.getBlob(12), zzeu.CREATOR);
                zzjx zzjx2 = new zzjx(string3, l3, object2, string2);
                zzed zzed2 = new zzed((String)object, string2, zzjx2, l2, bl, string4, zzeu2, l, zzeu3, l4, zzeu4);
                arrayList.add(zzed2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzdy zzbc(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled", "ssaid_reporting_enabled"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzdy zzdy2 = new zzdy(this.zzajp.zzla(), string);
            zzdy2.zzal(cursor.getString(0));
            zzdy2.zzam(cursor.getString(1));
            zzdy2.zzan(cursor.getString(2));
            zzdy2.zzr(cursor.getLong(3));
            zzdy2.zzm(cursor.getLong(4));
            zzdy2.zzn(cursor.getLong(5));
            zzdy2.setAppVersion(cursor.getString(6));
            zzdy2.zzap(cursor.getString(7));
            zzdy2.zzp(cursor.getLong(8));
            zzdy2.zzq(cursor.getLong(9));
            zzdy2.setMeasurementEnabled(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzdy2.zzu(cursor.getLong(11));
            zzdy2.zzv(cursor.getLong(12));
            zzdy2.zzw(cursor.getLong(13));
            zzdy2.zzx(cursor.getLong(14));
            zzdy2.zzs(cursor.getLong(15));
            zzdy2.zzt(cursor.getLong(16));
            zzdy2.zzo(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzdy2.zzao(cursor.getString(18));
            zzdy2.zzz(cursor.getLong(19));
            zzdy2.zzy(cursor.getLong(20));
            zzdy2.zzaq(cursor.getString(21));
            zzdy2.zzaa(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzdy2.zzd(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzdy2.zze(cursor.isNull(24) || cursor.getInt(24) != 0);
            zzdy2.zzgh();
            if (cursor.moveToNext()) {
                this.zzge().zzim().zzg("Got multiple records for app, expected one. appId", zzfg.zzbm(string));
            }
            zzdy zzdy3 = zzdy2;
            return zzdy3;
        }
    }

    @WorkerThread
    public final void zza(zzdy zzdy2) {
        Preconditions.checkNotNull((Object)zzdy2);
        this.zzab();
        this.zzch();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzdy2.zzah());
        contentValues.put("app_instance_id", zzdy2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzdy2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzdy2.zzgi());
        contentValues.put("last_bundle_index", Long.valueOf(zzdy2.zzgq()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzdy2.zzgk()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzdy2.zzgl()));
        contentValues.put("app_version", zzdy2.zzag());
        contentValues.put("app_store", zzdy2.zzgn());
        contentValues.put("gmp_version", Long.valueOf(zzdy2.zzgo()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzdy2.zzgp()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzdy2.isMeasurementEnabled()));
        contentValues.put("day", Long.valueOf(zzdy2.zzgu()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzdy2.zzgv()));
        contentValues.put("daily_events_count", Long.valueOf(zzdy2.zzgw()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzdy2.zzgx()));
        contentValues.put("config_fetched_time", Long.valueOf(zzdy2.zzgr()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzdy2.zzgs()));
        contentValues.put("app_version_int", Long.valueOf(zzdy2.zzgm()));
        contentValues.put("firebase_instance_id", zzdy2.zzgj());
        contentValues.put("daily_error_events_count", Long.valueOf(zzdy2.zzgz()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzdy2.zzgy()));
        contentValues.put("health_monitor_sample", zzdy2.zzha());
        contentValues.put("android_id", Long.valueOf(zzdy2.zzhc()));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzdy2.zzhd()));
        contentValues.put("ssaid_reporting_enabled", Boolean.valueOf(zzdy2.zzhe()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzdy2.zzah()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzge().zzim().zzg("Failed to insert/update app (got -1). appId", zzfg.zzbm(zzdy2.zzah()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzim().zze("Error storing app. appId", zzfg.zzbm(zzdy2.zzah()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzbd(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzgg().zzb(string2, zzew.zzagx);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzim().zze("Error deleting over the limit events. appId", zzfg.zzbm(string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzej zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        String[] stringArray = new String[]{string};
        zzej zzej2 = new zzej();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzge().zzip().zzg("Not updating daily counts, app is not known. appId", zzfg.zzbm(string));
                zzej zzej3 = zzej2;
                return zzej3;
            }
            if (cursor.getLong(0) == l) {
                zzej2.zzafe = cursor.getLong(1);
                zzej2.zzafd = cursor.getLong(2);
                zzej2.zzaff = cursor.getLong(3);
                zzej2.zzafg = cursor.getLong(4);
                zzej2.zzafh = cursor.getLong(5);
            }
            if (bl) {
                ++zzej2.zzafe;
            }
            if (bl2) {
                ++zzej2.zzafd;
            }
            if (bl3) {
                ++zzej2.zzaff;
            }
            if (bl4) {
                ++zzej2.zzafg;
            }
            if (bl5) {
                ++zzej2.zzafh;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzej2.zzafd));
            contentValues.put("daily_events_count", Long.valueOf(zzej2.zzafe));
            contentValues.put("daily_conversions_count", Long.valueOf(zzej2.zzaff));
            contentValues.put("daily_error_events_count", Long.valueOf(zzej2.zzafg));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzej2.zzafh));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzej zzej4 = zzej2;
            return zzej4;
        }
    }

    @WorkerThread
    public final byte[] zzbe(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzge().zzim().zzg("Got multiple records for app config, expected one. appId", zzfg.zzbm(string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzkq zzkq2, boolean bl) {
        byte[] byArray;
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)((Object)zzkq2));
        Preconditions.checkNotEmpty((String)zzkq2.zzti);
        Preconditions.checkNotNull((Object)zzkq2.zzatm);
        this.zzhp();
        long l = this.zzbt().currentTimeMillis();
        if (zzkq2.zzatm < l - zzef.zzhh() || zzkq2.zzatm > l + zzef.zzhh()) {
            this.zzge().zzip().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzfg.zzbm(zzkq2.zzti), l, zzkq2.zzatm);
        }
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = new byte[zzkq2.zzvm()];
            zzabw zzabw2 = zzabw.zzb((byte[])byArray2, (int)0, (int)byArray3.length);
            zzkq2.zza(zzabw2);
            zzabw2.zzve();
            byArray = this.zzgb().zza(byArray2);
        }
        catch (IOException iOException) {
            this.zzge().zzim().zze("Data loss. Failed to serialize bundle. appId", zzfg.zzbm(zzkq2.zzti), iOException);
            return false;
        }
        this.zzge().zzit().zzg("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzkq2.zzti);
        contentValues.put("bundle_end_timestamp", zzkq2.zzatm);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        if (zzkq2.zzauj != null) {
            contentValues.put("retry_count", zzkq2.zzauj);
        }
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzge().zzim().zzg("Failed to insert bundle (got -1). appId", zzfg.zzbm(zzkq2.zzti));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzim().zze("Error storing bundle. appId", zzfg.zzbm(zzkq2.zzti), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final String zzhn() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public final boolean zzho() {
        return this.zza("select count(1) > 0 from queue where has_realtime = 1", (String[])null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzkq, Long>> zzb(String string, int n, int n2) {
        this.zzab();
        this.zzch();
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((n2 > 0 ? 1 : 0) != 0);
        Preconditions.checkNotEmpty((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data", "retry_count"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzkq, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzkq, Long>> arrayList = new ArrayList<Pair<zzkq, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzgb().zzb((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzge().zzim().zze("Failed to unzip queued bundle. appId", zzfg.zzbm(string), iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                byte[] byArray2 = byArray;
                object = zzabv.zza((byte[])byArray, (int)0, (int)byArray2.length);
                zzkq zzkq2 = new zzkq();
                try {
                    zzkq2.zzb((zzabv)object);
                }
                catch (IOException iOException) {
                    this.zzge().zzim().zze("Failed to merge queued bundle. appId", zzfg.zzbm(string), iOException);
                    continue;
                }
                if (!cursor.isNull(2)) {
                    zzkq2.zzauj = cursor.getInt(2);
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzkq, Long>)Pair.create((Object)((Object)zzkq2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzkq, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzhp() {
        this.zzab();
        this.zzch();
        if (!this.zzhv()) {
            return;
        }
        long l = this.zzgf().zzajx.get();
        long l2 = this.zzbt().elapsedRealtime();
        if (Math.abs(l2 - l) > zzew.zzahg.get()) {
            this.zzgf().zzajx.set(l2);
            zzei zzei2 = this;
            zzei2.zzab();
            zzei2.zzch();
            if (zzei2.zzhv()) {
                SQLiteDatabase sQLiteDatabase = zzei2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzei2.zzbt().currentTimeMillis()), String.valueOf(zzef.zzhh())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzei2.zzge().zzit().zzg("Deleted stale rows. rowsDeleted", n);
                }
            }
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzc(List<Long> list) {
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull(list);
        Preconditions.checkNotZero((int)list.size());
        if (!this.zzhv()) {
            return;
        }
        String string = TextUtils.join((CharSequence)",", list);
        String string2 = new StringBuilder(2 + String.valueOf(string).length()).append("(").append(string).append(")").toString();
        if (this.zza(new StringBuilder(80 + String.valueOf(string2).length()).append("SELECT COUNT(1) FROM queue WHERE rowid IN ").append(string2).append(" AND retry_count =  2147483647 LIMIT 1").toString(), (String[])null) > 0L) {
            this.zzge().zzip().log("The number of upload retries exceeds the limit. Will remain unchanged.");
        }
        try {
            this.getWritableDatabase().execSQL(new StringBuilder(127 + String.valueOf(string2).length()).append("UPDATE queue SET retry_count = IFNULL(retry_count, 0) + 1 WHERE rowid IN ").append(string2).append(" AND (retry_count IS NULL OR retry_count < 2147483647)").toString());
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzim().zzg("Error incrementing retry count. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, zzkd[] zzkdArray) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzkdArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzei zzei2 = this;
            zzei2.zzch();
            zzei2.zzab();
            Preconditions.checkNotEmpty((String)string2);
            Object object = zzei2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzkdArray;
            int n2 = zzkdArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzke zzke2;
                int n3;
                int n4;
                zzkd zzkd2 = object2[n];
                object = zzkd2;
                string2 = string;
                zzei2 = this;
                zzei2.zzch();
                zzei2.zzab();
                Preconditions.checkNotEmpty((String)string2);
                Preconditions.checkNotNull((Object)object);
                Preconditions.checkNotNull((Object)object.zzarn);
                Preconditions.checkNotNull((Object)object.zzarm);
                if (object.zzarl == null) {
                    zzei2.zzge().zzip().zzg("Audience with no ID. appId", zzfg.zzbm(string2));
                    continue;
                }
                int n5 = object.zzarl;
                zzaby[] zzabyArray = object.zzarn;
                int n6 = object.zzarn.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzabyArray[n4].zzarp != null) continue;
                    zzei2.zzge().zzip().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzfg.zzbm(string2), object.zzarl);
                    continue block3;
                }
                zzabyArray = object.zzarm;
                n6 = object.zzarm.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzabyArray[n4].zzarp != null) continue;
                    zzei2.zzge().zzip().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzfg.zzbm(string2), object.zzarl);
                    continue block3;
                }
                boolean bl = true;
                zzaby[] zzabyArray2 = object.zzarn;
                n4 = object.zzarn.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzke2 = zzabyArray2[n3];
                    if (zzei2.zza(string2, n5, zzke2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    zzabyArray2 = object.zzarm;
                    n4 = object.zzarm.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzke2 = zzabyArray2[n3];
                        if (zzei2.zza(string2, n5, (zzkh)((Object)zzke2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzei zzei3 = zzei2;
                zzei3.zzch();
                zzei3.zzab();
                Preconditions.checkNotEmpty((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzei3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzkd[] zzkdArray2 = zzkdArray;
            n = zzkdArray.length;
            for (int i = 0; i < n; ++i) {
                zzkd zzkd3 = zzkdArray2[i];
                object2.add(zzkd3.zzarl);
            }
            this.zza(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzke zzke2) {
        byte[] byArray;
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzke2));
        if (TextUtils.isEmpty((CharSequence)zzke2.zzarq)) {
            this.zzge().zzip().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzfg.zzbm(string), n, String.valueOf(zzke2.zzarp));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzke2.zzvm()];
            zzabw zzabw2 = zzabw.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzke2.zza(zzabw2);
            zzabw2.zzve();
        }
        catch (IOException iOException) {
            this.zzge().zzim().zze("Configuration loss. Failed to serialize event filter. appId", zzfg.zzbm(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzke2.zzarp);
        contentValues.put("event_name", zzke2.zzarq);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzge().zzim().zzg("Failed to insert event filter (got -1). appId", zzfg.zzbm(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzim().zze("Error storing event filter. appId", zzfg.zzbm(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzkh zzkh2) {
        byte[] byArray;
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzkh2));
        if (TextUtils.isEmpty((CharSequence)zzkh2.zzasf)) {
            this.zzge().zzip().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzfg.zzbm(string), n, String.valueOf(zzkh2.zzarp));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzkh2.zzvm()];
            zzabw zzabw2 = zzabw.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkh2.zza(zzabw2);
            zzabw2.zzve();
        }
        catch (IOException iOException) {
            this.zzge().zzim().zze("Configuration loss. Failed to serialize property filter. appId", zzfg.zzbm(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzkh2.zzarp);
        contentValues.put("property_name", zzkh2.zzasf);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzge().zzim().zzg("Failed to insert property filter (got -1). appId", zzfg.zzbm(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzim().zze("Error storing property filter. appId", zzfg.zzbm(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzke>> zzk(String string, String string2) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzke>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzabv zzabv2 = zzabv.zza((byte[])byArray, (int)0, (int)byArray.length);
                zzke zzke2 = new zzke();
                try {
                    zzke2.zzb(zzabv2);
                }
                catch (IOException iOException) {
                    this.zzge().zzim().zze("Failed to merge filter. appId", zzfg.zzbm(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzke> arrayList = (ArrayList<zzke>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzke>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzke2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzkh>> zzl(String string, String string2) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzkh>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzabv zzabv2 = zzabv.zza((byte[])byArray, (int)0, (int)byArray.length);
                zzkh zzkh2 = new zzkh();
                try {
                    zzkh2.zzb(zzabv2);
                }
                catch (IOException iOException) {
                    this.zzge().zzim().zze("Failed to merge filter", zzfg.zzbm(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzkh> arrayList = (ArrayList<zzkh>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzkh>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzkh2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zza(String string, List<Integer> list) {
        Object object;
        long l;
        Preconditions.checkNotEmpty((String)string);
        this.zzch();
        this.zzab();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zza("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzim().zze("Database error querying filters. appId", zzfg.zzbm(string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzgg().zzb(string2, zzew.zzahn);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzkr> zzbf(String string) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzabv zzabv2 = zzabv.zza((byte[])byArray, (int)0, (int)byArray.length);
                zzkr zzkr2 = new zzkr();
                try {
                    zzkr2.zzb(zzabv2);
                }
                catch (IOException iOException) {
                    this.zzge().zzim().zzd("Failed to merge filter results. appId, audienceId, error", zzfg.zzbm(string), n, iOException);
                    continue;
                }
                arrayMap.put(n, zzkr2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @VisibleForTesting
    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzge().zzim().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzge().zzim().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzge().zzim().zzg("Loaded invalid unknown value type, ignoring it", n3);
        return null;
    }

    @WorkerThread
    public final long zzhq() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    @VisibleForTesting
    protected final long zzm(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzge().zzim().zze("Failed to insert column (got -1). appId", zzfg.zzbm(string), string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzge().zzim().zze("Failed to update column (got 0). appId", zzfg.zzbm(string), string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzim().zzd("Error inserting column. appId", zzfg.zzbm(string), string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzhr() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzkq zzkq2) throws IOException {
        long l;
        Object object;
        byte[] byArray;
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)((Object)zzkq2));
        Preconditions.checkNotEmpty((String)zzkq2.zzti);
        try {
            byArray = new byte[zzkq2.zzvm()];
            object = byArray;
            zzabw zzabw2 = zzabw.zzb((byte[])byArray, (int)0, (int)((byte[])object).length);
            zzkq2.zza(zzabw2);
            zzabw2.zzve();
        }
        catch (IOException iOException) {
            this.zzge().zzim().zze("Data loss. Failed to serialize event metadata. appId", zzfg.zzbm(zzkq2.zzti), iOException);
            throw iOException;
        }
        byte[] byArray2 = byArray;
        object = this.zzgb();
        Preconditions.checkNotNull((Object)byArray2);
        ((zzhg)object).zzab();
        MessageDigest messageDigest = zzka.getMessageDigest("MD5");
        if (messageDigest == null) {
            ((zzhg)object).zzge().zzim().log("Failed to get MD5");
            l = 0L;
        } else {
            l = zzka.zzc(messageDigest.digest(byArray2));
        }
        long l2 = l;
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzkq2.zzti);
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzim().zze("Error storing raw event metadata. appId", zzfg.zzbm(zzkq2.zzti), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l2;
    }

    public final boolean zzhs() {
        return this.zza("select count(1) > 0 from raw_events", (String[])null) != 0L;
    }

    public final boolean zzht() {
        return this.zza("select count(1) > 0 from raw_events where realtime = 1", (String[])null) != 0L;
    }

    public final long zzbg(String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzab(long l) {
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzge().zzit().log("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzhu() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final Pair<zzkn, Long> zza(String string, Long l) {
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select main_event, children_to_process from main_event_params where app_id=? and event_id=?", new String[]{string, String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzge().zzit().log("Main event not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            Long l2 = cursor.getLong(1);
            byte[] byArray2 = byArray;
            zzabv zzabv2 = zzabv.zza((byte[])byArray, (int)0, (int)byArray2.length);
            zzkn zzkn2 = new zzkn();
            try {
                zzkn2.zzb(zzabv2);
            }
            catch (IOException iOException) {
                this.zzge().zzim().zzd("Failed to merge main event. appId, eventId", zzfg.zzbm(string), l, iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            Pair pair = Pair.create((Object)((Object)zzkn2), (Object)l2);
            return pair;
        }
        return null;
    }

    public final boolean zza(String string, Long l, long l2, zzkn zzkn2) {
        byte[] byArray;
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)((Object)zzkn2));
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)l);
        try {
            byte[] byArray2 = byArray = new byte[zzkn2.zzvm()];
            zzabw zzabw2 = zzabw.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkn2.zza(zzabw2);
            zzabw2.zzve();
        }
        catch (IOException iOException) {
            this.zzge().zzim().zzd("Data loss. Failed to serialize event params/data. appId, eventId", zzfg.zzbm(string), l, iOException);
            return false;
        }
        this.zzge().zzit().zze("Saving complex main event, appId, data size", this.zzga().zzbj(string), byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("event_id", l);
        contentValues.put("children_to_process", Long.valueOf(l2));
        contentValues.put("main_event", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1L) {
                this.zzge().zzim().zzg("Failed to insert complex main event (got -1). appId", zzfg.zzbm(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzim().zze("Error storing complex main event. appId", zzfg.zzbm(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(zzep zzep2, long l, boolean bl) {
        Object object;
        zzko zzko2;
        String string2;
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)zzep2);
        Preconditions.checkNotEmpty((String)zzep2.zzti);
        zzkn zzkn2 = new zzkn();
        new zzkn().zzatc = zzep2.zzafp;
        zzkn2.zzata = new zzko[zzep2.zzafq.size()];
        int n = 0;
        for (String string2 : zzep2.zzafq) {
            zzko2 = new zzko();
            zzkn2.zzata[n++] = zzko2;
            zzko2.name = string2;
            Object object2 = zzep2.zzafq.get(string2);
            this.zzgb().zza(zzko2, object2);
        }
        try {
            byte[] byArray = new byte[zzkn2.zzvm()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzko2 = zzabw.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkn2.zza((zzabw)zzko2);
            zzko2.zzve();
        }
        catch (IOException iOException) {
            this.zzge().zzim().zze("Data loss. Failed to serialize event params/data. appId", zzfg.zzbm(zzep2.zzti), iOException);
            return false;
        }
        this.zzge().zzit().zze("Saving event, name, data size", this.zzga().zzbj(zzep2.name), ((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzep2.zzti);
        string2.put("name", zzep2.name);
        string2.put("timestamp", Long.valueOf(zzep2.timestamp));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzge().zzim().zzg("Failed to insert raw event (got -1). appId", zzfg.zzbm(zzep2.zzti));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzge().zzim().zze("Error storing raw event. appId", zzfg.zzbm(zzep2.zzti), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzhv() {
        return this.getContext().getDatabasePath("google_app_measurement.db").exists();
    }

    @WorkerThread
    private static boolean zza(zzfg zzfg2, SQLiteDatabase sQLiteDatabase, String string) {
        if (zzfg2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
            boolean bl = cursor.moveToFirst();
            return bl;
        }
    }

    @WorkerThread
    private static Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
        try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
            Collections.addAll(hashSet, cursor.getColumnNames());
        }
        return hashSet;
    }

    @WorkerThread
    static void zza(zzfg zzfg2, SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, String[] stringArray) throws SQLiteException {
        if (zzfg2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (!zzei.zza(zzfg2, sQLiteDatabase, string)) {
            sQLiteDatabase.execSQL(string2);
        }
        try {
            String[] stringArray2 = stringArray;
            String string4 = string3;
            String string5 = string;
            SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
            zzfg zzfg3 = zzfg2;
            if (zzfg3 == null) {
                throw new IllegalArgumentException("Monitor must not be null");
            }
            Set<String> set = zzei.zzb(sQLiteDatabase2, string5);
            for (String string6 : string4.split(",")) {
                if (set.remove(string6)) continue;
                throw new SQLiteException(new StringBuilder(35 + String.valueOf(string5).length() + String.valueOf(string6).length()).append("Table ").append(string5).append(" is missing required column: ").append(string6).toString());
            }
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; i += 2) {
                    if (set.remove(stringArray2[i])) continue;
                    sQLiteDatabase2.execSQL(stringArray2[i + 1]);
                }
            }
            if (!set.isEmpty()) {
                zzfg3.zzip().zze("Table has extra columns. table, columns", string5, TextUtils.join((CharSequence)", ", set));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            zzfg2.zzim().zzg("Failed to verify columns on table that was just created", string);
            throw sQLiteException;
        }
    }

    static void zza(zzfg zzfg2, SQLiteDatabase sQLiteDatabase) {
        if (zzfg2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        File file = new File(sQLiteDatabase.getPath());
        if (!file.setReadable(false, false)) {
            zzfg2.zzip().log("Failed to turn off database read permission");
        }
        if (!file.setWritable(false, false)) {
            zzfg2.zzip().log("Failed to turn off database write permission");
        }
        if (!file.setReadable(true, true)) {
            zzfg2.zzip().log("Failed to turn on database read permission for owner");
        }
        if (!file.setWritable(true, true)) {
            zzfg2.zzip().log("Failed to turn on database write permission for owner");
        }
    }

    static /* synthetic */ zzjm zza(zzei zzei2) {
        return zzei2.zzafc;
    }

    static /* synthetic */ String[] zzhw() {
        return zzaev;
    }

    static /* synthetic */ String[] zzhx() {
        return zzaew;
    }

    static /* synthetic */ String[] zzhy() {
        return zzaex;
    }

    static /* synthetic */ String[] zzhz() {
        return zzaez;
    }

    static /* synthetic */ String[] zzia() {
        return zzaey;
    }

    static /* synthetic */ String[] zzib() {
        return zzafa;
    }
}

