/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.firebase.iid.FirebaseInstanceId;
import java.math.BigInteger;
import java.util.Locale;

public final class zzfb
extends zzhh {
    private String zzti;
    private String zzth;
    private int zzaie;
    private String zzadt;
    private String zztg;
    private long zzaif;
    private long zzadx;
    private int zzaen;
    private String zzadm;

    zzfb(zzgl zzgl2) {
        super(zzgl2);
    }

    @Override
    protected final boolean zzhf() {
        return true;
    }

    @Override
    protected final void zzih() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzhg)this).getContext().getPackageName();
        PackageManager packageManager = ((zzhg)this).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzhg)this).zzge().zzim().zzg("PackageManager is null, app identity information might be inaccurate. appId", zzfg.zzbm(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzhg)this).zzge().zzim().zzg("Error retrieving app installer package name. appId", zzfg.zzbm(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzhg)this).getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzhg)this).zzge().zzim().zze("Error retrieving package info. appId, appName", zzfg.zzbm(string4), string3);
            }
        }
        this.zzti = string4;
        this.zzadt = string;
        this.zzth = string2;
        this.zzaie = n;
        this.zztg = string3;
        this.zzaif = 0L;
        packageInfo = GoogleServices.initialize((Context)((zzhg)this).getContext());
        boolean bl = packageInfo != null && packageInfo.isSuccess();
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzfb zzfb2 = this;
            if (packageInfo2 == null) {
                ((zzhg)zzfb2).zzge().zzim().log("GoogleService failed to initialize (no status)");
            } else {
                ((zzhg)zzfb2).zzge().zzim().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzhg)this).zzgg().zzas("firebase_analytics_collection_enabled");
            if (((zzhg)this).zzgg().zzhg()) {
                ((zzhg)this).zzge().zzir().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                ((zzhg)this).zzge().zzir().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && GoogleServices.isMeasurementExplicitlyDisabled()) {
                ((zzhg)this).zzge().zzir().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzhg)this).zzge().zzit().log("Collection enabled");
            }
        }
        this.zzadm = "";
        this.zzadx = 0L;
        try {
            object = GoogleServices.getGoogleAppId();
            Object object2 = this.zzadm = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (bl2) {
                ((zzhg)this).zzge().zzit().zze("App package, google app id", this.zzti, this.zzadm);
            }
        }
        catch (IllegalStateException illegalStateException) {
            ((zzhg)this).zzge().zzim().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzfg.zzbm(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzaen = InstantApps.isInstantApp((Context)((zzhg)this).getContext()) ? 1 : 0;
            return;
        }
        this.zzaen = 0;
    }

    @WorkerThread
    final zzdz zzbi(String string) {
        ((zzhg)this).zzab();
        String string2 = this.zzah();
        String string3 = this.getGmpAppId();
        zzhg zzhg2 = this;
        zzhg2.zzch();
        String string4 = zzhg2.zzth;
        long l = this.zzij();
        zzhg2 = this;
        zzhg2.zzch();
        String string5 = zzhg2.zzadt;
        zzhg2 = this;
        zzhg2.zzch();
        ((zzhg)zzhg2).zzab();
        if (zzhg2.zzaif == 0L) {
            zzhg2.zzaif = ((zzjr)zzhg2.zzacw).zzgb().zzd(((zzhg)zzhg2).getContext(), ((zzhg)zzhg2).getContext().getPackageName());
        }
        long l2 = zzhg2.zzaif;
        boolean bl = this.zzacw.isEnabled();
        boolean bl2 = !((zzhg)this).zzgf().zzakn;
        String string6 = this.zzgj();
        this.zzch();
        zzhg2 = ((zzhg)this).zzgg();
        Boolean bl3 = ((zzef)zzhg2).zzas("google_analytics_adid_collection_enabled");
        boolean bl4 = bl3 == null || bl3 != false;
        zzhg2 = ((zzhg)this).zzgg();
        bl3 = ((zzef)zzhg2).zzas("google_analytics_ssaid_collection_enabled");
        return new zzdz(string2, string3, string4, l, string5, 12451L, l2, string, bl, bl2, string6, 0L, this.zzacw.zzjt(), this.zzik(), bl4, bl3 == null || bl3 != false, ((zzhg)this).zzgf().zzje());
    }

    @WorkerThread
    final String zzii() {
        byte[] byArray = new byte[16];
        ((zzhg)this).zzgb().zzlc().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    private final String zzgj() {
        ((zzhg)this).zzab();
        if (((zzhg)this).zzgg().zzay(this.zzti) && !this.zzacw.isEnabled()) {
            return null;
        }
        try {
            return FirebaseInstanceId.getInstance().getId();
        }
        catch (IllegalStateException illegalStateException) {
            ((zzhg)this).zzge().zzip().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String zzah() {
        this.zzch();
        return this.zzti;
    }

    final String getGmpAppId() {
        this.zzch();
        return this.zzadm;
    }

    final int zzij() {
        this.zzch();
        return this.zzaie;
    }

    final int zzik() {
        this.zzch();
        return this.zzaen;
    }
}

