/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzfc;
import com.google.android.gms.internal.measurement.zzhg;

@VisibleForTesting
final class zzfd
extends SQLiteOpenHelper {
    private final /* synthetic */ zzfc zzaii;

    zzfd(zzfc zzfc2, Context context, String string) {
        this.zzaii = zzfc2;
        super(context, string, null, 1);
    }

    @WorkerThread
    public final SQLiteDatabase getWritableDatabase() throws SQLiteException {
        try {
            return super.getWritableDatabase();
        }
        catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
            throw sQLiteDatabaseLockedException;
        }
        catch (SQLiteException sQLiteException) {
            ((zzhg)this.zzaii).zzge().zzim().log("Opening the local database failed, dropping and recreating it");
            String string = "google_app_measurement_local.db";
            if (!((zzhg)this.zzaii).getContext().getDatabasePath(string).delete()) {
                ((zzhg)this.zzaii).zzge().zzim().zzg("Failed to delete corrupted local db file", string);
            }
            try {
                return super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException2) {
                ((zzhg)this.zzaii).zzge().zzim().zzg("Failed to open local database. Events will bypass local storage", (Object)sQLiteException2);
                return null;
            }
        }
    }

    @WorkerThread
    public final void onOpen(SQLiteDatabase sQLiteDatabase) {
        if (Build.VERSION.SDK_INT < 15) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);
                cursor.moveToFirst();
            }
        }
        zzei.zza(((zzhg)this.zzaii).zzge(), sQLiteDatabase, "messages", "create table if not exists messages ( type INTEGER NOT NULL, entry BLOB NOT NULL)", "type,entry", null);
    }

    @WorkerThread
    public final void onCreate(SQLiteDatabase sQLiteDatabase) {
        zzei.zza(((zzhg)this.zzaii).zzge(), sQLiteDatabase);
    }

    @WorkerThread
    public final void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
    }

    @WorkerThread
    public final void onDowngrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
    }
}

