/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzft;
import com.google.android.gms.internal.measurement.zzfu;
import com.google.android.gms.internal.measurement.zzfv;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzka;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzfr
extends zzhh {
    @VisibleForTesting
    static final Pair<String, Long> zzajs = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzabf;
    public zzfv zzajt;
    public final zzfu zzaju = new zzfu(this, "last_upload", 0L);
    public final zzfu zzajv = new zzfu(this, "last_upload_attempt", 0L);
    public final zzfu zzajw = new zzfu(this, "backoff", 0L);
    public final zzfu zzajx = new zzfu(this, "last_delete_stale", 0L);
    public final zzfu zzajy;
    public final zzfu zzajz;
    public final zzfu zzaka;
    public final zzfw zzakb;
    private String zzakc;
    private boolean zzakd;
    private long zzake;
    private String zzakf;
    private long zzakg;
    private final Object zzakh;
    public final zzfu zzaki = new zzfu(this, "time_before_start", 10000L);
    public final zzfu zzakj = new zzfu(this, "session_timeout", 1800000L);
    public final zzft zzakk = new zzft(this, "start_new_session", true);
    public final zzfu zzakl = new zzfu(this, "last_pause_time", 0L);
    public final zzfu zzakm = new zzfu(this, "time_active", 0L);
    public boolean zzakn;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzbo(String string) {
        this.zzab();
        long l = this.zzbt().elapsedRealtime();
        if (this.zzakc != null && l < this.zzake) {
            return new Pair((Object)this.zzakc, (Object)this.zzakd);
        }
        String string2 = string;
        this.zzake = l + this.zzgg().zza(string2, zzew.zzagj);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zzakc = info.getId();
                this.zzakd = info.isLimitAdTrackingEnabled();
            }
            if (this.zzakc == null) {
                this.zzakc = "";
            }
        }
        catch (Exception exception) {
            this.zzge().zzis().zzg("Unable to get advertising id", exception);
            this.zzakc = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzakc, (Object)this.zzakd);
    }

    @WorkerThread
    final String zzbp(String string) {
        this.zzab();
        String string2 = (String)this.zzbo((String)string).first;
        MessageDigest messageDigest = zzka.getMessageDigest("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzfr(zzgl zzgl2) {
        super(zzgl2);
        this.zzajy = new zzfu(this, "midnight_offset", 0L);
        this.zzajz = new zzfu(this, "first_open_time", 0L);
        this.zzaka = new zzfu(this, "app_install_time", 0L);
        this.zzakb = new zzfw(this, "app_instance_id", null);
        this.zzakh = new Object();
    }

    @Override
    protected final boolean zzhf() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void zzih() {
        this.zzabf = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzakn = this.zzabf.getBoolean("has_been_opened", false);
        if (!this.zzakn) {
            SharedPreferences.Editor editor = this.zzabf.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzajt = new zzfv(this, "health_monitor", Math.max(0L, zzew.zzagk.get()), null);
    }

    @WorkerThread
    private final SharedPreferences zziy() {
        this.zzab();
        this.zzch();
        return this.zzabf;
    }

    @WorkerThread
    final void zzbq(String string) {
        this.zzab();
        SharedPreferences.Editor editor = this.zziy().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zziz() {
        this.zzab();
        return this.zziy().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzbr(String string) {
        Object object = this.zzakh;
        synchronized (object) {
            this.zzakf = string;
            this.zzakg = this.zzbt().elapsedRealtime();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzja() {
        Object object = this.zzakh;
        synchronized (object) {
            if (Math.abs(this.zzbt().elapsedRealtime() - this.zzakg) < 1000L) {
                return this.zzakf;
            }
            return null;
        }
    }

    @WorkerThread
    final Boolean zzjb() {
        this.zzab();
        if (!this.zziy().contains("use_service")) {
            return null;
        }
        return this.zziy().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzf(boolean bl) {
        this.zzab();
        this.zzge().zzit().zzg("Setting useService", bl);
        SharedPreferences.Editor editor = this.zziy().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzjc() {
        this.zzab();
        this.zzge().zzit().log("Clearing collection preferences.");
        boolean bl = this.zziy().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzg(true);
        }
        SharedPreferences.Editor editor = this.zziy().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzab();
        this.zzge().zzit().zzg("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zziy().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzg(boolean bl) {
        this.zzab();
        return this.zziy().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected final String zzjd() {
        this.zzab();
        String string = this.zziy().getString("previous_os_version", null);
        this.zzfw().zzch();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zziy().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzh(boolean bl) {
        this.zzab();
        this.zzge().zzit().zzg("Updating deferred analytics collection", bl);
        SharedPreferences.Editor editor = this.zziy().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzje() {
        this.zzab();
        return this.zziy().getBoolean("deferred_analytics_collection", false);
    }

    @WorkerThread
    final boolean zzjf() {
        return this.zzabf.contains("deferred_analytics_collection");
    }

    static /* synthetic */ SharedPreferences zza(zzfr zzfr2) {
        return zzfr2.zziy();
    }
}

