/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzgc;
import com.google.android.gms.internal.measurement.zzgd;
import com.google.android.gms.internal.measurement.zzge;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzjr;

public final class zzgb {
    private final zzge zzala;

    public zzgb(zzge zzge2) {
        Preconditions.checkNotNull((Object)zzge2);
        this.zzala = zzge2;
    }

    public static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void onReceive(Context context, Intent intent) {
        zzgl zzgl2 = zzgl.zzg(context);
        zzfg zzfg2 = ((zzjr)zzgl2).zzge();
        if (intent == null) {
            zzfg2.zzip().log("Receiver called with null intent");
            return;
        }
        String string = intent.getAction();
        zzfg2.zzit().zzg("Local receiver got", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzfg2.zzit().log("Starting wakeful intent.");
            this.zzala.doStartService(context, intent2);
            return;
        }
        if ("com.android.vending.INSTALL_REFERRER".equals(string)) {
            try {
                ((zzjr)zzgl2).zzgd().zzc(new zzgc(this, zzgl2, zzfg2));
            }
            catch (Exception exception) {
                zzfg2.zzip().zzg("Install Referrer Reporter encountered a problem", exception);
            }
            BroadcastReceiver.PendingResult pendingResult = this.zzala.doGoAsync();
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzfg2.zzit().log("Install referrer extras are null");
                if (pendingResult != null) {
                    pendingResult.finish();
                }
                return;
            }
            zzfg2.zzir().zzg("Install referrer extras are", string2);
            if (!string2.contains("?")) {
                String string3 = String.valueOf(string2);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            Uri uri = Uri.parse((String)string2);
            Bundle bundle = ((zzjr)zzgl2).zzgb().zza(uri);
            if (bundle == null) {
                zzfg2.zzit().log("No campaign defined in install referrer broadcast");
                if (pendingResult != null) {
                    pendingResult.finish();
                    return;
                }
            } else {
                long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzfg2.zzip().log("Install referrer is missing timestamp");
                }
                ((zzjr)zzgl2).zzgd().zzc(new zzgd(this, zzgl2, l, bundle, context, zzfg2, pendingResult));
            }
        }
    }
}

