/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzabv;
import com.google.android.gms.internal.measurement.zzabw;
import com.google.android.gms.internal.measurement.zzaby;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzjp;
import com.google.android.gms.internal.measurement.zzjq;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzka;
import com.google.android.gms.internal.measurement.zzkd;
import com.google.android.gms.internal.measurement.zzke;
import com.google.android.gms.internal.measurement.zzkf;
import com.google.android.gms.internal.measurement.zzkh;
import com.google.android.gms.internal.measurement.zzkj;
import com.google.android.gms.internal.measurement.zzkk;
import com.google.android.gms.internal.measurement.zzkl;
import com.google.android.gms.measurement.AppMeasurement;
import java.io.IOException;
import java.util.Map;

public final class zzgf
extends zzjq
implements zzeh {
    @VisibleForTesting
    private static int zzalf = 65535;
    @VisibleForTesting
    private static int zzalg = 2;
    private final Map<String, Map<String, String>> zzalh = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzali = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzalj = new ArrayMap();
    private final Map<String, zzkk> zzalk = new ArrayMap();
    private final Map<String, Map<String, Integer>> zzall;
    private final Map<String, String> zzalm = new ArrayMap();

    zzgf(zzjr zzjr2) {
        super(zzjr2);
        this.zzall = new ArrayMap();
    }

    @WorkerThread
    private final void zzbt(String string) {
        this.zzch();
        ((zzhg)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzalk.get(string) == null) {
            byte[] byArray = ((zzjp)this).zzix().zzbe(string);
            if (byArray == null) {
                this.zzalh.put(string, null);
                this.zzali.put(string, null);
                this.zzalj.put(string, null);
                this.zzalk.put(string, null);
                this.zzalm.put(string, null);
                this.zzall.put(string, null);
                return;
            }
            zzkk zzkk2 = this.zza(string, byArray);
            this.zzalh.put(string, zzgf.zza(zzkk2));
            this.zza(string, zzkk2);
            this.zzalk.put(string, zzkk2);
            this.zzalm.put(string, null);
        }
    }

    @WorkerThread
    protected final zzkk zzbu(String string) {
        this.zzch();
        ((zzhg)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        this.zzbt(string);
        return this.zzalk.get(string);
    }

    @WorkerThread
    protected final String zzbv(String string) {
        ((zzhg)this).zzab();
        return this.zzalm.get(string);
    }

    @WorkerThread
    protected final void zzbw(String string) {
        ((zzhg)this).zzab();
        this.zzalm.put(string, null);
    }

    @WorkerThread
    final void zzbx(String string) {
        ((zzhg)this).zzab();
        this.zzalk.remove(string);
    }

    @Override
    @WorkerThread
    public final String zze(String string, String string2) {
        ((zzhg)this).zzab();
        this.zzbt(string);
        Map<String, String> map = this.zzalh.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    private static Map<String, String> zza(zzkk zzkk2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzkk2 != null && zzkk2.zzasr != null) {
            zzkl[] zzklArray = zzkk2.zzasr;
            int n = zzkk2.zzasr.length;
            for (int i = 0; i < n; ++i) {
                zzkl zzkl2 = zzklArray[i];
                if (zzkl2 == null) continue;
                arrayMap.put(zzkl2.zzny, zzkl2.value);
            }
        }
        return arrayMap;
    }

    private final void zza(String string, zzkk zzkk2) {
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zzkk2 != null && zzkk2.zzass != null) {
            zzkj[] zzkjArray = zzkk2.zzass;
            int n = zzkk2.zzass.length;
            for (int i = 0; i < n; ++i) {
                zzkj zzkj2 = zzkjArray[i];
                if (TextUtils.isEmpty((CharSequence)zzkj2.name)) {
                    ((zzhg)this).zzge().zzip().log("EventConfig contained null event name");
                    continue;
                }
                String string2 = AppMeasurement.Event.zzak(zzkj2.name);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    zzkj2.name = string2;
                }
                arrayMap.put(zzkj2.name, zzkj2.zzasm);
                arrayMap2.put(zzkj2.name, zzkj2.zzasn);
                if (zzkj2.zzaso == null) continue;
                if (zzkj2.zzaso < zzalg || zzkj2.zzaso > zzalf) {
                    ((zzhg)this).zzge().zzip().zze("Invalid sampling rate. Event name, sample rate", zzkj2.name, zzkj2.zzaso);
                    continue;
                }
                arrayMap3.put(zzkj2.name, zzkj2.zzaso);
            }
        }
        this.zzali.put(string, (Map<String, Boolean>)arrayMap);
        this.zzalj.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzall.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    protected final boolean zza(String string, byte[] byArray, String string2) {
        this.zzch();
        ((zzhg)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        zzkk zzkk2 = this.zza(string, byArray);
        if (zzkk2 == null) {
            return false;
        }
        this.zza(string, zzkk2);
        this.zzalk.put(string, zzkk2);
        this.zzalm.put(string, string2);
        this.zzalh.put(string, zzgf.zza(zzkk2));
        Object object = zzkk2.zzast;
        String string3 = string;
        Object object2 = ((zzjp)this).zziw();
        Preconditions.checkNotNull((Object)object);
        for (zzkd zzkd2 : object) {
            String string4;
            zzke zzke2;
            int n;
            zzaby[] zzabyArray = zzkd2.zzarn;
            int n2 = zzkd2.zzarn.length;
            for (n = 0; n < n2; ++n) {
                zzke2 = zzabyArray[n];
                string4 = AppMeasurement.Event.zzak(zzke2.zzarq);
                if (string4 != null) {
                    zzke2.zzarq = string4;
                }
                zzkf[] zzkfArray = zzke2.zzarr;
                int n3 = zzke2.zzarr.length;
                for (int i = 0; i < n3; ++i) {
                    zzkf zzkf2 = zzkfArray[i];
                    String string5 = AppMeasurement.Param.zzak(zzkf2.zzary);
                    if (string5 == null) continue;
                    zzkf2.zzary = string5;
                }
            }
            zzabyArray = zzkd2.zzarm;
            n2 = zzkd2.zzarm.length;
            for (n = 0; n < n2; ++n) {
                zzke2 = zzabyArray[n];
                string4 = AppMeasurement.UserProperty.zzak(((zzkh)((Object)zzke2)).zzasf);
                if (string4 == null) continue;
                ((zzkh)((Object)zzke2)).zzasf = string4;
            }
        }
        ((zzjp)object2).zzix().zza(string3, (zzkd[])object);
        try {
            zzkk2.zzast = null;
            byte[] byArray2 = new byte[zzkk2.zzvm()];
            object2 = byArray2;
            zzabw zzabw2 = zzabw.zzb((byte[])byArray2, (int)0, (int)((Object)object2).length);
            zzkk2.zza(zzabw2);
            byArray = byArray2;
        }
        catch (IOException iOException) {
            ((zzhg)this).zzge().zzip().zze("Unable to serialize reduced-size config. Storing full config instead. appId", zzfg.zzbm(string), iOException);
        }
        object = byArray;
        string3 = string;
        object2 = ((zzjp)this).zzix();
        Preconditions.checkNotEmpty((String)string3);
        ((zzhg)object2).zzab();
        ((zzjq)object2).zzch();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", (byte[])object);
        try {
            if ((long)((zzei)object2).getWritableDatabase().update("apps", contentValues, "app_id = ?", new String[]{string3}) == 0L) {
                ((zzhg)object2).zzge().zzim().zzg("Failed to update remote config (got 0). appId", zzfg.zzbm(string3));
            }
        }
        catch (SQLiteException sQLiteException) {
            ((zzhg)object2).zzge().zzim().zze("Error storing remote config. appId", zzfg.zzbm(string3), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    final boolean zzn(String string, String string2) {
        ((zzhg)this).zzab();
        this.zzbt(string);
        if (this.zzby(string) && zzka.zzci(string2)) {
            return true;
        }
        if (this.zzbz(string) && zzka.zzcc(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzali.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzo(String string, String string2) {
        ((zzhg)this).zzab();
        this.zzbt(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzalj.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final int zzp(String string, String string2) {
        ((zzhg)this).zzab();
        this.zzbt(string);
        Map<String, Integer> map = this.zzall.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    private final zzkk zza(String string, byte[] byArray) {
        if (byArray == null) {
            return new zzkk();
        }
        byte[] byArray2 = byArray;
        zzabv zzabv2 = zzabv.zza((byte[])byArray, (int)0, (int)byArray2.length);
        zzkk zzkk2 = new zzkk();
        try {
            zzkk2.zzb(zzabv2);
            ((zzhg)this).zzge().zzit().zze("Parsed config. version, gmp_app_id", zzkk2.zzasp, zzkk2.zzadm);
        }
        catch (IOException iOException) {
            ((zzhg)this).zzge().zzip().zze("Unable to merge remote config. appId", zzfg.zzbm(string), iOException);
            return new zzkk();
        }
        return zzkk2;
    }

    final boolean zzby(String string) {
        return "1".equals(this.zze(string, "measurement.upload.blacklist_internal"));
    }

    final boolean zzbz(String string) {
        return "1".equals(this.zze(string, "measurement.upload.blacklist_public"));
    }

    @Override
    protected final boolean zzhf() {
        return false;
    }
}

