/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Application;
import android.content.Context;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzdu;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeo;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfc;
import com.google.android.gms.internal.measurement.zzfe;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzfr;
import com.google.android.gms.internal.measurement.zzfx;
import com.google.android.gms.internal.measurement.zzgb;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.android.gms.internal.measurement.zzid;
import com.google.android.gms.internal.measurement.zzif;
import com.google.android.gms.internal.measurement.zzii;
import com.google.android.gms.internal.measurement.zzjc;
import com.google.android.gms.internal.measurement.zzjh;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzka;
import com.google.android.gms.internal.measurement.zzws;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.util.concurrent.atomic.AtomicReference;

public class zzgl
extends zzjr
implements zzhi {
    private static volatile zzgl zzame;
    private final Context zzqx;
    private final zzef zzamf;
    private final zzfr zzamg;
    private final zzfg zzamh;
    private final zzgg zzami;
    private final zzjh zzamj;
    private final AppMeasurement zzamk;
    private final FirebaseAnalytics zzaml;
    private final zzka zzamm;
    private final zzfe zzamn;
    private final Clock zzro;
    private final zzif zzamo;
    private final zzhk zzamp;
    private final zzdu zzamq;
    private zzfc zzamr;
    private zzii zzams;
    private zzeo zzamt;
    private zzfb zzamu;
    private zzfx zzamv;
    private boolean zzvo = false;
    private Boolean zzamw;
    private long zzamx;
    private int zzamy;
    private int zzamz;
    private final long zzaem;

    private zzgl(zzhj zzhj2) {
        zzdu zzdu2;
        Preconditions.checkNotNull((Object)zzhj2);
        this.zza(this);
        this.zzqx = zzhj2.zzqx;
        zzws.init(this.zzqx);
        this.zzaqs = -1L;
        this.zzro = DefaultClock.getInstance();
        this.zzaem = this.zzro.currentTimeMillis();
        zzgl zzgl2 = this;
        this.zzamf = new zzef(zzgl2);
        zzgl2 = this;
        zzfr zzfr2 = new zzfr(zzgl2);
        zzfr2.zzm();
        this.zzamg = zzfr2;
        zzgl2 = this;
        zzfg zzfg2 = new zzfg(zzgl2);
        zzfg2.zzm();
        this.zzamh = zzfg2;
        zzgl2 = this;
        zzka zzka2 = new zzka(zzgl2);
        zzka2.zzm();
        this.zzamm = zzka2;
        zzgl2 = this;
        zzfe zzfe2 = new zzfe(zzgl2);
        zzfe2.zzm();
        this.zzamn = zzfe2;
        zzgl2 = this;
        this.zzamq = zzdu2 = new zzdu(zzgl2);
        zzgl2 = this;
        zzif zzif2 = new zzif(zzgl2);
        zzif2.zzm();
        this.zzamo = zzif2;
        zzgl2 = this;
        zzhk zzhk2 = new zzhk(zzgl2);
        zzhk2.zzm();
        this.zzamp = zzhk2;
        zzgl2 = this;
        this.zzamk = new AppMeasurement(zzgl2);
        zzgl2 = this;
        this.zzaml = new FirebaseAnalytics(zzgl2);
        zzgl2 = this;
        zzjh zzjh2 = new zzjh(zzgl2);
        zzjh2.zzm();
        this.zzamj = zzjh2;
        zzgl2 = this;
        zzgg zzgg2 = new zzgg(zzgl2);
        zzgg2.zzm();
        this.zzami = zzgg2;
        zzgl2 = this;
        if (zzgl2.zzqx.getApplicationContext() instanceof Application) {
            zzhk zzhk3 = zzgl2.zzfu();
            if (((zzhg)zzhk3).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzhg)zzhk3).getContext().getApplicationContext();
                if (zzhk3.zzanp == null) {
                    zzhk3.zzanp = new zzid(zzhk3, null);
                }
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhk3.zzanp);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhk3.zzanp);
                ((zzhg)zzhk3).zzge().zzit().log("Registered activity lifecycle callback");
            }
        } else {
            ((zzjr)zzgl2).zzge().zzip().log("Application context is not an Application");
        }
        zzgl2 = this;
        zzfk zzfk2 = new zzfk((zzjr)zzgl2);
        zzfk2.zzm();
        this.zzaqb = zzfk2;
        zzgl2 = this;
        zzgf zzgf2 = new zzgf((zzjr)zzgl2);
        zzgf2.zzm();
        this.zzaqa = zzgf2;
        this.zzami.zzc(new zzgm(this, zzhj2));
    }

    @WorkerThread
    final void zza(zzhj zzhj2) {
        String string;
        zzfi zzfi2;
        ((zzjr)this).zzab();
        zzgl zzgl2 = this;
        zzeo zzeo2 = new zzeo(zzgl2);
        zzeo2.zzm();
        this.zzamt = zzeo2;
        zzgl2 = this;
        zzfb zzfb2 = new zzfb(zzgl2);
        zzfb2.zzm();
        this.zzamu = zzfb2;
        zzgl2 = this;
        zzfc zzfc2 = new zzfc(zzgl2);
        zzfc2.zzm();
        this.zzamr = zzfc2;
        zzgl2 = this;
        zzii zzii2 = new zzii(zzgl2);
        zzii2.zzm();
        this.zzams = zzii2;
        this.zzamm.zzjw();
        this.zzamg.zzjw();
        zzgl2 = this;
        this.zzamv = new zzfx(zzgl2);
        this.zzamu.zzjw();
        ((zzjr)this).zzge().zzir().zzg("App measurement is starting up, version", 12451L);
        ((zzjr)this).zzge().zzir().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string2 = zzfb2.zzah();
        if (((zzjr)this).zzgb().zzcj(string2)) {
            zzfi2 = ((zzjr)this).zzge().zzir();
            string = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
        } else {
            zzfi2 = ((zzjr)this).zzge().zzir();
            String string3 = String.valueOf(string2);
            string = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
        }
        zzfi2.log(string);
        ((zzjr)this).zzge().zzis().log("Debug-level message logging enabled");
        if (this.zzamy != this.zzamz) {
            ((zzjr)this).zzge().zzim().zze("Not all components initialized", this.zzamy, this.zzamz);
        }
        super.zza(zzhj2);
        this.zzvo = true;
    }

    @Override
    @WorkerThread
    protected final void start() {
        ((zzjr)this).zzab();
        if (((zzjr)this).zzgf().zzaju.get() == 0L) {
            ((zzjr)this).zzgf().zzaju.set(((zzjr)this).zzbt().currentTimeMillis());
        }
        if (Long.valueOf(((zzjr)this).zzgf().zzajz.get()) == 0L) {
            ((zzjr)this).zzge().zzit().zzg("Persisting first open", this.zzaem);
            ((zzjr)this).zzgf().zzajz.set(this.zzaem);
        }
        if (!this.zzjv()) {
            if (this.isEnabled()) {
                if (!((zzjr)this).zzgb().zzx("android.permission.INTERNET")) {
                    ((zzjr)this).zzge().zzim().log("App is missing INTERNET permission");
                }
                if (!((zzjr)this).zzgb().zzx("android.permission.ACCESS_NETWORK_STATE")) {
                    ((zzjr)this).zzge().zzim().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!Wrappers.packageManager((Context)((zzjr)this).getContext()).isCallerInstantApp()) {
                    if (!zzgb.zza(((zzjr)this).getContext())) {
                        ((zzjr)this).zzge().zzim().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzjc.zza(((zzjr)this).getContext(), false)) {
                        ((zzjr)this).zzge().zzim().log("AppMeasurementService not registered/enabled");
                    }
                }
                ((zzjr)this).zzge().zzim().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzfv().getGmpAppId())) {
                String string = ((zzjr)this).zzgf().zziz();
                if (string == null) {
                    ((zzjr)this).zzgf().zzbq(this.zzfv().getGmpAppId());
                } else if (!string.equals(this.zzfv().getGmpAppId())) {
                    ((zzjr)this).zzge().zzir().log("Rechecking which service to use due to a GMP App Id change");
                    ((zzjr)this).zzgf().zzjc();
                    this.zzams.disconnect();
                    this.zzams.zzdf();
                    ((zzjr)this).zzgf().zzbq(this.zzfv().getGmpAppId());
                    ((zzjr)this).zzgf().zzajz.set(this.zzaem);
                    ((zzjr)this).zzgf().zzakb.zzbs(null);
                }
            }
            this.zzfu().zzbr(((zzjr)this).zzgf().zzakb.zzjg());
            if (!TextUtils.isEmpty((CharSequence)this.zzfv().getGmpAppId())) {
                boolean bl = this.isEnabled();
                if (!((zzjr)this).zzgf().zzjf() && !((zzjr)this).zzgg().zzhg()) {
                    ((zzjr)this).zzgf().zzh(!bl);
                }
                if (!((zzjr)this).zzgg().zzaz(this.zzfv().zzah()) || bl) {
                    this.zzfu().zzkb();
                }
                this.zzfx().zza(new AtomicReference<String>());
            }
        }
        super.start();
    }

    @Override
    public final zzef zzgg() {
        return this.zzamf;
    }

    @Override
    public final zzfr zzgf() {
        zzgl.zza((zzhg)this.zzamg);
        return this.zzamg;
    }

    @Override
    public final zzfg zzge() {
        zzgl.zza(this.zzamh);
        return this.zzamh;
    }

    public final zzfg zzjo() {
        if (this.zzamh != null && this.zzamh.isInitialized()) {
            return this.zzamh;
        }
        return null;
    }

    @Override
    public final zzgg zzgd() {
        zzgl.zza(this.zzami);
        return this.zzami;
    }

    public final zzjh zzgc() {
        zzgl.zza(this.zzamj);
        return this.zzamj;
    }

    public final zzfx zzjp() {
        return this.zzamv;
    }

    final zzgg zzjq() {
        return this.zzami;
    }

    public final zzhk zzfu() {
        zzgl.zza(this.zzamp);
        return this.zzamp;
    }

    public final AppMeasurement zzjr() {
        return this.zzamk;
    }

    public final FirebaseAnalytics zzjs() {
        return this.zzaml;
    }

    @Override
    public final zzka zzgb() {
        zzgl.zza((zzhg)this.zzamm);
        return this.zzamm;
    }

    @Override
    public final zzfe zzga() {
        zzgl.zza((zzhg)this.zzamn);
        return this.zzamn;
    }

    public final zzfc zzfz() {
        zzgl.zza(this.zzamr);
        return this.zzamr;
    }

    @Override
    public final Context getContext() {
        return this.zzqx;
    }

    @Override
    public final Clock zzbt() {
        return this.zzro;
    }

    public final zzif zzfy() {
        zzgl.zza(this.zzamo);
        return this.zzamo;
    }

    public final zzii zzfx() {
        zzgl.zza(this.zzams);
        return this.zzams;
    }

    @Override
    public final zzeo zzfw() {
        zzgl.zza(this.zzamt);
        return this.zzamt;
    }

    public final zzfb zzfv() {
        zzgl.zza(this.zzamu);
        return this.zzamu;
    }

    public final zzdu zzft() {
        zzgl.zza(this.zzamq);
        return this.zzamq;
    }

    @Override
    @WorkerThread
    public final void zzab() {
        ((zzhg)((zzjr)this).zzgd()).zzab();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzgl zzg(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzame != null) return zzame;
        Class<zzgl> clazz = zzgl.class;
        synchronized (zzgl.class) {
            if (zzame != null) return zzame;
            zzhj zzhj2 = new zzhj(context);
            zzame = new zzgl(zzhj2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzame;
        }
    }

    private final void zzch() {
        if (!this.zzvo) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zza(zzhh zzhh2) {
        if (zzhh2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzhh2.isInitialized()) {
            String string = String.valueOf(zzhh2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzhg zzhg2) {
        if (zzhg2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    public final boolean isEnabled() {
        ((zzjr)this).zzab();
        this.zzch();
        if (((zzjr)this).zzgg().zzhg()) {
            return false;
        }
        Boolean bl = ((zzjr)this).zzgg().zzas("firebase_analytics_collection_enabled");
        boolean bl2 = bl != null ? bl : !GoogleServices.isMeasurementExplicitlyDisabled();
        return ((zzjr)this).zzgf().zzg(bl2);
    }

    final long zzjt() {
        Long l = ((zzjr)this).zzgf().zzajz.get();
        if (l == 0L) {
            return this.zzaem;
        }
        return Math.min(this.zzaem, l);
    }

    static void zzfr() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzb(zzhh zzhh2) {
        ++this.zzamy;
    }

    final void zzju() {
        ++this.zzamz;
    }

    @WorkerThread
    protected final boolean zzjv() {
        this.zzch();
        ((zzjr)this).zzab();
        if (this.zzamw == null || this.zzamx == 0L || this.zzamw != null && !this.zzamw.booleanValue() && Math.abs(((zzjr)this).zzbt().elapsedRealtime() - this.zzamx) > 1000L) {
            this.zzamx = ((zzjr)this).zzbt().elapsedRealtime();
            this.zzamw = ((zzjr)this).zzgb().zzx("android.permission.INTERNET") && ((zzjr)this).zzgb().zzx("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)((zzjr)this).getContext()).isCallerInstantApp() || zzgb.zza(((zzjr)this).getContext()) && zzjc.zza(((zzjr)this).getContext(), false));
            if (this.zzamw.booleanValue()) {
                this.zzamw = ((zzjr)this).zzgb().zzcg(this.zzfv().getGmpAppId());
            }
        }
        return this.zzamw;
    }
}

