/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzhl;
import com.google.android.gms.internal.measurement.zzhm;
import com.google.android.gms.internal.measurement.zzhn;
import com.google.android.gms.internal.measurement.zzho;
import com.google.android.gms.internal.measurement.zzhp;
import com.google.android.gms.internal.measurement.zzhq;
import com.google.android.gms.internal.measurement.zzhr;
import com.google.android.gms.internal.measurement.zzhs;
import com.google.android.gms.internal.measurement.zzht;
import com.google.android.gms.internal.measurement.zzhu;
import com.google.android.gms.internal.measurement.zzhv;
import com.google.android.gms.internal.measurement.zzhw;
import com.google.android.gms.internal.measurement.zzhx;
import com.google.android.gms.internal.measurement.zzhy;
import com.google.android.gms.internal.measurement.zzhz;
import com.google.android.gms.internal.measurement.zzia;
import com.google.android.gms.internal.measurement.zzib;
import com.google.android.gms.internal.measurement.zzic;
import com.google.android.gms.internal.measurement.zzid;
import com.google.android.gms.internal.measurement.zzie;
import com.google.android.gms.internal.measurement.zzif;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzjx;
import com.google.android.gms.internal.measurement.zzka;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class zzhk
extends zzhh {
    @VisibleForTesting
    protected zzid zzanp;
    private AppMeasurement.EventInterceptor zzanq;
    private final Set<AppMeasurement.OnEventListener> zzanr = new CopyOnWriteArraySet<AppMeasurement.OnEventListener>();
    private boolean zzans;
    private final AtomicReference<String> zzant = new AtomicReference();
    @VisibleForTesting
    protected boolean zzanu = true;

    protected zzhk(zzgl zzgl2) {
        super(zzgl2);
    }

    @Override
    protected final boolean zzhf() {
        return false;
    }

    public final Boolean zzjx() {
        AtomicReference atomicReference = new AtomicReference();
        return (Boolean)((zzhg)this).zzgd().zza(atomicReference, 15000L, "boolean test flag value", new zzhl(this, atomicReference));
    }

    public final String zzhm() {
        AtomicReference atomicReference = new AtomicReference();
        return (String)((zzhg)this).zzgd().zza(atomicReference, 15000L, "String test flag value", new zzhv(this, atomicReference));
    }

    public final Long zzjy() {
        AtomicReference atomicReference = new AtomicReference();
        return (Long)((zzhg)this).zzgd().zza(atomicReference, 15000L, "long test flag value", new zzhw(this, atomicReference));
    }

    public final Integer zzjz() {
        AtomicReference atomicReference = new AtomicReference();
        return (Integer)((zzhg)this).zzgd().zza(atomicReference, 15000L, "int test flag value", new zzhx(this, atomicReference));
    }

    public final Double zzka() {
        AtomicReference atomicReference = new AtomicReference();
        return (Double)((zzhg)this).zzgd().zza(atomicReference, 15000L, "double test flag value", new zzhy(this, atomicReference));
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzch();
        ((zzhg)this).zzgd().zzc(new zzhz(this, bl));
    }

    @WorkerThread
    private final void zzi(boolean bl) {
        ((zzhg)this).zzab();
        this.zzch();
        ((zzhg)this).zzge().zzis().zzg("Setting app measurement enabled (FE)", bl);
        ((zzhg)this).zzgf().setMeasurementEnabled(bl);
        if (((zzhg)this).zzgg().zzaz(((zzhg)this).zzfv().zzah())) {
            if (this.zzacw.isEnabled() && this.zzanu) {
                ((zzhg)this).zzge().zzis().log("Recording app launch after enabling measurement for the first time (FE)");
                this.zzkb();
                return;
            }
            ((zzhg)this).zzfx().zzke();
            return;
        }
        ((zzhg)this).zzfx().zzke();
    }

    public final void setMinimumSessionDuration(long l) {
        ((zzhg)this).zzgd().zzc(new zzia(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        ((zzhg)this).zzgd().zzc(new zzib(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        boolean bl2 = this.zzanq == null || zzka.zzci(string2);
        this.zza(string, string2, bundle, true, bl2, true, null);
    }

    public final void logEvent(String string, String string2, Bundle bundle) {
        boolean bl = this.zzanq == null || zzka.zzci(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    @WorkerThread
    final void zza(String string, String string2, Bundle bundle) {
        ((zzhg)this).zzab();
        boolean bl = this.zzanq == null || zzka.zzci(string2);
        this.zzb(string, string2, ((zzhg)this).zzbt().currentTimeMillis(), bundle, true, bl, false, null);
    }

    public final void zza(String string, String string2, Bundle bundle, long l) {
        this.zza(string, string2, l, bundle, false, true, true, null);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zza(string, string2, ((zzhg)this).zzbt().currentTimeMillis(), bundle, true, bl2, bl3, null);
    }

    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Bundle bundle3 = bundle;
        if (bundle3 == null) {
            bundle2 = new Bundle();
        } else {
            Bundle bundle4 = new Bundle(bundle3);
            for (String string4 : bundle4.keySet()) {
                int n;
                Object object;
                Object object2 = bundle4.get(string4);
                if (object2 instanceof Bundle) {
                    bundle4.putBundle(string4, new Bundle((Bundle)object2));
                    continue;
                }
                if (object2 instanceof Parcelable[]) {
                    object = (Parcelable[])object2;
                    for (n = 0; n < ((Parcelable[])object).length; ++n) {
                        if (!(object[n] instanceof Bundle)) continue;
                        object[n] = new Bundle((Bundle)object[n]);
                    }
                    continue;
                }
                if (!(object2 instanceof ArrayList)) continue;
                object = (ArrayList)object2;
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    Object e = ((ArrayList)object).get(n);
                    if (!(e instanceof Bundle)) continue;
                    ((ArrayList)object).set(n, new Bundle((Bundle)e));
                }
            }
            bundle2 = bundle4;
        }
        Bundle bundle5 = bundle2;
        ((zzhg)this).zzgd().zzc(new zzic(this, string, string2, l, bundle5, bl, bl2, bl3, string3));
    }

    @WorkerThread
    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Object object;
        Object object2;
        Object object3;
        zzie zzie2;
        zzie zzie3;
        zzie zzie4;
        Object object4;
        zzhh zzhh2;
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        Preconditions.checkNotNull((Object)bundle);
        ((zzhg)this).zzab();
        this.zzch();
        if (!this.zzacw.isEnabled()) {
            ((zzhg)this).zzge().zzis().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzans) {
            this.zzans = true;
            zzhh2 = this;
            try {
                object4 = Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                Class<?> clazz = object4;
                zzhk zzhk2 = zzhh2;
                try {
                    clazz.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzhg)zzhk2).getContext());
                }
                catch (Exception exception) {
                    ((zzhg)zzhk2).zzge().zzip().zzg("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                zzhh2.zzge().zzir().log("Tag Manager is not found and thus will not be used");
            }
        }
        if (bl3 && !"_iap".equals(string2)) {
            int n;
            object4 = string2;
            zzhh2 = ((zzjr)this.zzacw).zzgb();
            if ((!((zzka)zzhh2).zzq("event", (String)object4) ? 2 : (!((zzka)zzhh2).zza("event", AppMeasurement.Event.zzacx, (String)object4) ? 13 : (n = !((zzka)zzhh2).zza("event", 40, (String)object4) ? 2 : 0))) != 0) {
                ((zzhg)this).zzge().zzio().zzg("Invalid public event name. Event will not be logged (FE)", ((zzhg)this).zzga().zzbj(string2));
                ((zzjr)this.zzacw).zzgb();
                String string4 = zzka.zza(string2, 40, true);
                int n2 = string2 != null ? string2.length() : 0;
                ((zzjr)this.zzacw).zzgb().zza(n, "_ev", string4, n2);
                return;
            }
        }
        if ((zzie4 = ((zzhg)this).zzfy().zzkc()) != null && !bundle.containsKey("_sc")) {
            zzie4.zzaok = true;
        }
        zzie zzie5 = zzie4;
        zzif.zza(zzie5, bundle, bl && bl3);
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzka.zzci(string2);
        if (bl && this.zzanq != null && !bl5 && !bl4) {
            ((zzhg)this).zzge().zzis().zze("Passing event to registered event handler (FE)", ((zzhg)this).zzga().zzbj(string2), ((zzhg)this).zzga().zzb(bundle));
            this.zzanq.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzacw.zzjv()) {
            return;
        }
        int n = ((zzhg)this).zzgb().zzcd(string2);
        if (n != 0) {
            ((zzhg)this).zzge().zzio().zzg("Invalid event name. Event will not be logged (FE)", ((zzhg)this).zzga().zzbj(string2));
            ((zzhg)this).zzgb();
            String string5 = zzka.zza(string2, 40, true);
            int n3 = string2 != null ? string2.length() : 0;
            ((zzjr)this.zzacw).zzgb().zza(string3, n, "_ev", string5, n3);
            return;
        }
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        Bundle bundle3 = ((zzhg)this).zzgb().zza(string2, bundle, list, bl3, true);
        zzhh2 = bundle3;
        if (bundle3 == null || !zzhh2.containsKey("_sc") || !zzhh2.containsKey("_si")) {
            zzie3 = null;
        } else {
            object4 = zzhh2.getString("_sn");
            String string6 = zzhh2.getString("_sc");
            Long l2 = zzhh2.getLong("_si");
            zzie3 = zzie2 = new zzie((String)object4, string6, l2);
        }
        if (zzie3 == null) {
            zzie2 = zzie5;
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l3 = ((zzhg)this).zzgb().zzlc().nextLong();
        int n4 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object[] objectArray2 = objectArray;
        int n5 = objectArray.length;
        for (int i = 0; i < n5; ++i) {
            object3 = objectArray2[i];
            object2 = bundle3.get((String)object3);
            ((zzhg)this).zzgb();
            object = zzka.zze(object2);
            if (object == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])object).length);
            for (int j = 0; j < ((Bundle[])object).length; ++j) {
                Bundle object5 = object[j];
                zzif.zza(zzie2, object5, true);
                bundle2 = ((zzhg)this).zzgb().zza("_ep", object5, list, bl3, false);
                bundle2.putString("_en", string2);
                bundle2.putLong("_eid", l3);
                bundle2.putString("_gn", (String)object3);
                bundle2.putInt("_ll", ((Bundle[])object).length);
                bundle2.putInt("_i", j);
                arrayList.add(bundle2);
            }
            n4 += ((Bundle[])object).length;
        }
        if (n4 != 0) {
            bundle3.putLong("_eid", l3);
            bundle3.putInt("_epc", n4);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle4 = (Bundle)arrayList.get(i);
            object3 = i != 0 ? "_ep" : string2;
            bundle4.putString("_o", string);
            object2 = bl2 ? ((zzhg)this).zzgb().zzd(bundle4) : bundle4;
            ((zzhg)this).zzge().zzis().zze("Logging event (FE)", ((zzhg)this).zzga().zzbj(string2), ((zzhg)this).zzga().zzb((Bundle)object2));
            object = new zzeu((String)object3, new zzer((Bundle)object2), string, l);
            ((zzhg)this).zzfx().zzb((zzeu)((Object)object), string3);
            if (bl4) continue;
            for (AppMeasurement.OnEventListener onEventListener : this.zzanr) {
                bundle2 = new Bundle((Bundle)object2);
                onEventListener.onEvent(string, string2, bundle2, l);
            }
        }
        if (((zzhg)this).zzfy().zzkc() != null && "_ae".equals(string2)) {
            ((zzhg)this).zzgc().zzl(true);
        }
    }

    public final void setUserProperty(String string, String string2, Object object) {
        Preconditions.checkNotEmpty((String)string);
        long l = ((zzhg)this).zzbt().currentTimeMillis();
        int n = ((zzhg)this).zzgb().zzcf(string2);
        if (n != 0) {
            ((zzhg)this).zzgb();
            String string3 = zzka.zza(string2, 24, true);
            int n2 = string2 != null ? string2.length() : 0;
            ((zzjr)this.zzacw).zzgb().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = ((zzhg)this).zzgb().zzi(string2, object);
            if (n != 0) {
                ((zzhg)this).zzgb();
                String string4 = zzka.zza(string2, 24, true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n3 = String.valueOf(object).length();
                }
                ((zzjr)this.zzacw).zzgb().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = ((zzhg)this).zzgb().zzj(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzhg)this).zzgd().zzc(new zzhm(this, string, string2, object, l));
    }

    @WorkerThread
    private final void zza(String string, String string2, Object object, long l) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ((zzhg)this).zzab();
        this.zzch();
        if (!this.zzacw.isEnabled()) {
            ((zzhg)this).zzge().zzis().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzacw.zzjv()) {
            return;
        }
        ((zzhg)this).zzge().zzis().zze("Setting user property (FE)", ((zzhg)this).zzga().zzbj(string2), object);
        zzjx zzjx2 = new zzjx(string2, l, object, string);
        ((zzhg)this).zzfx().zzb(zzjx2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzjx> zzj(boolean bl) {
        this.zzch();
        ((zzhg)this).zzge().zzis().log("Fetching user attributes (FE)");
        if (((zzhg)this).zzgd().zzjk()) {
            ((zzhg)this).zzge().zzim().log("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzhg)this).zzgd();
        if (zzgg.isMainThread()) {
            ((zzhg)this).zzge().zzim().log("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            ((zzjr)this.zzacw).zzgd().zzc(new zzhn(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhg)this).zzge().zzip().zzg("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzhg)this).zzge().zzip().log("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    public final Task<String> getAppInstanceId() {
        try {
            String string = ((zzhg)this).zzgf().zzja();
            if (string != null) {
                return Tasks.forResult((Object)string);
            }
            return Tasks.call((Executor)((zzhg)this).zzgd().zzjl(), (Callable)new zzho(this));
        }
        catch (Exception exception) {
            ((zzhg)this).zzge().zzip().log("Failed to schedule task for getAppInstanceId");
            return Tasks.forException((Exception)exception);
        }
    }

    @Nullable
    public final String zzja() {
        return this.zzant.get();
    }

    final void zzbr(@Nullable String string) {
        this.zzant.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final String zzae(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzhg)this).zzgd().zzc(new zzhp(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                ((zzhg)this).zzge().zzip().log("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    public final void resetAnalyticsData() {
        long l = ((zzhg)this).zzbt().currentTimeMillis();
        ((zzhg)this).zzgd().zzc(new zzhq(this, l));
    }

    @WorkerThread
    public final void zzkb() {
        ((zzhg)this).zzab();
        this.zzch();
        if (!this.zzacw.zzjv()) {
            return;
        }
        ((zzhg)this).zzfx().zzkb();
        this.zzanu = false;
        String string = ((zzhg)this).zzgf().zzjd();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            ((zzhg)this).zzfw().zzch();
            if (!string.equals(Build.VERSION.RELEASE)) {
                Bundle bundle = new Bundle();
                bundle.putString("_po", string);
                this.logEvent("auto", "_ou", bundle);
            }
        }
    }

    @WorkerThread
    public final void setEventInterceptor(AppMeasurement.EventInterceptor eventInterceptor) {
        ((zzhg)this).zzab();
        this.zzch();
        if (eventInterceptor != null && eventInterceptor != this.zzanq) {
            Preconditions.checkState((this.zzanq == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzanq = eventInterceptor;
    }

    public final void registerOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        this.zzch();
        Preconditions.checkNotNull((Object)onEventListener);
        if (!this.zzanr.add(onEventListener)) {
            ((zzhg)this).zzge().zzip().log("OnEventListener already registered");
        }
    }

    public final void unregisterOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        this.zzch();
        Preconditions.checkNotNull((Object)onEventListener);
        if (!this.zzanr.remove(onEventListener)) {
            ((zzhg)this).zzge().zzip().log("OnEventListener had not been registered");
        }
    }

    public final void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            ((zzhg)this).zzge().zzip().log("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public final void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mAppId);
        ((zzhg)this).zzfr();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private final void zza(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = ((zzhg)this).zzbt().currentTimeMillis();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mOrigin);
        Preconditions.checkNotNull((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        if (((zzhg)this).zzgb().zzcf(string) != 0) {
            ((zzhg)this).zzge().zzim().zzg("Invalid conditional user property name", ((zzhg)this).zzga().zzbl(string));
            return;
        }
        if (((zzhg)this).zzgb().zzi(string, object) != 0) {
            ((zzhg)this).zzge().zzim().zze("Invalid conditional user property value", ((zzhg)this).zzga().zzbl(string), object);
            return;
        }
        Object object2 = ((zzhg)this).zzgb().zzj(string, object);
        if (object2 == null) {
            ((zzhg)this).zzge().zzim().zze("Unable to normalize conditional user property value", ((zzhg)this).zzga().zzbl(string), object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (!(TextUtils.isEmpty((CharSequence)conditionalUserProperty.mTriggerEventName) || l2 <= 15552000000L && l2 >= 1L)) {
            ((zzhg)this).zzge().zzim().zze("Invalid conditional user property timeout", ((zzhg)this).zzga().zzbl(string), l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > 15552000000L || l3 < 1L) {
            ((zzhg)this).zzge().zzim().zze("Invalid conditional user property time to live", ((zzhg)this).zzga().zzbl(string), l3);
            return;
        }
        ((zzhg)this).zzgd().zzc(new zzhr(this, conditionalUserProperty));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotEmpty((String)string);
        ((zzhg)this).zzfr();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzhg)this).zzbt().currentTimeMillis();
        Preconditions.checkNotEmpty((String)string2);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        ((zzhg)this).zzgd().zzc(new zzhs(this, conditionalUserProperty));
    }

    @WorkerThread
    private final void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzeu zzeu2;
        zzeu zzeu3;
        zzeu zzeu4;
        ((zzhg)this).zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mOrigin);
        Preconditions.checkNotNull((Object)conditionalUserProperty.mValue);
        if (!this.zzacw.isEnabled()) {
            ((zzhg)this).zzge().zzis().log("Conditional property not sent since Firebase Analytics is disabled");
            return;
        }
        zzjx zzjx2 = new zzjx(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzeu4 = ((zzhg)this).zzgb().zza(conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzeu3 = ((zzhg)this).zzgb().zza(conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzeu2 = ((zzhg)this).zzgb().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzed zzed2 = new zzed(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzjx2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzeu3, conditionalUserProperty.mTriggerTimeout, zzeu4, conditionalUserProperty.mTimeToLive, zzeu2);
        ((zzhg)this).zzfx().zzd(zzed2);
    }

    @WorkerThread
    private final void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzeu zzeu2;
        ((zzhg)this).zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        if (!this.zzacw.isEnabled()) {
            ((zzhg)this).zzge().zzis().log("Conditional property not cleared since Firebase Analytics is disabled");
            return;
        }
        zzjx zzjx2 = new zzjx(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzeu2 = ((zzhg)this).zzgb().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzed zzed2 = new zzed(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzjx2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzeu2);
        ((zzhg)this).zzfx().zzd(zzed2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        return this.zzf(null, string, string2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        ((zzhg)this).zzfr();
        return this.zzf(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final List<AppMeasurement.ConditionalUserProperty> zzf(String string, String string2, String string3) {
        if (((zzhg)this).zzgd().zzjk()) {
            ((zzhg)this).zzge().zzim().log("Cannot get conditional user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzhg)this).zzgd();
        if (zzgg.isMainThread()) {
            ((zzhg)this).zzge().zzim().log("Cannot get conditional user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            ((zzjr)this.zzacw).zzgd().zzc(new zzht(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhg)this).zzge().zzip().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzhg)this).zzge().zzip().zzg("Timed out waiting for get conditional user properties", string);
                return Collections.emptyList();
            }
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzed zzed2 = (zzed)((Object)iterator.next());
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
                new AppMeasurement.ConditionalUserProperty().mAppId = string;
                conditionalUserProperty.mOrigin = string2;
                conditionalUserProperty.mCreationTimestamp = zzed2.creationTimestamp;
                conditionalUserProperty.mName = zzed2.zzaep.name;
                conditionalUserProperty.mValue = zzed2.zzaep.getValue();
                conditionalUserProperty.mActive = zzed2.active;
                conditionalUserProperty.mTriggerEventName = zzed2.triggerEventName;
                if (zzed2.zzaeq != null) {
                    conditionalUserProperty.mTimedOutEventName = zzed2.zzaeq.name;
                    if (zzed2.zzaeq.zzafq != null) {
                        conditionalUserProperty.mTimedOutEventParams = zzed2.zzaeq.zzafq.zzif();
                    }
                }
                conditionalUserProperty.mTriggerTimeout = zzed2.triggerTimeout;
                if (zzed2.zzaer != null) {
                    conditionalUserProperty.mTriggeredEventName = zzed2.zzaer.name;
                    if (zzed2.zzaer.zzafq != null) {
                        conditionalUserProperty.mTriggeredEventParams = zzed2.zzaer.zzafq.zzif();
                    }
                }
                conditionalUserProperty.mTriggeredTimestamp = zzed2.zzaep.zzaqz;
                conditionalUserProperty.mTimeToLive = zzed2.timeToLive;
                if (zzed2.zzaes != null) {
                    conditionalUserProperty.mExpiredEventName = zzed2.zzaes.name;
                    if (zzed2.zzaes.zzafq != null) {
                        conditionalUserProperty.mExpiredEventParams = zzed2.zzaes.zzafq.zzif();
                    }
                }
                arrayList.add(conditionalUserProperty);
            }
            return arrayList;
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        Preconditions.checkNotEmpty((String)string);
        ((zzhg)this).zzfr();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzhg)this).zzgd().zzjk()) {
            ((zzhg)this).zzge().zzim().log("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzhg)this).zzgd();
        if (zzgg.isMainThread()) {
            ((zzhg)this).zzge().zzim().log("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            ((zzjr)this.zzacw).zzgd().zzc(new zzhu(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhg)this).zzge().zzip().zzg("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzhg)this).zzge().zzip().log("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzjx zzjx2 = (zzjx)((Object)iterator.next());
                arrayMap.put(zzjx2.name, zzjx2.getValue());
            }
            return arrayMap;
        }
    }

    static /* synthetic */ void zza(zzhk zzhk2, boolean bl) {
        zzhk2.zzi(bl);
    }

    static /* synthetic */ void zza(zzhk zzhk2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzhk2.zzb(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzhk zzhk2, String string, String string2, Object object, long l) {
        zzhk2.zza(string, string2, object, l);
    }

    static /* synthetic */ void zza(zzhk zzhk2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzhk2.zzb(conditionalUserProperty);
    }

    static /* synthetic */ void zzb(zzhk zzhk2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzhk2.zzc(conditionalUserProperty);
    }
}

