/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzie;
import com.google.android.gms.internal.measurement.zzij;
import com.google.android.gms.internal.measurement.zzik;
import com.google.android.gms.internal.measurement.zzil;
import com.google.android.gms.internal.measurement.zzim;
import com.google.android.gms.internal.measurement.zzin;
import com.google.android.gms.internal.measurement.zzio;
import com.google.android.gms.internal.measurement.zzip;
import com.google.android.gms.internal.measurement.zziq;
import com.google.android.gms.internal.measurement.zzir;
import com.google.android.gms.internal.measurement.zzis;
import com.google.android.gms.internal.measurement.zzit;
import com.google.android.gms.internal.measurement.zziu;
import com.google.android.gms.internal.measurement.zziv;
import com.google.android.gms.internal.measurement.zziw;
import com.google.android.gms.internal.measurement.zzjm;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzjx;
import com.google.android.gms.internal.measurement.zzka;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzii
extends zzhh {
    private final zziw zzaox;
    private zzey zzaoy;
    private volatile Boolean zzaoz;
    private final zzem zzapa;
    private final zzjm zzapb;
    private final List<Runnable> zzapc = new ArrayList<Runnable>();
    private final zzem zzapd;

    protected zzii(zzgl zzgl2) {
        super(zzgl2);
        this.zzapb = new zzjm(((zzjr)zzgl2).zzbt());
        this.zzaox = new zziw(this);
        this.zzapa = new zzij(this, zzgl2);
        this.zzapd = new zzio(this, zzgl2);
    }

    @Override
    protected final boolean zzhf() {
        return false;
    }

    @WorkerThread
    public final boolean isConnected() {
        ((zzhg)this).zzab();
        this.zzch();
        return this.zzaoy != null;
    }

    @WorkerThread
    protected final void zzke() {
        ((zzhg)this).zzab();
        this.zzch();
        zzdz zzdz2 = this.zzk(true);
        this.zzf(new zzip(this, zzdz2));
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzey zzey2, AbstractSafeParcelable abstractSafeParcelable, zzdz zzdz2) {
        ((zzhg)this).zzab();
        this.zzch();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            List<AbstractSafeParcelable> list = ((zzhg)this).zzfz().zzp(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzeu) {
                    try {
                        zzey2.zza((zzeu)abstractSafeParcelable2, zzdz2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhg)this).zzge().zzim().zzg("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzjx) {
                    try {
                        zzey2.zza((zzjx)abstractSafeParcelable2, zzdz2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhg)this).zzge().zzim().zzg("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzed) {
                    try {
                        zzey2.zza((zzed)abstractSafeParcelable2, zzdz2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhg)this).zzge().zzim().zzg("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzhg)this).zzge().zzim().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzb(zzeu zzeu2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzeu2));
        ((zzhg)this).zzab();
        this.zzch();
        boolean bl = ((zzhg)this).zzfz().zza(zzeu2);
        zzdz zzdz2 = this.zzk(true);
        this.zzf(new zziq(this, true, bl, zzeu2, zzdz2, string));
    }

    @WorkerThread
    protected final void zzd(zzed zzed2) {
        Preconditions.checkNotNull((Object)((Object)zzed2));
        ((zzhg)this).zzab();
        this.zzch();
        boolean bl = ((zzhg)this).zzfz().zzc(zzed2);
        zzed zzed3 = new zzed(zzed2);
        zzdz zzdz2 = this.zzk(true);
        this.zzf(new zzir(this, true, bl, zzed3, zzdz2, zzed2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzed>> atomicReference, String string, String string2, String string3) {
        ((zzhg)this).zzab();
        this.zzch();
        zzdz zzdz2 = this.zzk(false);
        this.zzf(new zzis(this, atomicReference, string, string2, string3, zzdz2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzjx>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzhg)this).zzab();
        this.zzch();
        zzdz zzdz2 = this.zzk(false);
        this.zzf(new zzit(this, atomicReference, string, string2, string3, bl, zzdz2));
    }

    @WorkerThread
    protected final void zzb(zzjx zzjx2) {
        ((zzhg)this).zzab();
        this.zzch();
        boolean bl = ((zzhg)this).zzfz().zza(zzjx2);
        zzdz zzdz2 = this.zzk(true);
        this.zzf(new zziu(this, bl, zzjx2, zzdz2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzjx>> atomicReference, boolean bl) {
        ((zzhg)this).zzab();
        this.zzch();
        zzdz zzdz2 = this.zzk(false);
        this.zzf(new zziv(this, atomicReference, zzdz2, bl));
    }

    @WorkerThread
    protected final void resetAnalyticsData() {
        ((zzhg)this).zzab();
        this.zzch();
        zzdz zzdz2 = this.zzk(false);
        ((zzhg)this).zzfz().resetAnalyticsData();
        this.zzf(new zzik(this, zzdz2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzhg)this).zzab();
        this.zzch();
        zzdz zzdz2 = this.zzk(false);
        this.zzf(new zzil(this, atomicReference, zzdz2));
    }

    @WorkerThread
    protected final void zzkb() {
        ((zzhg)this).zzab();
        this.zzch();
        zzdz zzdz2 = this.zzk(true);
        this.zzf(new zzim(this, zzdz2));
    }

    @WorkerThread
    protected final void zzb(zzie zzie2) {
        ((zzhg)this).zzab();
        this.zzch();
        this.zzf(new zzin(this, zzie2));
    }

    @WorkerThread
    private final void zzcu() {
        ((zzhg)this).zzab();
        this.zzapb.start();
        this.zzapa.zzh(zzew.zzaho.get());
    }

    @WorkerThread
    final void zzdf() {
        Intent intent;
        Object object;
        zzii zzii2;
        ((zzhg)this).zzab();
        this.zzch();
        if (this.isConnected()) {
            return;
        }
        if (this.zzaoz == null) {
            boolean bl;
            zzii2 = this;
            ((zzhg)zzii2).zzab();
            zzii2.zzch();
            object = ((zzhg)zzii2).zzgf().zzjb();
            if (object != null && ((Boolean)object).booleanValue()) {
                bl = true;
            } else {
                boolean bl2;
                boolean bl3;
                if (((zzhg)zzii2).zzfv().zzik() == 1) {
                    bl3 = true;
                    bl2 = true;
                } else {
                    ((zzhg)zzii2).zzge().zzit().log("Checking service availability");
                    zzka zzka2 = ((zzhg)zzii2).zzgb();
                    int n = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(((zzhg)zzka2).getContext(), 12451);
                    switch (n) {
                        case 0: {
                            ((zzhg)zzii2).zzge().zzit().log("Service available");
                            bl3 = true;
                            bl2 = true;
                            break;
                        }
                        case 1: {
                            ((zzhg)zzii2).zzge().zzit().log("Service missing");
                            bl3 = false;
                            bl2 = true;
                            break;
                        }
                        case 18: {
                            ((zzhg)zzii2).zzge().zzip().log("Service updating");
                            bl3 = true;
                            bl2 = true;
                            break;
                        }
                        case 2: {
                            ((zzhg)zzii2).zzge().zzis().log("Service container out of date");
                            if (((zzhg)zzii2).zzgb().zzld() < 12600) {
                                bl3 = false;
                                bl2 = true;
                                break;
                            }
                            Boolean bl4 = ((zzhg)zzii2).zzgf().zzjb();
                            bl3 = bl4 == null || bl4 != false;
                            bl2 = false;
                            break;
                        }
                        case 3: {
                            ((zzhg)zzii2).zzge().zzip().log("Service disabled");
                            bl3 = false;
                            bl2 = false;
                            break;
                        }
                        case 9: {
                            ((zzhg)zzii2).zzge().zzip().log("Service invalid");
                            bl3 = false;
                            bl2 = false;
                            break;
                        }
                        default: {
                            ((zzhg)zzii2).zzge().zzip().zzg("Unexpected service status", n);
                            bl3 = false;
                            bl2 = false;
                        }
                    }
                }
                if (bl2) {
                    ((zzhg)zzii2).zzgf().zzf(bl3);
                }
                bl = bl3;
            }
            this.zzaoz = bl;
        }
        if (this.zzaoz.booleanValue()) {
            this.zzaox.zzkh();
            return;
        }
        zzii2 = this;
        object = ((zzhg)zzii2).getContext().getPackageManager();
        List list = object.queryIntentServices(intent = new Intent().setClassName(((zzhg)zzii2).getContext(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
        if (list != null && list.size() > 0) {
            Intent intent2 = new Intent("com.google.android.gms.measurement.START");
            intent2.setComponent(new ComponentName(((zzhg)this).getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
            this.zzaox.zzc(intent2);
            return;
        }
        ((zzhg)this).zzge().zzim().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
    }

    final Boolean zzkf() {
        return this.zzaoz;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzey zzey2) {
        ((zzhg)this).zzab();
        Preconditions.checkNotNull((Object)zzey2);
        this.zzaoy = zzey2;
        this.zzcu();
        this.zzkg();
    }

    @WorkerThread
    public final void disconnect() {
        ((zzhg)this).zzab();
        this.zzch();
        try {
            ConnectionTracker.getInstance().unbindService(((zzhg)this).getContext(), (ServiceConnection)this.zzaox);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzaoy = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        ((zzhg)this).zzab();
        if (this.zzaoy != null) {
            this.zzaoy = null;
            ((zzhg)this).zzge().zzit().zzg("Disconnected from device MeasurementService", componentName);
            zzii zzii2 = this;
            ((zzhg)zzii2).zzab();
            zzii2.zzdf();
        }
    }

    @WorkerThread
    private final void zzcv() {
        ((zzhg)this).zzab();
        if (!this.isConnected()) {
            return;
        }
        ((zzhg)this).zzge().zzit().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzf(Runnable runnable) throws IllegalStateException {
        ((zzhg)this).zzab();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zzapc.size() >= 1000L) {
            ((zzhg)this).zzge().zzim().log("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzapc.add(runnable);
        this.zzapd.zzh(60000L);
        this.zzdf();
    }

    @WorkerThread
    private final void zzkg() {
        ((zzhg)this).zzab();
        ((zzhg)this).zzge().zzit().zzg("Processing queued up service tasks", this.zzapc.size());
        for (Runnable runnable : this.zzapc) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzhg)this).zzge().zzim().zzg("Task exception while flushing queue", exception);
            }
        }
        this.zzapc.clear();
        this.zzapd.cancel();
    }

    @WorkerThread
    @Nullable
    private final zzdz zzk(boolean bl) {
        return ((zzhg)this).zzfv().zzbi(bl ? ((zzhg)this).zzge().zziv() : null);
    }

    static /* synthetic */ zziw zza(zzii zzii2) {
        return zzii2.zzaox;
    }

    static /* synthetic */ void zza(zzii zzii2, ComponentName componentName) {
        zzii2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzey zza(zzii zzii2, zzey zzey2) {
        zzii2.zzaoy = null;
        return null;
    }

    static /* synthetic */ void zzb(zzii zzii2) {
        zzii2.zzkg();
    }

    static /* synthetic */ void zzc(zzii zzii2) {
        zzii2.zzcv();
    }

    static /* synthetic */ zzey zzd(zzii zzii2) {
        return zzii2.zzaoy;
    }

    static /* synthetic */ void zze(zzii zzii2) {
        zzii2.zzcu();
    }
}

