/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzjd;
import com.google.android.gms.internal.measurement.zzje;
import com.google.android.gms.internal.measurement.zzjf;
import com.google.android.gms.internal.measurement.zzjg;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzka;

public final class zzjc<T extends Context> {
    private final T zzabm;

    public zzjc(T t) {
        Preconditions.checkNotNull(t);
        this.zzabm = t;
    }

    public static boolean zza(Context context, boolean bl) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzka.zzc(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzka.zzc(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    @MainThread
    public final void onCreate() {
        ((zzjr)zzgl.zzg(this.zzabm)).zzge().zzit().log("Local AppMeasurementService is starting up");
    }

    @MainThread
    public final void onDestroy() {
        ((zzjr)zzgl.zzg(this.zzabm)).zzge().zzit().log("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public final int onStartCommand(Intent intent, int n, int n2) {
        zzfg zzfg2 = ((zzjr)zzgl.zzg(this.zzabm)).zzge();
        if (intent == null) {
            zzfg2.zzip().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzfg2.zzit().zze("Local AppMeasurementService called. startId, action", n2, string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zzb(new zzjd(this, n2, zzfg2, intent));
        }
        return 2;
    }

    private final void zzb(Runnable runnable) {
        zzgl zzgl2 = zzgl.zzg(this.zzabm);
        ((zzjr)zzgl2).zzgd().zzc(new zzjf(this, zzgl2, runnable));
    }

    @MainThread
    public final IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzge().zzim().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzgn(zzgl.zzg(this.zzabm));
        }
        this.zzge().zzip().zzg("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public final boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzge().zzim().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzge().zzit().zzg("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzfg zzfg2 = ((zzjr)zzgl.zzg(this.zzabm)).zzge();
        String string = jobParameters.getExtras().getString("action");
        zzfg2.zzit().zzg("Local AppMeasurementJobService called. action", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zzb(new zzje(this, zzfg2, jobParameters));
        }
        return true;
    }

    @MainThread
    public final void onRebind(Intent intent) {
        if (intent == null) {
            this.zzge().zzim().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzge().zzit().zzg("onRebind called. action", string);
    }

    private final zzfg zzge() {
        return ((zzjr)zzgl.zzg(this.zzabm)).zzge();
    }

    final /* synthetic */ void zza(zzfg zzfg2, JobParameters jobParameters) {
        zzfg2.zzit().log("AppMeasurementJobService processed last upload request.");
        ((zzjg)this.zzabm).zza(jobParameters, false);
    }

    final /* synthetic */ void zza(int n, zzfg zzfg2, Intent intent) {
        if (((zzjg)this.zzabm).callServiceStopSelfResult(n)) {
            zzfg2.zzit().zzg("Local AppMeasurementService processed last upload request. StartId", n);
            this.zzge().zzit().log("Completed wakeful intent.");
            ((zzjg)this.zzabm).zzb(intent);
        }
    }
}

