/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzabw;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzkn;
import com.google.android.gms.internal.measurement.zzko;
import com.google.android.gms.internal.measurement.zzkp;
import com.google.android.gms.internal.measurement.zzks;
import com.google.android.gms.measurement.AppMeasurement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.security.auth.x500.X500Principal;

public final class zzka
extends zzhh {
    private static final String[] zzard = new String[]{"firebase_", "google_", "ga_"};
    private SecureRandom zzare;
    private final AtomicLong zzarf = new AtomicLong(0L);
    private int zzarg;
    private Integer zzarh = null;

    zzka(zzgl zzgl2) {
        super(zzgl2);
    }

    @Override
    protected final boolean zzhf() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void zzih() {
        ((zzhg)this).zzab();
        SecureRandom secureRandom = new SecureRandom();
        long l = secureRandom.nextLong();
        if (l == 0L && (l = secureRandom.nextLong()) == 0L) {
            ((zzhg)this).zzge().zzip().log("Utils falling back to Random for random id");
        }
        this.zzarf.set(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long zzlb() {
        if (this.zzarf.get() == 0L) {
            AtomicLong atomicLong = this.zzarf;
            synchronized (atomicLong) {
                return new Random(System.nanoTime() ^ ((zzhg)this).zzbt().currentTimeMillis()).nextLong() + (long)(++this.zzarg);
            }
        }
        AtomicLong atomicLong = this.zzarf;
        synchronized (atomicLong) {
            this.zzarf.compareAndSet(-1L, 1L);
            return this.zzarf.getAndIncrement();
        }
    }

    @WorkerThread
    final SecureRandom zzlc() {
        ((zzhg)this).zzab();
        if (this.zzare == null) {
            this.zzare = new SecureRandom();
        }
        return this.zzare;
    }

    static boolean zzcc(String string) {
        Preconditions.checkNotEmpty((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    public final Bundle zza(@NonNull Uri uri) {
        if (uri == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            if (uri.isHierarchical()) {
                string = uri.getQueryParameter("utm_campaign");
                string2 = uri.getQueryParameter("utm_source");
                string3 = uri.getQueryParameter("utm_medium");
                string4 = uri.getQueryParameter("gclid");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ((zzhg)this).zzge().zzip().zzg("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
            return null;
        }
        if (!(TextUtils.isEmpty(string) && TextUtils.isEmpty(string2) && TextUtils.isEmpty(string3) && TextUtils.isEmpty(string4))) {
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                bundle.putString("campaign", string);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                bundle.putString("source", string2);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                bundle.putString("medium", string3);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                bundle.putString("gclid", string4);
            }
            if (!TextUtils.isEmpty((CharSequence)(string9 = uri.getQueryParameter("utm_term")))) {
                bundle.putString("term", string9);
            }
            if (!TextUtils.isEmpty((CharSequence)(string8 = uri.getQueryParameter("utm_content")))) {
                bundle.putString("content", string8);
            }
            if (!TextUtils.isEmpty((CharSequence)(string7 = uri.getQueryParameter("aclid")))) {
                bundle.putString("aclid", string7);
            }
            if (!TextUtils.isEmpty((CharSequence)(string6 = uri.getQueryParameter("cp1")))) {
                bundle.putString("cp1", string6);
            }
            if (!TextUtils.isEmpty((CharSequence)(string5 = uri.getQueryParameter("anid")))) {
                bundle.putString("anid", string5);
            }
            return bundle;
        }
        return null;
    }

    public static boolean zzd(Intent intent) {
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        return "android-app://com.google.android.googlequicksearchbox/https/www.google.com".equals(string) || "https://www.google.com".equals(string) || "android-app://com.google.appcrawler".equals(string);
    }

    final boolean zzq(String string, String string2) {
        int n;
        if (string2 == null) {
            ((zzhg)this).zzge().zzim().zzg("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            ((zzhg)this).zzge().zzim().zzg("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            ((zzhg)this).zzge().zzim().zze("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            ((zzhg)this).zzge().zzim().zze("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    private final boolean zzr(String string, String string2) {
        int n;
        if (string2 == null) {
            ((zzhg)this).zzge().zzim().zzg("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            ((zzhg)this).zzge().zzim().zzg("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2) && n2 != 95) {
            ((zzhg)this).zzge().zzim().zze("Name must start with a letter or _ (underscore). Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            ((zzhg)this).zzge().zzim().zze("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zza(String string, String[] stringArray, String string2) {
        boolean bl;
        String string3;
        block6: {
            if (string2 == null) {
                ((zzhg)this).zzge().zzim().zzg("Name is required and can't be null. Type", string);
                return false;
            }
            string3 = string2;
            Preconditions.checkNotNull((Object)string3);
            for (int i = 0; i < zzard.length; ++i) {
                if (!string3.startsWith(zzard[i])) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            ((zzhg)this).zzge().zzim().zze("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null) {
            boolean bl2;
            block7: {
                String[] stringArray2 = stringArray;
                string3 = string2;
                Preconditions.checkNotNull((Object)stringArray2);
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!zzka.zzs(string3, stringArray2[i])) continue;
                    bl2 = true;
                    break block7;
                }
                bl2 = false;
            }
            if (bl2) {
                ((zzhg)this).zzge().zzim().zze("Name is reserved. Type, name", string, string2);
                return false;
            }
        }
        return true;
    }

    final boolean zza(String string, int n, String string2) {
        if (string2 == null) {
            ((zzhg)this).zzge().zzim().zzg("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.codePointCount(0, string2.length()) > n) {
            ((zzhg)this).zzge().zzim().zzd("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    public final int zzcd(String string) {
        if (!this.zzr("event", string)) {
            return 2;
        }
        if (!this.zza("event", AppMeasurement.Event.zzacx, string)) {
            return 13;
        }
        if (!this.zza("event", 40, string)) {
            return 2;
        }
        return 0;
    }

    public final int zzce(String string) {
        if (!this.zzq("user property", string)) {
            return 6;
        }
        if (!this.zza("user property", AppMeasurement.UserProperty.zzadb, string)) {
            return 15;
        }
        if (!this.zza("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    public final int zzcf(String string) {
        if (!this.zzr("user property", string)) {
            return 6;
        }
        if (!this.zza("user property", AppMeasurement.UserProperty.zzadb, string)) {
            return 15;
        }
        if (!this.zza("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    private final boolean zza(String string, String string2, int n, Object object, boolean bl) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string3 = String.valueOf(object);
            if (string3.codePointCount(0, string3.length()) > n) {
                ((zzhg)this).zzge().zzip().zzd("Value is too long; discarded. Value kind, name, value length", string, string2, string3.length());
                return false;
            }
            return true;
        }
        if (object instanceof Bundle && bl) {
            return true;
        }
        if (object instanceof Parcelable[] && bl) {
            for (Parcelable parcelable : (Parcelable[])object) {
                if (parcelable instanceof Bundle) continue;
                ((zzhg)this).zzge().zzip().zze("All Parcelable[] elements must be of type Bundle. Value type, name", parcelable.getClass(), string2);
                return false;
            }
            return true;
        }
        if (object instanceof ArrayList && bl) {
            ArrayList arrayList = (ArrayList)object;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList.get(i);
                Object e2 = e;
                if (e instanceof Bundle) continue;
                ((zzhg)this).zzge().zzip().zze("All ArrayList elements must be of type Bundle. Value type, name", e2.getClass(), string2);
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean zzcg(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            ((zzhg)this).zzge().zzim().log("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
            return false;
        }
        String string2 = string;
        Preconditions.checkNotNull((Object)string2);
        String string3 = "^1:\\d+:android:[a-f0-9]+$";
        if (!string2.matches(string3)) {
            ((zzhg)this).zzge().zzim().zzg("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", string);
            return false;
        }
        return true;
    }

    private static Object zza(int n, Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long || object instanceof Double) {
            return object;
        }
        if (object instanceof Integer) {
            return (long)((Integer)object).intValue();
        }
        if (object instanceof Byte) {
            return (long)((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return (long)((Short)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            return zzka.zza(String.valueOf(object), n, bl);
        }
        return null;
    }

    public static String zza(String string, int n, boolean bl) {
        if (string.codePointCount(0, string.length()) > n) {
            if (bl) {
                return String.valueOf(string.substring(0, string.offsetByCodePoints(0, n))).concat("...");
            }
            return null;
        }
        return string;
    }

    public final Object zzh(String string, Object object) {
        if ("_ev".equals(string)) {
            return zzka.zza(256, object, true);
        }
        return zzka.zza(zzka.zzci(string) ? 256 : 100, object, false);
    }

    public static Bundle[] zze(Object object) {
        if (object instanceof Bundle) {
            return new Bundle[]{(Bundle)object};
        }
        if (object instanceof Parcelable[]) {
            return (Bundle[])Arrays.copyOf((Parcelable[])object, ((Parcelable[])object).length, Bundle[].class);
        }
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            return arrayList.toArray(new Bundle[arrayList.size()]);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public final Bundle zza(String var1_1, Bundle var2_2, @Nullable List<String> var3_3, boolean var4_4, boolean var5_5) {
        block15: {
            var6_6 = null;
            if (var2_2 == null) break block15;
            var6_6 = new Bundle(var2_2);
            var7_7 = 0;
            for (String var9_9 : var2_2.keySet()) {
                block16: {
                    var10_10 = 0;
                    if (var3_3 == null || !var3_3.contains(var9_9)) {
                        if (var4_4) {
                            var12_12 = this;
                            var13_13 = var9_9;
                            v0 = var12_12.zzq("event param", var13_13) == false ? 3 : (var12_12.zza("event param", null, var13_13) == false ? 14 : (var10_10 = var12_12.zza("event param", 40, var13_13) == false ? 3 : 0));
                        }
                        if (var10_10 == 0) {
                            var12_12 = this;
                            var13_13 = var9_9;
                            v1 = var12_12.zzr("event param", var13_13) == false ? 3 : (var12_12.zza("event param", null, var13_13) == false ? 14 : (var10_10 = var12_12.zza("event param", 40, var13_13) == false ? 3 : 0));
                        }
                    }
                    if (var10_10 != 0) {
                        if (zzka.zza(var6_6, var10_10)) {
                            var11_11 = zzka.zza(var9_9, 40, true);
                            var6_6.putString("_ev", var11_11);
                            if (var10_10 == 3) {
                                zzka.zza(var6_6, (Object)var9_9);
                            }
                        }
                        var6_6.remove(var9_9);
                        continue;
                    }
                    var16_16 = var5_5;
                    var15_15 = var2_2.get(var9_9);
                    var14_14 = var9_9;
                    var13_13 = var1_1;
                    var12_12 = this;
                    var12_12.zzab();
                    if (!var16_16) ** GOTO lbl-1000
                    var21_21 = var15_15;
                    var20_20 = var14_14;
                    var19_19 = "param";
                    var18_18 = var12_12;
                    if (!(var21_21 instanceof Parcelable[])) break block16;
                    var22_22 = ((Parcelable[])var21_21).length;
                    ** GOTO lbl43
                }
                if (!(var21_21 instanceof ArrayList)) {
                    v2 = true;
                } else {
                    var22_22 = ((ArrayList)var21_21).size();
lbl43:
                    // 2 sources

                    if (var22_22 > 1000) {
                        var18_18.zzge().zzip().zzd("Parameter array is too long; discarded. Value kind, name, array length", var19_19, var20_20, var22_22);
                        v2 = false;
                    } else {
                        v2 = true;
                    }
                }
                if (!v2) {
                    v3 = 17;
                } else lbl-1000:
                // 2 sources

                {
                    var17_17 = var12_12.zzgg().zzaw(var12_12.zzfv().zzah()) != false && zzka.zzci(var13_13) != false || zzka.zzci(var14_14) != false ? var12_12.zza("param", var14_14, 256, var15_15, var16_16) : var12_12.zza("param", var14_14, 100, var15_15, var16_16);
                    v3 = var10_10 = var17_17 != false ? 0 : 4;
                }
                if (v3 != 0 && !"_ev".equals(var9_9)) {
                    if (zzka.zza(var6_6, var10_10)) {
                        var11_11 = zzka.zza(var9_9, 40, true);
                        var6_6.putString("_ev", var11_11);
                        zzka.zza(var6_6, var2_2.get(var9_9));
                    }
                    var6_6.remove(var9_9);
                    continue;
                }
                if (!zzka.zzcc(var9_9) || ++var7_7 <= 25) continue;
                var11_11 = new StringBuilder(48).append("Event can't contain more than 25 params").toString();
                this.zzge().zzim().zze(var11_11, this.zzga().zzbj(var1_1), this.zzga().zzb(var2_2));
                zzka.zza(var6_6, 5);
                var6_6.remove(var9_9);
            }
        }
        return var6_6;
    }

    private static boolean zza(Bundle bundle, int n) {
        if (bundle.getLong("_err") == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    private static void zza(Bundle bundle, Object object) {
        Preconditions.checkNotNull((Object)bundle);
        if (object != null && (object instanceof String || object instanceof CharSequence)) {
            String string = String.valueOf(object);
            bundle.putLong("_el", (long)string.length());
        }
    }

    private static int zzch(String string) {
        if ("_ldl".equals(string)) {
            return 2048;
        }
        if ("_id".equals(string)) {
            return 256;
        }
        return 36;
    }

    public final int zzi(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zza("user property referrer", string, zzka.zzch(string), object, false) : this.zza("user property", string, zzka.zzch(string), object, false);
        if (bl) {
            return 0;
        }
        return 7;
    }

    public final Object zzj(String string, Object object) {
        if ("_ldl".equals(string)) {
            return zzka.zza(zzka.zzch(string), object, true);
        }
        return zzka.zza(zzka.zzch(string), object, false);
    }

    public final void zza(zzks zzks2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzks2.zzajf = null;
        zzks2.zzate = null;
        zzks2.zzarc = null;
        if (object instanceof String) {
            zzks2.zzajf = (String)object;
            return;
        }
        if (object instanceof Long) {
            zzks2.zzate = (Long)object;
            return;
        }
        if (object instanceof Double) {
            zzks2.zzarc = (Double)object;
            return;
        }
        ((zzhg)this).zzge().zzim().zzg("Ignoring invalid (type) user attribute value", object);
    }

    public final void zza(zzko zzko2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzko2.zzajf = null;
        zzko2.zzate = null;
        zzko2.zzarc = null;
        if (object instanceof String) {
            zzko2.zzajf = (String)object;
            return;
        }
        if (object instanceof Long) {
            zzko2.zzate = (Long)object;
            return;
        }
        if (object instanceof Double) {
            zzko2.zzarc = (Double)object;
            return;
        }
        ((zzhg)this).zzge().zzim().zzg("Ignoring invalid (type) event param value", object);
    }

    public final void zza(Bundle bundle, String string, Object object) {
        if (bundle == null) {
            return;
        }
        if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
            return;
        }
        if (object instanceof String) {
            String string2 = String.valueOf(object);
            bundle.putString(string, string2);
            return;
        }
        if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
            return;
        }
        if (string != null) {
            String string3 = object != null ? object.getClass().getSimpleName() : null;
            ((zzhg)this).zzge().zziq().zze("Not putting event parameter. Invalid value type. name, type", ((zzhg)this).zzga().zzbk(string), string3);
        }
    }

    public final void zza(int n, String string, String string2, int n2) {
        this.zza(null, n, string, string2, n2);
    }

    public final void zza(String string, int n, String string2, String string3, int n2) {
        Bundle bundle = new Bundle();
        zzka.zza(bundle, n);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            bundle.putLong("_el", (long)n2);
        }
        this.zzacw.zzfu().logEvent("auto", "_err", bundle);
    }

    public final byte[] zza(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            ((zzhg)this).zzge().zzim().zzg("Failed to gzip content", iOException);
            throw iOException;
        }
    }

    public final byte[] zzb(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            ((zzhg)this).zzge().zzim().zzg("Failed to ungzip content", iOException);
            throw iOException;
        }
    }

    static MessageDigest getMessageDigest(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string);
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return null;
    }

    @VisibleForTesting
    static long zzc(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        Preconditions.checkState((byArray.length > 0 ? 1 : 0) != 0);
        long l = 0L;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0 && i >= byArray.length - 8; --i) {
            l += ((long)byArray[i] & 0xFFL) << n;
            n += 8;
        }
        return l;
    }

    public final byte[] zzb(zzkp zzkp2) {
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = new byte[zzkp2.zzvm()];
            zzabw zzabw2 = zzabw.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkp2.zza(zzabw2);
            zzabw2.zzve();
            return byArray;
        }
        catch (IOException iOException) {
            ((zzhg)this).zzge().zzim().zzg("Data loss. Failed to serialize batch", iOException);
            return null;
        }
    }

    public final boolean zza(long l, long l2) {
        if (l == 0L || l2 <= 0L) {
            return true;
        }
        return Math.abs(((zzhg)this).zzbt().currentTimeMillis() - l) > l2;
    }

    public static boolean zzc(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ServiceInfo serviceInfo = packageManager.getServiceInfo(new ComponentName(context, string), 0);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @WorkerThread
    public final boolean zzx(String string) {
        ((zzhg)this).zzab();
        if (Wrappers.packageManager((Context)((zzhg)this).getContext()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        ((zzhg)this).zzge().zzis().zzg("Permission not granted", string);
        return false;
    }

    public static boolean zzci(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    public static boolean zzs(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static long[] zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                int n2 = i;
                lArray[n2] = lArray[n2] | 1L << j;
            }
        }
        return lArray;
    }

    public static boolean zza(long[] lArray, int n) {
        if (n >= lArray.length << 6) {
            return false;
        }
        return (lArray[n / 64] & 1L << n % 64) != 0L;
    }

    public final boolean zzcj(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return ((zzhg)this).zzgg().zzhj().equals(string);
    }

    static boolean zzck(String string) {
        return string != null && string.matches("(\\+|-)?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    final Bundle zzd(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zzh(string, bundle.get(string));
                if (object == null) {
                    ((zzhg)this).zzge().zzip().zzg("Param value can't be null", ((zzhg)this).zzga().zzbk(string));
                    continue;
                }
                this.zza(bundle2, string, object);
            }
        }
        return bundle2;
    }

    public static zzko zza(zzkn zzkn2, String string) {
        zzko[] zzkoArray = zzkn2.zzata;
        int n = zzkn2.zzata.length;
        for (int i = 0; i < n; ++i) {
            zzko zzko2 = zzkoArray[i];
            if (!zzko2.name.equals(string)) continue;
            return zzko2;
        }
        return null;
    }

    public static Object zzb(zzkn zzkn2, String string) {
        zzko zzko2 = zzka.zza(zzkn2, string);
        if (zzko2 != null) {
            if (zzko2.zzajf != null) {
                return zzko2.zzajf;
            }
            if (zzko2.zzate != null) {
                return zzko2.zzate;
            }
            if (zzko2.zzarc != null) {
                return zzko2.zzarc;
            }
        }
        return null;
    }

    static zzko[] zza(zzko[] zzkoArray, String string, Object object) {
        zzko[] zzkoArray2 = zzkoArray;
        int n = zzkoArray.length;
        for (int i = 0; i < n; ++i) {
            zzko zzko2 = zzkoArray2[i];
            if (!string.equals(zzko2.name)) continue;
            zzko2.zzate = null;
            zzko2.zzajf = null;
            zzko2.zzarc = null;
            if (object instanceof Long) {
                zzko2.zzate = (Long)object;
            } else if (object instanceof String) {
                zzko2.zzajf = (String)object;
            } else if (object instanceof Double) {
                zzko2.zzarc = (Double)object;
            }
            return zzkoArray;
        }
        zzkoArray2 = new zzko[zzkoArray.length + 1];
        System.arraycopy(zzkoArray, 0, zzkoArray2, 0, zzkoArray.length);
        zzko zzko3 = new zzko();
        new zzko().name = string;
        if (object instanceof Long) {
            zzko3.zzate = (Long)object;
        } else if (object instanceof String) {
            zzko3.zzajf = (String)object;
        } else if (object instanceof Double) {
            zzko3.zzarc = (Double)object;
        }
        zzkoArray2[zzkoArray.length] = zzko3;
        return zzkoArray2;
    }

    final zzeu zza(String string, Bundle bundle, String string2, long l, boolean bl, boolean bl2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzcd(string) != 0) {
            ((zzhg)this).zzge().zzim().zzg("Invalid conditional property event name", ((zzhg)this).zzga().zzbl(string));
            throw new IllegalArgumentException();
        }
        bundle = bundle != null ? new Bundle(bundle) : new Bundle();
        bundle.putString("_o", string2);
        List list = CollectionUtils.listOf((Object)"_o");
        Bundle bundle2 = this.zza(string, bundle, list, false, false);
        Bundle bundle3 = this.zzd(bundle2);
        return new zzeu(string, new zzer(bundle3), string2, l);
    }

    @WorkerThread
    final long zzd(Context context, String string) {
        ((zzhg)this).zzab();
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotEmpty((String)string);
        long l = 0L;
        PackageManager packageManager = context.getPackageManager();
        MessageDigest messageDigest = zzka.getMessageDigest("MD5");
        if (messageDigest == null) {
            ((zzhg)this).zzge().zzim().log("Could not get MD5 instance");
            l = -1L;
        } else if (packageManager != null) {
            try {
                if (!this.zze(context, string)) {
                    PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(((zzhg)this).getContext().getPackageName(), 64);
                    if (packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                        l = zzka.zzc(messageDigest.digest(packageInfo.signatures[0].toByteArray()));
                    } else {
                        ((zzhg)this).zzge().zzip().log("Could not get signatures");
                        l = -1L;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzhg)this).zzge().zzim().zzg("Package name not found", (Object)nameNotFoundException);
            }
        }
        return l;
    }

    @VisibleForTesting
    private final boolean zze(Context context, String string) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                return ((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(signature.toByteArray()))).getSubjectX500Principal().equals(x500Principal);
            }
        }
        catch (CertificateException certificateException) {
            ((zzhg)this).zzge().zzim().zzg("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzhg)this).zzge().zzim().zzg("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }

    @WorkerThread
    static boolean zzd(zzeu zzeu2, zzdz zzdz2) {
        Preconditions.checkNotNull((Object)((Object)zzeu2));
        Preconditions.checkNotNull((Object)((Object)zzdz2));
        return !TextUtils.isEmpty((CharSequence)zzdz2.zzadm);
    }

    @WorkerThread
    static boolean zzcl(String string) {
        Preconditions.checkNotEmpty((String)string);
        switch (string) {
            case "_in": 
            case "_ui": 
            case "_ug": {
                return true;
            }
        }
        return false;
    }

    final <T extends Parcelable> T zza(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (SafeParcelReader.ParseException parseException) {
            ((zzhg)this).zzge().zzim().log("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    static byte[] zza(Parcelable parcelable) {
        if (parcelable == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcelable.writeToParcel(parcel, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            parcel.recycle();
        }
    }

    public static Object zzf(Object object) {
        Object object2;
        if (object == null) {
            return null;
        }
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            object2 = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException exception) {
                return null;
            }
        }
        objectOutputStream.close();
        objectInputStream.close();
        return object2;
    }

    @Nullable
    public static String zza(String string, String[] stringArray, String[] stringArray2) {
        Preconditions.checkNotNull((Object)stringArray);
        Preconditions.checkNotNull((Object)stringArray2);
        int n = Math.min(stringArray.length, stringArray2.length);
        for (int i = 0; i < n; ++i) {
            if (!zzka.zzs(string, stringArray[i])) continue;
            return stringArray2[i];
        }
        return null;
    }

    public final int zzld() {
        if (this.zzarh == null) {
            this.zzarh = GoogleApiAvailabilityLight.getInstance().getApkVersion(((zzhg)this).getContext()) / 1000;
        }
        return this.zzarh;
    }
}

