/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.firebase.iid.FirebaseInstanceId;
import java.math.BigInteger;
import java.util.Locale;

public final class zzfc
extends zzhi {
    private String zzti;
    private String zzth;
    private int zzain;
    private String zzadt;
    private String zztg;
    private long zzaio;
    private long zzadx;
    private int zzaen;
    private String zzadm;

    zzfc(zzgm zzgm2) {
        super(zzgm2);
    }

    @Override
    protected final boolean zzhh() {
        return true;
    }

    @Override
    protected final void zzin() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzhh)this).getContext().getPackageName();
        PackageManager packageManager = ((zzhh)this).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzhh)this).zzgf().zzis().zzg("PackageManager is null, app identity information might be inaccurate. appId", zzfh.zzbl(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzhh)this).zzgf().zzis().zzg("Error retrieving app installer package name. appId", zzfh.zzbl(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzhh)this).getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzhh)this).zzgf().zzis().zze("Error retrieving package info. appId, appName", zzfh.zzbl(string4), string3);
            }
        }
        this.zzti = string4;
        this.zzadt = string;
        this.zzth = string2;
        this.zzain = n;
        this.zztg = string3;
        this.zzaio = 0L;
        zzec zzec2 = ((zzhh)this).zzgi();
        packageInfo = GoogleServices.initialize((Context)((zzhh)this).getContext());
        boolean bl = packageInfo != null && packageInfo.isSuccess();
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzfc zzfc2 = this;
            if (packageInfo2 == null) {
                ((zzhh)zzfc2).zzgf().zzis().log("GoogleService failed to initialize (no status)");
            } else {
                ((zzhh)zzfc2).zzgf().zzis().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzhh)this).zzgh().zzhk();
            if (((zzhh)this).zzgh().zzhj()) {
                ((zzhh)this).zzgf().zzix().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                ((zzhh)this).zzgf().zzix().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && GoogleServices.isMeasurementExplicitlyDisabled()) {
                ((zzhh)this).zzgf().zzix().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzhh)this).zzgf().zziz().log("Collection enabled");
            }
        }
        this.zzadm = "";
        this.zzadx = 0L;
        zzec2 = ((zzhh)this).zzgi();
        if (this.zzacw.zzka() != null) {
            this.zzadm = this.zzacw.zzka();
        } else {
            try {
                object = GoogleServices.getGoogleAppId();
                Object object2 = this.zzadm = TextUtils.isEmpty((CharSequence)object) ? "" : object;
                if (bl2) {
                    ((zzhh)this).zzgf().zziz().zze("App package, google app id", this.zzti, this.zzadm);
                }
            }
            catch (IllegalStateException illegalStateException) {
                ((zzhh)this).zzgf().zzis().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzfh.zzbl(string4), illegalStateException);
            }
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzaen = InstantApps.isInstantApp((Context)((zzhh)this).getContext()) ? 1 : 0;
            return;
        }
        this.zzaen = 0;
    }

    @WorkerThread
    final zzdz zzbh(String string) {
        ((zzhh)this).zzab();
        ((zzhh)this).zzfs();
        String string2 = this.zzah();
        String string3 = this.getGmpAppId();
        zzhh zzhh2 = this;
        ((zzhi)zzhh2).zzch();
        String string4 = ((zzfc)zzhh2).zzth;
        long l = this.zzip();
        zzhh2 = this;
        ((zzhi)zzhh2).zzch();
        String string5 = ((zzfc)zzhh2).zzadt;
        zzhh2 = this;
        ((zzhi)zzhh2).zzch();
        zzhh2.zzab();
        if (((zzfc)zzhh2).zzaio == 0L) {
            ((zzfc)zzhh2).zzaio = ((zzfc)zzhh2).zzacw.zzgc().zzd(zzhh2.getContext(), zzhh2.getContext().getPackageName());
        }
        long l2 = ((zzfc)zzhh2).zzaio;
        boolean bl = this.zzacw.isEnabled();
        boolean bl2 = !((zzhh)this).zzgg().zzakw;
        String string6 = this.zzgl();
        zzhh2 = this;
        ((zzhi)zzhh2).zzch();
        long l3 = ((zzfc)zzhh2).zzadx;
        long l4 = this.zzacw.zzkb();
        int n = this.zziq();
        zzhh2 = ((zzhh)this).zzgh();
        zzhh2.zzfs();
        Boolean bl3 = ((zzeg)zzhh2).zzar("google_analytics_adid_collection_enabled");
        boolean bl4 = bl3 == null || bl3 != false;
        zzhh2 = ((zzhh)this).zzgh();
        zzhh2.zzfs();
        bl3 = ((zzeg)zzhh2).zzar("google_analytics_ssaid_collection_enabled");
        return new zzdz(string2, string3, string4, l, string5, 12451L, l2, string, bl, bl2, string6, l3, l4, n, bl4, bl3 == null || bl3 != false, ((zzhh)this).zzgg().zzjl());
    }

    @WorkerThread
    final String zzio() {
        byte[] byArray = new byte[16];
        ((zzhh)this).zzgc().zzll().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    private final String zzgl() {
        ((zzhh)this).zzab();
        ((zzhh)this).zzfs();
        if (((zzhh)this).zzgh().zzax(this.zzti) && !this.zzacw.isEnabled()) {
            return null;
        }
        try {
            return FirebaseInstanceId.getInstance().getId();
        }
        catch (IllegalStateException illegalStateException) {
            ((zzhh)this).zzgf().zziv().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String zzah() {
        this.zzch();
        return this.zzti;
    }

    final String getGmpAppId() {
        this.zzch();
        return this.zzadm;
    }

    final int zzip() {
        this.zzch();
        return this.zzain;
    }

    final int zziq() {
        this.zzch();
        return this.zzaen;
    }
}

