/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzfu;
import com.google.android.gms.internal.measurement.zzfv;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzfx;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzkc;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzfs
extends zzhi {
    @VisibleForTesting
    static final Pair<String, Long> zzakb = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzabf;
    public zzfw zzakc;
    public final zzfv zzakd = new zzfv(this, "last_upload", 0L);
    public final zzfv zzake = new zzfv(this, "last_upload_attempt", 0L);
    public final zzfv zzakf = new zzfv(this, "backoff", 0L);
    public final zzfv zzakg = new zzfv(this, "last_delete_stale", 0L);
    public final zzfv zzakh;
    public final zzfv zzaki;
    public final zzfv zzakj;
    public final zzfx zzakk;
    private String zzakl;
    private boolean zzakm;
    private long zzakn;
    private String zzako;
    private long zzakp;
    private final Object zzakq;
    public final zzfv zzakr = new zzfv(this, "time_before_start", 10000L);
    public final zzfv zzaks = new zzfv(this, "session_timeout", 1800000L);
    public final zzfu zzakt = new zzfu(this, "start_new_session", true);
    public final zzfv zzaku = new zzfv(this, "last_pause_time", 0L);
    public final zzfv zzakv = new zzfv(this, "time_active", 0L);
    public boolean zzakw;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzbn(String string) {
        this.zzab();
        long l = this.zzbt().elapsedRealtime();
        if (this.zzakl != null && l < this.zzakn) {
            return new Pair((Object)this.zzakl, (Object)this.zzakm);
        }
        String string2 = string;
        this.zzakn = l + this.zzgh().zza(string2, zzey.zzagq);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zzakl = info.getId();
                this.zzakm = info.isLimitAdTrackingEnabled();
            }
            if (this.zzakl == null) {
                this.zzakl = "";
            }
        }
        catch (Exception exception) {
            this.zzgf().zziy().zzg("Unable to get advertising id", exception);
            this.zzakl = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzakl, (Object)this.zzakm);
    }

    @WorkerThread
    final String zzbo(String string) {
        this.zzab();
        String string2 = (String)this.zzbn((String)string).first;
        MessageDigest messageDigest = zzkc.getMessageDigest("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzfs(zzgm zzgm2) {
        super(zzgm2);
        this.zzakh = new zzfv(this, "midnight_offset", 0L);
        this.zzaki = new zzfv(this, "first_open_time", 0L);
        this.zzakj = new zzfv(this, "app_install_time", 0L);
        this.zzakk = new zzfx(this, "app_instance_id", null);
        this.zzakq = new Object();
    }

    @Override
    protected final boolean zzhh() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void zzin() {
        this.zzabf = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzakw = this.zzabf.getBoolean("has_been_opened", false);
        if (!this.zzakw) {
            SharedPreferences.Editor editor = this.zzabf.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzakc = new zzfw(this, "health_monitor", Math.max(0L, zzey.zzagr.get()), null);
    }

    @WorkerThread
    private final SharedPreferences zzjf() {
        this.zzab();
        this.zzch();
        return this.zzabf;
    }

    @WorkerThread
    final void zzbp(String string) {
        this.zzab();
        SharedPreferences.Editor editor = this.zzjf().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzjg() {
        this.zzab();
        return this.zzjf().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzbq(String string) {
        Object object = this.zzakq;
        synchronized (object) {
            this.zzako = string;
            this.zzakp = this.zzbt().elapsedRealtime();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzjh() {
        Object object = this.zzakq;
        synchronized (object) {
            if (Math.abs(this.zzbt().elapsedRealtime() - this.zzakp) < 1000L) {
                return this.zzako;
            }
            return null;
        }
    }

    @WorkerThread
    final Boolean zzji() {
        this.zzab();
        if (!this.zzjf().contains("use_service")) {
            return null;
        }
        return this.zzjf().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzf(boolean bl) {
        this.zzab();
        this.zzgf().zziz().zzg("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzjf().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzjj() {
        this.zzab();
        this.zzgf().zziz().log("Clearing collection preferences.");
        boolean bl = this.zzjf().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzg(true);
        }
        SharedPreferences.Editor editor = this.zzjf().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzab();
        this.zzgf().zziz().zzg("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzjf().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzg(boolean bl) {
        this.zzab();
        return this.zzjf().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected final String zzjk() {
        this.zzab();
        String string = this.zzjf().getString("previous_os_version", null);
        this.zzfx().zzch();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzjf().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzh(boolean bl) {
        this.zzab();
        this.zzgf().zziz().zzg("Updating deferred analytics collection", bl);
        SharedPreferences.Editor editor = this.zzjf().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzjl() {
        this.zzab();
        return this.zzjf().getBoolean("deferred_analytics_collection", false);
    }

    @WorkerThread
    final boolean zzjm() {
        return this.zzabf.contains("deferred_analytics_collection");
    }

    static /* synthetic */ SharedPreferences zza(zzfs zzfs2) {
        return zzfs2.zzjf();
    }
}

