/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Application;
import android.content.Context;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzdu;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzfc;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzfj;
import com.google.android.gms.internal.measurement.zzfs;
import com.google.android.gms.internal.measurement.zzfy;
import com.google.android.gms.internal.measurement.zzgc;
import com.google.android.gms.internal.measurement.zzgh;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.android.gms.internal.measurement.zzhl;
import com.google.android.gms.internal.measurement.zzie;
import com.google.android.gms.internal.measurement.zzig;
import com.google.android.gms.internal.measurement.zzij;
import com.google.android.gms.internal.measurement.zzji;
import com.google.android.gms.internal.measurement.zzkc;
import com.google.android.gms.internal.measurement.zzwu;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.util.concurrent.atomic.AtomicReference;

public class zzgm
implements zzhj {
    private static volatile zzgm zzamn;
    private final Context zzqx;
    private final String zzamo;
    private final zzec zzagd;
    private final zzeg zzamp;
    private final zzfs zzamq;
    private final zzfh zzamr;
    private final zzgh zzams;
    private final zzji zzamt;
    private final AppMeasurement zzamu;
    private final FirebaseAnalytics zzamv;
    private final zzkc zzamw;
    private final zzff zzamx;
    private final Clock zzro;
    private final zzig zzamy;
    private final zzhl zzamz;
    private final zzdu zzana;
    private zzfd zzanb;
    private zzij zzanc;
    private zzeq zzand;
    private zzfc zzane;
    private zzfy zzanf;
    private boolean zzvo = false;
    private Boolean zzang;
    private long zzanh;
    private int zzani;
    private int zzanj;
    private final long zzaem;

    private zzgm(zzhk zzhk2) {
        zzdu zzdu2;
        Preconditions.checkNotNull((Object)zzhk2);
        Object object = zzhk2.zzqx;
        this.zzagd = new zzec((Context)object);
        zzey.zza(this.zzagd);
        this.zzqx = zzhk2.zzqx;
        this.zzamo = zzhk2.zzamo;
        zzwu.init(this.zzqx);
        this.zzro = DefaultClock.getInstance();
        this.zzaem = this.zzro.currentTimeMillis();
        object = this;
        this.zzamp = new zzeg((zzgm)object);
        object = this;
        zzfs zzfs2 = new zzfs((zzgm)object);
        zzfs2.zzm();
        this.zzamq = zzfs2;
        object = this;
        zzfh zzfh2 = new zzfh((zzgm)object);
        zzfh2.zzm();
        this.zzamr = zzfh2;
        object = this;
        zzkc zzkc2 = new zzkc((zzgm)object);
        zzkc2.zzm();
        this.zzamw = zzkc2;
        object = this;
        zzff zzff2 = new zzff((zzgm)object);
        zzff2.zzm();
        this.zzamx = zzff2;
        object = this;
        this.zzana = zzdu2 = new zzdu((zzgm)object);
        object = this;
        zzig zzig2 = new zzig((zzgm)object);
        zzig2.zzm();
        this.zzamy = zzig2;
        object = this;
        zzhl zzhl2 = new zzhl((zzgm)object);
        zzhl2.zzm();
        this.zzamz = zzhl2;
        object = this;
        this.zzamu = new AppMeasurement((zzgm)object);
        object = this;
        this.zzamv = new FirebaseAnalytics((zzgm)object);
        object = this;
        zzji zzji2 = new zzji((zzgm)object);
        zzji2.zzm();
        this.zzamt = zzji2;
        object = this;
        zzgh zzgh2 = new zzgh((zzgm)object);
        zzgh2.zzm();
        this.zzams = zzgh2;
        object = this;
        zzec zzec2 = ((zzgm)object).zzagd;
        if (((zzgm)object).zzqx.getApplicationContext() instanceof Application) {
            zzhl zzhl3 = ((zzgm)object).zzfv();
            if (((zzhh)zzhl3).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzhh)zzhl3).getContext().getApplicationContext();
                if (zzhl3.zzanz == null) {
                    zzhl3.zzanz = new zzie(zzhl3, null);
                }
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhl3.zzanz);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhl3.zzanz);
                ((zzhh)zzhl3).zzgf().zziz().log("Registered activity lifecycle callback");
            }
        } else {
            ((zzgm)object).zzgf().zziv().log("Application context is not an Application");
        }
        this.zzams.zzc(new zzgn(this, zzhk2));
    }

    @WorkerThread
    private final void zza(zzhk zzhk2) {
        String string;
        zzfj zzfj2;
        ((zzhh)this.zzge()).zzab();
        zzeg.zzhi();
        zzgm zzgm2 = this;
        zzeq zzeq2 = new zzeq(zzgm2);
        zzeq2.zzm();
        this.zzand = zzeq2;
        zzgm2 = this;
        zzfc zzfc2 = new zzfc(zzgm2);
        zzfc2.zzm();
        this.zzane = zzfc2;
        zzgm2 = this;
        zzfd zzfd2 = new zzfd(zzgm2);
        zzfd2.zzm();
        this.zzanb = zzfd2;
        zzgm2 = this;
        zzij zzij2 = new zzij(zzgm2);
        zzij2.zzm();
        this.zzanc = zzij2;
        this.zzamw.zzke();
        this.zzamq.zzke();
        zzgm2 = this;
        this.zzanf = new zzfy(zzgm2);
        this.zzane.zzke();
        this.zzgf().zzix().zzg("App measurement is starting up, version", 12451L);
        zzec zzec2 = this.zzagd;
        this.zzgf().zzix().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzec2 = this.zzagd;
        String string2 = zzfc2.zzah();
        if (this.zzgc().zzci(string2)) {
            zzfj2 = this.zzgf().zzix();
            string = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
        } else {
            zzfj2 = this.zzgf().zzix();
            String string3 = String.valueOf(string2);
            string = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
        }
        zzfj2.log(string);
        this.zzgf().zziy().log("Debug-level message logging enabled");
        if (this.zzani != this.zzanj) {
            this.zzgf().zzis().zze("Not all components initialized", this.zzani, this.zzanj);
        }
        this.zzvo = true;
    }

    @WorkerThread
    protected final void start() {
        ((zzhh)this.zzge()).zzab();
        if (this.zzgg().zzakd.get() == 0L) {
            this.zzgg().zzakd.set(this.zzro.currentTimeMillis());
        }
        if (Long.valueOf(this.zzgg().zzaki.get()) == 0L) {
            this.zzgf().zziz().zzg("Persisting first open", this.zzaem);
            this.zzgg().zzaki.set(this.zzaem);
        }
        if (!this.zzkd()) {
            if (this.isEnabled()) {
                if (!this.zzgc().zzw("android.permission.INTERNET")) {
                    this.zzgf().zzis().log("App is missing INTERNET permission");
                }
                if (!this.zzgc().zzw("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzgf().zzis().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzec zzec2 = this.zzagd;
                if (!Wrappers.packageManager((Context)this.zzqx).isCallerInstantApp()) {
                    if (!zzgc.zza(this.zzqx)) {
                        this.zzgf().zzis().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzkc.zza(this.zzqx, false)) {
                        this.zzgf().zzis().log("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzgf().zzis().log("Uploading is not possible. App measurement disabled");
                return;
            }
        } else {
            zzec zzec3 = this.zzagd;
            if (!TextUtils.isEmpty((CharSequence)this.zzfw().getGmpAppId())) {
                String string = this.zzgg().zzjg();
                if (string == null) {
                    this.zzgg().zzbp(this.zzfw().getGmpAppId());
                } else if (!string.equals(this.zzfw().getGmpAppId())) {
                    this.zzgf().zzix().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzgg().zzjj();
                    this.zzanc.disconnect();
                    this.zzanc.zzdf();
                    this.zzgg().zzbp(this.zzfw().getGmpAppId());
                    this.zzgg().zzaki.set(this.zzaem);
                    this.zzgg().zzakk.zzbr(null);
                }
            }
            this.zzfv().zzbq(this.zzgg().zzakk.zzjn());
            zzec3 = this.zzagd;
            if (!TextUtils.isEmpty((CharSequence)this.zzfw().getGmpAppId())) {
                boolean bl = this.isEnabled();
                if (!this.zzgg().zzjm() && !this.zzamp.zzhj()) {
                    this.zzgg().zzh(!bl);
                }
                if (!this.zzamp.zzay(this.zzfw().zzah()) || bl) {
                    this.zzfv().zzkj();
                }
                this.zzfy().zza(new AtomicReference<String>());
            }
        }
    }

    @Override
    public final zzec zzgi() {
        return this.zzagd;
    }

    public final zzeg zzgh() {
        return this.zzamp;
    }

    public final zzfs zzgg() {
        zzgm.zza((zzhh)this.zzamq);
        return this.zzamq;
    }

    @Override
    public final zzfh zzgf() {
        zzgm.zza(this.zzamr);
        return this.zzamr;
    }

    public final zzfh zzjv() {
        if (this.zzamr != null && this.zzamr.isInitialized()) {
            return this.zzamr;
        }
        return null;
    }

    @Override
    public final zzgh zzge() {
        zzgm.zza(this.zzams);
        return this.zzams;
    }

    public final zzji zzgd() {
        zzgm.zza(this.zzamt);
        return this.zzamt;
    }

    public final zzfy zzjw() {
        return this.zzanf;
    }

    final zzgh zzjx() {
        return this.zzams;
    }

    public final zzhl zzfv() {
        zzgm.zza(this.zzamz);
        return this.zzamz;
    }

    public final AppMeasurement zzjy() {
        return this.zzamu;
    }

    public final FirebaseAnalytics zzjz() {
        return this.zzamv;
    }

    public final zzkc zzgc() {
        zzgm.zza((zzhh)this.zzamw);
        return this.zzamw;
    }

    public final zzff zzgb() {
        zzgm.zza((zzhh)this.zzamx);
        return this.zzamx;
    }

    public final zzfd zzga() {
        zzgm.zza(this.zzanb);
        return this.zzanb;
    }

    @Override
    public final Context getContext() {
        return this.zzqx;
    }

    public final String zzka() {
        return this.zzamo;
    }

    @Override
    public final Clock zzbt() {
        return this.zzro;
    }

    public final zzig zzfz() {
        zzgm.zza(this.zzamy);
        return this.zzamy;
    }

    public final zzij zzfy() {
        zzgm.zza(this.zzanc);
        return this.zzanc;
    }

    public final zzeq zzfx() {
        zzgm.zza(this.zzand);
        return this.zzand;
    }

    public final zzfc zzfw() {
        zzgm.zza(this.zzane);
        return this.zzane;
    }

    public final zzdu zzfu() {
        zzgm.zza(this.zzana);
        return this.zzana;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzgm zza(Context context, String string, String string2) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzamn != null) return zzamn;
        Class<zzgm> clazz = zzgm.class;
        synchronized (zzgm.class) {
            if (zzamn != null) return zzamn;
            zzhk zzhk2 = new zzhk(context, null);
            zzamn = new zzgm(zzhk2);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zzamn;
        }
    }

    private final void zzch() {
        if (!this.zzvo) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zza(zzhi zzhi2) {
        if (zzhi2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzhi2.isInitialized()) {
            String string = String.valueOf(zzhi2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzhh zzhh2) {
        if (zzhh2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    public final boolean isEnabled() {
        ((zzhh)this.zzge()).zzab();
        this.zzch();
        if (this.zzamp.zzhj()) {
            return false;
        }
        Boolean bl = this.zzamp.zzhk();
        boolean bl2 = bl != null ? bl : !GoogleServices.isMeasurementExplicitlyDisabled();
        return this.zzgg().zzg(bl2);
    }

    final long zzkb() {
        Long l = this.zzgg().zzaki.get();
        if (l == 0L) {
            return this.zzaem;
        }
        return Math.min(this.zzaem, l);
    }

    final void zzfs() {
        zzec zzec2 = this.zzagd;
    }

    final void zzfr() {
        zzec zzec2 = this.zzagd;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzb(zzhi zzhi2) {
        ++this.zzani;
    }

    final void zzkc() {
        ++this.zzanj;
    }

    @WorkerThread
    protected final boolean zzkd() {
        this.zzch();
        ((zzhh)this.zzge()).zzab();
        if (this.zzang == null || this.zzanh == 0L || this.zzang != null && !this.zzang.booleanValue() && Math.abs(this.zzro.elapsedRealtime() - this.zzanh) > 1000L) {
            this.zzanh = this.zzro.elapsedRealtime();
            zzec zzec2 = this.zzagd;
            this.zzang = this.zzgc().zzw("android.permission.INTERNET") && this.zzgc().zzw("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzqx).isCallerInstantApp() || zzgc.zza(this.zzqx) && zzkc.zza(this.zzqx, false));
            if (this.zzang.booleanValue()) {
                this.zzang = this.zzgc().zzcf(this.zzfw().getGmpAppId());
            }
        }
        return this.zzang;
    }

    static /* synthetic */ void zza(zzgm zzgm2, zzhk zzhk2) {
        zzgm2.zza(zzhk2);
    }
}

