/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzet;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzhm;
import com.google.android.gms.internal.measurement.zzhn;
import com.google.android.gms.internal.measurement.zzho;
import com.google.android.gms.internal.measurement.zzhp;
import com.google.android.gms.internal.measurement.zzhq;
import com.google.android.gms.internal.measurement.zzhr;
import com.google.android.gms.internal.measurement.zzhs;
import com.google.android.gms.internal.measurement.zzht;
import com.google.android.gms.internal.measurement.zzhu;
import com.google.android.gms.internal.measurement.zzhv;
import com.google.android.gms.internal.measurement.zzhw;
import com.google.android.gms.internal.measurement.zzhx;
import com.google.android.gms.internal.measurement.zzhy;
import com.google.android.gms.internal.measurement.zzhz;
import com.google.android.gms.internal.measurement.zzia;
import com.google.android.gms.internal.measurement.zzib;
import com.google.android.gms.internal.measurement.zzic;
import com.google.android.gms.internal.measurement.zzid;
import com.google.android.gms.internal.measurement.zzie;
import com.google.android.gms.internal.measurement.zzif;
import com.google.android.gms.internal.measurement.zzig;
import com.google.android.gms.internal.measurement.zzjz;
import com.google.android.gms.internal.measurement.zzkc;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class zzhl
extends zzhi {
    @VisibleForTesting
    protected zzie zzanz;
    private AppMeasurement.EventInterceptor zzaoa;
    private final Set<AppMeasurement.OnEventListener> zzaob = new CopyOnWriteArraySet<AppMeasurement.OnEventListener>();
    private boolean zzaoc;
    private final AtomicReference<String> zzaod = new AtomicReference();
    @VisibleForTesting
    protected boolean zzaoe = true;

    protected zzhl(zzgm zzgm2) {
        super(zzgm2);
    }

    @Override
    protected final boolean zzhh() {
        return false;
    }

    public final Boolean zzkf() {
        AtomicReference atomicReference = new AtomicReference();
        return (Boolean)((zzhh)this).zzge().zza(atomicReference, 15000L, "boolean test flag value", new zzhm(this, atomicReference));
    }

    public final String zzhq() {
        AtomicReference atomicReference = new AtomicReference();
        return (String)((zzhh)this).zzge().zza(atomicReference, 15000L, "String test flag value", new zzhw(this, atomicReference));
    }

    public final Long zzkg() {
        AtomicReference atomicReference = new AtomicReference();
        return (Long)((zzhh)this).zzge().zza(atomicReference, 15000L, "long test flag value", new zzhx(this, atomicReference));
    }

    public final Integer zzkh() {
        AtomicReference atomicReference = new AtomicReference();
        return (Integer)((zzhh)this).zzge().zza(atomicReference, 15000L, "int test flag value", new zzhy(this, atomicReference));
    }

    public final Double zzki() {
        AtomicReference atomicReference = new AtomicReference();
        return (Double)((zzhh)this).zzge().zza(atomicReference, 15000L, "double test flag value", new zzhz(this, atomicReference));
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzch();
        ((zzhh)this).zzfs();
        ((zzhh)this).zzge().zzc(new zzia(this, bl));
    }

    @WorkerThread
    private final void zzi(boolean bl) {
        ((zzhh)this).zzab();
        ((zzhh)this).zzfs();
        this.zzch();
        ((zzhh)this).zzgf().zziy().zzg("Setting app measurement enabled (FE)", bl);
        ((zzhh)this).zzgg().setMeasurementEnabled(bl);
        if (((zzhh)this).zzgh().zzay(((zzhh)this).zzfw().zzah())) {
            if (this.zzacw.isEnabled() && this.zzaoe) {
                ((zzhh)this).zzgf().zziy().log("Recording app launch after enabling measurement for the first time (FE)");
                this.zzkj();
                return;
            }
            ((zzhh)this).zzfy().zzkm();
            return;
        }
        ((zzhh)this).zzfy().zzkm();
    }

    public final void setMinimumSessionDuration(long l) {
        ((zzhh)this).zzfs();
        ((zzhh)this).zzge().zzc(new zzib(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        ((zzhh)this).zzfs();
        ((zzhh)this).zzge().zzc(new zzic(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        ((zzhh)this).zzfs();
        boolean bl2 = this.zzaoa == null || zzkc.zzch(string2);
        this.zza(string, string2, bundle, true, bl2, true, null);
    }

    public final void logEvent(String string, String string2, Bundle bundle) {
        ((zzhh)this).zzfs();
        boolean bl = this.zzaoa == null || zzkc.zzch(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    @WorkerThread
    final void zza(String string, String string2, Bundle bundle) {
        ((zzhh)this).zzfs();
        ((zzhh)this).zzab();
        boolean bl = this.zzaoa == null || zzkc.zzch(string2);
        this.zza(string, string2, ((zzhh)this).zzbt().currentTimeMillis(), bundle, true, bl, false, null);
    }

    @WorkerThread
    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Object object;
        Object object2;
        Object object3;
        zzif zzif2;
        zzif zzif3;
        Object object4;
        Object object5;
        zzhi zzhi2;
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        Preconditions.checkNotNull((Object)bundle);
        ((zzhh)this).zzab();
        this.zzch();
        if (!this.zzacw.isEnabled()) {
            ((zzhh)this).zzgf().zziy().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzaoc) {
            this.zzaoc = true;
            zzhi2 = this;
            try {
                object5 = Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                Class<?> clazz = object5;
                object4 = zzhi2;
                try {
                    clazz.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzhh)object4).getContext());
                }
                catch (Exception exception) {
                    ((zzhh)object4).zzgf().zziv().zzg("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                zzhi2.zzgf().zzix().log("Tag Manager is not found and thus will not be used");
            }
        }
        if (bl3) {
            object4 = ((zzhh)this).zzgi();
            if (!"_iap".equals(string2)) {
                int n;
                object5 = string2;
                zzhi2 = this.zzacw.zzgc();
                if ((!((zzkc)zzhi2).zzq("event", (String)object5) ? 2 : (!((zzkc)zzhi2).zza("event", AppMeasurement.Event.zzacx, (String)object5) ? 13 : (n = !((zzkc)zzhi2).zza("event", 40, (String)object5) ? 2 : 0))) != 0) {
                    ((zzhh)this).zzgf().zziu().zzg("Invalid public event name. Event will not be logged (FE)", ((zzhh)this).zzgb().zzbi(string2));
                    this.zzacw.zzgc();
                    String string4 = zzkc.zza(string2, 40, true);
                    int n2 = string2 != null ? string2.length() : 0;
                    this.zzacw.zzgc().zza(n, "_ev", string4, n2);
                    return;
                }
            }
        }
        object4 = ((zzhh)this).zzgi();
        zzif zzif4 = ((zzhh)this).zzfz().zzkk();
        if (zzif4 != null && !bundle.containsKey("_sc")) {
            zzif4.zzaou = true;
        }
        zzif zzif5 = zzif4;
        zzig.zza(zzif5, bundle, bl && bl3);
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzkc.zzch(string2);
        if (bl && this.zzaoa != null && !bl5 && !bl4) {
            ((zzhh)this).zzgf().zziy().zze("Passing event to registered event handler (FE)", ((zzhh)this).zzgb().zzbi(string2), ((zzhh)this).zzgb().zzb(bundle));
            this.zzaoa.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzacw.zzkd()) {
            return;
        }
        int n = ((zzhh)this).zzgc().zzcc(string2);
        if (n != 0) {
            ((zzhh)this).zzgf().zziu().zzg("Invalid event name. Event will not be logged (FE)", ((zzhh)this).zzgb().zzbi(string2));
            ((zzhh)this).zzgc();
            String string5 = zzkc.zza(string2, 40, true);
            int n3 = string2 != null ? string2.length() : 0;
            this.zzacw.zzgc().zza(string3, n, "_ev", string5, n3);
            return;
        }
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        Bundle bundle3 = ((zzhh)this).zzgc().zza(string2, bundle, list, bl3, true);
        zzhi2 = bundle3;
        if (bundle3 == null || !zzhi2.containsKey("_sc") || !zzhi2.containsKey("_si")) {
            zzif3 = null;
        } else {
            object5 = zzhi2.getString("_sn");
            String string6 = zzhi2.getString("_sc");
            Long l2 = zzhi2.getLong("_si");
            zzif3 = zzif2 = new zzif((String)object5, string6, l2);
        }
        if (zzif3 == null) {
            zzif2 = zzif5;
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l3 = ((zzhh)this).zzgc().zzll().nextLong();
        int n4 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object[] objectArray2 = objectArray;
        int n5 = objectArray.length;
        for (int i = 0; i < n5; ++i) {
            object3 = objectArray2[i];
            object2 = bundle3.get((String)object3);
            ((zzhh)this).zzgc();
            object = zzkc.zze(object2);
            if (object == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])object).length);
            for (int j = 0; j < ((Bundle[])object).length; ++j) {
                Bundle object6 = object[j];
                zzig.zza(zzif2, object6, true);
                bundle2 = ((zzhh)this).zzgc().zza("_ep", object6, list, bl3, false);
                bundle2.putString("_en", string2);
                bundle2.putLong("_eid", l3);
                bundle2.putString("_gn", (String)object3);
                bundle2.putInt("_ll", ((Bundle[])object).length);
                bundle2.putInt("_i", j);
                arrayList.add(bundle2);
            }
            n4 += ((Bundle[])object).length;
        }
        if (n4 != 0) {
            bundle3.putLong("_eid", l3);
            bundle3.putInt("_epc", n4);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle4 = (Bundle)arrayList.get(i);
            object3 = i != 0 ? "_ep" : string2;
            bundle4.putString("_o", string);
            object2 = bl2 ? ((zzhh)this).zzgc().zzd(bundle4) : bundle4;
            ((zzhh)this).zzgf().zziy().zze("Logging event (FE)", ((zzhh)this).zzgb().zzbi(string2), ((zzhh)this).zzgb().zzb((Bundle)object2));
            object = new zzew((String)object3, new zzet((Bundle)object2), string, l);
            ((zzhh)this).zzfy().zzb((zzew)((Object)object), string3);
            if (bl4) continue;
            for (AppMeasurement.OnEventListener onEventListener : this.zzaob) {
                bundle2 = new Bundle((Bundle)object2);
                onEventListener.onEvent(string, string2, bundle2, l);
            }
        }
        object4 = ((zzhh)this).zzgi();
        if (((zzhh)this).zzfz().zzkk() != null && "_ae".equals(string2)) {
            ((zzhh)this).zzgd().zzl(true);
        }
    }

    public final void zza(String string, String string2, Bundle bundle, long l) {
        ((zzhh)this).zzfs();
        this.zzb(string, string2, l, bundle, false, true, true, null);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zzb(string, string2, ((zzhh)this).zzbt().currentTimeMillis(), bundle, bl, bl2, bl3, string3);
    }

    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Bundle bundle3 = bundle;
        if (bundle3 == null) {
            bundle2 = new Bundle();
        } else {
            Bundle bundle4 = new Bundle(bundle3);
            for (String string4 : bundle4.keySet()) {
                int n;
                Object object;
                Object object2 = bundle4.get(string4);
                if (object2 instanceof Bundle) {
                    bundle4.putBundle(string4, new Bundle((Bundle)object2));
                    continue;
                }
                if (object2 instanceof Parcelable[]) {
                    object = (Parcelable[])object2;
                    for (n = 0; n < ((Parcelable[])object).length; ++n) {
                        if (!(object[n] instanceof Bundle)) continue;
                        object[n] = new Bundle((Bundle)object[n]);
                    }
                    continue;
                }
                if (!(object2 instanceof ArrayList)) continue;
                object = (ArrayList)object2;
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    Object e = ((ArrayList)object).get(n);
                    if (!(e instanceof Bundle)) continue;
                    ((ArrayList)object).set(n, new Bundle((Bundle)e));
                }
            }
            bundle2 = bundle4;
        }
        Bundle bundle5 = bundle2;
        ((zzhh)this).zzge().zzc(new zzid(this, string, string2, l, bundle5, bl, bl2, bl3, string3));
    }

    public final void setUserProperty(String string, String string2, Object object) {
        Preconditions.checkNotEmpty((String)string);
        long l = ((zzhh)this).zzbt().currentTimeMillis();
        int n = ((zzhh)this).zzgc().zzce(string2);
        if (n != 0) {
            ((zzhh)this).zzgc();
            String string3 = zzkc.zza(string2, 24, true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzacw.zzgc().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = ((zzhh)this).zzgc().zzi(string2, object);
            if (n != 0) {
                ((zzhh)this).zzgc();
                String string4 = zzkc.zza(string2, 24, true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n3 = String.valueOf(object).length();
                }
                this.zzacw.zzgc().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = ((zzhh)this).zzgc().zzj(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzhh)this).zzge().zzc(new zzhn(this, string, string2, object, l));
    }

    @WorkerThread
    private final void zza(String string, String string2, Object object, long l) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ((zzhh)this).zzab();
        ((zzhh)this).zzfs();
        this.zzch();
        if (!this.zzacw.isEnabled()) {
            ((zzhh)this).zzgf().zziy().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzacw.zzkd()) {
            return;
        }
        ((zzhh)this).zzgf().zziy().zze("Setting user property (FE)", ((zzhh)this).zzgb().zzbi(string2), object);
        zzjz zzjz2 = new zzjz(string2, l, object, string);
        ((zzhh)this).zzfy().zzb(zzjz2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzjz> zzj(boolean bl) {
        ((zzhh)this).zzfs();
        this.zzch();
        ((zzhh)this).zzgf().zziy().log("Fetching user attributes (FE)");
        if (((zzhh)this).zzge().zzjr()) {
            ((zzhh)this).zzgf().zzis().log("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        if (zzec.isMainThread()) {
            ((zzhh)this).zzgf().zzis().log("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzacw.zzge().zzc(new zzho(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhh)this).zzgf().zziv().zzg("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzhh)this).zzgf().zziv().log("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    public final Task<String> getAppInstanceId() {
        try {
            String string = ((zzhh)this).zzgg().zzjh();
            if (string != null) {
                return Tasks.forResult((Object)string);
            }
            return Tasks.call((Executor)((zzhh)this).zzge().zzjs(), (Callable)new zzhp(this));
        }
        catch (Exception exception) {
            ((zzhh)this).zzgf().zziv().log("Failed to schedule task for getAppInstanceId");
            return Tasks.forException((Exception)exception);
        }
    }

    @Nullable
    public final String zzjh() {
        ((zzhh)this).zzfs();
        return this.zzaod.get();
    }

    final void zzbq(@Nullable String string) {
        this.zzaod.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final String zzae(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzhh)this).zzge().zzc(new zzhq(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                ((zzhh)this).zzgf().zziv().log("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    public final void resetAnalyticsData() {
        long l = ((zzhh)this).zzbt().currentTimeMillis();
        ((zzhh)this).zzge().zzc(new zzhr(this, l));
    }

    @WorkerThread
    public final void zzkj() {
        ((zzhh)this).zzab();
        ((zzhh)this).zzfs();
        this.zzch();
        if (!this.zzacw.zzkd()) {
            return;
        }
        ((zzhh)this).zzfy().zzkj();
        this.zzaoe = false;
        String string = ((zzhh)this).zzgg().zzjk();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            ((zzhh)this).zzfx().zzch();
            if (!string.equals(Build.VERSION.RELEASE)) {
                Bundle bundle = new Bundle();
                bundle.putString("_po", string);
                this.logEvent("auto", "_ou", bundle);
            }
        }
    }

    @WorkerThread
    public final void setEventInterceptor(AppMeasurement.EventInterceptor eventInterceptor) {
        ((zzhh)this).zzab();
        ((zzhh)this).zzfs();
        this.zzch();
        if (eventInterceptor != null && eventInterceptor != this.zzaoa) {
            Preconditions.checkState((this.zzaoa == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzaoa = eventInterceptor;
    }

    public final void registerOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        ((zzhh)this).zzfs();
        this.zzch();
        Preconditions.checkNotNull((Object)onEventListener);
        if (!this.zzaob.add(onEventListener)) {
            ((zzhh)this).zzgf().zziv().log("OnEventListener already registered");
        }
    }

    public final void unregisterOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        ((zzhh)this).zzfs();
        this.zzch();
        Preconditions.checkNotNull((Object)onEventListener);
        if (!this.zzaob.remove(onEventListener)) {
            ((zzhh)this).zzgf().zziv().log("OnEventListener had not been registered");
        }
    }

    public final void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        ((zzhh)this).zzfs();
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            ((zzhh)this).zzgf().zziv().log("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public final void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mAppId);
        ((zzhh)this).zzfr();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private final void zza(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = ((zzhh)this).zzbt().currentTimeMillis();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mOrigin);
        Preconditions.checkNotNull((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        if (((zzhh)this).zzgc().zzce(string) != 0) {
            ((zzhh)this).zzgf().zzis().zzg("Invalid conditional user property name", ((zzhh)this).zzgb().zzbk(string));
            return;
        }
        if (((zzhh)this).zzgc().zzi(string, object) != 0) {
            ((zzhh)this).zzgf().zzis().zze("Invalid conditional user property value", ((zzhh)this).zzgb().zzbk(string), object);
            return;
        }
        Object object2 = ((zzhh)this).zzgc().zzj(string, object);
        if (object2 == null) {
            ((zzhh)this).zzgf().zzis().zze("Unable to normalize conditional user property value", ((zzhh)this).zzgb().zzbk(string), object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (!(TextUtils.isEmpty((CharSequence)conditionalUserProperty.mTriggerEventName) || l2 <= 15552000000L && l2 >= 1L)) {
            ((zzhh)this).zzgf().zzis().zze("Invalid conditional user property timeout", ((zzhh)this).zzgb().zzbk(string), l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > 15552000000L || l3 < 1L) {
            ((zzhh)this).zzgf().zzis().zze("Invalid conditional user property time to live", ((zzhh)this).zzgb().zzbk(string), l3);
            return;
        }
        ((zzhh)this).zzge().zzc(new zzhs(this, conditionalUserProperty));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        ((zzhh)this).zzfs();
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotEmpty((String)string);
        ((zzhh)this).zzfr();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzhh)this).zzbt().currentTimeMillis();
        Preconditions.checkNotEmpty((String)string2);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        ((zzhh)this).zzge().zzc(new zzht(this, conditionalUserProperty));
    }

    @WorkerThread
    private final void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzew zzew2;
        zzew zzew3;
        zzew zzew4;
        ((zzhh)this).zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mOrigin);
        Preconditions.checkNotNull((Object)conditionalUserProperty.mValue);
        if (!this.zzacw.isEnabled()) {
            ((zzhh)this).zzgf().zziy().log("Conditional property not sent since Firebase Analytics is disabled");
            return;
        }
        zzjz zzjz2 = new zzjz(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzew4 = ((zzhh)this).zzgc().zza(conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzew3 = ((zzhh)this).zzgc().zza(conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzew2 = ((zzhh)this).zzgc().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzee zzee2 = new zzee(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzjz2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzew3, conditionalUserProperty.mTriggerTimeout, zzew4, conditionalUserProperty.mTimeToLive, zzew2);
        ((zzhh)this).zzfy().zzd(zzee2);
    }

    @WorkerThread
    private final void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzew zzew2;
        ((zzhh)this).zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        if (!this.zzacw.isEnabled()) {
            ((zzhh)this).zzgf().zziy().log("Conditional property not cleared since Firebase Analytics is disabled");
            return;
        }
        zzjz zzjz2 = new zzjz(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzew2 = ((zzhh)this).zzgc().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzee zzee2 = new zzee(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzjz2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzew2);
        ((zzhh)this).zzfy().zzd(zzee2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        ((zzhh)this).zzfs();
        return this.zzf(null, string, string2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        ((zzhh)this).zzfr();
        return this.zzf(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final List<AppMeasurement.ConditionalUserProperty> zzf(String string, String string2, String string3) {
        if (((zzhh)this).zzge().zzjr()) {
            ((zzhh)this).zzgf().zzis().log("Cannot get conditional user properties from analytics worker thread");
            return Collections.emptyList();
        }
        if (zzec.isMainThread()) {
            ((zzhh)this).zzgf().zzis().log("Cannot get conditional user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzacw.zzge().zzc(new zzhu(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhh)this).zzgf().zziv().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzhh)this).zzgf().zziv().zzg("Timed out waiting for get conditional user properties", string);
                return Collections.emptyList();
            }
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzee zzee2 = (zzee)((Object)iterator.next());
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
                new AppMeasurement.ConditionalUserProperty().mAppId = zzee2.packageName;
                conditionalUserProperty.mOrigin = zzee2.origin;
                conditionalUserProperty.mCreationTimestamp = zzee2.creationTimestamp;
                conditionalUserProperty.mName = zzee2.zzaeq.name;
                conditionalUserProperty.mValue = zzee2.zzaeq.getValue();
                conditionalUserProperty.mActive = zzee2.active;
                conditionalUserProperty.mTriggerEventName = zzee2.triggerEventName;
                if (zzee2.zzaer != null) {
                    conditionalUserProperty.mTimedOutEventName = zzee2.zzaer.name;
                    if (zzee2.zzaer.zzafr != null) {
                        conditionalUserProperty.mTimedOutEventParams = zzee2.zzaer.zzafr.zzij();
                    }
                }
                conditionalUserProperty.mTriggerTimeout = zzee2.triggerTimeout;
                if (zzee2.zzaes != null) {
                    conditionalUserProperty.mTriggeredEventName = zzee2.zzaes.name;
                    if (zzee2.zzaes.zzafr != null) {
                        conditionalUserProperty.mTriggeredEventParams = zzee2.zzaes.zzafr.zzij();
                    }
                }
                conditionalUserProperty.mTriggeredTimestamp = zzee2.zzaeq.zzarl;
                conditionalUserProperty.mTimeToLive = zzee2.timeToLive;
                if (zzee2.zzaet != null) {
                    conditionalUserProperty.mExpiredEventName = zzee2.zzaet.name;
                    if (zzee2.zzaet.zzafr != null) {
                        conditionalUserProperty.mExpiredEventParams = zzee2.zzaet.zzafr.zzij();
                    }
                }
                arrayList.add(conditionalUserProperty);
            }
            return arrayList;
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        ((zzhh)this).zzfs();
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        Preconditions.checkNotEmpty((String)string);
        ((zzhh)this).zzfr();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzhh)this).zzge().zzjr()) {
            ((zzhh)this).zzgf().zzis().log("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        if (zzec.isMainThread()) {
            ((zzhh)this).zzgf().zzis().log("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzacw.zzge().zzc(new zzhv(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzhh)this).zzgf().zziv().zzg("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzhh)this).zzgf().zziv().log("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzjz zzjz2 = (zzjz)((Object)iterator.next());
                arrayMap.put(zzjz2.name, zzjz2.getValue());
            }
            return arrayMap;
        }
    }

    static /* synthetic */ void zza(zzhl zzhl2, boolean bl) {
        zzhl2.zzi(bl);
    }

    static /* synthetic */ void zza(zzhl zzhl2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzhl2.zza(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzhl zzhl2, String string, String string2, Object object, long l) {
        zzhl2.zza(string, string2, object, l);
    }

    static /* synthetic */ void zza(zzhl zzhl2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzhl2.zzb(conditionalUserProperty);
    }

    static /* synthetic */ void zzb(zzhl zzhl2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzhl2.zzc(conditionalUserProperty);
    }
}

