/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzdu;
import com.google.android.gms.internal.measurement.zzdx;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzif;
import com.google.android.gms.internal.measurement.zzih;
import com.google.android.gms.internal.measurement.zzii;
import com.google.android.gms.internal.measurement.zzkc;
import java.util.Map;

public final class zzig
extends zzhi {
    @VisibleForTesting
    protected zzif zzaov;
    private volatile zzif zzaow;
    private zzif zzaox;
    private final Map<Activity, zzif> zzaoy = new ArrayMap();
    private zzif zzaoz;
    private String zzapa;

    public zzig(zzgm zzgm2) {
        super(zzgm2);
    }

    @Override
    protected final boolean zzhh() {
        return false;
    }

    @WorkerThread
    public final zzif zzkk() {
        this.zzch();
        ((zzhh)this).zzab();
        return this.zzaov;
    }

    @MainThread
    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!zzec.isMainThread()) {
            ((zzhh)this).zzgf().zziv().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzaow == null) {
            ((zzhh)this).zzgf().zziv().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzaoy.get(activity) == null) {
            ((zzhh)this).zzgf().zziv().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzig.zzbz(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzaow.zzaos.equals(string2);
        boolean bl2 = zzkc.zzs(this.zzaow.zzul, string);
        if (bl && bl2) {
            ((zzhh)this).zzgf().zziw().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzhh)this).zzgf().zziv().zzg("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzhh)this).zzgf().zziv().zzg("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzhh)this).zzgf().zziz().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzif zzif2 = new zzif(string, string2, ((zzhh)this).zzgc().zzlk());
        this.zzaoy.put(activity, zzif2);
        this.zza(activity, zzif2, true);
    }

    public final zzif zzkl() {
        ((zzhh)this).zzfs();
        return this.zzaow;
    }

    @MainThread
    private final void zza(Activity activity, zzif zzif2, boolean bl) {
        zzif zzif3;
        zzif zzif4 = zzif3 = this.zzaow == null ? this.zzaox : this.zzaow;
        if (zzif2.zzaos == null) {
            zzif2 = new zzif(zzif2.zzul, zzig.zzbz(activity.getClass().getCanonicalName()), zzif2.zzaot);
        }
        zzif zzif5 = zzif2;
        this.zzaox = this.zzaow;
        this.zzaow = zzif5;
        ((zzhh)this).zzge().zzc(new zzih(this, bl, zzif3, zzif5));
    }

    @WorkerThread
    private final void zza(@NonNull zzif zzif2) {
        ((zzhh)this).zzfu().zzk(((zzhh)this).zzbt().elapsedRealtime());
        if (((zzhh)this).zzgd().zzl(zzif2.zzaou)) {
            zzif2.zzaou = false;
        }
    }

    public static void zza(zzif zzif2, Bundle bundle, boolean bl) {
        if (bundle != null && zzif2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzif2.zzul != null) {
                bundle.putString("_sn", zzif2.zzul);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzif2.zzaos);
            bundle.putLong("_si", zzif2.zzaot);
            return;
        }
        if (bundle != null && zzif2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzif zzif2) {
        ((zzhh)this).zzab();
        zzig zzig2 = this;
        synchronized (zzig2) {
            if (this.zzapa == null || this.zzapa.equals(string) || zzif2 != null) {
                this.zzapa = string;
                this.zzaoz = zzif2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zzbz(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzif zze(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzif zzif2 = this.zzaoy.get(activity);
        if (zzif2 == null) {
            String string = zzig.zzbz(activity.getClass().getCanonicalName());
            zzif2 = new zzif(null, string, ((zzhh)this).zzgc().zzlk());
            this.zzaoy.put(activity, zzif2);
        }
        return zzif2;
    }

    @MainThread
    public final void onActivityCreated(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.firebase.analytics.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzif zzif2 = new zzif(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzaoy.put(activity, zzif2);
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzif zzif2 = this.zze(activity);
        this.zza(activity, zzif2, false);
        zzdu zzdu2 = ((zzhh)this).zzfu();
        long l = ((zzhh)zzdu2).zzbt().elapsedRealtime();
        ((zzhh)zzdu2).zzge().zzc(new zzdx(zzdu2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzif zzif2 = this.zze(activity);
        this.zzaox = this.zzaow;
        this.zzaow = null;
        ((zzhh)this).zzge().zzc(new zzii(this, zzif2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzif zzif2 = this.zzaoy.get(activity);
        if (zzif2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzif2.zzaot);
        bundle2.putString("name", zzif2.zzul);
        bundle2.putString("referrer_name", zzif2.zzaos);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzaoy.remove(activity);
    }

    static /* synthetic */ void zza(zzig zzig2, zzif zzif2) {
        zzig2.zza(zzif2);
    }
}

