/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzij;
import com.google.android.gms.internal.measurement.zziy;
import com.google.android.gms.internal.measurement.zziz;
import com.google.android.gms.internal.measurement.zzja;
import com.google.android.gms.internal.measurement.zzjb;
import com.google.android.gms.internal.measurement.zzjc;

@VisibleForTesting
public final class zzix
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzapt;
    private volatile zzfg zzapu;
    final /* synthetic */ zzij zzapn;

    protected zzix(zzij zzij2) {
        this.zzapn = zzij2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzc(Intent intent) {
        ((zzhh)this.zzapn).zzab();
        Context context = ((zzhh)this.zzapn).getContext();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzix zzix2 = this;
        synchronized (zzix2) {
            if (this.zzapt) {
                ((zzhh)this.zzapn).zzgf().zziz().log("Connection attempt already in progress");
                return;
            }
            ((zzhh)this.zzapn).zzgf().zziz().log("Using local app measurement service");
            this.zzapt = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzij.zza(this.zzapn), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzix zzix2 = this;
        synchronized (zzix2) {
            String string;
            if (iBinder == null) {
                this.zzapt = false;
                ((zzhh)this.zzapn).zzgf().zzis().log("Service connected with null binder");
                return;
            }
            zzez zzez2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzez2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzez ? (zzez)iInterface : new zzfb(iBinder2));
                    ((zzhh)this.zzapn).zzgf().zziz().log("Bound to IMeasurementService interface");
                } else {
                    ((zzhh)this.zzapn).zzgf().zzis().zzg("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzhh)this.zzapn).zzgf().zzis().log("Service connect failed to get IMeasurementService");
            }
            if (zzez2 == null) {
                this.zzapt = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzhh)this.zzapn).getContext(), (ServiceConnection)zzij.zza(this.zzapn));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzez2;
                ((zzhh)this.zzapn).zzge().zzc(new zziy(this, (zzez)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzhh)this.zzapn).zzgf().zziy().log("Service disconnected");
        ((zzhh)this.zzapn).zzge().zzc(new zziz(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzkq() {
        ((zzhh)this.zzapn).zzab();
        Context context = ((zzhh)this.zzapn).getContext();
        zzix zzix2 = this;
        synchronized (zzix2) {
            if (this.zzapt) {
                ((zzhh)this.zzapn).zzgf().zziz().log("Connection attempt already in progress");
                return;
            }
            if (this.zzapu != null) {
                ((zzhh)this.zzapn).zzgf().zziz().log("Already awaiting connection attempt");
                return;
            }
            this.zzapu = new zzfg(context, Looper.getMainLooper(), this, this);
            ((zzhh)this.zzapn).zzgf().zziz().log("Connecting to remote service");
            this.zzapt = true;
            this.zzapu.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzix zzix2 = this;
        synchronized (zzix2) {
            try {
                zzez zzez2 = (zzez)this.zzapu.getService();
                this.zzapu = null;
                ((zzhh)this.zzapn).zzge().zzc(new zzja(this, zzez2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzapu = null;
                this.zzapt = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzhh)this.zzapn).zzgf().zziy().log("Service connection suspended");
        ((zzhh)this.zzapn).zzge().zzc(new zzjb(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzfh zzfh2 = this.zzapn.zzacw.zzjv();
        if (zzfh2 != null) {
            zzfh2.zziv().zzg("Service connection failed", connectionResult);
        }
        zzix zzix2 = this;
        synchronized (zzix2) {
            this.zzapt = false;
            this.zzapu = null;
        }
        ((zzhh)this.zzapn).zzge().zzc(new zzjc(this));
    }

    static /* synthetic */ boolean zza(zzix zzix2, boolean bl) {
        zzix2.zzapt = false;
        return false;
    }
}

