/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzgo;
import com.google.android.gms.internal.measurement.zzje;
import com.google.android.gms.internal.measurement.zzjf;
import com.google.android.gms.internal.measurement.zzjg;
import com.google.android.gms.internal.measurement.zzjh;
import com.google.android.gms.internal.measurement.zzjs;

public final class zzjd<T extends Context> {
    private final T zzabm;

    public zzjd(T t) {
        Preconditions.checkNotNull(t);
        this.zzabm = t;
    }

    @MainThread
    public final void onCreate() {
        zzgm zzgm2 = zzgm.zza(this.zzabm, null, null);
        zzfh zzfh2 = zzgm2.zzgf();
        zzec zzec2 = zzgm2.zzgi();
        zzfh2.zziz().log("Local AppMeasurementService is starting up");
    }

    @MainThread
    public final void onDestroy() {
        zzgm zzgm2 = zzgm.zza(this.zzabm, null, null);
        zzfh zzfh2 = zzgm2.zzgf();
        zzec zzec2 = zzgm2.zzgi();
        zzfh2.zziz().log("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public final int onStartCommand(Intent intent, int n, int n2) {
        zzgm zzgm2 = zzgm.zza(this.zzabm, null, null);
        zzfh zzfh2 = zzgm2.zzgf();
        if (intent == null) {
            zzfh2.zziv().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzec zzec2 = zzgm2.zzgi();
        zzfh2.zziz().zze("Local AppMeasurementService called. startId, action", n2, string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zzb(new zzje(this, n2, zzfh2, intent));
        }
        return 2;
    }

    private final void zzb(Runnable runnable) {
        zzjs zzjs2 = zzjs.zzg(this.zzabm);
        zzjs2.zzge().zzc(new zzjg(this, zzjs2, runnable));
    }

    @MainThread
    public final IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzgf().zzis().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzgo(zzjs.zzg(this.zzabm));
        }
        this.zzgf().zziv().zzg("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public final boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzgf().zzis().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzgf().zziz().zzg("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzgm zzgm2 = zzgm.zza(this.zzabm, null, null);
        zzfh zzfh2 = zzgm2.zzgf();
        String string = jobParameters.getExtras().getString("action");
        zzec zzec2 = zzgm2.zzgi();
        zzfh2.zziz().zzg("Local AppMeasurementJobService called. action", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zzb(new zzjf(this, zzfh2, jobParameters));
        }
        return true;
    }

    @MainThread
    public final void onRebind(Intent intent) {
        if (intent == null) {
            this.zzgf().zzis().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzgf().zziz().zzg("onRebind called. action", string);
    }

    private final zzfh zzgf() {
        return zzgm.zza(this.zzabm, null, null).zzgf();
    }

    final /* synthetic */ void zza(zzfh zzfh2, JobParameters jobParameters) {
        zzfh2.zziz().log("AppMeasurementJobService processed last upload request.");
        ((zzjh)this.zzabm).zza(jobParameters, false);
    }

    final /* synthetic */ void zza(int n, zzfh zzfh2, Intent intent) {
        if (((zzjh)this.zzabm).callServiceStopSelfResult(n)) {
            zzfh2.zziz().zzg("Local AppMeasurementService processed last upload request. StartId", n);
            this.zzgf().zziz().log("Completed wakeful intent.");
            ((zzjh)this.zzabm).zzb(intent);
        }
    }
}

