/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.support.annotation.GuardedBy;
import android.util.Log;
import com.google.android.gms.internal.measurement.zzws;
import com.google.android.gms.internal.measurement.zzwt;
import com.google.android.gms.internal.measurement.zzwu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class zzwr {
    private static final ConcurrentHashMap<Uri, zzwr> zzbnf = new ConcurrentHashMap();
    private final ContentResolver zzbng;
    private final Uri uri;
    private final ContentObserver zzbnh;
    private final Object zzbni = new Object();
    private volatile Map<String, String> zzbnj;
    private final Object zzbnk = new Object();
    @GuardedBy(value="listenersLock")
    private final List<zzwt> zzbnl = new ArrayList<zzwt>();
    private static final String[] zzbnm = new String[]{"key", "value"};

    private zzwr(ContentResolver contentResolver, Uri uri) {
        this.zzbng = contentResolver;
        this.uri = uri;
        this.zzbnh = new zzws(this, null);
    }

    public static zzwr zza(ContentResolver contentResolver, Uri uri) {
        zzwr zzwr2 = zzbnf.get(uri);
        if (zzwr2 == null) {
            zzwr2 = new zzwr(contentResolver, uri);
            zzwr zzwr3 = zzbnf.putIfAbsent(uri, zzwr2);
            if (zzwr3 == null) {
                zzwr2.zzbng.registerContentObserver(zzwr2.uri, false, zzwr2.zzbnh);
            } else {
                zzwr2 = zzwr3;
            }
        }
        return zzwr2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> zzsc() {
        Map<String, String> map = zzwu.zzd("gms:phenotype:phenotype_flag:debug_disable_caching", false) ? this.zzse() : this.zzbnj;
        if (map == null) {
            Object object = this.zzbni;
            synchronized (object) {
                map = this.zzbnj;
                if (map == null) {
                    map = this.zzse();
                    this.zzbnj = map;
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzsd() {
        Object object = this.zzbni;
        synchronized (object) {
            this.zzbnj = null;
            return;
        }
    }

    private final Map<String, String> zzse() {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Cursor cursor = this.zzbng.query(this.uri, zzbnm, null, null, null);
            if (cursor != null) {
                try {
                    while (cursor.moveToNext()) {
                        hashMap.put(cursor.getString(0), cursor.getString(1));
                    }
                }
                finally {
                    cursor.close();
                }
            }
            return hashMap;
        }
        catch (SQLiteException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLoader", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzsf() {
        Object object = this.zzbnk;
        synchronized (object) {
            Iterator<zzwt> iterator = this.zzbnl.iterator();
            while (iterator.hasNext()) {
                iterator.next().zzsg();
            }
            return;
        }
    }

    static /* synthetic */ void zza(zzwr zzwr2) {
        zzwr2.zzsf();
    }
}

