/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzif;
import com.google.android.gms.internal.measurement.zzjz;
import com.google.android.gms.internal.measurement.zzkc;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.util.List;
import java.util.Map;

@Deprecated
@Keep
public class AppMeasurement {
    @KeepForSdk
    public static final String CRASH_ORIGIN = "crash";
    @KeepForSdk
    public static final String FCM_ORIGIN = "fcm";
    private final zzgm zzacw;

    @Deprecated
    @Keep
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    public static AppMeasurement getInstance(Context context) {
        return zzgm.zza(context, null, null).zzjy();
    }

    public final void logEvent(@NonNull @Size(min=1L, max=40L) String string, Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        this.zzacw.zzfv().zza("app", string, bundle, true);
    }

    public final void setUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable @Size(max=36L) String string2) {
        int n = this.zzacw.zzgc().zzcd(string);
        if (n != 0) {
            this.zzacw.zzgc();
            String string3 = zzkc.zza(string, 24, true);
            int n2 = string != null ? string.length() : 0;
            this.zzacw.zzgc().zza(n, "_ev", string3, n2);
            return;
        }
        this.setUserPropertyInternal("app", string, string2);
    }

    @Deprecated
    public void setMeasurementEnabled(boolean bl) {
        this.zzacw.zzfv().setMeasurementEnabled(bl);
    }

    public final void setMinimumSessionDuration(long l) {
        this.zzacw.zzfv().setMinimumSessionDuration(l);
    }

    public final void setSessionTimeoutDuration(long l) {
        this.zzacw.zzfv().setSessionTimeoutDuration(l);
    }

    public AppMeasurement(zzgm zzgm2) {
        Preconditions.checkNotNull((Object)zzgm2);
        this.zzacw = zzgm2;
    }

    @Keep
    public void logEventInternal(String string, String string2, Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        this.zzacw.zzfv().logEvent(string, string2, bundle);
    }

    @KeepForSdk
    public void logEventInternalNoInterceptor(String string, String string2, Bundle bundle, long l) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        this.zzacw.zzfv().zza(string, string2, bundle, l);
    }

    @KeepForSdk
    public void setUserPropertyInternal(String string, String string2, Object object) {
        this.zzacw.zzfv().setUserProperty(string, string2, object);
    }

    @WorkerThread
    @KeepForSdk
    public Map<String, Object> getUserProperties(boolean bl) {
        List<zzjz> list = this.zzacw.zzfv().zzj(bl);
        ArrayMap arrayMap = new ArrayMap(list.size());
        for (zzjz zzjz2 : list) {
            arrayMap.put(zzjz2.name, zzjz2.getValue());
        }
        return arrayMap;
    }

    @WorkerThread
    @KeepForSdk
    public void setEventInterceptor(EventInterceptor eventInterceptor) {
        this.zzacw.zzfv().setEventInterceptor(eventInterceptor);
    }

    @KeepForSdk
    public void registerOnMeasurementEventListener(OnEventListener onEventListener) {
        this.zzacw.zzfv().registerOnMeasurementEventListener(onEventListener);
    }

    @KeepForSdk
    public void unregisterOnMeasurementEventListener(OnEventListener onEventListener) {
        this.zzacw.zzfv().unregisterOnMeasurementEventListener(onEventListener);
    }

    @Nullable
    @Keep
    public String getCurrentScreenName() {
        zzif zzif2 = this.zzacw.zzfz().zzkl();
        if (zzif2 != null) {
            return zzif2.zzul;
        }
        return null;
    }

    @Nullable
    @Keep
    public String getCurrentScreenClass() {
        zzif zzif2 = this.zzacw.zzfz().zzkl();
        if (zzif2 != null) {
            return zzif2.zzaos;
        }
        return null;
    }

    @Nullable
    @Keep
    public String getAppInstanceId() {
        return this.zzacw.zzfv().zzjh();
    }

    @Nullable
    @Keep
    public String getGmpAppId() {
        if (this.zzacw.zzka() != null) {
            return this.zzacw.zzka();
        }
        try {
            return GoogleServices.getGoogleAppId();
        }
        catch (IllegalStateException illegalStateException) {
            this.zzacw.zzgf().zzis().zzg("getGoogleAppId failed with exception", illegalStateException);
            return null;
        }
    }

    @Keep
    public long generateEventId() {
        return this.zzacw.zzgc().zzlk();
    }

    @Keep
    public void beginAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zzacw.zzfu().beginAdUnitExposure(string);
    }

    @Keep
    public void endAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zzacw.zzfu().endAdUnitExposure(string);
    }

    @Keep
    @KeepForSdk
    public void setConditionalUserProperty(@NonNull ConditionalUserProperty conditionalUserProperty) {
        this.zzacw.zzfv().setConditionalUserProperty(conditionalUserProperty);
    }

    @Keep
    @VisibleForTesting
    protected void setConditionalUserPropertyAs(@NonNull ConditionalUserProperty conditionalUserProperty) {
        this.zzacw.zzfv().setConditionalUserPropertyAs(conditionalUserProperty);
    }

    @Keep
    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        this.zzacw.zzfv().clearConditionalUserProperty(string, string2, bundle);
    }

    @Keep
    @VisibleForTesting
    protected void clearConditionalUserPropertyAs(@NonNull @Size(min=1L) String string, @NonNull @Size(min=1L, max=24L) String string2, @Nullable String string3, @Nullable Bundle bundle) {
        this.zzacw.zzfv().clearConditionalUserPropertyAs(string, string2, string3, bundle);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected Map<String, Object> getUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=24L) String string2, boolean bl) {
        return this.zzacw.zzfv().getUserProperties(string, string2, bl);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected Map<String, Object> getUserPropertiesAs(@NonNull @Size(min=1L) String string, @Nullable String string2, @Nullable @Size(min=1L, max=23L) String string3, boolean bl) {
        return this.zzacw.zzfv().getUserPropertiesAs(string, string2, string3, bl);
    }

    @WorkerThread
    @Keep
    @KeepForSdk
    public List<ConditionalUserProperty> getConditionalUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=23L) String string2) {
        return this.zzacw.zzfv().getConditionalUserProperties(string, string2);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected List<ConditionalUserProperty> getConditionalUserPropertiesAs(@NonNull @Size(min=1L) String string, @Nullable String string2, @Nullable @Size(min=1L, max=23L) String string3) {
        return this.zzacw.zzfv().getConditionalUserPropertiesAs(string, string2, string3);
    }

    @WorkerThread
    @Keep
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        this.zzacw.zzfv();
        String string2 = string;
        Preconditions.checkNotEmpty((String)string2);
        return 25;
    }

    @KeepForSdk
    public Boolean getBoolean() {
        return this.zzacw.zzfv().zzkf();
    }

    @KeepForSdk
    public String getString() {
        return this.zzacw.zzfv().zzhq();
    }

    @KeepForSdk
    public Long getLong() {
        return this.zzacw.zzfv().zzkg();
    }

    @KeepForSdk
    public Integer getInteger() {
        return this.zzacw.zzfv().zzkh();
    }

    @KeepForSdk
    public Double getDouble() {
        return this.zzacw.zzfv().zzki();
    }

    @KeepForSdk
    public static class ConditionalUserProperty {
        @Keep
        @KeepForSdk
        public String mAppId;
        @Keep
        @KeepForSdk
        public String mOrigin;
        @Keep
        @KeepForSdk
        public String mName;
        @Keep
        @KeepForSdk
        public Object mValue;
        @Keep
        @KeepForSdk
        public String mTriggerEventName;
        @Keep
        @KeepForSdk
        public long mTriggerTimeout;
        @Keep
        public String mTimedOutEventName;
        @Keep
        public Bundle mTimedOutEventParams;
        @Keep
        public String mTriggeredEventName;
        @Keep
        public Bundle mTriggeredEventParams;
        @Keep
        @KeepForSdk
        public long mTimeToLive;
        @Keep
        public String mExpiredEventName;
        @Keep
        public Bundle mExpiredEventParams;
        @Keep
        @KeepForSdk
        public long mCreationTimestamp;
        @Keep
        @KeepForSdk
        public boolean mActive;
        @Keep
        @KeepForSdk
        public long mTriggeredTimestamp;

        public ConditionalUserProperty() {
        }

        public ConditionalUserProperty(ConditionalUserProperty conditionalUserProperty) {
            Preconditions.checkNotNull((Object)conditionalUserProperty);
            this.mAppId = conditionalUserProperty.mAppId;
            this.mOrigin = conditionalUserProperty.mOrigin;
            this.mCreationTimestamp = conditionalUserProperty.mCreationTimestamp;
            this.mName = conditionalUserProperty.mName;
            if (conditionalUserProperty.mValue != null) {
                this.mValue = zzkc.zzf(conditionalUserProperty.mValue);
                if (this.mValue == null) {
                    this.mValue = conditionalUserProperty.mValue;
                }
            }
            this.mActive = conditionalUserProperty.mActive;
            this.mTriggerEventName = conditionalUserProperty.mTriggerEventName;
            this.mTriggerTimeout = conditionalUserProperty.mTriggerTimeout;
            this.mTimedOutEventName = conditionalUserProperty.mTimedOutEventName;
            if (conditionalUserProperty.mTimedOutEventParams != null) {
                this.mTimedOutEventParams = new Bundle(conditionalUserProperty.mTimedOutEventParams);
            }
            this.mTriggeredEventName = conditionalUserProperty.mTriggeredEventName;
            if (conditionalUserProperty.mTriggeredEventParams != null) {
                this.mTriggeredEventParams = new Bundle(conditionalUserProperty.mTriggeredEventParams);
            }
            this.mTriggeredTimestamp = conditionalUserProperty.mTriggeredTimestamp;
            this.mTimeToLive = conditionalUserProperty.mTimeToLive;
            this.mExpiredEventName = conditionalUserProperty.mExpiredEventName;
            if (conditionalUserProperty.mExpiredEventParams != null) {
                this.mExpiredEventParams = new Bundle(conditionalUserProperty.mExpiredEventParams);
            }
        }
    }

    @KeepForSdk
    public static interface OnEventListener {
        @WorkerThread
        @KeepForSdk
        public void onEvent(String var1, String var2, Bundle var3, long var4);
    }

    @KeepForSdk
    public static interface EventInterceptor {
        @WorkerThread
        @KeepForSdk
        public void interceptEvent(String var1, String var2, Bundle var3, long var4);
    }

    @KeepForSdk
    public static final class UserProperty
    extends FirebaseAnalytics.UserProperty {
        @KeepForSdk
        public static final String FIREBASE_LAST_NOTIFICATION = "_ln";
        public static final String[] zzadb = new String[]{"firebase_last_notification", "first_open_time", "first_visit_time", "last_deep_link_referrer", "user_id", "first_open_after_install", "lifetime_user_engagement"};
        public static final String[] zzadc = new String[]{"_ln", "_fot", "_fvt", "_ldl", "_id", "_fi", "_lte"};

        private UserProperty() {
        }

        public static String zzaj(String string) {
            return zzkc.zza(string, zzadb, zzadc);
        }
    }

    @KeepForSdk
    public static final class Param
    extends FirebaseAnalytics.Param {
        @KeepForSdk
        public static final String FATAL = "fatal";
        @KeepForSdk
        public static final String TIMESTAMP = "timestamp";
        @KeepForSdk
        public static final String TYPE = "type";
        public static final String[] zzacz = new String[]{"firebase_conversion", "engagement_time_msec", "exposure_time", "ad_event_id", "ad_unit_id", "firebase_error", "firebase_error_value", "firebase_error_length", "firebase_event_origin", "firebase_screen", "firebase_screen_class", "firebase_screen_id", "firebase_previous_screen", "firebase_previous_class", "firebase_previous_id", "message_device_time", "message_id", "message_name", "message_time", "previous_app_version", "previous_os_version", "topic", "update_with_analytics", "previous_first_open_count", "system_app", "system_app_update", "previous_install_count", "ga_event_id", "ga_extra_params_ct", "ga_group_name", "ga_list_length", "ga_index", "ga_event_name", "campaign_info_source", "deferred_analytics_collection"};
        public static final String[] zzada = new String[]{"_c", "_et", "_xt", "_aeid", "_ai", "_err", "_ev", "_el", "_o", "_sn", "_sc", "_si", "_pn", "_pc", "_pi", "_ndt", "_nmid", "_nmn", "_nmt", "_pv", "_po", "_nt", "_uwa", "_pfo", "_sys", "_sysu", "_pin", "_eid", "_epc", "_gn", "_ll", "_i", "_en", "_cis", "_dac"};

        private Param() {
        }

        public static String zzaj(String string) {
            return zzkc.zza(string, zzacz, zzada);
        }
    }

    @KeepForSdk
    public static final class Event
    extends FirebaseAnalytics.Event {
        @KeepForSdk
        public static final String APP_EXCEPTION = "_ae";
        @KeepForSdk
        public static final String AD_REWARD = "_ar";
        public static final String[] zzacx = new String[]{"app_clear_data", "app_exception", "app_remove", "app_upgrade", "app_install", "app_update", "firebase_campaign", "error", "first_open", "first_visit", "in_app_purchase", "notification_dismiss", "notification_foreground", "notification_open", "notification_receive", "os_update", "session_start", "user_engagement", "ad_exposure", "adunit_exposure", "ad_query", "ad_activeview", "ad_impression", "ad_click", "ad_reward", "screen_view", "ga_extra_parameter"};
        public static final String[] zzacy = new String[]{"_cd", "_ae", "_ui", "_ug", "_in", "_au", "_cmp", "_err", "_f", "_v", "_iap", "_nd", "_nf", "_no", "_nr", "_ou", "_s", "_e", "_xa", "_xu", "_aq", "_aa", "_ai", "_ac", "_ar", "_vs", "_ep"};

        private Event() {
        }

        public static String zzaj(String string) {
            return zzkc.zza(string, zzacx, zzacy);
        }
    }
}

